

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSmartFolderAssocs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSmartFolderAssocs.sp,v $ $Id: AppSmartFolderAssocs.sp,v 1.5.42.6 2018/03/22 01:37:30 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: AppSmartFolderAssocs()
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSmartFolderAssocs <<<'

IF EXISTS (select * from sysobjects where name='AppSmartFolderAssocs')
	drop procedure AppSmartFolderAssocs
IF EXISTS (select * from GxQscripts where name='AppSmartFolderAssocs')
	delete from GxQscripts where name = 'AppSmartFolderAssocs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartFolderAssocs')
	delete from GXDBVersions where aliasname = 'AppSmartFolderAssocs'
GO
print '... Creating Procedure: AppSmartFolderAssocs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSmartFolderAssocs
  @i_userId INT,
  @i_expandLevel INT,
  @i_assocXml XML
AS
  DECLARE @o_outPutXml XML = '<App_GetSmartFolderAssocResp/>'
DECLARE @ErrorMessage		NVARCHAR(4000)
DECLARE @ErrorSeverity		INT
DECLARE @ErrorState			INT
DECLARE @releaseId			INT
DECLARE @allAssociations	INT
DECLARE @commcellParam		INT
DECLARE @capability			INT
DECLARE @ERROR_STATE		INT
DECLARE @ERROR_SEVERITY		INT
DECLARE @smartfolderId		INT
SET	@ERROR_STATE		=	1
SET @ERROR_SEVERITY		=	10
SET @ErrorSeverity		=	0
SET @ErrorState			=	0
SET @ErrorMessage		=	''
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @folderTbl TABLE
	(
		folderId	INT,
		clientGrp	INT,
		clientId	INT,
		appTypeId	INT,
		instanceId	INT,
		backupsetId INT,
		appId		INT,
		workFlowId	INT,
		status		INT,
		refTime		INT,
		entityType	INT
	)
	SELECT @smartfolderId= ISNULL(Tbl.Col.value('@smartFolderId', 'int'),0) FROM @i_assocXml.nodes('entity') as Tbl(Col)
	-- Populate the subclient information from includeEntity
	INSERT INTO @folderTbl
	-- Folders
	SELECT
(Case When A.componentType = 127 Then A.componentId Else 0 end),
(Case When A.componentType = 28 Then A.componentId Else 0 end),
(Case When A.componentType = 3 Then A.componentId Else 0 end),
(Case When A.componentType = 4 Then A.componentId Else 0 end),
(Case When A.componentType = 5 Then A.componentId Else 0 end),
(Case When A.componentType = 6 Then A.componentId Else 0 end),
(Case When A.componentType = 7 Then A.componentId Else 0 end),
(Case When A.componentType = 83 Then A.componentId Else 0 end),
	0, 0, A.componentType
	FROM App_SmartFolderAssoc A WHERE folderId = @smartfolderId
	IF object_id('tempdb.dbo.#canSeeEntityList') is not null
    DROP TABLE #canSeeEntityList
	CREATE TABLE #canSeeEntityList(entityId INT)
	--verify security for the sub folders
IF EXISTS(SELECT 1 FROM @folderTbl WHERE entityType = 127)
	BEGIN
		IF object_id('tempdb.dbo.#folderList') is not null
			DROP TABLE #folderList
		CREATE TABLE #folderList(folderId INT)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 127, 0, '#canSeeEntityList'
		--get children of canSeeEntityList
		;WITH CHILDREN(folderId) AS
		(
			(SELECT canSee.entityId FROM #canSeeEntityList canSee)
			UNION ALL
(SELECT Assoc.componentId FROM App_SmartFolderAssoc Assoc INNER JOIN CHILDREN ON Assoc.folderId = CHILDREN.folderId AND Assoc.componenttype = 127)
		)
		INSERT INTO #folderList
		SELECT folderId FROM CHILDREN
		--get parents of  canSeeEntityList
		;WITH PARENTS(folderId) AS
		(
			(SELECT canSee.entityId FROM #canSeeEntityList canSee)
			UNION ALL
(SELECT Assoc.folderId FROM App_SmartFolderAssoc Assoc INNER JOIN PARENTS ON Assoc.componentId = PARENTS.folderId AND Assoc.componenttype = 127)
		)
		INSERT INTO #folderList
		SELECT folderId FROM PARENTS
		--now remove from foldertable if the id is not found in #folderList because user has no permission on those folders
		DELETE Folders
		FROM @FolderTbl Folders
		LEFT JOIN #folderList canSee on Folders.folderId = canSee.folderId
WHERE canSee.folderId is null AND Folders.entityType = 127
		DROP TABLE #folderList
	END
	DECLARE @assocEntityType INT = 0
SET @assocEntityType = (SELECT TOP 1 entityType FROM @folderTbl WHERE entityType <> 127 and entityType <> 0)
	-- security for the entities added under the folder (clientgroup or workflow)
IF @assocEntityType=28 OR  @assocEntityType=83
	BEGIN
		TRUNCATE TABLE #canSeeEntityList
		EXEC sec_getNonIdaObjectsForThisUser @i_userId, @assocEntityType, 0, '#canSeeEntityList'
		--remove from FolderTbl if user is not allowed to see
IF @assocEntityType=28
			DELETE Folders
			FROM @FolderTbl Folders
			LEFT JOIN #canSeeEntityList canSee on Folders.clientGrp = canSee.entityId
WHERE canSee.entityId is null AND Folders.entityType = 28
ELSE IF @assocEntityType=83
		    DELETE Folders
			FROM @FolderTbl Folders
			LEFT JOIN #canSeeEntityList canSee on Folders.workflowId = canSee.entityId
WHERE canSee.entityId is null AND Folders.entityType = 83
	END
	DROP TABLE #canSeeEntityList
	DECLARE @folderId	INT
	DECLARE @clientGrp	INT
	DECLARE @clientId	INT
	DECLARE @appTypeId	INT
	DECLARE @instanceId	INT
	DECLARE @backupsetId INT
	DECLARE @appId		INT
	DECLARE @workFlowId	INT
	DECLARE @entityType INT
	DECLARE @outPutEntityXml XML
	DECLARE @expandLevel INT
	DECLARE db_assocCur CURSOR FOR
	SELECT distinct folderId, clientGrp, clientId, appTypeId, instanceId, backupsetId, appId, workFlowId, entityType From @folderTbl
	OPEN db_assocCur
	FETCH NEXT From db_assocCur INTO @folderId, @clientGrp, @clientId, @appTypeId, @instanceId, @backupsetId, @appId, @workFlowId, @entityType
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @expandLevel = @entityType
		DECLARE @ownerId INT = 0
		DECLARE @groupId INT = 0
		DECLARE @ownerName NVARCHAR(512)
		DECLARE @entityId INT = 0
		SET @entityId = CASE @expandLevel
WHEN 127 THEN @folderId
WHEN 83 THEN @workflowId
WHEN 28 THEN @clientGrp
						END
		--fill owner info only for folder entity
IF(@entityType = 127)
		BEGIN
			SELECT @ownerId = creatorUserId, @groupId = creatorUserGroupId FROM sec_getCreatorIdForEntity(@entityType, @entityId,0,0,0,0,0,0,0,0)
			IF(@ownerId<>0)
				SELECT @ownerName = login FROM UMUsers WHERE id = @ownerId
			ELSE IF(@groupId<>0)
				SELECT  @ownerName = domainname+'\'+name FROM umgroups INNER JOIN umdsproviders ON umgroups.umdsProviderId=umdsproviders.id AND UMGroups.id = @groupId
		END
IF @expandLevel = 127
		BEGIN
				SET @outPutEntityXml = (select DISTINCT
				SF.flag as '@flags',
				@ownerName as '@owner',
				SF.description as 'entityWrapper/@description',
				SF.id as 'entityWrapper/entity/@smartFolderId',
				SF.name as 'entityWrapper/entity/@smartFolderName',
				@expandLevel as 'entityWrapper/entity/@_type_'
				from App_SmartFolder SF
				Where SF.id = @folderId
				FOR XML PATH('associations'))
		END
ELSE IF @expandLevel = 83
		BEGIN
		SET @outPutEntityXml = (select DISTINCT
				C.WorkflowId as 'entityWrapper/entity/@workflowId',
				C.name as 'entityWrapper/entity/@workflowName',
				@expandLevel as 'entityWrapper/entity/@_type_'
				from
				WF_Definition C
				where C.WorkFlowId = @workFlowId
				And C.flags & 16 = 0
				FOR XML PATH('associations'))
		END
ELSE IF @expandLevel = 28
		BEGIN
		SET @outPutEntityXml = (select DISTINCT
				C.id as 'entityWrapper/entity/@clientGroupId',
				C.name as 'entityWrapper/entity/@clientGroupName',
				@expandLevel as 'entityWrapper/entity/@_type_'
				from
				APP_ClientGroup C
				where C.id = @clientGrp
				FOR XML PATH('associations'))
		END
		SET @o_outPutXml.modify('
									insert
									(
										sql:variable("@outPutEntityXml")
									)
									as last into
									(/App_GetSmartFolderAssocResp[1])
								')
		FETCH NEXT From db_assocCur INTO @folderId, @clientGrp, @clientId, @appTypeId, @instanceId, @backupsetId, @appId, @workFlowId, @entityType
	END
	CLOSE db_assocCur
	DEALLOCATE db_assocCur
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @o_outPutXml = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericResp'), TYPE);
END CATCH
SELECT cast(@o_outPutXml as nvarchar(max))
--IF @ErrorSeverity <> 0 OR @ErrorState <> 0
--	RAISERROR(@ErrorMessage,@ErrorSeverity,@ErrorState)
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSmartFolderAssocs')
	delete from GxQscripts where name = 'AppSmartFolderAssocs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartFolderAssocs')
	delete from GXDBVersions where aliasname = 'AppSmartFolderAssocs'
GO

insert into GXDBVersions values(2, 'AppSmartFolderAssocs',  '00010005004200060000', 'AppSmartFolderAssocs', '00010005004200060000')
GO

