

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSmartClientGroupForHACCluster.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSmartClientGroupForHACCluster.sp,v $ $Id: AppSmartClientGroupForHACCluster.sp,v 1.1.4.5 2020/10/04 00:54:49 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSmartClientGroupForHACCluster')
BEGIN
	print '>>> Drop Stored Procedure: AppSmartClientGroupForHACCluster <<<'
	drop procedure AppSmartClientGroupForHACCluster
END
IF EXISTS (select * from GxQscripts where name='AppSmartClientGroupForHACCluster')
	delete from GxQscripts where name = 'AppSmartClientGroupForHACCluster'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartClientGroupForHACCluster')
	delete from GXDBVersions where aliasname = 'AppSmartClientGroupForHACCluster'
GO
print '... Creating Procedure: AppSmartClientGroupForHACCluster'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSmartClientGroupForHACCluster
AS
  DECLARE @o_cloudInfoXML XML
IF object_id('tempdb.dbo.#zkCloudInfo') IS NOT NULL drop table #zkCloudInfo
create table #zkCloudInfo (
					t_cloudId	INT,
					t_cloudStatus	INT,
					t_pseudoClientId    INT,
					t_cloudName NVARCHAR(255),
					t_cloudDisplayName NVARCHAR(255),
					)
IF object_id('tempdb.dbo.#zkNodeInfo') IS NOT NULL drop table #zkNodeInfo
create table #zkNodeInfo(
					t_cloudId    INT,
					t_nodeClientId    INT,
					t_nodeStatus    INT,
					t_nodeClientName NVARCHAR(255),
					t_nodeHostName NVARCHAR(255),
					t_zkNodeMetaInfo XML,
					t_ListenerPort INT DEFAULT 0,
					t_ElectionPort INT DEFAULT 0,
					t_DataPort INT  DEFAULT 0,
					t_ServerId INT  DEFAULT 0,
					t_serverInfo NVARCHAR(2048),
					t_zkDataDir NVARCHAR(1024)
				)
--get ZK Cloud details
	INSERT INTO #zkCloudInfo (t_cloudId, t_cloudStatus, t_pseudoClientId, t_cloudName, t_cloudDisplayName)
	SELECT DISTINCT DC.cloudId, DC.status, C.id, C.name, C.displayName
	FROM APP_Client C WITH(READUNCOMMITTED)
	JOIN DM2Cloud DC WITH(READUNCOMMITTED) ON	DC.pseudoClientId = C.id
WHERE DC.Cloudtype = 6
--get ZK node details
	INSERT INTO #zkNodeInfo (t_cloudId, t_nodeClientId, t_nodeClientName, t_nodeHostName, t_nodeStatus, t_zkNodeMetaInfo)
	SELECT S.cloudId, S.clientId, C.name, C.net_HostName, S.status, S.nodeProps
	FROM #zkCloudInfo ZK
	JOIN DM2SearchServerCoreInfo S WITH(READUNCOMMITTED) ON	ZK.t_cloudId = S.cloudId
	JOIN APP_Client C WITH(READUNCOMMITTED) ON	S.clientId = C.id
--Get ZK node meta properties
	IF object_id('tempdb.dbo.#zkNodeMetaProperties') IS NOT NULL drop table #zkNodeMetaProperties
	create table #zkNodeMetaProperties (clientId INT, attName NVARCHAR(1024), attVal NVARCHAR(1024))
	INSERT INTO #zkNodeMetaProperties
	SELECT DISTINCT C.t_nodeClientId, a.value('@name', 'NVARCHAR(1024)'),a.value('@value', 'NVARCHAR(1024)')
	FROM #zkNodeInfo C
	CROSS APPLY C.t_zkNodeMetaInfo.nodes('NodeMetaProp/nodeMetaInfos') rc(a)
	WHERE        a.value('@value', 'NVARCHAR(1024)') IS NOT NULL
--Get ZK node pivot properties
	IF object_id('tempdb.dbo.#zkNodePivotMetaProperties') IS NOT NULL drop table #zkNodePivotMetaProperties
	create table #zkNodePivotMetaProperties (
								t_zkNodeClientId      INT,
								t_zkNodeListenerPort INT ,
								t_ZKDataPort	INT ,
								t_zkElectionPort INT ,
								t_zkServerID    INT,
								t_zkServerInfo  NVARCHAR(2048),
								t_zkDataDir NVARCHAR(1024)
								)
	INSERT #zkNodePivotMetaProperties (t_zkNodeClientId, t_zkNodeListenerPort, t_ZKDataPort, t_zkElectionPort, t_zkServerID, t_zkServerInfo, t_zkDataDir)
	SELECT clientId,
				zkListenerPort AS t_zkNodeListenerPort,
				zkDataPort AS t_ZKDataPort,
				zkElectionPort AS t_zkElectionPort,
				zkServerID AS t_zkServerID,
				ISNULL(zkServerInfo,N'') AS t_zkServerInfo,
				ISNULL(zkDataDir,N'') AS t_zkDataDir
		FROM (
			SELECT  clientId, attVal, attName FROM #zkNodeMetaProperties
			) AS ZKNodeList
		PIVOT ( MAX( attVal ) FOR attName IN ( zkListenerPort, zkDataPort, zkElectionPort, zkServerID, zkServerInfo, zkDataDir)
		) AS P
--update zk node meta details
	UPDATE #zkNodeInfo
	SET t_ListenerPort = ZK.t_zkNodeListenerPort,
	t_DataPort = ZK.t_ZKDataPort,
	t_ElectionPort = ZK.t_zkElectionPort,
	t_ServerID = ZK.t_zkServerID,
	t_serverInfo = ZK.t_zkServerInfo,
	t_zkDataDir = ZK.t_zkDataDir
	FROM #zkNodePivotMetaProperties ZK
	WHERE t_nodeClientId = ZK.t_zkNodeClientId
--OUTPUT
SET @o_cloudInfoXML = ISNULL(( SELECT ( SELECT  (SELECT  6 AS '@type',
										0 AS '@opType',
                                        ZC.t_cloudStatus '@status',
										(SELECT
                                            ZC.t_pseudoClientId AS '@clientId'
											FOR XML PATH ('indexServerClient'), TYPE),
										 (SELECT
                                            ZC.t_cloudId AS '@cloudId',
                                            ZC.t_cloudName AS '@cloudName',
											ZC.t_cloudDisplayName AS '@cloudDisplayName'
											FOR XML PATH ('cloudInfoEntity'), TYPE),
											(select S.t_nodeStatus '@status',
													0 AS '@opType',
												(SELECT
												  S.t_nodeClientId AS '@clientId',
												  S.t_nodeClientName AS '@clientName',
												  S.t_nodeHostName AS '@hostName'
												  FOR XML PATH ('nodeClientEntity'), TYPE),
												(SELECT
													'zkDataPort' AS '@name',
													S.t_DataPort AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkElectionPort' AS '@name',
													S.t_ElectionPort AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkListenerPort' AS '@name',
													S.t_ListenerPort AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkServerId' AS '@name',
													S.t_ServerId AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkDataDir' AS '@name',
													S.t_zkDataDir AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkServerInfo' AS '@name',
													S.t_serverInfo AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE)
												FROM #zkNodeInfo S
												WHERE S.t_cloudId = ZC.t_cloudId
												ORDER BY S.t_ServerId
                                                FOR XML PATH('cloudNodes'), TYPE)
										FROM #zkCloudInfo ZC
										FOR XML PATH ('cloudInfoList'), TYPE)
										FOR XML PATH ('App_HACClusterListResp'), TYPE)
								 ),'<App_HACClusterListResp/>')
--OUTPUT
SELECT @o_cloudInfoXML
IF object_id('tempdb.dbo.#zkCloudInfo') IS NOT NULL drop table #zkCloudInfo
IF object_id('tempdb.dbo.#zkNodeInfo') IS NOT NULL drop table #zkNodeInfo
IF object_id('tempdb.dbo.#zkNodeMetaProperties') IS NOT NULL drop table #zkNodeMetaProperties
IF object_id('tempdb.dbo.#zkNodePivotMetaProperties') IS NOT NULL drop table #zkNodePivotMetaProperties
GO
SET QUOTED_IDENTIFIER ON

IF EXISTS (select * from GxQscripts where name = 'AppSmartClientGroupForHACCluster')
	delete from GxQscripts where name = 'AppSmartClientGroupForHACCluster'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartClientGroupForHACCluster')
	delete from GXDBVersions where aliasname = 'AppSmartClientGroupForHACCluster'
GO

insert into GXDBVersions values(2, 'AppSmartClientGroupForHACCluster',  '00010001000400050000', 'AppSmartClientGroupForHACCluster', '00010001000400050000')
GO

