

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSmartClientGroupForCloud.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSmartClientGroupForCloud.sp,v $ $Id: AppSmartClientGroupForCloud.sp,v 1.1.4.13 2020/06/09 04:22:30 kvinayak Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppSmartClientGroupForCloud
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSmartClientGroupForCloud')
BEGIN
	print '>>> Drop Stored Procedure: AppSmartClientGroupForCloud <<<'
	drop procedure AppSmartClientGroupForCloud
END
IF EXISTS (select * from GxQscripts where name='AppSmartClientGroupForCloud')
	delete from GxQscripts where name = 'AppSmartClientGroupForCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartClientGroupForCloud')
	delete from GXDBVersions where aliasname = 'AppSmartClientGroupForCloud'
GO
print '... Creating Procedure: AppSmartClientGroupForCloud'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSmartClientGroupForCloud
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--		This sp is used to create smart client group for Conent Analyzer , Index server
--		when corresponding package is installed
--
--			N_WIN_PACKAGE_CONTENT_ANALYZER
--			N_WIN_PACKAGE_MEDIAAGENT_ANALYTICS
--			i_cloudType  =  6 - Solr Server
--						= 10	-Content Analyzer
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_cloudType integer
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorString varchar(1024) = 'Success'
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
IF @i_cloudType IN ( 6, 10, 12)
BEGIN
	DECLARE @ownerId INT
	DECLARE @smartClientGroupId INT = 0
	SET @ownerId = ISNULL((SELECT TOP(1) id from UMUsers WITH (NOLOCK) where (flags & 64 = 64)), 1)
	DECLARE @SmartClientsQuery nvarchar (max)
	DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))
	DECLARE @clientGrpXML NVARCHAR(MAX)= N''
	DECLARE @unixTime INT = dbo.getUnixTime(GETDATE())
IF @i_cloudType = 6  --APP_SCG_CLOUD_TYPE_SOLR_SERVER
	BEGIN
IF NOT EXISTS (SELECT 1 FROM APP_ClientGroupProp (nolock) WHERE attrName = 'Client Group Unique Id' AND attrVal = 8 AND modified=0)
		BEGIN
			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId)
values('Index Servers', 'Select Clients which have analytics index configured', 4096, 0, @ownerId, 0, '0', '', 2)
			SET @smartClientGroupId = SCOPE_IDENTITY()
			IF @smartClientGroupId = 0
			BEGIN
				SET @o_errorCode = 1
				SET @o_errorString =  'Fail to create smart client group for Index Servers'
				GOTO PROC_EXIT
			END
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@smartClientGroupId, 'Client Group Unique Id', 7, 8, @unixTime, 0),
(@smartClientGroupId, 'System Created', 7, 0, @unixTime, 0)
			--SCG_PKID_SOLR_SERVERS_CLIENT  = 46
			SET @clientGrpXML = N'<scgRule op="0"><rules><rule op="0"><rules> <rule filterID="1" propID="46" propType="1" /> </rules> </rule></rules></scgRule>'
		END
	END
ELSE IF @i_cloudType = 10  --APP_SCG_CLOUD_TYPE_CONTENT_ANALYZER
	BEGIN
IF NOT EXISTS (SELECT 1 FROM APP_ClientGroupProp (nolock) WHERE attrName = 'Client Group Unique Id' AND attrVal = 9 AND modified=0)
		BEGIN
			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId)
			values('Content Analyzer Cloud', 'Select Clients which have content extractor configured', 4096, 0, @ownerId, 0, '0', '', 2)
			SET @smartClientGroupId = SCOPE_IDENTITY()
			IF @smartClientGroupId = 0
			BEGIN
				SET @o_errorCode = 2
				SET @o_errorString =  'Fail to create smart client group for Content Analyzer Cloud'
				GOTO PROC_EXIT
			END
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@smartClientGroupId, 'Client Group Unique Id', 7, 9, @unixTime, 0),
(@smartClientGroupId, 'System Created', 7, 0, @unixTime, 0)
			--SCG_PKID_ANALYZER_SERVERS_CLIENT  = 54
			SET @clientGrpXML = N'<scgRule op="0"><rules><rule op="0"><rules> <rule filterID="1" propID="54" propType="1" /> </rules> </rule></rules></scgRule>'
		END
	END
ELSE IF @i_cloudType = 12  --APP_SCG_CLOUD_TYPE_HAC_CLUSTER
	BEGIN
IF NOT EXISTS (SELECT 1 FROM APP_ClientGroupProp (nolock) WHERE attrName = 'Client Group Unique Id' AND attrVal = 5 AND modified=0)
		BEGIN
			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId)
			values('HAC Cluster', 'Select Clients which have HAC is configured', 4096, 0, @ownerId, 0, '0', '', 2)
			SET @smartClientGroupId = SCOPE_IDENTITY()
			IF @smartClientGroupId = 0
			BEGIN
				SET @o_errorCode = 3
				SET @o_errorString =  'Fail to create smart client group for HAC Cluster'
				GOTO PROC_EXIT
			END
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@smartClientGroupId, 'Client Group Unique Id', 7, 5, @unixTime, 0),
(@smartClientGroupId, 'System Created', 7, 0, @unixTime, 0)
			--SCG_PKID_HAC_CLUSTER_CLIENT  = 85
			SET @clientGrpXML = N'<scgRule op="0"><rules><rule op="0"><rules> <rule filterID="1" propID="85" propType="1" /> </rules> </rule></rules></scgRule>'
		END
	END
	IF @smartClientGroupId != 0
	BEGIN
		EXEC APPSCGV2GenerateQueryParams @clientGrpXML, @o_errorCode OUTPUT, @o_errorString OUTPUT, @SmartClientsQuery OUTPUT
		IF (@o_errorCode = 0)
		BEGIN
			insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			values(@smartClientGroupId,
				@clientGrpXML,
				@SmartClientsQuery,
				1, 0, '0')
			--Set the creator with either Master role (that has all capabilities) or with System owner capabilities role (present against entityType(1) and entityID(2) in UMOwnerRoles table)
			DECLARE @smartClientGrpCreatorRoleId INT
			SET @smartClientGrpCreatorRoleId = ISNULL((SELECT roleId FROM UMOwnerRoles WHERE entityType = 1 AND entityID = 2),
													(SELECT id FROM UMRoles WHERE name = 'Master' AND (flags & (1 | 2) <> 0)))
			DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
			EXEC sec_setCreatorForEntity @creatorUserId = 0,
										@creatorRoleId =  @smartClientGrpCreatorRoleId,
										@creatorPermissions = '',
										@errorCode = @o_errorCode OUTPUT,
										@errorString = @o_errorString OUTPUT,
										@entityTYpe1 = 28,          /*CLIENT_GROUP_ENTITY*/
										@entityId1 = @smartClientGroupId,
										@creatorUserGroupId = @masterUserGroupId,
										@loggedInUserId = @ownerId
			-- Now update App_Clientgroup table also with this creator Id.
			EXEC sec_getCreateAsUserId 28 /*CLIENT_GROUP_ENTITY*/,
										@smartClientGroupId,
										@ownerId OUTPUT
			UPDATE App_ClientGroup
			SET userId = @ownerId
			WHERE
				id = @smartClientGroupId
		END
	END
END
PROC_EXIT:
---OUTPUT
SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppSmartClientGroupForCloud')
	delete from GxQscripts where name = 'AppSmartClientGroupForCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartClientGroupForCloud')
	delete from GXDBVersions where aliasname = 'AppSmartClientGroupForCloud'
GO

insert into GXDBVersions values(2, 'AppSmartClientGroupForCloud',  '00010001000400130000', 'AppSmartClientGroupForCloud', '00010001000400130000')
GO

