

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSizeOfJobVMs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSizeOfJobVMs.sp,v $ $Id: AppSizeOfJobVMs.sp,v 1.2.40.4 2020/05/05 01:59:01 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSizeOfJobVMs')
BEGIN
	print '>>> Drop Stored Procedure: AppSizeOfJobVMs <<<'
	drop procedure AppSizeOfJobVMs
END
IF EXISTS (select * from GxQscripts where name='AppSizeOfJobVMs')
	delete from GxQscripts where name = 'AppSizeOfJobVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSizeOfJobVMs')
	delete from GXDBVersions where aliasname = 'AppSizeOfJobVMs'
GO
print '... Creating Procedure: AppSizeOfJobVMs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSizeOfJobVMs
  @dummy INT = 0
AS
SET NOCOUNT ON
/* This temp table is created and populated entries per non-IndexingV2 VSA job by the caller.
   This procedure is not working for IndexingV2 VSA jobs that child job details per VM are already in JMBkpStats table.
   The jobId, commCellId, appId, bkpLevel, startDate and endDate columns must be set.
	CREATE	TABLE #JobVMs (
		jobId INT, commCellId INT, appId INT, bkpLevel INT, startDate INT, endDate INT,
		vmClientId INT, vmStatus INT, vmFailureReason VARCHAR(512), vmAppSize BIGINT, vmGuestSize BIGINT, vmSize BIGINT
	)
*/
INSERT INTO #JobVMs
SELECT	B.jobId, B.commCellId, B.appId, B.bkpLevel,
		MAX(CASE WHEN V.attrName = 'vmBackupStartTime' THEN CAST(V.attrVal AS INT) ELSE 0 END),
		MAX(CASE WHEN V.attrName = 'vmBackupEndTime' THEN CAST(V.attrVal AS INT) ELSE 0 END),
		V.VMclientId,
		MAX(CASE WHEN V.attrName = 'vmStatus' THEN CAST(V.attrVal AS INT) ELSE -1 END),
		'',
		MAX(CASE WHEN V.attrName = 'vmUsedSpace' THEN CAST(V.attrVal AS BIGINT) ELSE 0 END),
		MAX(CASE WHEN V.attrName = 'vmGuestSize' THEN CAST(V.attrVal AS BIGINT) ELSE 0 END),
		MAX(CASE WHEN V.attrName = 'vmSize' THEN CAST(V.attrVal AS BIGINT) ELSE 0 END)
FROM	APP_VMProp V WITH (NOLOCK)
		INNER JOIN #JobVMs B ON B.jobId = V.jobId AND B.commCellId = V.commCellId
WHERE	V.attrName IN ('vmBackupStartTime', 'vmBackupEndTime', 'vmStatus', 'vmUsedSpace', 'vmGuestSize', 'vmSize')
GROUP BY B.jobId, B.commCellId, B.appId, B.bkpLevel, V.VMclientId
UPDATE	#JobVMs SET vmFailureReason =  LEFT(V.attrVal, 512)
FROM	APP_VMProp V WITH (NOLOCK)
		INNER JOIN #JobVMs J ON V.jobId = J.jobId AND V.commCellId = J.commCellId AND V.VMclientId = J.VMclientId AND J.vmStatus <> 0
WHERE	V.attrName = 'vmFailureReason' AND V.attrVal <> ''
-- vmUsedSpace may not be set for Synthetic Full jobs
CREATE TABLE #SynthFullJobVM (jobId INT, commCellId INT, AppId INT, BkpLevel INT, StartDate INT, EndDate INT)
; WITH SFJobNoVM (jobId, commCellId) AS
(
	SELECT	jobId, commCellId
	FROM	#JobVMs
	WHERE	BkpLevel IN (64, 128, 16384)
	GROUP BY jobId, commCellId
	HAVING SUM(VMclientId) = 0
)
INSERT INTO #SynthFullJobVM
SELECT	J.jobId, J.commCellId, J.appId, J.bkpLevel, J.startDate, J.endDate
FROM	#JobVMs J INNER JOIN SFJobNoVM SF ON J.jobId = SF.jobId AND J.commCellId = SF.commCellId
-- If the previous full cycle still exists, set VM sizes of the synthetic full job to the maximum VM sizes of the full cycle.
IF EXISTS (SELECT * FROM #SynthFullJobVM)
BEGIN
	; WITH LastFullJobPerVM (jobId, commCellId, AppId, BkpLevel, StartDate, EndDate, FullJobId) AS
	(
		SELECT	J.jobId, J.commCellId, J.AppId, J.BkpLevel, J.StartDate, J.EndDate, MAX(B.jobId)
		FROM	#SynthFullJobVM J
				INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.appId = J.AppId
		WHERE	B.bkpLevel IN (1, 1024, 32768) AND B.status IN (1, 14)
			AND B.jobId < J.jobId AND B.commCellId = J.commCellId
		GROUP BY J.jobId, J.commCellId, J.AppId, J.BkpLevel, J.StartDate, J.EndDate
	)
	INSERT INTO #JobVMs
	SELECT	J.jobId, J.commCellId, J.appId, J.BkpLevel, J.StartDate, J.EndDate, V.VMclientId, 0, '',
			MAX(CASE WHEN V.attrName = 'vmUsedSpace' THEN CAST(V.attrVal AS BIGINT) ELSE 0 END),
			MAX(CASE WHEN V.attrName = 'vmGuestSize' THEN CAST(V.attrVal AS BIGINT) ELSE 0 END),
			MAX(CASE WHEN V.attrName = 'vmSize' THEN CAST(V.attrVal AS BIGINT) ELSE 0 END)
	FROM	LastFullJobPerVM J
			INNER JOIN JMBkpStats B WITH (NOLOCK)
				ON B.appId = J.AppId AND B.jobId >= J.FullJobId AND B.jobId < J.jobId AND B.commCellId = J.commCellId
			INNER JOIN APP_VMProp V WITH (NOLOCK)
				ON V.jobId = B.JobId AND V.commCellId = B.commCellId
				AND V.attrName IN ('vmUsedSpace', 'vmGuestSize', 'vmSize')
	GROUP BY J.jobId, J.commCellId, J.appId, J.BkpLevel, V.VMclientId, J.StartDate, J.EndDate
END
DROP TABLE #SynthFullJobVM
DELETE FROM #JobVMs WHERE ISNULL(VMclientId, 0) = 0 OR ISNULL(vmStatus, -1) = -1
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSizeOfJobVMs')
	delete from GxQscripts where name = 'AppSizeOfJobVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSizeOfJobVMs')
	delete from GXDBVersions where aliasname = 'AppSizeOfJobVMs'
GO

insert into GXDBVersions values(2, 'AppSizeOfJobVMs',  '00010002004000040000', 'AppSizeOfJobVMs', '00010002004000040000')
GO

