

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppShortUrlConvertion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppShortUrlConvertion							|
--	|		Procedure to create a short URL from a URL					|
--	|		Or return a long URL from a short URL						|
--	+===================================================================+
--	i_flag -> 1 (one time access, the entry will be deleted once the long URL is accessed)
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppShortUrlConvertion')
BEGIN
	print '>>> Drop Stored Procedure: AppShortUrlConvertion <<<'
	drop procedure AppShortUrlConvertion
END
IF EXISTS (select * from GxQscripts where name='AppShortUrlConvertion')
	delete from GxQscripts where name = 'AppShortUrlConvertion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppShortUrlConvertion')
	delete from GXDBVersions where aliasname = 'AppShortUrlConvertion'
GO
print '... Creating Procedure: AppShortUrlConvertion'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppShortUrlConvertion
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId INT,
  @i_longUrl NVARCHAR(MAX) OUTPUT,
  @i_shortUrl NVARCHAR(MAX) OUTPUT,
  @o_errorCode INT OUTPUT,
  @i_flag INT=0,
  @returnCursor INT = 0 
-----------------------------------------------------------
AS
  DECLARE @o_cur_longUrl NVARCHAR(MAX)
  DECLARE @o_cur_shortUrl NVARCHAR(MAX) 
  DECLARE @o_cur_errorCode INT
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @shortHash INT = CHECKSUM(@i_shortUrl)
	DECLARE @id INT
	SET @o_errorCode = 0
	IF LEN (@i_longUrl) > 0 AND (@i_shortUrl = '' OR @i_shortUrl IS NULL)
	BEGIN
		DECLARE @errorCode			INT = 0
		DECLARE @errorString		NVARCHAR(MAX) = ''
		DECLARE @pos INT = 0
		DECLARE @rnd INT = 0
		DECLARE @charPool NVARCHAR(MAX) = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890'
		DECLARE @Upper INT = LEN(@charPool)
		DECLARE @Lower INT = 1 -- THE LOWEST RANDOM NUMBER
		DECLARE @urlLen INT = LEN(@i_longUrl)
		DECLARE @length INT = 5 + ROUND((10 * RAND()), 0)
		DECLARE @origLength INT = @length
		DECLARE @longHash INT = CHECKSUM(@i_longUrl)
		DECLARE @loopCount INT = 0
		SELECT @i_shortUrl = ISNULL(shortUrl, ''), @id = ISNULL(id, 0)
		FROM App_ShortUrl WITH (NOLOCK)
		WHERE longHash = @longHash AND longUrl = @i_longUrl
		IF @i_shortUrl = ''
		BEGIN
RETRY_CONVERT:
			IF (@length > @urlLen)
				SET @length = @urlLen
			WHILE @length > 0
			BEGIN
				SELECT @rnd = ROUND(((@Upper - @Lower -1) * RAND() + @Lower), 0)
				SET @i_shortUrl = @i_shortUrl + SUBSTRING(@charPool, @rnd, 1)
				SET @length = @length - 1
			END
			--CHECK IF SHORT URL WAS ALREADY GENERATED
			SET @shortHash = CHECKSUM(@i_shortUrl)
			IF EXISTS(SELECT 1 FROM App_ShortUrl WHERE shortHash = @shortHash AND shortUrl = @i_shortUrl)
			BEGIN
				SET @length = @origLength
				SET @loopCount = @loopCount + 1
				IF @loopCount < 10
					GOTO RETRY_CONVERT
				SET @o_errorCode =  1
				GOTO ERROR_EXIT
			END
			INSERT INTO App_ShortUrl (longUrl, shortUrl, userId, created, modified, lastAccessed, count, flag)
			VALUES(@i_longUrl, @i_shortUrl, @i_userId, @nowTime, 0, @nowTime, 0, @i_flag)
		END
		ELSE
		BEGIN
			UPDATE App_ShortUrl
			SET lastAccessed = @nowTime, count = count + 1 , flag = @i_flag
			WHERE id = @id
		END
	END
	ELSE
	BEGIN
		DECLARE @flag int = 0
	   	SELECT @i_longUrl = longUrl, @id = id, @flag = flag
		FROM App_ShortUrl WITH (NOLOCK)
		WHERE shortHash = @shortHash AND shortUrl = @i_shortUrl
	    --if flag is 1 - OneTimeAccess, then remove entry once it is accessed
		IF (@flag & 1) = 1
			DELETE FROM App_ShortUrl WHERE id=@id
		ELSE
			UPDATE App_ShortUrl
			SET lastAccessed = @nowTime, count = count + 1
			WHERE id = @id
	END
IF @returnCursor = 1
BEGIN
SELECT @o_cur_longUrl = @i_longUrl, @o_cur_shortUrl = @i_shortUrl, @o_cur_errorCode = @o_errorCode -- for evmgrs calls to output the results.
SELECT @o_cur_longUrl, @o_cur_shortUrl, @o_cur_errorCode
END
ERROR_EXIT:
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppShortUrlConvertion')
	delete from GxQscripts where name = 'AppShortUrlConvertion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppShortUrlConvertion')
	delete from GXDBVersions where aliasname = 'AppShortUrlConvertion'
GO

insert into GXDBVersions values(2, 'AppShortUrlConvertion',  '00000000000000000000', 'AppShortUrlConvertion', '00000000000000000000')
GO

