

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingUpdateConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSharingUpdateConfig						|
--	|       Procedure for modifying  an existing Share Folder			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSharingUpdateConfig')
BEGIN
	print '>>> Drop Stored Procedure: AppSharingUpdateConfig <<<'
	drop procedure AppSharingUpdateConfig
END
IF EXISTS (select * from GxQscripts where name='AppSharingUpdateConfig')
	delete from GxQscripts where name = 'AppSharingUpdateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingUpdateConfig')
	delete from GXDBVersions where aliasname = 'AppSharingUpdateConfig'
GO
print '... Creating Procedure: AppSharingUpdateConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingUpdateConfig
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @UTypeUser			INT = 1
DECLARE @UTypeEmail			INT = 2
	DECLARE @userExists			INT = 0
	DECLARE @isDeletedUser		INT = 0
	DECLARE @permissionReduced	INT = 0
    DECLARE @assocCount			INT = 0
	DECLARE @i					INT = 1
	DECLARE @assocXML			XML
	DECLARE @userType			INT = 0
	DECLARE @sharedBy			INT = 0
	DECLARE @userStatus			INT = 0
	DECLARE @opEvMsgId			INT = 0
	DECLARE @dataIsEvent		INT = 0
	DECLARE @opMsgId			INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
	DECLARE @sharedTo			NVARCHAR(MAX) = ''
	DECLARE @shareToName		NVARCHAR(MAX) = ''
	DECLARE @userName			NVARCHAR(MAX) = ''
	DECLARE @permission			INT = 0
	DECLARE @shareToTable		TABLE (sharedTo NVARCHAR(MAX), userType INT, shareToName NVARCHAR(MAX), errorCode INT, errorString NVARCHAR(MAX))
	DECLARE @browseInfo			XML
	DECLARE @flag				INT
	DECLARE @oldFlag			INT
	DECLARE @oldDescription		NVARCHAR(MAX) = ''
	DECLARE @oldShareName		NVARCHAR(MAX) = ''
	DECLARE @oldFlagParam		INT
	DECLARE @oldFlagVal			NVARCHAR(MAX) = ''
	DECLARE @flagParam			INT
	DECLARE @flagVal			NVARCHAR(MAX) = ''
	DECLARE @userDeleted		INT
	DECLARE @permissionParam	INT
	DECLARE @isPswdSet			INT = 0
	DECLARE @isOldPswdSet		INT = 0
	DECLARE @permissionVal		NVARCHAR(MAX) = ''
	DECLARE @shortUrl			NVARCHAR(MAX) = ''
	DECLARE @oldPasswordCheck	NVARCHAR(MAX) = ''
	DECLARE @oldPassword		NVARCHAR(MAX) = ''
	DECLARE @newPassword		NVARCHAR(MAX) = ''
	DECLARE @oldRtnPassword		NVARCHAR(MAX) = ''
	DECLARE @oldExpirationDate	NVARCHAR(MAX) = ''
	DECLARE @deletedTable		TABLE (sharedTo NVARCHAR(MAX), userType INT)
	DECLARE @insertedTable		TABLE (sharedTo NVARCHAR(MAX), userType INT)
	DECLARE @permissionChangeTable	TABLE (sharedTo NVARCHAR(MAX), userType INT)
	-- READ THE XML
	DECLARE @shareName			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo/shareFolder') R(ref)), '')
	DECLARE @description		NVARCHAR(MAX)	= ISNULL (( SELECT ref.value('@description', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo') R(ref)), '')
	DECLARE @shareId			INT = ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
													FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo/shareFolder') R(ref)), 0)
	DECLARE @ownerId			INT = ISNULL (( SELECT ref.value('@userId', 'INT')
													FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo/owner') R(ref)), @i_userId)
	DECLARE @status				INT = ISNULL (( SELECT ref.value('@status', 'INT')
													FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo') R(ref)), 0)
	DECLARE @operationType		INT = ISNULL (( SELECT ref.value('@sharedToOperationType', 'INT')
FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo') R(ref)), 1)
	DECLARE @browseXMLReq		XML =  @i_xmlString.query('/App_UpdateSharedFolderReq/shareInfo/browseInfo')
	DECLARE @emailInfo			XML =  @i_xmlString.query('/App_UpdateSharedFolderReq/shareInfo/browseInfo/emailInfo')
	--DECLARE @browseUrl			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@browseUrl', 'NVARCHAR(MAX)')
														--FROM @i_xmlString.nodes ('/App_UpdateSharedFolderReq/shareInfo/browseInfo/emailInfo') R(ref)), '')
	DECLARE @canReshare			INT = ISNULL (( SELECT ref.value('@canReshare', 'INT')
													FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo') R(ref)), 0)
	DECLARE @reshareFlag		INT = 0
	DECLARE @expiration			XML = @i_xmlString.query('/App_UpdateSharedFolderReq/shareInfo/browseInfo/expirationTime')
	DECLARE @reshareOperationType INT = ISNULL (( SELECT ref.value('@reshareOperationType', 'INT')
													FROM @i_xmlString.nodes ('App_UpdateSharedFolderReq/shareInfo') R(ref)), 0) --NONE=0, OVERTAKE=1, DELETE=2
	DECLARE @reshareId INT = 0
	DECLARE @reshareSharedBy INT = 0
	DECLARE @deleteShareXML XML = '<App_DeleteSharedFolderReq><shareFolder syncWebFolderId="0"/></App_DeleteSharedFolderReq>';
	DECLARE @isReshareDeleted	INT = 0
	DECLARE @expirationTime		INT = ISNULL (( SELECT ref.value('@time', 'INT')
														FROM @expiration.nodes ('expirationTime') R(ref)), 0)
	DECLARE @expirationDate		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@timeValue', 'NVARCHAR(MAX)')
														FROM @expiration.nodes ('expirationTime') R(ref)), dbo.GetDateTime(@expirationTime))
	DECLARE @password			XML = @i_xmlString.query('/App_UpdateSharedFolderReq/shareInfo/browseInfo/password')
	DECLARE @reSharedBy			INT = @ownerId
	DECLARE @parentShareId		INT = 0
	DECLARE @parentShareSharedBy	INT = 0
	DECLARE @isSet				INT = ISNULL (( SELECT ref.value('@isSet', 'INT')
														FROM @password.nodes ('/password') R(ref)), 0)
	DECLARE @isGeneratePwd				INT = ISNULL (( SELECT ref.value('@generatePassword', 'INT')
														FROM @password.nodes ('/password') R(ref)), 0)
	DECLARE @enforcePwdForPublicLink INT = 0
SET @flag = (SELECT CASE @status WHEN 1 THEN 0x8
WHEN 4 THEN 0x80
ELSE 0x4
				END
				)
	IF OBJECT_ID('tempdb.dbo.#reshares') IS NOT NULL
		DROP TABLE #reshares
	IF @shareId < 1
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid share Folder info in update request.'
		GOTO ERROR_EXIT
	END
	SET @ownerId = ISNULL( (SELECT ownerId FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @shareId), 0)
	If @ownerId = 0
	BEGIN
SET @errorCode = (2272 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	--FOR RESHARED SHARE, OWNER WILL BE THE PARENT SHARE OWNER SO NEED TO CHECK WITH THE SHAREDBY USER
	SELECT @reSharedBy = sharedBy FROM App_SharingUserInfo WITH(NOLOCK) WHERE shareId = @shareId
	IF (@i_userId <> @reSharedBy)
	BEGIN
		--SELECT @userName = login FROM UMUsers WITH (NOLOCK) WHERE id = @i_userId
SET @errorCode = (2273 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	--IF EXISTS (SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK)
	--				WHERE syncWebFolderName = @shareName
	--				AND syncWebFolderId <> @shareId
	--				AND ownerId = @ownerId
	--				AND flag & (CAST(SYNC_FOLDER_IS_SHARE_FOLDER AS INT)|CAST(SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER AS INT)) <> 0	--CHECK THAT FOLDER IS A SHARE
	--				AND flag & @flag = @flag	--WE CAN NOW HAVE PRIVATE AND PUBLIC SHARE WITH SAME NAME
	--			)
	--BEGIN
	--	SET @errorCode = GUIMSG_SHARE_FOLDER_NAME_EXISTS
	--	SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
	--	GOTO ERROR_EXIT
	--END
	-- GET PARENT SHARE DETAILS
	SELECT @parentShareId = SC.parentShareId, @parentShareSharedBy = SU.sharedBy FROM App_SyncCloudConfig SC WITH(NOLOCK)
		JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SC.parentShareId
		WHERE SC.syncWebFolderId = @shareId
		AND SU.isOwner = 1
	BEGIN TRAN
		--GET INITIAL VALUES
		SELECT @oldShareName = syncWebFolderName,
		--@oldFlag = flag,
		@oldDescription = description
		FROM App_SyncCloudFolder
		WHERE syncWebFolderId = @shareId
SET @flag = (SELECT CASE @status WHEN 1 THEN 0x8
WHEN 4 THEN 0x80
ELSE 0x4
				END
				)
		IF @shareName = ''
			Set @shareName = @oldShareName
		-- UPDATE THE SHARE FOLDER
		UPDATE App_SyncCloudFolder
		SET syncWebFolderName = @shareName,
		description = @description,
		--ownerId = @ownerId,
		modified = @nowTime
		--flag = @flag
		WHERE syncWebFolderId = @shareId
	--
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR_EXIT
	--
		-- SET GUI AUDIT OPERATION
SET @opMsgId = (399 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 1, 2, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @shareName, @dataIsEvent
SET @paramMsgId = (1082 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		IF @oldShareName != @shareName
		BEGIN
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @oldShareName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @shareName, @dataIsEvent
SET @paramMsgId = (1089 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		-- Get initial values for the reshare flag
		SELECT @oldFlag = flag
		FROM App_SyncCloudConfig
		WHERE syncWebFolderId = @shareId
SET @reshareFlag = (SELECT CASE @canReshare WHEN 1 THEN 0x10
ELSE 0x8
							END
							)
		IF @oldFlag != @reshareFlag
		BEGIN
			UPDATE App_SyncCloudConfig
SET flag = (flag & ~(CAST(0x8 AS INT)|CAST(0x10 AS INT))) | @reshareFlag
			WHERE syncWebFolderId = @shareId
			SET @oldFlagVal = (SELECT CASE @canReshare WHEN 1 THEN 'OFF'
								ELSE 'ON'
								END
								)
			SET @flagVal = (SELECT CASE @canReshare WHEN 1 THEN 'ON'
								ELSE 'OFF'
								END
								)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @oldFlagVal, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @flagVal, @dataIsEvent
SET @paramMsgId = (1210 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			-- DELETE RE-SHARES IF RESHARE FLAG WAS ON PREVIOUSLY AND NOW TURNED OFF
IF @canReshare = 0 AND (@oldFlag & 0x10 = 0x10)
			BEGIN
				IF @reshareOperationType = 2
				BEGIN
					DECLARE @resharesCursor CURSOR
					-- GET ALL THE RE_SHARES oF THE SHARE
					WITH cteReShares (syncWebFolderId, parentShareId)
					AS
					(
						SELECT syncWebFolderId, parentShareId FROM App_SyncCloudConfig WHERE syncWebFolderId = @shareId
						UNION ALL
						SELECT sc.syncWebFolderId, sc.parentShareId FROM App_SyncCloudConfig sc
							INNER JOIN cteReShares cs ON sc.parentShareId = cs.syncWebFolderId
					)
					SELECT DISTINCT CS.syncWebFolderId, SU.sharedBy INTO #tempReshares FROM cteReShares CS JOIN App_SharingUserInfo SU
						ON CS.syncWebFolderId = SU.shareId WHERE CS.syncWebFolderId <> @shareId
					SET @resharesCursor = CURSOR FOR
						select syncWebFolderId, sharedBy from #tempReshares
					OPEN @resharesCursor
					FETCH NEXT FROM @resharesCursor INTO @reshareId, @reshareSharedBy
					WHILE @@FETCH_STATUS = 0
					BEGIN
						SET @deleteShareXML.modify('replace value of (/App_DeleteSharedFolderReq/shareFolder/@syncWebFolderId)[1] with sql:variable("@reshareId")')
						EXEC AppSharingDeleteShareFolder @deleteShareXML, @reshareSharedBy, @i_localeId
						SELECT @errorCode = @@ERROR
						IF @errorCode <> 0 GOTO ERROR_EXIT
						FETCH NEXT FROM @resharesCursor INTO @reshareId, @reshareSharedBy
					END;
					CLOSE @resharesCursor;
					DEALLOCATE @resharesCursor;
					DELETE #tempReshares
					SET @isReshareDeleted = 1 --FLAG TO TELL THAT THE RE-SHARES ARE DELETED
				END
			END
		END
		--IF @oldFlag != @flag
		--BEGIN
		--	SET @oldFlagParam =
		--		(SELECT CASE WHEN @oldFlag&SYNC_FOLDER_IS_SHARE_FOLDER = SYNC_FOLDER_IS_SHARE_FOLDER THEN GUIAUDIT_PARAMS_SHARE_FOLDER_PRIVATE_MODE
		--		WHEN @oldFlag&SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER = SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER THEN GUIAUDIT_PARAMS_SHARE_FOLDER_PUBLIC_MODE
		--		END)
		--	SET @oldFlagVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @oldFlagParam, 0, 2)
		--	SET @flagParam =
		--		(SELECT CASE WHEN @flag&SYNC_FOLDER_IS_SHARE_FOLDER = SYNC_FOLDER_IS_SHARE_FOLDER THEN GUIAUDIT_PARAMS_SHARE_FOLDER_PRIVATE_MODE
		--		WHEN @flag&SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER = SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER THEN GUIAUDIT_PARAMS_SHARE_FOLDER_PUBLIC_MODE
		--		END)
		--	SET @flagVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @flagParam, 0, 2)
		--	-- SET GUI AUDIT PARAMETER
		--	EXEC EvGuiAuditSetParamData @opId, @oldFlagVal, @dataIsEvent
		--	EXEC EvGuiAuditSetParamData @opId, @flagVal, @dataIsEvent
		--	SET @paramMsgId = GUIAUDIT_PARAMS_SHARE_FOLDER_UPDATE_MODE
		--	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		--END
		IF @browseXMLReq.exist('/browseInfo') > 0
		BEGIN
			SELECT @browseInfo = configOptions
			FROM App_SyncCloudConfig WITH(NOLOCK)
			WHERE syncWebFolderId = @shareId
	--
			IF LEN(CAST(@emailInfo AS NVARCHAR(MAX))) > 0
			BEGIN
				DECLARE @dontSendEmail INT = ISNULL (( SELECT ref.value('@dontSendEmail', 'INT')
											FROM @emailInfo.nodes ('/emailInfo') R(ref)), 0)
				DECLARE @emailMessage NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@emailMessage', 'NVARCHAR(MAX)')
													FROM @emailInfo.nodes ('/emailInfo') R(ref)), '')
				IF (@browseInfo.exist('/browseInfo/emailInfo')) <> 1
					SET @browseInfo.modify('insert sql:variable("@emailInfo") into (/browseInfo)[1]')
				SET @browseInfo.modify('replace value of (/browseInfo/emailInfo/@emailMessage)[1] with sql:variable("@emailMessage")')
				SET @browseInfo.modify('replace value of (/browseInfo/emailInfo/@dontSendEmail)[1] with sql:variable("@dontSendEmail")')
			END
	--
			DECLARE @oldExpirationTime INT = ISNULL (( SELECT ref.value('@time', 'INT')
													FROM @browseInfo.nodes ('//expirationTime') R(ref)), 0)
			IF @expiration.exist('/expirationTime/@time') = 1 OR @browseInfo.exist('/browseInfo/expirationTime/@time') = 1 --WHEN PREVIOUSLY SET BUT NOW NOT PASSED (EQUIVALENT TO NEVER EXPIRE)
			BEGIN
				SET @oldExpirationDate = ISNULL (( SELECT ref.value('@timeValue', 'NVARCHAR(MAX)')
													FROM @browseInfo.nodes ('//expirationTime') R(ref)), dbo.GetDateTime(@oldExpirationTime))
				IF (@browseInfo.exist('/browseInfo/expirationTime')) = 1
					SET @browseInfo.modify('delete /browseInfo/expirationTime [1]')
				IF (@browseInfo.exist('/browseInfo/expirationTime')) <> 1
					SET @browseInfo.modify('insert sql:variable("@expiration") into (/browseInfo)[1]')
				IF @oldExpirationTime <> @expirationTime
				BEGIN
					--REMOVE THE EXPIRE FLAG
					UPDATE App_SyncCloudFolder
SET flag = flag & ~CAST(0x40 AS INT)
					WHERE syncWebFolderId = @shareId
					-- SET GUI AUDIT PARAMETER
					EXEC EvGuiAuditSetParamData @opId, @oldExpirationDate, @dataIsEvent
					EXEC EvGuiAuditSetParamData @opId, @expirationDate, @dataIsEvent
SET @paramMsgId = (1202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
					--VALIDATE WITH PARENT EXPIRATION (IF ANY)
					IF @parentShareId <> 0
					BEGIN
						DECLARE @parentShareBrowseInfo XML = ISNULL((SELECT configOptions FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @parentShareId), '')
						IF (@parentShareBrowseInfo.exist('/browseInfo/expirationTime/@time')) = 1
						BEGIN
							DECLARE @parentShareExpirationTime BIGINT = ISNULL (( SELECT ref.value('@time', 'BIGINT')
													FROM @parentShareBrowseInfo.nodes ('//expirationTime') R(ref)), 0)
							IF (@expirationTime > @parentShareExpirationTime AND @parentShareExpirationTime <> 0) OR @expirationTime <= 0 -- 0=NEVER EXPIRE
							BEGIN
								SET @expirationTime = @parentShareExpirationTime
								SET @browseInfo.modify('replace value of (/browseInfo/expirationTime/@time)[1] with sql:variable("@expirationTime")')
							END
						END
					END
				END
				--IF EXPIRATION TIME IS DECREASED, UPDATE EXPIRATION FOR CHILD RE-SHARES (IF THEIR EXPIRATION IS GREATER)
				IF (@expirationTime <> 0 AND @expirationTime < @oldExpirationTime) OR (@expirationTime > 0 AND @oldExpirationTime = 0) --NEVER EXPIRE=0
				BEGIN
					DECLARE @childSharesCursor CURSOR
					DECLARE @syncWebFolderId INT
					DECLARE @childShareExpirationTime BIGINT
					DECLARE @childShareBrowseInfo XML = '';
					-- GET THE LIST OF CHILD RE-SHARES
					WITH cteChildShares (syncWebFolderId, parentShareId)
					AS
					(
						SELECT syncWebFolderId, parentShareId FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @shareId
						UNION ALL
						SELECT sc.syncWebFolderId, sc.parentShareId FROM App_SyncCloudConfig sc
							INNER JOIN cteChildShares cs ON sc.parentShareId = cs.syncWebFolderId
					)
					SELECT syncWebFolderId INTO #temp FROM cteChildShares WHERE syncWebFolderId <> @shareId
					--BEGIN TRAN
					SET @childSharesCursor = CURSOR FOR SELECT syncWebFolderId FROM #temp
					OPEN @childSharesCursor FETCH NEXT FROM @childSharesCursor INTO @syncWebFolderId
					WHILE @@FETCH_STATUS = 0
					BEGIN
						SET @childShareBrowseInfo = ISNULL((SELECT configOptions FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @syncWebFolderId), '')
						IF (@childShareBrowseInfo.exist('/browseInfo/expirationTime/@time')) = 1
						BEGIN
							SET @childShareExpirationTime = ISNULL (( SELECT ref.value('@time', 'BIGINT')
													FROM @childShareBrowseInfo.nodes ('//expirationTime') R(ref)), 0)
							IF (@childShareExpirationTime > @expirationTime AND @childShareExpirationTime <> 0) OR @childShareExpirationTime <= 0 -- 0=NEVER EXPIRE
								SET @childShareBrowseInfo.modify('replace value of (/browseInfo/expirationTime/@time)[1] with sql:variable("@expirationTime")')
						END
						ELSE -- NEVER EXPIRE CASE
						BEGIN
							IF @childShareBrowseInfo.exist('browseInfo/expirationTime') = 1
							BEGIN
								IF @childShareBrowseInfo.exist('browseInfo/expirationTime/@time') = 1
									SET @childShareBrowseInfo.modify('replace value of (/browseInfo/expirationTime/@time)[1] with sql:variable("@expirationTime")')
								ELSE
									SET @childShareBrowseInfo.modify('insert (attribute time {sql:variable("@expirationTime")}) into (/browseInfo/expirationTime)[1]')
							END
							ELSE
							BEGIN
								SET @childShareBrowseInfo.modify('insert <expirationTime/> into (/browseInfo)[1]')
								SET @childShareBrowseInfo.modify('insert (attribute time {sql:variable("@expirationTime")}) into (/browseInfo/expirationTime)[1]')
							END
						END
						UPDATE App_SyncCloudConfig SET configOptions = @childShareBrowseInfo WHERE syncWebFolderId = @syncWebFolderId
						SELECT @errorCode = @@ERROR
						IF @errorCode <> 0 GOTO ERROR_EXIT
						FETCH NEXT FROM @childSharesCursor INTO @syncWebFolderId
					END
				END
			END
--
			-- if public share
IF ((@flag & CAST(0x8 AS INT) = CAST(0x8 AS INT)) OR
(@flag & CAST(0x80 AS INT) = CAST(0x80 AS INT)))
			BEGIN
				-- check if additional setting EnforcePasswordForPublicLink is enabled for the user.
				DECLARE @consoleSettingXML xml = '<App_ConsoleSettingsFilter><keyNameList val="EnforcePasswordForPublicLink"/></App_ConsoleSettingsFilter>'
				exec AppGetConsoleSettingsList @i_userId,1,@consoleSettingXML output
				SET @enforcePwdForPublicLink = (SELECT TOP 1 1 FROM @consoleSettingXML.nodes ('/App_ConsoleSettingsListResp/consoleSettings') R(ref) WHERE ref.value('@atterValue', 'NVARCHAR(MAX)')='true')
				-- Enforce password for public share if not set and auto generate password.
				IF(@enforcePwdForPublicLink = 1 AND @isSet <> 1)
				BEGIN
SET @errorCode = (3631 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
					GOTO ERROR_EXIT
				END
			END
--
			IF @password.exist('/password/@isSet') = 1 OR @browseInfo.exist('/password/@isSet') = 1
			BEGIN
				SET @isPswdSet = ISNULL (( SELECT ref.value('@isSet', 'INT')
																FROM @password.nodes ('/password') R(ref)), 0)
				SET @newPassword = ISNULL (( SELECT ref.value('@password', 'NVARCHAR(MAX)')
											FROM @password.nodes ('/password') R(ref)), '')
				SET @isOldPswdSet = ISNULL (( SELECT ref.value('@isSet', 'INT')
											FROM @browseInfo.nodes ('/browseInfo/password') R(ref)), 0)
				SET @oldPassword = ISNULL (( SELECT ref.value('@password', 'NVARCHAR(MAX)')
											FROM @browseInfo.nodes ('/browseInfo/password') R(ref)), '')
				SET @oldRtnPassword = ISNULL (( SELECT ref.value('@oldPassword', 'NVARCHAR(MAX)')
											FROM @browseInfo.nodes ('/browseInfo/password') R(ref)), '')
				DECLARE @isOldPasswordSystemGenerated INT  = ISNULL (( SELECT ref.value('@generatePassword', 'INT')
													FROM @browseInfo.nodes ('/browseInfo/password') R(ref)), 0)
				DECLARE @decryptedPwd NVARCHAR(MAX)
				BEGIN TRY
					IF @isGeneratePwd = 1
					BEGIN
						--if old password was system generated and now we again get a system generate password in request we will not generate the password each time.
						IF(@isOldPasswordSystemGenerated<>1)
						BEGIN
							EXEC APPGeneratePassword @newPassword OUTPUT
							SET @decryptedPwd = dbo.base64Encode(@newPassword)
						END
					END
					ELSE
					BEGIN
						-- Password is in base64encoded->V3encrypted->base64encoded format
						IF((CHARINDEX('|#',@newPassword, 1)) >0 )
						BEGIN
							 SET @newPassword=(select dbo.DecodeInvalidXMLChar(@newPassword))
							 SET @newPassword = SUBSTRING(@newPassword,2,LEN(@newPassword))
						END
						SET @newPassword = dbo.base64Decode(@newPassword)
						exec miscProc2 @newPassword, @decryptedPwd OUTPUT
					END
					SET @newPassword = @decryptedPwd -- We keep the password in base64 encoded format
					IF (@password.exist('/password/@password')) = 1
						SET @password.modify('replace value of (/password/@password)[1] with sql:variable("@newPassword")')
					ELSE
						SET @password.modify('insert (attribute password {sql:variable("@newPassword")}) into (/password)[1]')
					IF (@isPswdSet <> @isOldPswdSet) OR (@isPswdSet = 1 AND @oldPassword <> @newPassword AND @newPassword <> '')
					BEGIN
						IF (@browseInfo.exist('/browseInfo/password')) = 1
							SET @browseInfo.modify('delete /browseInfo/password [1]')
						IF (@browseInfo.exist('/browseInfo/password')) <> 1
							SET @browseInfo.modify('insert sql:variable("@password") into (/browseInfo)[1]')
						IF @isPswdSet = 1 AND @isOldPswdSet = 1
						BEGIN
SET @paramMsgId = (128 | (CAST(POWER(2, 24) AS BIGINT) * 83))
							EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
						END
						ELSE IF @isPswdSet <> 1 AND @isOldPswdSet = 1
						BEGIN
SET @paramMsgId = (1201 | (CAST(POWER(2, 24) AS BIGINT) * 85))
							EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
						END
						ELSE IF @isPswdSet = 1 AND @isOldPswdSet <> 1
						BEGIN
SET @paramMsgId = (1200 | (CAST(POWER(2, 24) AS BIGINT) * 85))
							EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
						END
						-- PASSWORD COMPLEXITY VALIDATION
						IF @isPswdSet = 1
						BEGIN
							DECLARE @isStrongPwd INT = 0
							DECLARE @encryptedPwd NVARCHAR(MAX)
							SET @newPassword = dbo.base64Decode(@decryptedPwd) -- Plain text password
							EXEC dbo.pswEncryptionManaged @newPassword , @encryptedPwd OUTPUT
							DECLARE @psErrorCode int = 0
							EXEC sec_isPasswordStrong @encryptedPwd, @isStrongPwd OUTPUT, @errorString OUTPUT, @i_localeId, @psErrorCode OUTPUT
							IF @isStrongPwd = 0
							BEGIN
								SET @errorCode=400
								GOTO ERROR_EXIT
							END
						END
					END
					--storing the previous password to determine if password email has to be sent to the owner
					IF @oldRtnPassword <> @oldPassword
					BEGIN
						IF (@browseInfo.exist('/browseInfo/password/@oldPassword')) = 1
							SET @browseInfo.modify('replace value of (/browseInfo/password/@oldPassword)[1] with sql:variable("@oldPassword")')
						ELSE
							SET @browseInfo.modify('insert (attribute oldPassword {sql:variable("@oldPassword")}) into (/browseInfo/password)[1]')
					END
				END TRY
				BEGIN CATCH
					SET @errorCode=ERROR_NUMBER()
					SET @errorString = ERROR_MESSAGE()
					GOTO ERROR_EXIT
				END CATCH
			END
	--
			UPDATE App_SyncCloudConfig
			SET configOptions = @browseInfo
			WHERE syncWebFolderId = @shareId
	--
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR_EXIT
		END
		-- ADD/UPDATE/DELETE USERS FOR THIS SHARE FOLDER
		SET @assocCount = @i_xmlString.value('count(//.[@userType])', 'INT')
IF @operationType = 1 --AND @assocCount > 0
		BEGIN
			--DELETE FROM App_SharingUserInfo
			UPDATE App_SharingUserInfo SET deleted = 1
			OUTPUT inserted.sharedTo, inserted.userType
			INTO @deletedTable
			WHERE shareId = @shareId
			AND
			(
				sharedBy = @i_userId	--FOLDER IS SHARED BY USER
				OR
				EXISTS (SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @shareId AND ownerId = @i_userId)	--USER IS OWNER OF FOLDER
			)
			AND isOwner = 0	--DO NOT CHANGE THE OWNER
			--AND excluded = 0 --MR# 168429
			AND
			(
				(SELECT(CASE
							WHEN userType = 1 AND sharedTo = @parentShareSharedBy THEN 1
							ELSE 0
						END)) = 0 -- DO NOT DELETE IMMEDIATE PARENT SHARE OWNER
			)
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR_EXIT
		END
		WHILE (@i <= @assocCount)
		BEGIN
			SET @userExists = 0
			SET @isDeletedUser = 0
			SET @permissionReduced = 0
			SET @assocXML = @i_xmlString.query('(//.[@userType])[sql:variable("@i")]')
			SET @permission = ISNULL (( SELECT ref.value('@permission', 'INT')
										FROM @assocXML.nodes ('sharedTo') R(ref)), 0)
			SET @sharedBy = ISNULL (( SELECT ref.value('@userId', 'INT')
										FROM @assocXML.nodes ('sharedTo/sharedBy') R(ref)), @i_userId)
			SET @userStatus = ISNULL (( SELECT ref.value('@userStatus', 'INT')
										FROM @assocXML.nodes ('sharedTo') R(ref)), 0)
--
			DELETE @shareToTable
--
			INSERT INTO @shareToTable
			EXEC AppSharingSetUserConfig @assocXML, @i_userId, @i_localeId
			SELECT TOP 1 @sharedTo = sharedTo, @userType = userType, @shareToName = shareToName, @errorCode = errorCode, @errorString = errorString
			FROM @shareToTable
			IF @errorCode <> 0 GOTO ERROR_EXIT
			IF EXISTS (SELECT 1 FROM App_SharingUserInfo WITH (NOLOCK) WHERE shareId = @shareId AND sharedTo = @sharedTo AND userType = @userType)
			BEGIN
				SET @userExists = 1
				IF EXISTS (SELECT 1 FROM App_SharingUserInfo WITH (NOLOCK) WHERE shareId = @shareId AND sharedTo = @sharedTo AND userType = @userType AND deleted = 1)
					SET @isDeletedUser = 1
				--CHECK IF PERMISSION LEVEL IS REDUCED i.e. FROM 2->1(EDIT->VIEW). THIS VALRIABLE IS USED TO CHANGE PERMISSIONS IN THE RE-SHARE ITEMS.
SELECT  @permissionReduced = case WHEN (permission&2=2 AND @permission&2<>2)
OR (permission&4=4 AND @permission&4<>4) THEN 1
													ELSE 0
											   END FROM App_SharingUserInfo WITH (NOLOCK) WHERE shareId = @shareId AND sharedTo = @sharedTo AND userType = @userType
			END
IF @operationType = 3
			BEGIN
				-- DELETE EXISTING ENTRIES FOR THE USER
				--DELETE FROM App_SharingUserInfo
				UPDATE App_SharingUserInfo SET deleted = 1
				WHERE shareId = @shareId AND sharedTo = @sharedTo AND userType = @userType
				SELECT @errorCode = @@ERROR
				IF @errorCode <> 0 GOTO ERROR_EXIT
--
				INSERT INTO @deletedTable (sharedTo, userType)
				SELECT @sharedTo, @userType
--
				GOTO NEXT
			END
IF @operationType = 2 OR (@operationType = 1 AND @userExists = 0)
			BEGIN
				-- If user is deleted earlier, just bring him back with new permission ELSE update with new permissions
				IF @isDeletedUser = 1 OR (@userExists = 1 AND @isDeletedUser = 0)
				BEGIN
					UPDATE App_SharingUserInfo
					SET deleted = 0,
					excluded = (CASE @userStatus WHEN 2 THEN 1 ELSE 0 END),
					permission = @permission,
					--modified = @nowTime,
					enabled =	(
									CASE WHEN @userStatus = 1 /*DISABLED*/ THEN 0
									ELSE 1 /*ENABLED*/
									END
								)
					WHERE shareId = @shareId
					AND sharedTo = @sharedTo AND userType = @userType
					SELECT @errorCode = @@ERROR
					IF @errorCode <> 0 GOTO ERROR_EXIT
				END
				ELSE
				BEGIN
					-- ADD ENTRIES FOR THE USER
					INSERT INTO App_SharingUserInfo(shareId, sharedTo, sharedBy, userType, enabled, deleted,  permission, created, modified, isOwner, excluded)
											VALUES(@shareId, @sharedTo, @sharedBy, @userType, 1, 0, @permission, @nowTime, 0, 0, (CASE @userStatus WHEN 2 THEN 1 ELSE 0 END))
					SELECT @errorCode = @@ERROR
					IF @errorCode <> 0 GOTO ERROR_EXIT
				END
				IF @shareToName IS NULL OR @shareToName = ''
					SET @shareToName =
(SELECT CASE WHEN @userType = 1 THEN (SELECT login FROM UMUsers WITH (NOLOCK) WHERE CAST(id AS NVARCHAR(MAX)) = @sharedTo)
WHEN @userType = 2 THEN @sharedTo
WHEN @userType IN(3, 4) THEN (SELECT name FROM UMGroups WITH (NOLOCK) WHERE CAST(id AS NVARCHAR(MAX)) = @sharedTo)
									END)
--
				INSERT INTO @insertedTable (sharedTo, userType)
				SELECT @shareToName, @userType
--
				GOTO NEXT
			END
IF @operationType = 1
			BEGIN
				-- DELETE EXISTING ENTRIES FOR THE USER
				--DELETE FROM App_SharingUserInfo
				UPDATE App_SharingUserInfo
				SET deleted = 0,
				--excluded = 0, --MR# 168429. USER WILL BE IN EXCLUDED LIST EVEN IF OWNER REMOVES AND ADD AGAIN
				permission = @permission,
				--modified = @nowTime,
				enabled =	(
								CASE WHEN @userStatus = 1 /*DISABLED*/ THEN 0
								ELSE 1 /*ENABLED*/
								END
							)
				WHERE shareId = @shareId
				AND sharedTo = @sharedTo AND userType = @userType
				SELECT @errorCode = @@ERROR
				IF @errorCode <> 0 GOTO ERROR_EXIT
--
				DELETE @deletedTable
				WHERE sharedTo = @sharedTo
				AND userType = @userType
--
--
				IF @permissionReduced = 1
					INSERT INTO @permissionChangeTable (sharedTo, userType) SELECT @sharedTo, @userType
--
				GOTO NEXT
			END
		NEXT:
			SET @i  = @i +1
		END
	--NO NEED TO AUDIT PUBLIC FOLDERS USERS SINCE ARE ONLY USED TO SEND MAIL
	IF @status = 1
		GOTO ERROR_EXIT
	-- Remove all entries from NTalertsubscriptions for Deleted users/groups
if exists(select 1 from @deletedTable where userType = 3 OR userType = 4 Or userType = 1 )
	BEGIN
		-- Remove subscriptions for users to this share who are not associated to this share anymore.
		UPDATE NTAlertsubscriptions
		SET flags = 0
		FROM NTAlertsubscriptions WITH (NOLOCK)
INNER JOIN @deletedTable deletedTable ON deletedTable.sharedTo = NTAlertSubscriptions.userId AND deletedTable.userType=1
		AND NTAlertsubscriptions.entityId1 = @shareId
AND NTAlertsubscriptions.EntityType1 = 7987
		-- Remove subscriptions for users to this share whose user groups are not associated to this share anymore. Unless user is added to share explicitly
		UPDATE NTAlertsubscriptions
		SET flags = 0
		FROM NTAlertsubscriptions WITH (NOLOCK)
INNER JOIN @deletedTable deletedTable ON (deletedTable.userType=3 OR deletedTable.userType = 4 )
		AND NTAlertsubscriptions.entityId1 = @shareId
AND NTAlertsubscriptions.EntityType1 = 7987
		INNER JOIN UMUserGroup WITH (NOLOCK) ON deletedTable.sharedTo = UMUserGroup.groupId AND
		UMUserGroup.userId = NTAlertSubscriptions.userId
		LEFT JOIN App_SharingUserInfo UsersSharedTo ON UsersSharedTo.shareId = @shareId
AND UsersSharedTo.userType = 1
			AND UsersSharedTo.excluded = 0
			AND UsersSharedTo.deleted = 0
			AND UsersSharedTo.enabled = 1
			AND UsersSharedTo.sharedTo =  NTAlertSubscriptions.userId
			WHERE UsersSharedTo.shareId IS NULL
	END
	--AUDIT USER CHANGES
	DECLARE @reshareCount	INT = 0,
			@iterator		INT = 0
	DECLARE shareToChangeCur CURSOR
	FOR
		SELECT sharedTo, userType, 1, 0 FROM @deletedTable
		UNION
		SELECT sharedTo, userType, 0, 0 FROM @insertedTable
		UNION
		SELECT sharedTo, userType, 0, 1 FROM @permissionChangeTable
	OPEN shareToChangeCur
	FETCH FROM shareToChangeCur INTO @sharedTo, @userType, @userDeleted, @permissionReduced
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @permissionReduced = 1 OR @userDeleted = 1
		BEGIN
			--GET THE RE-SHAREIDs
			IF @userType = @UTypeUser OR @userType = @UTypeEmail --RE-SHARE CAN BE CREATED ONLY BY USERS AND NOT GROUPS
				SELECT IDENTITY(int, 1, 1) AS RowID, SC.syncWebFolderId INTO #reshares FROM App_SyncCloudConfig SC WITH(NOLOCK)
										JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SC.syncWebFolderId = SU.shareId
										WHERE SC.parentShareId = @shareId
										AND SU.sharedBy =
										(
											CASE WHEN @userType = @UTypeUser THEN @sharedTo
											WHEN @userType = @UTypeEmail THEN ISNULL((SELECT id FROM UMUsers WITH(NOLOCK) WHERE email = @sharedTo), 0)
											END
										)
			SET @reshareCount = @@ROWCOUNT --GET THE TOTAL NO. OF RESHARES
			SET	@iterator = 1 --RESET THE ITERATOR
		END
		--CHANGE PERMISSION LEVEL OF THE RE-SHARES CREATED BY THE USER
		IF @permissionReduced = 1 AND @reshareCount <> 0
		BEGIN
			-- Get all the child shared folder which has EDIT permissions
			WITH cteShares (syncWebFolderId, parentShareId)
				AS
				(
					SELECT syncWebFolderId, parentShareId FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @shareId
					UNION ALL
					SELECT sc.syncWebFolderId, sc.parentShareId FROM App_SyncCloudConfig sc
						INNER JOIN cteShares cs ON sc.parentShareId = cs.syncWebFolderId
						INNER JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SC.syncWebFolderId = SU.shareId AND SU.permission <> 1
				)
			SELECT syncWebFolderId INTO #tempPermChange FROM cteShares WHERE syncWebFolderId <> @shareId
UPDATE App_SharingUserInfo SET permission = CASE WHEN permission&4=0 THEN @permission&~4
															ELSE @permission
														END
				WHERE shareId IN (SELECT syncWebFolderId FROM #tempPermChange)
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR_EXIT
			DELETE #tempPermChange
		END
		IF @userDeleted = 1
		BEGIN
			--DELETE ALL THE RE-SHARES CREATED BY THE REMOVED USER
			IF @isReshareDeleted = 0 AND @reshareOperationType <> 0 --NONE=0
			BEGIN
				--DELETE ALL THE RE-SHARES CREATED BY THE REMOVED USER
				WHILE (@iterator <= @reshareCount)
				BEGIN
					SELECT @reshareId=syncWebFolderId FROM #reshares WHERE RowID = @iterator -- GET THE RESHARE ID FROM THE TABLE
					IF @reshareOperationType = 2 AND @reshareId <> 0
					BEGIN
						SET @deleteShareXML.modify('replace value of (/App_DeleteSharedFolderReq/shareFolder/@syncWebFolderId)[1] with sql:variable("@reshareId")')
						SET @reshareSharedBy = ISNULL((SELECT DISTINCT sharedBy FROM App_SharingUserInfo WITH(NOLOCK) WHERE shareId = @reshareId), 0)
						EXEC AppSharingDeleteShareFolder @deleteShareXML, @reshareSharedBy, @i_localeId
					END
					-- OVERTAKE THE RE-SHARES CREATED BY THE REMOVED USER
					ELSE IF @reshareOperationType = 1 AND @reshareId <> 0
					BEGIN
						UPDATE App_SharingUserInfo SET sharedTo = @i_userId WHERE shareId = @reshareId AND isOwner=1
						UPDATE App_SharingUserInfo SET sharedBy = @i_userId WHERE shareId = @reshareId
					END
					SET @iterator = @iterator + 1
				END
			END
			SET @sharedTo =
(SELECT CASE WHEN @userType = 1 THEN (SELECT login FROM UMUsers WITH (NOLOCK) WHERE CAST(id AS NVARCHAR(MAX)) = @sharedTo)
WHEN @userType = 2 THEN @sharedTo
WHEN @userType IN(3, 4) THEN (SELECT name FROM UMGroups WITH (NOLOCK) WHERE CAST(id AS NVARCHAR(MAX)) = @sharedTo)
				END)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @sharedTo, @dataIsEvent
			SET @paramMsgId =
(SELECT CASE WHEN @userType = 1 THEN (1091 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 2 THEN (1093 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 3 THEN (1095 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 4 THEN (1095 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				END)
		END
		ELSE
		BEGIN
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @sharedTo, @dataIsEvent
            		SET @permissionParam =
(SELECT CASE WHEN @permission&2 = 2 THEN (1085 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @permission&1 = 1 THEN (1086 | (CAST(POWER(2, 24) AS BIGINT) * 85))
               			 END)
			SET @permissionVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @permissionParam, 0, 2)
			EXEC EvGuiAuditSetParamData @opId, @permissionVal, @dataIsEvent
			SET @paramMsgId =
(SELECT CASE WHEN @userType = 1 THEN (1090 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 2 THEN (1092 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 3 THEN (1094 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 4 THEN (1094 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				END)
		END
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		IF OBJECT_ID('tempdb.dbo.#reshares') IS NOT NULL
			DROP TABLE #reshares
		FETCH FROM shareToChangeCur INTO @sharedTo, @userType, @userDeleted, @permissionReduced
	END
	CLOSE shareToChangeCur
	DEALLOCATE shareToChangeCur
ERROR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#reshares') IS NOT NULL
		DROP TABLE #reshares
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0
			ROLLBACK TRAN
	END
	ELSE
		COMMIT TRAN
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('App_GenericResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingUpdateConfig')
	delete from GxQscripts where name = 'AppSharingUpdateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingUpdateConfig')
	delete from GXDBVersions where aliasname = 'AppSharingUpdateConfig'
GO

insert into GXDBVersions values(2, 'AppSharingUpdateConfig',  '00000000000000000000', 'AppSharingUpdateConfig', '00000000000000000000')
GO

