

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingSetUserConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingSetUserConfig.sp,v $ $Id: AppSharingSetUserConfig.sp,v 1.5.2.5 2018/08/08 15:22:57 njain Exp $";
--	+===================================================================+
--	|  					  AppSharingSetUserConfig						|
--	|          Procedure for setting sharedBy info for Shared Folder	|
--	|          and to add user and user group entries in DB				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingSetUserConfig <<<'

IF EXISTS (select * from sysobjects where name='AppSharingSetUserConfig')
	drop procedure AppSharingSetUserConfig
IF EXISTS (select * from GxQscripts where name='AppSharingSetUserConfig')
	delete from GxQscripts where name = 'AppSharingSetUserConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingSetUserConfig')
	delete from GXDBVersions where aliasname = 'AppSharingSetUserConfig'
GO
print '... Creating Procedure: AppSharingSetUserConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingSetUserConfig
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_sharedTo NVARCHAR(MAX)
  DECLARE @o_userType INT
  DECLARE @o_sharedToName NVARCHAR(MAX)
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
BEGIN
	DECLARE @userId				INT = 0
	DECLARE @groupName			NVARCHAR(MAX) = ''
	DECLARE @userGroupId		INT = 0
	DECLARE @userName			NVARCHAR(MAX) = ''
	DECLARE @providerName		NVARCHAR(MAX) = ''
	DECLARE @shareToEmail		NVARCHAR(MAX) = ''
	DECLARE @providerId			INT = 0
	DECLARE @ccId				INT = 2
	DECLARE @pos				INT = 0
	DECLARE @newUserFlag		INT = 0x001
	DECLARE @groupDescription	NVARCHAR(MAX) = 'Group created for sharing'
	DECLARE @userDescription	NVARCHAR(MAX) = 'User created for sharing'
	DECLARE @userGUID			NVARCHAR(MAX)
	SET @o_userType = ISNULL (( SELECT ref.value('@userType', 'INT')
								FROM @i_xmlString.nodes ('sharedTo') R(ref)), 0)
	SET @shareToEmail = ISNULL (( SELECT ref.value('@email', 'NVARCHAR(MAX)')
							FROM @i_xmlString.nodes ('sharedTo') R(ref)), '')
IF @o_userType = 1	--USER
	BEGIN
		SET @o_sharedTo = ISNULL (( SELECT ref.value('@userId', 'NVARCHAR(MAX)')
								FROM @i_xmlString.nodes ('sharedTo/user') R(ref)), '')
		SET @userGUID = ISNULL (( SELECT ref.value('@userGUID', 'NVARCHAR(MAX)')
								FROM @i_xmlString.nodes ('sharedTo/user') R(ref)), '')
		SET @o_sharedToName = ISNULL (( SELECT ref.value('@userName', 'NVARCHAR(MAX)')
									FROM @i_xmlString.nodes ('sharedTo/user') R(ref)), '')
		IF @o_sharedTo = '' OR @o_sharedTo = '0'
		BEGIN
			SET @o_sharedTo = @o_sharedToName
			SET @userId = ISNULL ((SELECT id FROM UMUsers WHERE login = @o_sharedTo), 0)
			IF @userId = 0
			BEGIN
				--CREATE USER
				SET @pos = CHARINDEX('\', @o_sharedTo)
				IF @pos <> 0
				BEGIN
					SET @providerName = LTRIM(RTRIM(LEFT(@o_sharedTo, @pos-1)))
					SET @userName = RIGHT(@o_sharedTo, LEN(@o_sharedTo)-@pos)
				END
				SET @userId = ISNULL ((SELECT id FROM UMUsers WHERE login = @o_sharedTo), 0)
				if @userId=0
				begin
					select @userId = id from UMUsers where userGuid=@userGUID
					Update UMUsers
					set login = @o_sharedTo,
					enabled = 1, password='2AZdUUxUUyUUz', flags = 1
					where id=@userId
				end
				IF @userId = 0
				BEGIN
					--CREATE USER
					SET @providerId = ISNULL((SELECT id FROM UMDSProviders WHERE domainName = @providerName), 0)
					IF (@providerId = 0)
					BEGIN
						SET @o_errorCode = 1
						SET @o_errorString = 'Error : Domain [' + @providerName + '] not found for User: ' + @o_sharedTo
						GOTO ERROR
					END
					INSERT INTO UMUsers (name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified, pVer, Pager, lastLogInTime, credSetTime, umDSproviderId, userGuid, origUserGuid, origCCId)
					VALUES (@userName, @userDescription, @o_sharedTo, '2AZdUUxUUyUUz', @shareToEmail, 0, 0, 0, 1, @newUserFlag, 0, 50, '', 0, 0, @providerId, @userGUID, '', @ccId)
					SELECT @o_errorCode = @@ERROR, @userId = @@IDENTITY
					IF @o_errorCode <> 0 GOTO ERROR
				END
			END
			SET @o_sharedTo = CAST(@userId AS NVARCHAR(MAX))
		END
	END
ELSE IF @o_userType = 2	--EMAIL
	BEGIN
		SET @o_sharedTo = @shareToEmail
		SET @o_sharedToName = @shareToEmail
	END
ELSE IF @o_userType = 3	--CC GROUP
	BEGIN
		SET @o_sharedTo = ISNULL (( SELECT ref.value('@userGroupId', 'INT')
								FROM @i_xmlString.nodes ('sharedTo/group') R(ref)), '')
		SET @o_sharedToName = ISNULL (( SELECT ref.value('@userGroupName', 'NVARCHAR(MAX)')
								FROM @i_xmlString.nodes ('sharedTo/group') R(ref)), '')
		IF @o_sharedTo = '' OR @o_sharedTo = '0'
		BEGIN
			-------------------------------------------------------------------------------------------------------------------
			-- MR# 216594 - Validation for AD group by parsing the group name and look for slash delimeter. If found return error.
			SET @pos = CHARINDEX('\', @o_sharedToName)
			IF @pos <> 0
			BEGIN
				SET @providerName = LTRIM(RTRIM(LEFT(@o_sharedToName, @pos-1)))
				IF EXISTS (SELECT 1 FROM UMDSProviders WHERE domainName = @providerName)
				BEGIN
					SET @o_errorCode = 1
					SET @o_errorString = 'Error: Invalid userType provided in the request for the domain group [' + @o_sharedToName + ']'
					GOTO ERROR
				END
			END
			-------------------------------------------------------------------------------------------------------------------
			SET @o_sharedTo = @o_sharedToName
			SET @userGroupId = ISNULL ((SELECT id FROM UMGroups WHERE umdsProviderId=0 AND name = @o_sharedTo ), 0)
			IF @userGroupId = 0
			BEGIN
				--CREATE GROUP
				INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID)
				VALUES (1, 0, 0, 1, @o_sharedTo, @groupDescription, @ccId, NEWID())
				SELECT @o_errorCode = @@ERROR, @userGroupId = @@IDENTITY
				IF @o_errorCode <> 0 GOTO ERROR
			END
			SET @o_sharedTo = CAST(@userGroupId AS NVARCHAR(MAX))
		END
	END
ELSE IF @o_userType = 4	--EXTERNAL GROUP
	BEGIN
		--support all these cases
		--group: commvault-nj\Dev-Server
		--group: Dev-Server providerId: 1
		--group: Dev-Server providerDomainName: commvault-nj
		SET @o_sharedTo = ISNULL (( SELECT ref.value('@groupId', 'INT')
								FROM @i_xmlString.nodes ('sharedTo/externalGroup') R(ref)), '')
		SET @o_sharedToName = ISNULL (( SELECT ref.value('@externalGroupName', 'NVARCHAR(MAX)')
								FROM @i_xmlString.nodes ('sharedTo/externalGroup') R(ref)), '')
		IF @o_sharedTo = '' OR @o_sharedTo = '0'
		BEGIN
			SET @groupName = @o_sharedToName
			SET @providerId = ISNULL (( SELECT ref.value('@providerId', 'NVARCHAR(MAX)')
										FROM @i_xmlString.nodes ('sharedTo/externalGroup') R(ref)), 0)
		IF @providerId = 0
		BEGIN
			SET @pos = CHARINDEX('\', @groupName)
			IF @pos <> 0
			BEGIN
				SET @providerName = LTRIM(RTRIM(LEFT(@groupName, @pos-1)))
				SET @groupName = RIGHT(@groupName, LEN(@groupName)-@pos)
			END
			SET @providerName = ISNULL (( SELECT ref.value('@providerDomainName', 'NVARCHAR(MAX)')
									FROM @i_xmlString.nodes ('sharedTo/externalGroup') R(ref)), @providerName)
			SET @providerId = ISNULL((SELECT id FROM UMDSProviders WHERE domainName = @providerName), 0)
			IF (@providerId = 0)
			BEGIN
				SET @o_errorCode = 1
				SET @o_errorString = 'Error : Domain [' + @providerName + '] not found for Group: ' + @groupName
				GOTO ERROR
			END
		END
		SET @userGroupId = ISNULL ((SELECT id FROM UMDSgroups WHERE name = @groupName AND @providerID = umdsProviderId), 0)
		IF @userGroupId = 0
		BEGIN
			--CREATE AD GROUP
			INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
			VALUES (1, 0, 0, 1, @groupName, @groupDescription, 2, NEWID(), @providerId, @shareToEmail, 0)
			SELECT @userGroupId = @@IDENTITY
			INSERT INTO UMDSgroups(id, umdsProviderId, enabled, name, description, email, lastCredSetTime, oldId)
			SELECT UMGroups.id, @providerId, 1, @groupName, @groupDescription, @shareToEmail, 0, 0
			FROM UMGroups
			WHERE UMGroups.name = @groupName AND UMGroups.umdsProviderId = @providerId
			SELECT @o_errorCode = @@ERROR
			IF @o_errorCode <> 0 GOTO ERROR
		END
		SET @o_sharedTo = CAST(@userGroupId AS NVARCHAR(MAX))
	END
	END
	ELSE
	BEGIN
		SET @o_errorCode = 2
		SET @o_errorString = 'Error : Invalid user type.'
		GOTO ERROR
	END
NEXT:
ERROR:
	SELECT @o_sharedTo AS 'o_sharedTo', @o_userType 'o_userType', @o_sharedToName 'o_sharedToName', @o_errorCode AS 'o_errorCode', @o_errorString AS 'o_errorString'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingSetUserConfig')
	delete from GxQscripts where name = 'AppSharingSetUserConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingSetUserConfig')
	delete from GXDBVersions where aliasname = 'AppSharingSetUserConfig'
GO

insert into GXDBVersions values(2, 'AppSharingSetUserConfig',  '00010005000200050000', 'AppSharingSetUserConfig', '00010005000200050000')
GO

