

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingRequestInviteEmail.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSharingRequestInviteEmail()
--  | Description:  Get request invite email for a share
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingRequestInviteEmail <<<'

IF EXISTS (select * from sysobjects where name='AppSharingRequestInviteEmail')
	drop procedure AppSharingRequestInviteEmail
IF EXISTS (select * from GxQscripts where name='AppSharingRequestInviteEmail')
	delete from GxQscripts where name = 'AppSharingRequestInviteEmail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingRequestInviteEmail')
	delete from GXDBVersions where aliasname = 'AppSharingRequestInviteEmail'
GO
print '... Creating Procedure: AppSharingRequestInviteEmail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingRequestInviteEmail
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
---
  @i_shareId INT,
  @i_inviteeUserId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
BEGIN
	DECLARE @posIdx				INT = 0
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @webConsoleURL		NVARCHAR(MAX) = ''
	DECLARE @shortUrl			NVARCHAR(MAX) = ''
	DECLARE @adminEmail			NVARCHAR(MAX) = ''
	DECLARE @weBHostName		NVARCHAR(MAX) = ''
	DECLARE @status				INT = 0
	DECLARE @goToLink			NVARCHAR(MAX) = ISNULL((SELECT value FROM GXGlobalParam WHERE name='Short Url Template' AND modified=0), 'gtl.do?gid=')
	DECLARE @goToLen			INT = LEN(@goToLink)
	DECLARE @shareName			NVARCHAR(MAX) = ''
	DECLARE @strShareBody		NVARCHAR(MAX) = '<!doctype html><html><head/><body><div style="width: 600px;padding: 0;margin: 0 auto;text-align: center;text-align:-moz-center; text-align:-webkit-center;"><table border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff" width="600" style="border: 0;color: #666;background: #ffffff;width: 600px;"><tbody><tr><td colspan="4">&nbsp;</td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.85em;line-height: 35px;text-align: left;"><p>Requesting access to the share <a href="{@LINK}" style="color: #666666;">{@SHARENAME}</a></p></td><td>&nbsp;</td></tr><tr><td colspan="4">&nbsp;</td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-size: 1em;line-height: 1.2em;text-align: left;font-family: Helvetica, Arial, sans-serif;"><p><a href="mailto:{@INVITEEMAILTO}" style="color: #666666;">{@INVITEE}</a> has requested access to your share: {@SHARENAME}.<br/><br/>Select one of the following to respond to this request:<br/><div><!--[if mso]><v:roundrect  xmlns:v="urn:schemas-microsoft-com:vml"  xmlns:w="urn:schemas-microsoft-com:office:word"  href="{@ALLOWLINK}"  style="height:40px;v-text-anchor:middle;width:200px;"  arcsize="8%"  strokecolor="#666666"  fillcolor="#4a96ad"><w:anchorlock/><center style="color:#ffffff;font-family:Helvetica, Arial, sans-serif;font-size:13px;font-weight:bold;">Allow</center></v:roundrect><![endif]--><a href="{@ALLOWLINK}" title="Allow" style="background-color:#4a96ad;border:1px solid #666666;border-radius:3px;color:#ffffff;display:inline-block;font-family:Helvetica, Arial, sans-serif;font-size:13px;font-weight:bold;line-height:40px;text-align:center;text-decoration:none;width:200px;-webkit-text-size-adjust:none;mso-hide:all;">Allow</a></div><br/><div><!--[if mso]><v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="{@DENYLINK}" style="height:40px;v-text-anchor:middle;width:200px;" arcsize="8%" strokecolor="#666666" fillcolor="#ffffff"><w:anchorlock/><center style="color:#4a96ad;font-family:Helvetica, Arial, sans-serif;font-size:13px;font-weight:bold;">Deny</center></v:roundrect><![endif]--><a href="{@DENYLINK}" title="Deny" style="background-color:#ffffff;border:1px solid #666666;border-radius:3px;color:#4a96ad;display:inline-block;font-family:Helvetica, Arial, sans-seriff;font-size:13px;font-weight:bold;line-height:40px;text-align:center;text-decoration:none;width:200px;-webkit-text-size-adjust:none;mso-hide:all;">Deny</a></div><br/>Please contact your <a href="mailto:{@MAILTO}" style="color: #666666;">administrator</a> if you need help or do not recognize<br/>the sender of this email.</p></td><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr></tbody></table></div></body></html>'
	SET @strShareBody = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'InviteEMailShareBody' AND modified = 0), @strShareBody)
	-- READ THE XML
	DECLARE @browseInfo			XML
	DECLARE @emailInfo			XML
	-- NAME VALIDATION
	IF NOT EXISTS (SELECT 1 FROM App_SyncCloudFolder WHERE syncWebFolderId = @i_shareId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Share Folder name does not exist for the owner.'
		GOTO ERROR_EXIT
	END
	SELECT @shareName = syncWebFolderName
		FROM App_SyncCloudFolder (NOLOCK)
		WHERE syncWebFolderId = @i_shareId
AND flag & (CAST(0x4 AS INT)) <> 0 -- ONLY FOR PRIVATE SHARES
--
	-- GET THE WEBSERVER NAME
	SELECT @webConsoleURL = value FROM GXGlobalParam
	WHERE name = 'WebConsoleURL' AND modified = 0
	SELECT @adminEmail=email FROM UMUsers WHERE flags&0x040=0x040
	SET @posIdx = PATINDEX('%/webconsole/%', @webConsoleURL)
	IF @posIdx = 0
	BEGIN
		SET @posIdx = PATINDEX('%/webconsole%', @webConsoleURL)
		IF @posIdx = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error : Invalid webserver information.'
			GOTO ERROR_EXIT
		END
		SET @webConsoleURL =  REVERSE(RIGHT(REVERSE (@webConsoleURL), len(@webConsoleURL) -
			NULLIF(charindex('elosnocbew/', REVERSE(@webConsoleURL)) - 2,0))) + '/'
	END
	ELSE
	BEGIN
		SET @webConsoleURL = LEFT(@webConsoleURL, @posIdx+LEN('/webconsole/')-1)
	END
	SET @weBHostName = LEFT(@webConsoleURL, @posIdx-1) --GET THE WEB HOST NAME
--
	-- GET THE BROWSE URL FOR THE EMAIL
	SELECT @emailInfo = SC.configOptions.query('/browseInfo/emailInfo'),
		@browseInfo = SC.configOptions.query('/browseInfo')
		FROM App_SyncCloudConfig SC WITH (NOLOCK)
		WHERE SC.syncWebFolderId = @i_shareId
--
	--GET EMAIL LINK. SHARE ID IS ADDED BY CREATE STORED PROCEDURE
	DECLARE @browseUrl			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@browseUrl', 'NVARCHAR(MAX)')
													FROM @emailInfo.nodes ('/emailInfo') R(ref)), '')
	DECLARE @allowURL			NVARCHAR(MAX) = '/browse/shareInvites.jsp?s={@shareId}&u={@inviteeId}&o=a'
	DECLARE @denyURL			NVARCHAR(MAX) = '/browse/shareInvites.jsp?s={@shareId}&u={@inviteeId}&o=d'
	SET @allowURL = REPLACE(@allowURL, '{@shareId}', @i_shareId)
	SET @allowURL = REPLACE(@allowURL, '{@inviteeId}', @i_inviteeUserId)
	SET @denyURL = REPLACE(@denyURL, '{@shareId}', @i_shareId)
	SET @denyURL = REPLACE(@denyURL, '{@inviteeId}', @i_inviteeUserId)
	SET @posIdx = PATINDEX(@goToLink, @browseUrl) - 1
	IF @posIdx > 0
		SET @shortUrl = RIGHT(@browseUrl, LEN(@browseUrl) - (@posIdx + @goToLen))
IF ((@status & CAST(0x8 AS INT) = CAST(0x8 AS INT)) OR
(@status & CAST(0x80 AS INT) = CAST(0x80 AS INT)))
	BEGIN
		SET @browseUrl = @browseUrl + '&iP=PUBLIC'
	END
	--CREATE URL FOR EMAIL
	SET @allowURL = @webConsoleURL + @allowURL
	SET @denyURL = @webConsoleURL + @denyURL
	SET @browseUrl = @weBHostName + @browseUrl
	SET @strShareBody = REPLACE(@strShareBody, '{@LINK}', @browseUrl)
	SET @strShareBody = REPLACE(@strShareBody, '{@MAILTO}', @adminEmail)
	SET @strShareBody = REPLACE(@strShareBody, '{@SHARENAME}', @shareName)
	SET @strShareBody = REPLACE(@strShareBody, '{@INVITEE}', (SELECT ISNULL(NULLIF(name, ''), login) FROM UMUsers WITH(NOLOCK) WHERE id = @i_inviteeUserId))
	SET @strShareBody = REPLACE(@strShareBody, '{@INVITEEMAILTO}', (SELECT email FROM UMUsers WITH(NOLOCK) WHERE id = @i_inviteeUserId))
	SET @strShareBody = REPLACE(@strShareBody, '{@ALLOWLINK}', @allowURL)
	SET @strShareBody = REPLACE(@strShareBody, '{@DENYLINK}', @denyURL)
--
	SET @o_xmlString =
			(SELECT
				@strShareBody '@body'
				FOR XML PATH('App_ShareRequestInviteEmailResp'), TYPE
			)
ERROR_EXIT:
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<App_ShareRequestInviteEmailResp/>'
	SELECT @o_xmlString AS EmailBody
--
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSharingRequestInviteEmail')
	delete from GxQscripts where name = 'AppSharingRequestInviteEmail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingRequestInviteEmail')
	delete from GXDBVersions where aliasname = 'AppSharingRequestInviteEmail'
GO

insert into GXDBVersions values(2, 'AppSharingRequestInviteEmail',  '00000000000000000000', 'AppSharingRequestInviteEmail', '00000000000000000000')
GO

