

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetUsers.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSharingGetUsers()
--  | Description:  Get user information given local username
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingGetUsers.sp,v $ $Id: AppSharingGetUsers.sp,v 1.3.60.2 2018/03/27 08:01:12 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingGetUsers <<<'

IF EXISTS (select * from sysobjects where name='AppSharingGetUsers')
	drop procedure AppSharingGetUsers
IF EXISTS (select * from GxQscripts where name='AppSharingGetUsers')
	delete from GxQscripts where name = 'AppSharingGetUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetUsers')
	delete from GXDBVersions where aliasname = 'AppSharingGetUsers'
GO
print '... Creating Procedure: AppSharingGetUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetUsers
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
BEGIN
	DECLARE @i_userName		NVARCHAR(1024)
	DECLARE @errorCode		INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = ''
	SET @o_xmlString = '<App_UsersForSharingResp />'
	DECLARE @userInfo TABLE (id INT, name NVARCHAR(MAX), userType INT)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	INSERT INTO @userInfo
--CS USERS
	SELECT id, login, 1
	FROM UMUsers
	WHERE id > 0
AND (flags & 0x001) = 0x001
AND (flags & 0x004) = 0
	UNION
-- EMAILS
	SELECT 0, email, 2
	FROM UMUsers
	WHERE id > 0
	AND email != ''
AND (flags & 0x001) = 0x001
AND (flags & 0x004) = 0
	UNION
	SELECT 0, sharedTo, 2
	FROM App_SharingUserInfo
	WHERE userType = 2
--
	UNION
--CS USER GROUPS
	SELECT id, name , 3
	FROM UMGroups
	WHERE groupFlags&32768=0
	AND groupFlags&1=1
--
	UNION
--AD USER GROUPS
	SELECT DG.id, P.domainName+'\'+DG.name, 4
	FROM UMDSgroups DG
	JOIN UMDSProviders P ON P.id = DG.umdsProviderId
	WHERE DG.enabled=1 AND P.enabled=1
--
	SET @o_xmlString =
		(
			SELECT
				SU.userType AS '@userType',
				SU.id AS '@id',
				SU.name AS '@name'
			FROM @userInfo SU
			FOR XML PATH('users'), ROOT('App_UsersForSharingResp')
		)
EXIT_PROC:
	IF @errorCode > 0
	BEGIN
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), TYPE)
	END
	SELECT @o_xmlString
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetUsers')
	delete from GxQscripts where name = 'AppSharingGetUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetUsers')
	delete from GXDBVersions where aliasname = 'AppSharingGetUsers'
GO

insert into GXDBVersions values(2, 'AppSharingGetUsers',  '00010003006000020000', 'AppSharingGetUsers', '00010003006000020000')
GO

