

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetSharesByClientId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  			    AppSharingGetSharesByClientId						|
--	|          Procedure for getting Shares & Subscriptions				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingGetSharesByClientId <<<'

IF EXISTS (select * from sysobjects where name='AppSharingGetSharesByClientId')
	drop procedure AppSharingGetSharesByClientId
IF EXISTS (select * from GxQscripts where name='AppSharingGetSharesByClientId')
	delete from GxQscripts where name = 'AppSharingGetSharesByClientId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharesByClientId')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharesByClientId'
GO
print '... Creating Procedure: AppSharingGetSharesByClientId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetSharesByClientId
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_batchCount INT,
  @i_maxId INT,
  @i_clientId INT,
  @o_xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @webserverId INT = 0, @maxSyncConfigId INT = 0
DECLARE @UTypeUser		INT = 1
DECLARE @UTypeEmail		INT = 2
DECLARE @UTypeGroup		INT = 3
DECLARE @UTypeDSGroup	INT = 4
	DECLARE @privateShareBit		INT = CAST(0x4 AS INT)
	DECLARE @publicViewShareBit		INT = CAST(0x8 AS INT)
	DECLARE @publicUploadShareBit	INT = CAST(0x80 AS INT)
	-- gets the index servers webserver associated associated with the edge client.
	SET @webserverId = ISNULL((SELECT TOP 1 webserverId FROM AppEdgeDriveWebserverAssociation where edgeClientId = @i_clientId),0)
	SELECT @maxSyncConfigId = MAX(syncConfigId)
	FROm (
			SELECT TOP(@i_batchCount) SC.syncConfigId
			FROM App_SyncCloudFolder SF WITH(NOLOCK)
			JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON SF.syncWebFolderId = Sc.syncWebFolderId AND SC.clientId = @i_clientId
			WHERE SF.flag & (CAST(0x4 AS INT)|CAST(0x8 AS INT)|CAST(0x80 AS INT)) > 0 AND Sc.syncConfigId > @i_maxId
			ORDER BY SC.syncConfigId
		) S
	SET @o_xmlString =
	(SELECT @maxSyncConfigId as '@maxSyncConfigId', @webserverId as '@indexClientId',
		(SELECT TOP(@i_batchCount)
			(CASE
				WHEN SF.flag & @privateShareBit = @privateShareBit THEN 0			--PRIVATE
				WHEN SF.flag & @publicViewShareBit = @publicViewShareBit THEN 1		--PUBLICVIEW
				WHEN SF.flag & @publicUploadShareBit = @publicUploadShareBit THEN 4	--PUBLICUPLOAD
				ELSE -1
			END)as '@status',
			(SELECT
				SF.syncWebFolderId AS '@syncWebFolderId',
				SF.syncWebFolderName AS '@syncWebFolderName' -- NOT USING dbo.DecodeInvalidXMLChar FUNCTION AS IT WILL BE EXECUTED FOR EACH ROW
				FOR XML PATH('shareFolder'), TYPE
			),
			(SELECT
				AP.id AS '@subclientId'
				FOR XML PATH('client'), TYPE
			),
			(SELECT SC.configOptions AS browseInfo),
			(SELECT
				SU.userType AS '@userType',
				(CASE
					WHEN SU.userType = @UTypeUser THEN (SELECT SU.sharedTo AS '@userId'FOR XML PATH('user'), TYPE)
					WHEN SU.userType = @UTypeGroup THEN (SELECT SU.sharedTo AS '@userGroupId' FOR XML PATH('group'), TYPE)
					WHEN SU.userType = @UTypeDSGroup THEN (SELECT SU.sharedTo AS '@groupId' FOR XML PATH('externalGroup'), TYPE)
					WHEN SU.userType = @UTypeEmail THEN (SELECT ISNULL((SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE email=SU.sharedTo), 0) AS '@userId' FOR XML PATH('user'), TYPE)
					ELSE NULL
				END)
				FROM App_SharingUserInfo SU WITH(NOLOCK)
				WHERE SU.shareId = SF.syncWebFolderId AND SU.deleted = 0
				FOR XML PATH('sharedTo'), TYPE
			)
		FROM App_SyncCloudFolder SF WITH(NOLOCK)
		JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON SF.syncWebFolderId = Sc.syncWebFolderId AND SC.clientId = @i_clientId
		JOIN APP_Application AP WITH (NOLOCK) ON AP.id = SC.subclientId
		WHERE SF.flag & (CAST(0x4 AS INT)|CAST(0x8 AS INT)|CAST(0x80 AS INT)) > 0 AND Sc.syncConfigId > @i_maxId
		ORDER BY SC.syncConfigId
		FOR XML PATH('shares'), TYPE
	    )
	FOR XML PATH('Api_SyncShareInfoReq')
	)
	SELECT @o_xmlString AS o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetSharesByClientId')
	delete from GxQscripts where name = 'AppSharingGetSharesByClientId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharesByClientId')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharesByClientId'
GO

insert into GXDBVersions values(2, 'AppSharingGetSharesByClientId',  '00000000000000000000', 'AppSharingGetSharesByClientId', '00000000000000000000')
GO

