

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetSharedFoldersForUser.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSharingGetSharedFoldersForUser()
--  | Description:  Get shared folder for which user has rights
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingGetSharedFoldersForUser.sp,v $ $Id: AppSharingGetSharedFoldersForUser.sp,v 1.8.36.14 2019/11/15 10:17:05 njain Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSharingGetSharedFoldersForUser')
BEGIN
	print '>>> Drop Stored Procedure: AppSharingGetSharedFoldersForUser <<<'
	drop procedure AppSharingGetSharedFoldersForUser
END
IF EXISTS (select * from GxQscripts where name='AppSharingGetSharedFoldersForUser')
	delete from GxQscripts where name = 'AppSharingGetSharedFoldersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharedFoldersForUser')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharedFoldersForUser'
GO
print '... Creating Procedure: AppSharingGetSharedFoldersForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetSharedFoldersForUser
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
---
  @i_userId INT,
  @i_shareId INT,
  @i_shareBucketType INT = 0,
  @i_includeExcludedShare INT = 0,
  @i_includePublicShare INT = 0
-----------------------------------------------------------
AS
BEGIN
DECLARE @flagPrivate		INT = CAST(0x4 AS INT)
DECLARE @flagPublicView		INT = CAST(0x8 AS INT)
DECLARE @flagPublicUpload	INT = CAST(0x80 AS INT)
DECLARE @flagContentStore	INT = CAST(0x40000000 AS INT)
DECLARE @shareCap			BIGINT = POWER(2.0, 40-1)
DECLARE @flagExpired		INT = CAST(0x40 AS INT)
DECLARE @DoNotBrowseFlag INT = 0x100
	IF NOT EXISTS(SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK)
				  WHERE entityType = 13 --User entity
				  AND entityid = @i_userId
				  AND keyName = 'ShowFileStoreShares' AND CONVERT(NVARCHAR(10), value) = 'true'
				  AND enabled = 1 AND deleted = 0
				 )
	BEGIN
SET @DoNotBrowseFlag = @DoNotBrowseFlag | 0x400
	END
	IF OBJECT_ID('tempdb.dbo.#usersShares') IS NOT NULL
		DROP TABLE #usersShares
	CREATE TABLE #usersShares (
		shareId int,
		sharedTo NVARCHAR(255),
		userType int,
		permission int,
		isOwner		int,
		excluded	int,
		shareType	int,
		primary key (shareid,userType,sharedTo)
	)
	-- GET ALL THE BUCKETS IF SHAREID IS PASSED
	IF @i_shareId > 0
		SET @i_shareBucketType = 0
	-- GET ALL PUBLIC AND PRIVATE SHARES BOTH. IT WILL BE CALLED WITH PROEPRTYLEVEL=1 FOR DRIVE BROWSE TO SHOW SHARE ICONS. I KNOW IT"S NOT A GOOD WAY.
	IF @i_shareBucketType = 1 AND @i_includePublicShare = 1
		SET @flagPrivate = @flagPrivate|@flagPublicView|@flagPublicUpload
	-- GET only private SHARES SHARED BY THE USER
	IF @i_shareBucketType = 0 OR @i_shareBucketType = 1
		INSERT INTO #usersShares
		SELECT
			SU.shareId,
			SU.sharedTo,
			SU.userType, dbo.BitwiseOR(SU.permission), MAX(SU.isOwner), MAX(SU.excluded), 1/*SHAREDBYME*/
			FROM App_SyncCloudFolder SH WITH (NOLOCK)
			JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND (SU.shareId = @i_shareId OR @i_shareId = 0) AND SU.isOwner = 1 AND SU.sharedBy = @i_userId
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			WHERE (SH.flag & @DoNotBrowseFlag = 0) AND SH.flag&@flagPrivate > 0 AND (SU.excluded = 0 OR @i_includeExcludedShare =1)		-- PRIVATE SHARES
			GROUP BY SU.shareId, SU.sharedTo, SU.userType
	-- GET SHARES SHARED TO USER/GROUP/EMAIL. THIS GETS COLLAB SHARES AS WELL
	IF @i_shareBucketType = 0 OR @i_shareBucketType = 2 OR @i_shareBucketType = 3
	BEGIN
		INSERT INTO #usersShares
		-- SHARED TO USER
		SELECT
			SU.shareId,
			SU.sharedTo,
			SU.userType, dbo.BitwiseOR(SU.permission), MAX(SU.isOwner), MAX(SU.excluded),
			CASE
				WHEN (CL.status & @flagContentStore = 0 OR (CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/)) THEN 2 /*SHAREDWITHME*/
				ELSE 3 /*COLLABSHARE*/
			END
			FROM App_SyncCloudFolder SH WITH (NOLOCK)
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			JOIN APP_Client CL WITH(NOLOCK) ON Sc.clientId = CL.id
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND (SU.shareId = @i_shareId OR @i_shareId = 0) AND userType = 1 AND SU.isOwner = 0 AND SU.sharedBy <> @i_userId
			LEFT OUTER JOIN App_ClientProp CP WITH(NOLOCK) ON CL.id = CP.componentNameId AND CP.attrName='System Drive Type' AND CP.modified=0
			WHERE (SH.flag & @DoNotBrowseFlag = 0) AND SU.sharedTo = CAST(@i_userId AS NVARCHAR(10)) AND (SH.flag & @flagExpired = 0) AND
			(CL.status & @flagContentStore)  =
				CASE @i_shareBucketType
						WHEN 0 THEN CL.status & @flagContentStore -- GET ALL
						WHEN 2 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), @flagContentStore, 0)
						WHEN 3 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), 0, @flagContentStore)
				END
			GROUP BY SU.shareId, SU.sharedTo, SU.userType, CL.status, CP.attrVal
		-- SHARED TO GROUP
		UNION ALL
		SELECT
			SU.shareId,
			SU.sharedTo,
			SU.userType, dbo.BitwiseOR(SU.permission), MAX(SU.isOwner), MAX(SU.excluded),
			CASE
				WHEN (CL.status & @flagContentStore = 0 OR (CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/)) THEN 2 /*SHAREDWITHME*/
				ELSE 3 /*COLLABSHARE*/
			END
			FROM App_SyncCloudFolder SH WITH (NOLOCK)
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			JOIN APP_Client CL WITH(NOLOCK) ON Sc.clientId = CL.id
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND (SU.shareId = @i_shareId OR @i_shareId = 0) AND (userType = 3 OR userType = 4) AND SU.isOwner = 0 AND SU.sharedBy <> @i_userId
			JOIN UMUserGroup UG WITH (NOLOCK) ON UG.userId = @i_userId
			LEFT OUTER JOIN App_ClientProp CP WITH(NOLOCK) ON CL.id = CP.componentNameId AND CP.attrName='System Drive Type' AND CP.modified=0
			WHERE (SH.flag & @DoNotBrowseFlag = 0) AND SU.sharedTo = CAST(UG.groupId AS NVARCHAR(10)) AND (SU.excluded = 0 OR @i_includeExcludedShare =1) AND (SH.flag & @flagExpired = 0) AND
			(CL.status & @flagContentStore)  =
				CASE @i_shareBucketType
						WHEN 0 THEN CL.status & @flagContentStore -- GET ALL
						WHEN 2 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), @flagContentStore, 0)
						WHEN 3 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), 0, @flagContentStore)
				END
			GROUP BY SU.shareId, SU.sharedTo, SU.userType, CL.status, CP.attrVal
		-- SHARED TO GROUP'S EMAIL
		UNION ALL
		SELECT
			SU.shareId,
			SU.sharedTo,
			SU.userType, dbo.BitwiseOR(SU.permission), MAX(SU.isOwner), MAX(SU.excluded),
			CASE
				WHEN (CL.status & @flagContentStore = 0 OR (CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/)) THEN 2 /*SHAREDWITHME*/
				ELSE 3 /*COLLABSHARE*/
			END
			FROM App_SyncCloudFolder SH WITH (NOLOCK)
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			JOIN APP_Client CL WITH(NOLOCK) ON Sc.clientId = CL.id
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND (SU.shareId = @i_shareId OR @i_shareId = 0) AND userType = 2 AND SU.isOwner = 0 AND SU.sharedBy <> @i_userId
			JOIN UMGroups G (NOLOCK) ON G.email = SU.sharedTo AND SU.sharedTo <> ''
			JOIN UMUserGroup UG (NOLOCK) ON UG.userId = @i_userId AND UG.groupId = G.id
			LEFT OUTER JOIN App_ClientProp CP WITH(NOLOCK) ON CL.id = CP.componentNameId AND CP.attrName='System Drive Type' AND CP.modified=0
			WHERE (SH.flag & @DoNotBrowseFlag = 0) AND (SU.excluded = 0 OR @i_includeExcludedShare =1) AND (SH.flag & @flagExpired = 0) AND
			(CL.status & @flagContentStore)  =
				CASE @i_shareBucketType
						WHEN 0 THEN CL.status & @flagContentStore -- GET ALL
						WHEN 2 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), @flagContentStore, 0)
						WHEN 3 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), 0, @flagContentStore)
				END
			GROUP BY SU.shareId, SU.sharedTo, SU.userType, CL.status, CP.attrVal
		-- SHARED TO USER'S EMAIL
		UNION ALL
		SELECT
			SU.shareId,
			SU.sharedTo,
			SU.userType, dbo.BitwiseOR(SU.permission), MAX(SU.isOwner), MAX(SU.excluded),
			CASE
				WHEN (CL.status & @flagContentStore = 0 OR (CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/)) THEN 2 /*SHAREDWITHME*/
				ELSE 3 /*COLLABSHARE*/
			END
			FROM App_SyncCloudFolder SH WITH (NOLOCK)
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			JOIN APP_Client CL WITH(NOLOCK) ON Sc.clientId = CL.id
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND (SU.shareId = @i_shareId OR @i_shareId = 0) AND userType = 2 AND SU.isOwner = 0 AND SU.sharedBy <> @i_userId
			JOIN UMUsers U WITH(NOLOCK) ON U.email = SU.sharedTo AND U.id = @i_userId
			LEFT OUTER JOIN App_ClientProp CP WITH(NOLOCK) ON CL.id = CP.componentNameId AND CP.attrName='System Drive Type' AND CP.modified=0
			WHERE (SH.flag & @DoNotBrowseFlag = 0) AND (SH.flag & @flagExpired = 0) AND
			(CL.status & @flagContentStore)  =
				CASE @i_shareBucketType
						WHEN 0 THEN CL.status & @flagContentStore -- GET ALL
						WHEN 2 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), @flagContentStore, 0)
						WHEN 3 THEN IIF((CP.attrVal IS NOT NULL AND CAST(CP.attrVal as INT) = 4/*NFS*/), 0, @flagContentStore)
				END
			GROUP BY SU.shareId, SU.sharedTo, SU.userType, CL.status, CP.attrVal
	END
	-- PUBLIC SHARES
	IF @i_shareBucketType = 4 OR @i_shareBucketType = 0
		INSERT INTO #usersShares
		SELECT
			SU.shareId,
			SU.sharedTo,
			SU.userType, dbo.BitwiseOR(SU.permission), MAX(SU.isOwner), MAX(SU.excluded), 4/*PUBLICLINKS*/
			FROM App_SyncCloudFolder SH WITH (NOLOCK)
			JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND (SU.shareId = @i_shareId OR @i_shareId = 0) AND SU.isOwner = 1 AND SU.sharedBy = @i_userId
			JOIN App_SyncCloudConfig SC WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			WHERE (SH.flag & @DoNotBrowseFlag = 0) AND SH.flag&(@flagPublicView|@flagPublicUpload) > 0 AND SU.excluded = 0
			GROUP BY SU.shareId, SU.sharedTo, SU.userType
	-- DELETE EXCLUDED SHARES FOR SHAREDBYME BUCKET. SP7 MR# 177994
	IF @i_includeExcludedShare = 0 AND (@i_shareBucketType = 2 OR @i_shareBucketType = 3)
		DELETE FROM #usersShares WHERE shareId IN (SELECT shareId FROM #usersShares WHERE excluded = 1)
	-- CREATE RESULT
	select shareId, sharedTo, userType, permission, isOwner, excluded, shareType
		FROM #usersShares
		GROUP BY shareId, sharedTo, userType, permission, isOwner, excluded, shareType
	IF OBJECT_ID('tempdb.dbo.#usersShares') IS NOT NULL
		DROP TABLE #usersShares
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetSharedFoldersForUser')
	delete from GxQscripts where name = 'AppSharingGetSharedFoldersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharedFoldersForUser')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharedFoldersForUser'
GO

insert into GXDBVersions values(2, 'AppSharingGetSharedFoldersForUser',  '00010008003600140000', 'AppSharingGetSharedFoldersForUser', '00010008003600140000')
GO

