

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetSharedFolders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSharingGetSharedFolders					|
--	|  Procedure to get a list of shared folders for a given user		|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSharingGetSharedFolders')
BEGIN
	print '>>> Drop Stored Procedure: AppSharingGetSharedFolders <<<'
	drop procedure AppSharingGetSharedFolders
END
IF EXISTS (select * from GxQscripts where name='AppSharingGetSharedFolders')
	delete from GxQscripts where name = 'AppSharingGetSharedFolders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharedFolders')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharedFolders'
GO
print '... Creating Procedure: AppSharingGetSharedFolders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetSharedFolders
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
DECLARE @shareCap			BIGINT = POWER(2.0, 40-1)
DECLARE @shareBits			INT = CAST(0x4 AS INT)|CAST(0x8 AS INT)|CAST(0x80 AS INT)
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @UTypeUser		INT = 1
DECLARE @UTypeEmail		INT = 2
DECLARE @UTypeGroup		INT = 3
DECLARE @UTypeDSGroup	INT = 4
	DECLARE @privateShareBit		INT = CAST(0x4 AS INT)
	DECLARE @publicViewShareBit		INT = CAST(0x8 AS INT)
	DECLARE @publicUploadShareBit	INT = CAST(0x80 AS INT)
	DECLARE @contentStoreBit		INT = CAST(0x40000000 AS INT)
	IF OBJECT_ID('tempdb.dbo.#shareList') IS NOT NULL
		DROP TABLE #shareList
	CREATE TABLE #shareList (
		shareId			INT,
		permission		INT,
		canUserEdit		INT,
		canReshare		INT,
		subclientId		INT,
		excluded		INT,
		browseInfoXML	XML,
		syncPath		NVARCHAR(MAX),
		parentShareId	INT,
		parentShareName	NVARCHAR(MAX),
		shareType		INT
	)
	CREATE CLUSTERED INDEX shareList_idx ON #shareList(shareId)
	IF OBJECT_ID('tempdb.dbo.#userList') IS NOT NULL
		DROP TABLE #userList
	CREATE TABLE #userList (
		shareId		INT,
		id			INT,
		name		NVARCHAR(MAX),
		permission	INT,
		sharedBy	INT,
		userType	INT,
		created		INT,
		modified	INT
	)
	CREATE CLUSTERED INDEX userList_idx1 ON #userList(shareId, id)
	IF OBJECT_ID('tempdb.dbo.#childShares') IS NOT NULL
		DROP TABLE #childShares
	CREATE TABLE #childShares (
		parentShareId	INT,
		shareType		INT,
		shareId			INT
	)
	CREATE CLUSTERED INDEX childShares_idx_ShareId ON #childShares(shareId, parentShareId)
	-- READ THE XML
	DECLARE @shareName			NVARCHAR(MAX) = ''
	DECLARE @shareId			INT = 0
	DECLARE @ownerId			INT = 0
	DECLARE @clientId			INT = 0
	DECLARE @edgeClient			INT = 0
	DECLARE @contentStoreType	NVARCHAR(MAX) = ''
	DECLARE @inPropertyLevel	INT	= 10
	DECLARE @bucketType			INT = 0 -- GET ALL SHARES
	DECLARE @getHiddenShares	INT = 0
	SELECT
		@shareName = ISNULL(a.value('(./shareInfo/shareFolder/@syncWebFolderName)[1]', 'NVARCHAR(MAX)'), ''),
		@shareId = ISNULL(a.value('(./shareInfo/shareFolder/@syncWebFolderId)[1]', 'INT'), 0),
		@ownerId = ISNULL(a.value('(./shareInfo/owner/@userId)[1]', 'INT'), 0),
		@clientId = ISNULL(a.value('(./shareInfo/client/@clientId)[1]', 'INT'), 0),
		@edgeClient = ISNULL(a.value('(./shareInfo/browseInfo/@edgeClient)[1]', 'INT'), 0),
		@contentStoreType = ISNULL(a.value('(./shareInfo/browseInfo/@contentStoreType)[1]', 'nvarchar(max)'), ''),
		@inPropertyLevel = ISNULL(a.value('@propertyLevel', 'INT'), 10),
		@bucketType = ISNULL(a.value('(./shareInfo/@shareType)[1]', 'INT'), @bucketType),
		@getHiddenShares = ISNULL(a.value('(@getHiddenShares)[1]', 'INT'), 0)
	FROM
		@i_xmlString.nodes ('App_GetSharedFoldersReq') doc(a)
	-- EXTENDED PROPERTIES IS FOR A SHARED FOLDER. SO ID IS NEEDED.
	IF @inPropertyLevel = 30 AND @shareId = 0
	BEGIN
		SELECT
			@shareId = syncWebFolderId
		FROM
			App_SyncCloudFolder WITH(NOLOCK)
		WHERE
			syncWebFolderName = @shareName
			AND ownerId = @i_userId
		IF @shareId = 0
			GOTO ERROR_EXIT
	END
	ELSE IF @inPropertyLevel = 1	-- GET SHAREDBYME BUCKET FOR MY DRIVE TO SHOW WHICH ITEMS ARE SHARED
		SET @bucketType = 1
	IF OBJECT_ID('tempdb.dbo.#InUserGroup') IS NOT NULL
		DROP TABLE #InUserGroup
	CREATE TABLE #InUserGroup (
		userId		INT,
		groupId		INT,
		dsType		INT,
		PRIMARY KEY (userId, dsType, groupId)
	)
	INSERT INTO #InUserGroup
		SELECT userId, groupId, 0
		FROM UMUserGroup WITH(NOLOCK)
		WHERE userId = @i_userId
		UNION ALL
		SELECT userId, groupId, 1
		FROM UMDSUserGroup ug WITH(NOLOCK)
		WHERE ug.userId = @i_userId
	-- GET THE SHARED FOLDER INFO. It will get details based on UserType
    IF OBJECT_ID('tempdb.dbo.#UserShares') IS NOT NULL
		DROP TABLE #UserShares
	CREATE TABLE #UserShares (
		shareId			INT,
		sharedTo		NVARCHAR(255),
		userType		INT,
		permission		int,
		isOwner			int,
		excluded		int,
		shareType		INT,
		primary key (shareid,userType,sharedTo)
	)
	IF @inPropertyLevel = 30
		INSERT INTO #UserShares
			EXEC AppSharingGetSharedFoldersForUser @i_userId, @shareId, @bucketType, 1/*includeExcludedShare*/ -- GET VISIBLE\HIDDEN SHARES
	ELSE IF @inPropertyLevel = 1 -- GET ALL SHAREDBYME (PRIVATE+PUBLIC)
		INSERT INTO #UserShares
			EXEC AppSharingGetSharedFoldersForUser @i_userId, @shareId, 1/*SHAREDBYME bucket*/, 0/*visible shares*/, 1/*includePublicShare*/ -- GET VISIBLE PRIVATE SHARES
	ELSE
		INSERT INTO #UserShares
			EXEC AppSharingGetSharedFoldersForUser @i_userId, @shareId, @bucketType, @getHiddenShares -- GET VISIBLE SHARES
	-- CHECK USER'S ACCESS PERMISSIONS WHEN SHAREID IS PASSED.
	IF (@shareId > 0)
	BEGIN
		SELECT @shareName = syncWebFolderName FROM App_SyncCloudFolder WHERE syncWebFolderId = @shareId
		IF NOT EXISTS(SELECT 1 FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @shareId)
SET @errorCode = (2272 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		IF @errorCode <> 0
			GOTO ERROR_EXIT
		SELECT @errorCode = (CASE
WHEN (SC.flag & CAST(0x40 AS INT) = CAST(0x40 AS INT)) THEN (2507 | (CAST(POWER(2, 24) AS BIGINT) * 35)) -- SHARE EXPIRED
								WHEN SU.deleted = 0 THEN -1
								ELSE 0
							END)
			FROM App_SyncCloudFolder SC
				JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SC.syncWebFolderId = SU.shareId
				JOIN #UserShares US ON (SU.shareId = US.shareId AND SU.sharedTo = US.sharedTo AND SU.userType = US.userType)
			WHERE SC.syncWebFolderId = @shareId
		IF @errorCode = 0 -- ABOVE QUERY DOES NOT RETURN
SET @errorCode = (2171 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		ELSE IF @errorCode = -1 -- USER HAS ACCESS TO THE SHARE
			SET @errorCode = 0
		IF @errorCode <> 0
		BEGIN
			-- EXPIRED SHARE FOLDER INFO NEEDS TO BE SENT IF THE REQUESTOR IS THE SHARED OWNER
IF NOT (@errorCode = (2507 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND ((SELECT sharedBy FROM App_SharingUserInfo(NOLOCK) WHERE shareId = @shareId AND isOwner = 1) = @i_userId))
				GOTO ERROR_EXIT
			ELSE
				SET @errorCode = 0
		END
	END
	INSERT INTO #shareList
		SELECT
			US.shareId,
			dbo.BitWiseor(US.permission),
			MAX(US.isOwner),	--ONLY OWNER CAN EDIT FOR NOW. ADDED MAX TO AVOID DUPLICATE IN CASE OWNER AND SHARED TO ARE SAME
			(CASE
				WHEN (SC.flag & (CAST(0x8 AS INT) | CAST(0x10 AS INT)) = CAST(0x8 AS INT)) OR SC.flag = 0 THEN 0	--CANNOT RESHARE
				ELSE 1																								--CANRESHARE
			END) canReshare,																						--THIS FLAG TELLS WHETHER THE FOLDER CAN BE RESHARED OR NOT.
			SC.subclientId,
			MAX(US.excluded),
			NULL AS configOptions,
			SC.syncPath,
			SC.parentShareId,
			PS.syncWebFolderName,
			US.shareType
		FROM #UserShares US
			JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON
				SC.syncWebFolderId = US.shareId--SH.syncWebFolderId
				AND (SC.flag &0x1) <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			LEFT OUTER JOIN App_SyncCloudFolder PS WITH(NOLOCK) ON
				PS.syncWebFolderId = SC.parentShareId
			GROUP BY US.shareId, SC.subclientId, SC.flag, SC.parentShareId, PS.syncWebFolderName, SC.syncPath, US.shareType
	-- Update browseInfo XML
		UPDATE SL
		SET SL.browseInfoXML = SC.configOptions
		FROM #shareList SL
		INNER JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON
		SL.shareId = SC.syncWebFolderId
--
	IF @contentStoreType <> '' OR @edgeClient <> 0
	BEGIN
		DELETE
		FROM #shareList
		WHERE (@contentStoreType <> '' AND ISNULL(browseInfoXML.value('(/browseInfo/@contentStoreType)[1]', 'nvarchar(max)'), '') <> @contentStoreType)
		OR (@edgeClient <> 0 AND ISNULL(browseInfoXML.value('(/browseInfo/@edgeClient)[1]', 'int'), '') <> @edgeClient)
	END
--
	--Determine if passwords need to be removed
	IF @inPropertyLevel <> 1
	BEGIN
		UPDATE #shareList SET browseInfoXML.modify('replace value of (//password/@password)[1] with ""')
			WHERE browseInfoXML.exist('//password/@password') = 1
		UPDATE #shareList SET browseInfoXML.modify('replace value of (//password/@oldPassword)[1] with ""')
			WHERE browseInfoXML.exist('//password/@oldPassword') = 1
	END
--
IF @inPropertyLevel = 30
BEGIN
	INSERT INTO #userList
		SELECT DISTINCT
			SL.shareId,
			0 id,
			SU.sharedTo sharedTo,
			SU.permission,
			SU.sharedBy,
			SU.userType,
			SU.created,
			SU.modified
		FROM #shareList SL
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON
				SU.shareId = SL.shareId
				AND SU.userType = @UTypeEmail
			LEFT OUTER JOIN UMUsers U WITH(NOLOCK) ON
				U.enabled = 1
				AND (U.flags & 1) = 1
				AND U.email = SU.sharedTo
		WHERE
			(@shareId = 0 OR SL.shareId = @shareId)
			AND SU.deleted = 0
			AND SU.enabled = 1
			AND SU.isOwner = 0 --DO NOT SEND OWNER
			--AND SU.excluded = 0 --DO NOT SEND EXCLUDED USERS
			--AND U.email = @userMail
			AND EXISTS (SELECT 1 FROM UmUsers WITH(NOLOCK) WHERE email=SU.sharedTo AND enabled = 1) --User should be enabled
		UNION
		SELECT DISTINCT
			SL.shareId,
			0 id,
			SU.sharedTo sharedTo,
			SU.permission,
			SU.sharedBy,
			SU.userType,
			SU.created,
			SU.modified
		FROM #shareList SL
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON
				SU.shareId = SL.shareId
				AND SU.userType = @UTypeEmail
			LEFT OUTER JOIN UMDSgroups EG WITH(NOLOCK) ON
				(
					SL.canUserEdit = 1
					OR EXISTS(SELECT 1 FROM UMDSUserGroup UG WITH(NOLOCK) WHERE EG.id = UG.groupId AND UG.userId = @i_userId)
				)
		WHERE
			(@shareId = 0 OR SL.shareId = @shareId)
			AND SU.deleted = 0
			AND SU.enabled = 1
			AND SU.isOwner = 0 --DO NOT SEND OWNER
			--AND SU.excluded = 0 --DO NOT SEND EXCLUDED USERS
			AND EG.email = SU.sharedTo
		UNION
		SELECT DISTINCT
			SL.shareId,
			CAST(SU.sharedTo AS INT) id,
			P.domainName + '\' + EG.name sharedTo,
			SU.permission,
			SU.sharedBy,
			SU.userType,
			SU.created,
			SU.modified
		FROM #shareList SL
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON
				SU.shareId = SL.shareId
				AND SU.userType = @UTypeDSGroup
				AND ISNUMERIC(SU.sharedTo) = 1
			LEFT OUTER JOIN UMDSgroups EG WITH(NOLOCK) ON
				(
					SL.canUserEdit = 1
					OR EXISTS (SELECT 1  FROM UMDSUserGroup UG WITH(NOLOCK) WHERE UG.userId = @i_userId AND UG.groupId = CAST(SU.sharedTo AS INT))
				)
			LEFT OUTER JOIN UMDSProviders P WITH (NOLOCK) ON
				P.id = EG.umdsProviderId
		WHERE
			(@shareId = 0 OR SL.shareId = @shareId)
			AND SU.deleted = 0
			AND SU.enabled = 1
			AND SU.isOwner = 0 --DO NOT SEND OWNER
			--AND SU.excluded = 0 --DO NOT SEND EXCLUDED USERS
			AND EG.id = CAST(SU.sharedTo AS INT)
		UNION
		SELECT DISTINCT
			SL.shareId,
			CAST(SU.sharedTo AS INT) id,
			U.login sharedTo,
			SU.permission,
			SU.sharedBy,
			SU.userType,
			SU.created,
			SU.modified
		FROM #shareList SL
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON
				SU.shareId = SL.shareId
				AND SU.userType = @UTypeUser
				AND ISNUMERIC(SU.sharedTo) = 1
			LEFT OUTER JOIN UMUsers U WITH(NOLOCK) ON
				(
					(SL.canUserEdit = 1
					OR U.id = @i_userId)
					AND U.enabled = 1
				)
		WHERE
			(@shareId = 0 OR SL.shareId = @shareId)
			AND SU.deleted = 0
			AND SU.enabled = 1
			AND SU.isOwner = 0 --DO NOT SEND OWNER
			--AND SU.excluded = 0 --DO NOT SEND EXCLUDED USERS
			AND U.id = CAST(SU.sharedTo AS INT)
		UNION
		SELECT DISTINCT
			SL.shareId,
			CAST(SU.sharedTo AS INT) id,
			UG.name sharedTo,
			SU.permission,
			SU.sharedBy,
			SU.userType,
			SU.created,
			SU.modified
		FROM #shareList SL
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON
				SU.shareId = SL.shareId
				AND SU.userType =  @UTypeGroup
				AND ISNUMERIC(SU.sharedTo) = 1
			LEFT OUTER JOIN UMGroups UG WITH(NOLOCK) ON
				(
					SL.canUserEdit = 1
					OR EXISTS (SELECT 1 FROM #InUserGroup ug WHERE ug.userId = @i_userId AND ug.dsType = 0 AND ug.groupId = CAST(SU.sharedTo AS INT))
				)
		WHERE
			(@shareId = 0 OR SL.shareId = @shareId)
			AND SU.deleted = 0
			AND SU.enabled = 1
			AND SU.isOwner = 0 --DO NOT SEND OWNER
			--AND SU.excluded = 0 --DO NOT SEND EXCLUDED USERS
			AND UG.id = CAST(SU.sharedTo AS INT)
END
--
	--REMOVE OTHER SHARE INFORMATION IF SHAREID IS PASSED
	IF @shareId > 0
	BEGIN
		DELETE FROM #shareList WHERE shareId <> @shareId
		DELETE FROM #userList WHERE shareId <> @shareId
	END
	--GET THE PENDING  INVITES FOR THE SHARES FOUND
	IF OBJECT_ID('tempdb.dbo.#pendingInvites') IS NOT NULL
		DROP TABLE #pendingInvites
	CREATE TABLE #pendingInvites (
		shareId			INT,
		inviteCount		INT,
	)
	IF (@inPropertyLevel = 20 AND @bucketType = 1) -- ONLY WHEN SHAREDBYME IS REQUESTED
	BEGIN
		INSERT INTO #pendingInvites
			select SL.shareId, count(1) FROM UMUsersProp UP WITH(NOLOCK)
			INNER JOIN #shareList SL ON CHECKSUM(N'Share Id') = UP.cs_attrName AND UP.attrName = 'Share Id'
			WHERE UP.attrval = CAST(SL.shareId as NVARCHAR(12))	AND modified = 0
			GROUP BY SL.shareId
	END
	-- Get child shares (re-shares) for shared with me & collaborativeshares page
	IF (@inPropertyLevel = 20 AND (@bucketType=2 OR @bucketType = 3))
	BEGIN
		INSERT INTO #childShares (parentShareId, shareId, shareType)
			SELECT SC.parentShareId, SC.syncWebFolderId,
				(CASE
					WHEN SF.flag&@publicViewShareBit > 0	THEN 1	--PUBLIC VIEW
					WHEN SF.flag&@publicUploadShareBit > 0	THEN 4	--PUBLIC UPLOAD
					ELSE 0											--PRIVATE
				END)
				FROM #shareList SL
				INNER JOIN App_SyncCloudConfig SC WITH (NOLOCK)ON SL.shareId = SC.parentShareId
				INNER JOIN App_SyncCloudFolder SF WITH(NOLOCK) ON SF.syncWebFolderId = SC.syncWebFolderId
				INNER JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SC.syncWebFolderId AND SU.isOwner = 1
				AND SU.sharedBy = @i_userId
				AND --Look for child shares only when shared from root
				(
					SC.syncPath = '\'			--WINDOWS SHARE
					OR SC.syncPath = '/'		--UNIX SHARE
					OR SC.syncPath = SL.syncPath --EDGECLIENT
				)
	END
	-- FORM THE XML RESPONSE
	-- THIS IS INSIDE A PARTICULAR SHARE FOLDER
	IF @inPropertyLevel = 1 -- GET ONLY MINIMAL FIELDS FOR SHARES PAGE IN WEBCONSOLE
	BEGIN
		SET @o_xmlString =
			(
				(SELECT
					(CASE
						WHEN SF.flag&@publicViewShareBit = @publicViewShareBit		THEN 1	--PUBLIC VIEW
						WHEN SF.flag&@publicUploadShareBit = @publicUploadShareBit	THEN 4	--PUBLIC UPLOAD
						ELSE 0																--PRIVATE
					END) AS '@status',
					(SELECT
						SH.syncWebFolderId AS '@syncWebFolderId'
						--SH.syncWebFolderName AS '@syncWebFolderName' -- NOT USING dbo.DecodeInvalidXMLChar FUNCTION AS IT WILL BE EXECUTED FOR EACH ROW
						FOR XML PATH('shareFolder'), TYPE
					),
					SH.syncPath AS 'browseInfo/paths/@path',
					(CASE
						WHEN SL.parentShareId <> 0 THEN
							(SELECT SL.parentShareId AS '@shareId', SL.parentShareName AS '@shareName'
								FOR XML PATH('parentShare'), TYPE)
						ELSE NULL
					END),
					SH.clientId AS 'client/@clientId'
					FROM #shareList SL
					JOIN App_SyncCloudConfig SH WITH (NOLOCK) ON SL.shareId = SH.syncWebFolderId
					JOIN App_SyncCloudFolder SF WITH (NOLOCK) ON SL.shareId = SF.syncWebFolderId
					ORDER BY SH.created DESC
					FOR XML PATH('shares'), ROOT('App_GetSharedFoldersResp')
				)
			)
	END
	ELSE IF @inPropertyLevel = 30 -- ListPropertyLevels_AllProperties
	BEGIN
		IF @shareId > 0
		BEGIN
			--ONLY USER THAT CAN SHARED THE FOLDER CAN VIEW
			--IF NOT EXISTS (SELECT 1 FROM #userList WHERE sharedBy = @i_userId)
			--BEGIN
			--	GOTO ERROR_EXIT
			--END
--
			SET @o_xmlString =
				(
					(SELECT
						SH.description AS '@description',
						(CASE
WHEN SL.permission & 2 <> 0 THEN 2
ELSE 1
						END) AS '@userPermission',
						SL.canUserEdit AS '@canUserEdit',
						SL.canReshare AS '@canReshare',
						(CASE
							WHEN EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH(NOLOCK)
								WHERE parentShareId = SH.syncWebFolderId) THEN 1 --SHARE HAS RE-SHARES
							ELSE 0 --NO RE-SHARES
						END) AS '@hasReshares',
						SL.shareType AS '@shareType',
						CI.attrVal AS '@ciEnabled',
						DT.attrVal AS '@driveType',
						(CASE
                            WHEN EPN.attrVal = '1' THEN 1
                            ELSE 0
                        END) AS '@isNotificationEnabled',
						(CASE
WHEN SH.flag&CAST(0x8 AS INT) = CAST(0x8 AS INT) THEN 1	--PUBLIC VIEW
WHEN SH.flag&CAST(0x80 AS INT) = CAST(0x80 AS INT) THEN 4	--PUBLIC UPLOAD
							ELSE 0	--PRIVATE
						END) AS '@status',
						(CASE
							WHEN SH.modified = 0 THEN SH.created
							ELSE SH.modified
						END) AS 'lastModified/@timeValue',
						SH.created AS 'created/@timeValue',
						(SELECT
							CL.id AS '@clientId',
							CL.displayName AS '@clientName',
							AP.appTypeId AS '@applicationId',
							AP.instance AS '@instanceId',
							AP.backupSet AS '@backupsetId',
							AP.id AS '@subclientId'
							FOR XML PATH('client'), TYPE
						),
						(SELECT
							SU.sharedBy '@userId',
							U.login AS '@userName'
							FROM App_SharingUserInfo SU WITH(NOLOCK)
							JOIN UMUsers U WITH(NOLOCK) ON SU.sharedBy = U.id
							where shareId = SH.syncWebFolderId AND isOwner = 1
							FOR XML PATH('owner'), TYPE
						),
						(SELECT
							SH.syncWebFolderId AS '@syncWebFolderId',
							SH.syncWebFolderName AS '@syncWebFolderName' -- NOT USING dbo.DecodeInvalidXMLChar FUNCTION AS IT WILL BE EXECUTED FOR EACH ROW
							FOR XML PATH('shareFolder'), TYPE
						),
						(SELECT
							SU.permission AS '@permission',
							(CASE
								WHEN SU.userType = @UTypeUser THEN ISNULL((
																			SELECT TOP 1 1 FROM App_SyncCloudConfig SC WITH(NOLOCK)
																			JOIN App_SharingUserInfo UI WITH(NOLOCK) ON SC.syncWebFolderId = UI.shareId
																			WHERE SC.parentShareId = SL.shareId
																			AND UI.sharedBy = SU.id
																		), 0)
								WHEN SU.userType = @UTypeEmail THEN ISNULL((
																			SELECT TOP 1 1 FROM App_SyncCloudConfig SC WITH(NOLOCK)
																			JOIN App_SharingUserInfo UI WITH(NOLOCK) ON SC.syncWebFolderId = UI.shareId
																			WHERE SC.parentShareId = SL.shareId
																			AND UI.sharedBy IN (SELECT UU.id FROM UMUsers UU WITH(NOLOCK) WHERE UU.email = SU.name AND UU.enabled = 1)
																		), 0)
								ELSE 0 --NO RE-SHARE CREATED BY THE SHAREDTO USER
							END) AS '@userHasReshares',
							ESU.excluded AS '@userStatus',	--EXCLUDED USER
							SU.userType AS '@userType',
							(CASE		--EMAIL
								WHEN SU.userType = @UTypeEmail THEN SU.name
								ELSE NULL
							END) AS '@email',
							(SELECT		--SHARED BY
								SU.sharedBy AS '@userId'
								FOR XML PATH('sharedBy'), TYPE
							),
							(SELECT		--USER
								(CASE WHEN SU.userType = @UTypeUser THEN SU.id
								ELSE NULL END) AS '@userId',
								(CASE WHEN SU.userType = @UTypeUser THEN SU.name
								ELSE NULL END) AS '@userName'
								FOR XML PATH('user'), TYPE
							),
							(SELECT		--COMMCELL_GROUP
								(CASE WHEN SU.userType = @UTypeGroup THEN SU.id
								ELSE NULL END) AS '@userGroupId',
								(CASE WHEN SU.userType = @UTypeGroup THEN SU.name
								ELSE NULL END) AS '@userGroupName'
								FOR XML PATH('group'), TYPE
							),
							(SELECT		--EXTERNAL_GROUP
								(CASE WHEN SU.userType = @UTypeDSGroup THEN SU.id
								ELSE NULL END) AS '@groupId',
								(CASE WHEN SU.userType = @UTypeDSGroup THEN SU.name
								ELSE NULL END) AS '@externalGroupName'
								FOR XML PATH('externalGroup'), TYPE
							)
							FROM #userList SU
							INNER JOIN App_SharingUserInfo ESU WITH(NOLOCK) ON SU.shareId = ESU.shareId AND SU.userType = ESU.userType
								AND ESU.sharedTo = (CASE
														WHEN ESU.userType = @UTypeEmail THEN SU.name
														ELSE CAST(SU.id AS nvarchar(MAX))
													END) -- To determine which users are excluded.
							LEFT OUTER JOIN App_SharingUserInfo ASU WITH(NOLOCK) ON ASU.shareId=SL.parentShareId AND ASU.isOwner=1 -- GET IMMEDIATE PARENT SHARE DETAILS
							WHERE SU.name IS NOT NULL	--REMOVE USERS THAT CANT BE SEEN
							--DO NOT INCLUDE PARENT SHARE OWNER AS THAT IS IMPLICIT. MR#148822
							AND (SU.id=0 OR(ISNULL(ASU.sharedBy, 0) <> SU.id)) -- sharedTo CAN BE AN EMAIL AND WILL HAVE id=0
							ORDER BY SU.userType, SU.name
							FOR XML PATH('sharedTo'), TYPE
						),
						(CASE
							WHEN SL.parentShareId <> 0 THEN
								(SELECT SL.parentShareId AS '@shareId', SL.parentShareName AS '@shareName'
									FOR XML PATH('parentShare'), TYPE) -- NOT USING dbo.DecodeInvalidXMLChar FUNCTION AS IT WILL BE EXECUTED FOR EACH ROW
							ELSE NULL
						END),
						(SELECT SL.browseInfoXML AS browseInfo)
						FROM App_SyncCloudFolder SH WITH (NOLOCK)
						JOIN #shareList SL ON SL.shareId = SH.syncWebFolderId
						JOIN APP_Application AP WITH (NOLOCK) ON AP.id = SL.subclientId
						JOIN App_Client CL WITH (NOLOCK) ON CL.id = AP.clientId
						JOIN UMUsers US WITH (NOLOCK) ON US.id = SH.ownerId
						LEFT OUTER JOIN App_ClientProp DT WITH (NOLOCK) ON CL.id = DT.componentNameId AND DT.attrName = 'System Drive Type' AND DT.modified = 0
						LEFT OUTER JOIN APP_ClientProp CI WITH (NOLOCK) ON CI.componentNameId = CL.id AND CI.attrName = 'Content Indexing Enabled' AND CI.modified = 0
                        LEFT OUTER JOIN App_ClientProp EPN WITH (NOLOCK) ON CL.id = EPN.componentNameId AND EPN.attrName = 'Edge Drive Enable Push Notification'
						WHERE SH.syncWebFolderId = @shareId AND SH.Flag&@shareBits <> 0	--CHECK THAT FOLDER IS A SHARE
						FOR XML PATH('shares'), ROOT('App_GetSharedFoldersResp')
					)
				)
		END
	END
	ELSE IF @inPropertyLevel = 20 -- ListPropertyLevels_ExtendedProperties
	BEGIN
		SET @o_xmlString =
			(
				(SELECT
					SL.shareType AS '@shareType',
					(CASE
						WHEN SL.permission & 2 <> 0 THEN 2
						ELSE 1
					END) AS '@userPermission',
					--SL.canUserEdit AS '@canUserEdit',
					SL.canReshare AS '@canReshare',
					DT.attrVal AS '@driveType',
					(CASE
                        WHEN EPN.attrVal = '1' THEN 1
                        ELSE 0
                    END) AS '@isNotificationEnabled',
					(CASE
						WHEN @bucketType = 1 THEN ISNULL((SELECT inviteCount FROM #pendingInvites WHERE shareId = SL.shareId), 0)
						ELSE NULL
					END) AS '@pendingInvitations',
					(CASE
						WHEN SH.flag&@publicViewShareBit = @publicViewShareBit THEN 1				--PUBLIC VIEW
						WHEN SH.flag&@publicUploadShareBit = @publicUploadShareBit THEN 4			--PUBLIC UPLOAD
						ELSE 0																		--PRIVATE
					END) AS '@status',
					(CASE
						WHEN SH.flag&CAST(0x40 AS INT) = CAST(0x40 AS INT) THEN 1
						ELSE 0
					END) AS '@isExpired',
					SH.created AS 'created/@timeValue',
					(SELECT
						CL.id AS '@clientId',
						CL.displayName AS '@clientName',
						AP.appTypeId AS '@applicationId',
						AP.id AS '@subclientId'
						FOR XML PATH('client'), TYPE
					),
					(SELECT SUI.sharedBy '@userId',
							U.login AS '@userName'
							FOR XML PATH('owner'), TYPE
					),
					(SELECT
						SH.syncWebFolderId AS '@syncWebFolderId',
						SH.syncWebFolderName AS '@syncWebFolderName' -- NOT USING dbo.DecodeInvalidXMLChar FUNCTION AS IT WILL BE EXECUTED FOR EACH ROW
						FOR XML PATH('shareFolder'), TYPE
					),
					(CASE
						WHEN SL.parentShareId <> 0 THEN
							(SELECT SL.parentShareId AS '@shareId', SL.parentShareName AS '@shareName'
								FOR XML PATH('parentShare'), TYPE)
						ELSE NULL
					END),
					(SELECT
						CS.shareId as '@syncWebFolderId',
						CS.shareType as '@status'
						FROM #childShares CS WHERE CS.parentShareId = SL.shareId
						FOR XML PATH('childShares'), TYPE),
					(SELECT SL.browseInfoXML AS browseInfo)
					FROM App_SyncCloudFolder SH WITH (NOLOCK)
					JOIN #shareList SL ON SL.shareId = SH.syncWebFolderId
					JOIN App_SharingUserInfo SUI WITH (NOLOCK) ON SUI.shareId = SH.syncWebFolderId AND SUI.isOwner = 1
					JOIN UMUsers U WITH (NOLOCK) ON U.id = SUI.sharedBy
					JOIN APP_Application AP WITH (NOLOCK) ON AP.id = SL.subclientId
					JOIN App_Client CL WITH (NOLOCK) ON CL.id = AP.clientId
					LEFT OUTER JOIN App_ClientProp DT WITH (NOLOCK) ON CL.id = DT.componentNameId AND DT.attrName = 'System Drive Type' AND DT.modified = 0
                    LEFT OUTER JOIN App_ClientProp EPN WITH (NOLOCK) ON CL.id = EPN.componentNameId AND EPN.attrName = 'Edge Drive Enable Push Notification'
					LEFT OUTER JOIN App_SharingUSerInfo PS WITH(NOLOCK) ON PS.shareId = SL.parentShareId AND PS.isOwner=1 -- GET PARENTSHARE DETAILS WITH JUST 1 RECORD
					LEFT OUTER JOIN App_SharingUSerInfo SU WITH(NOLOCK) ON SU.shareId = SL.shareId AND SU.isOwner=1 -- GET PARENTSHARE DETAILS WITH JUST 1 RECORD
					WHERE (ISNULL(PS.sharedBy, 0) <> @i_userId -- EXCLUDE RESHARES WHERE USER IS THE IMMEDIATE PARENT SHARE CREATOR
						OR SU.sharedBy = @i_userId) -- INCLUDE RESHARES WHERE USER IS THE CREATOR
					ORDER BY SH.flag DESC, SH.created DESC, SH.modified DESC
					FOR XML PATH('shares'), ROOT('App_GetSharedFoldersResp')
				)
			)
	END
	-- THIS IS FOR SUMMARY PAGE
	ELSE --IF @inPropertyLevel = 10 -- ListPropertyLevels_BasicProperties
	BEGIN
		SET @o_xmlString =
			(
				(SELECT
					(CASE
						WHEN SL.excluded = 0 THEN 1
						ELSE 0
					END)  AS '@isVisible',
					SH.description AS '@description',
					(CASE
WHEN SL.permission & 2 <> 0 THEN 2
ELSE 1
					END) AS '@userPermission',
					SL.canUserEdit AS '@canUserEdit',
					SL.canReshare AS '@canReshare',
					(CASE
						WHEN EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH(NOLOCK)
							WHERE parentShareId = SH.syncWebFolderId) THEN 1 --SHARE HAS RE-SHARES
						ELSE 0 --NO RE-SHARES
					END) AS '@hasReshares',
					SL.shareType AS '@shareType',
					CI.attrVal AS '@ciEnabled',
					(CASE
WHEN SH.flag&CAST(0x8 AS INT) = CAST(0x8 AS INT) THEN 1	--PUBLIC VIEW
WHEN SH.flag&CAST(0x80 AS INT) = CAST(0x80 AS INT) THEN 4	--PUBLIC UPLOAD
						ELSE 0	--PRIVATE
					END) AS '@status',
					(CASE
WHEN SH.flag&CAST(0x40 AS INT) = CAST(0x40 AS INT) THEN 1
						ELSE 0
					END) AS '@isExpired',
					(CASE
						WHEN SH.modified = 0 THEN SH.created
						ELSE SH.modified
					END) AS 'lastModified/@timeValue',
					SH.created AS 'created/@timeValue',
					(SELECT
						CL.id AS '@clientId',
						CL.displayName AS '@clientName',
						AP.appTypeId AS '@applicationId',
						AP.instance AS '@instanceId',
						AP.backupSet AS '@backupsetId',
						AP.id AS '@subclientId'
						FOR XML PATH('client'), TYPE
					),
					(SELECT
							SU.sharedBy '@userId',
							U.login AS '@userName',
							U.userGUID AS '@userGUID'
							FROM App_SharingUserInfo SU WITH(NOLOCK)
							JOIN UMUsers U WITH(NOLOCK) ON SU.sharedBy = U.id
							where shareId = SH.syncWebFolderId AND isOwner = 1
							FOR XML PATH('owner'), TYPE
					),
					(SELECT
						SH.syncWebFolderId AS '@syncWebFolderId',
						SH.syncWebFolderName AS '@syncWebFolderName' -- NOT USING dbo.DecodeInvalidXMLChar FUNCTION AS IT WILL BE EXECUTED FOR EACH ROW
						FOR XML PATH('shareFolder'), TYPE
					),
					(CASE
						WHEN SL.parentShareId <> 0 THEN
							(SELECT SL.parentShareId AS '@shareId', SL.parentShareName AS '@shareName'
								FOR XML PATH('parentShare'), TYPE) -- NOT USING dbo.DecodeInvalidXMLChar FUNCTION AS IT WILL BE EXECUTED FOR EACH ROW
						ELSE NULL
					END),
					(SELECT SL.browseInfoXML AS browseInfo)
					FROM App_SyncCloudFolder SH WITH (NOLOCK)
					JOIN #shareList SL ON SL.shareId = SH.syncWebFolderId
					JOIN APP_Application AP WITH (NOLOCK) ON AP.id = SL.subclientId
					JOIN App_Client CL WITH (NOLOCK) ON CL.id = AP.clientId
					JOIN UMUsers U WITH (NOLOCK) ON U.id = SH.ownerId
					LEFT OUTER JOIN APP_ClientProp CI WITH (NOLOCK) ON CI.componentNameId = CL.id AND CI.attrName = 'Content Indexing Enabled' AND CI.modified = 0
					ORDER BY SH.flag DESC, SH.created DESC, SH.modified DESC
					FOR XML PATH('shares'), ROOT('App_GetSharedFoldersResp')
				)
			)
	END
ERROR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#InUserGroup') IS NOT NULL
		DROP TABLE #InUserGroup
	IF OBJECT_ID('tempdb.dbo.#shareList') IS NOT NULL
		DROP TABLE #shareList
	IF OBJECT_ID('tempdb.dbo.#userList') IS NOT NULL
		DROP TABLE #userList
	IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT Null
		DROP TABLE #tempLaptopSecurityObjects
	IF OBJECT_ID('tempdb.dbo.#pendingInvites') IS NOT NULL
		DROP TABLE #pendingInvites
	IF @errorCode <> 0
	BEGIN
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
IF @errorCode = (2507 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = REPLACE(@errorString, '[]', '[' + @shareName + ']')
		IF @o_xmlString IS NULL
			SET @o_xmlString = (
									SELECT
										(SELECT @errorCode '@errorCode',
												@errorString '@errorMessage'
										FOR XML PATH ('resp'), TYPE
										),
										(SELECT
											(SELECT
												@shareId AS '@syncWebFolderId',
												@shareName AS '@syncWebFolderName'
												FOR XML PATH('shareFolder'), TYPE
											)
										FOR XML PATH('shares'), TYPE)
									FOR XML PATH(''), ROOT('App_GetSharedFoldersResp')
							   )
		ELSE
		BEGIN
			IF (@o_xmlString.exist('/App_GetSharedFoldersResp/resp/@errorCode')) = 1
				BEGIN
					SET @o_xmlString.modify('replace value of (/App_GetSharedFoldersResp/resp/@errorCode)[1] with sql:variable("@errorCode")')
					SET @o_xmlString.modify('replace value of (/App_GetSharedFoldersResp/resp/@errorMessage)[1] with sql:variable("@errorString")')
				END
			ELSE
				BEGIN
					SET @o_xmlString.modify('insert <resp/> into (/App_GetSharedFoldersResp)[1]')
					SET @o_xmlString.modify('insert (attribute errorCode {sql:variable("@errorCode")}) into (/App_GetSharedFoldersResp/resp)[1]')
					SET @o_xmlString.modify('insert (attribute errorMessage {sql:variable("@errorString")}) into (/App_GetSharedFoldersResp/resp)[1]')
				END
		END
	END
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_GetSharedFoldersResp/>'
	IF OBJECT_ID('tempdb.dbo.#OutputAppSharingGetSharedFolders') IS NOT NULL
		INSERT INTO #OutputAppSharingGetSharedFolders VALUES(@o_xmlString )
	ELSE
		SELECT @o_xmlString AS o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetSharedFolders')
	delete from GxQscripts where name = 'AppSharingGetSharedFolders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharedFolders')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharedFolders'
GO

insert into GXDBVersions values(2, 'AppSharingGetSharedFolders',  '00000000000000000000', 'AppSharingGetSharedFolders', '00000000000000000000')
GO

