

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetSharedFolderInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSharingGetUsers()
--  | Description:  Get user information given local username
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingGetSharedFolderInfo.sp,v $ $Id: AppSharingGetSharedFolderInfo.sp,v 1.10.12.5 2018/03/27 08:09:12 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingGetSharedFolderInfo <<<'

IF EXISTS (select * from sysobjects where name='AppSharingGetSharedFolderInfo')
	drop procedure AppSharingGetSharedFolderInfo
IF EXISTS (select * from GxQscripts where name='AppSharingGetSharedFolderInfo')
	delete from GxQscripts where name = 'AppSharingGetSharedFolderInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharedFolderInfo')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharedFolderInfo'
GO
print '... Creating Procedure: AppSharingGetSharedFolderInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetSharedFolderInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
---
  @i_shareId INT,
  @io_sharePath NVARCHAR(MAX) OUTPUT,
  @o_shareName NVARCHAR(MAX) OUTPUT,
  @o_clientId INT OUTPUT,
  @o_clientName NVARCHAR(MAX) OUTPUT,
  @o_appTypeId INT OUTPUT,
  @o_subclientId INT OUTPUT,
  @o_userId INT OUTPUT,
  @o_userName NVARCHAR(MAX) OUTPUT,
  @o_userGuid NVARCHAR(MAX) OUTPUT,
  @o_status INT OUTPUT,
  @o_ciEnabled INT OUTPUT,
  @o_cloudId INT OUTPUT,
  @o_directory INT OUTPUT,
  @o_sharedBy INT OUTPUT,
  @o_xmlConfig XML OUTPUT
-----------------------------------------------------------
AS
BEGIN
	SELECT @io_sharePath = (CASE (SELECT ref.value('@directory', 'INT')
			FROM xmlConfig.nodes ('browseInfo/paths') R(ref)) WHEN 1 THEN syncPath+@io_sharePath
			ELSE	--SINGLE FILE
				( CASE dbo.scgGetClientOSType(clientId)
					WHEN 2 THEN		--UNIX
						SUBSTRING(syncPath, 0, ABS(LEN(syncPath) - CHARINDEX('/', REVERSE(syncPath))+1))
					ELSE
						SUBSTRING(syncPath, 0, ABS(LEN(syncPath) - CHARINDEX('\', REVERSE(syncPath))+1))
					END
				)
			END),
			@o_shareName = syncWebFolderName,
			@o_clientId = clientId,
			@o_appTypeId = appTypeId,
			@o_subclientId = subclientId,
			@o_clientName = name,
			@o_userId = id,
			@o_userName = login,
			@o_userGuid = userGuid,
			@o_status = flag,
			@o_ciEnabled = contentIndex,
			@o_cloudId = (SELECT ISNULL(ref.value('@cloudId', 'INT'), 0)
				FROM xmlConfig.nodes ('browseInfo') R(ref)),
			@o_directory = (SELECT ISNULL(ref.value('@directory', 'INT'), 0)
				FROM xmlConfig.nodes ('browseInfo/paths') R(ref)),
			@o_xmlConfig = xmlConfig,
			@o_sharedBy = ISNULL((SELECT id FROM UMUsers WITH(NOLOCK) WHERE id = sharedBy), 0)
			FROM (
				SELECT  SC.syncPath, SF.syncWebFolderName, SC.clientId, C.name, U.id, U.login, U.userGuid, SF.flag, APP.id subclientId, APP.appTypeId,
					SC.configOptions  xmlConfig, ISNULL(CI.attrVal, 0) contentIndex, sharedBy
				FROM App_SyncCloudConfig SC WITH (NOLOCK)
				JOIN App_SyncCloudFolder SF WITH (NOLOCK) ON SF.syncWebFolderId = SC.syncWebFolderId
				JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SC.syncWebFolderId AND SU.isOwner = 1
				JOIN UMUsers U WITH (NOLOCK) ON U.id = SF.ownerId
				JOIN App_Client C WITH (NOLOCK) ON C.id = SC.clientId
				JOIN APP_Application APP WITH (NOLOCK) ON APP.id = SC.subclientId
				LEFT OUTER JOIN APP_ClientProp CI WITH (NOLOCK) ON CI.componentNameId = C.id AND CI.attrName = 'Content Indexing Enabled' AND CI.modified = 0
				WHERE SC.syncWebFolderId = @i_shareId
			) T
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetSharedFolderInfo')
	delete from GxQscripts where name = 'AppSharingGetSharedFolderInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetSharedFolderInfo')
	delete from GXDBVersions where aliasname = 'AppSharingGetSharedFolderInfo'
GO

insert into GXDBVersions values(2, 'AppSharingGetSharedFolderInfo',  '00010010001200050000', 'AppSharingGetSharedFolderInfo', '00010010001200050000')
GO

