

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetNotificatonAndAlertSubscriptionForShares.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  		AppSharingGetNotificatonAndAlertSubscriptionForShares	    |
--	|          Procedure for creating a new Shared Folder				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingGetNotificatonAndAlertSubscriptionForShares <<<'

IF EXISTS (select * from sysobjects where name='AppSharingGetNotificatonAndAlertSubscriptionForShares')
	drop procedure AppSharingGetNotificatonAndAlertSubscriptionForShares
IF EXISTS (select * from GxQscripts where name='AppSharingGetNotificatonAndAlertSubscriptionForShares')
	delete from GxQscripts where name = 'AppSharingGetNotificatonAndAlertSubscriptionForShares'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetNotificatonAndAlertSubscriptionForShares')
	delete from GXDBVersions where aliasname = 'AppSharingGetNotificatonAndAlertSubscriptionForShares'
GO
print '... Creating Procedure: AppSharingGetNotificatonAndAlertSubscriptionForShares'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetNotificatonAndAlertSubscriptionForShares
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_shareId INT,
  @i_userId INT,
  @inLocaleId INT,
  @o_xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	-- READ THE XML
	DECLARE @errorCode		INT = 0
	DECLARE @errorString	NVARCHAR(200) = ''
DECLARE @ruleId         INT = ISNULL( (SELECT top 1 NR.id FROM NTnotificationRule NR WITH(NOLOCK) where NR.alertTypeId=72 and (NR.status&128)>0),0)
	IF OBJECT_ID('tempdb.dbo.#shareInfo') IS NOT NULL
		DROP TABLE #shareInfo
	CREATE TABLE #shareInfo (shareId INT, notificationOption INT, enableAlertNotification INT, isDigestEnabledForAlert INT, PRIMARY KEY (shareId))
	IF @i_shareId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_SyncCloudFolder WHERE syncWebFolderId = @i_shareId)
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'Invalid share inforation provided in the request.'
			GOTO ERROR_EXIT
		END
    END
	INSERT INTO #shareInfo
        SELECT
        SM.shareId, SM.flag, 0, 0
        FROM App_ShareUserSubscriptionMap SM WITH(NOLOCK)
        WHERE (SM.shareId = @i_shareId OR @i_shareId = 0)AND SM.userId = @i_userId
	MERGE #shareInfo AS TARGET
    USING (SELECT entityId1, userId, flags, ntRuleId, entityType1 FROM NTAlertSubScriptions WITH(NOLOCK) WHERE userId= @i_userId AND
entityType1 = 7987/*SHARE_FOLDER_ENTITY*/ AND (entityId1 = @i_shareId OR @i_shareId = 0 ) ) AS
                            SOURCE (entityId1, userId, flags, ntRuleId, entityType1)
        ON (SOURCE.entityId1 = TARGET.shareId)
    WHEN MATCHED THEN
        UPDATE SET enableAlertNotification = case when (SOURCE.flags & 1 )>0 then 1 else 0 end, -- NT_STATUS_USER_SUBSCRIBED
			isDigestEnabledForAlert = case when (SOURCE.flags & 2 )>0 then 1 else 0 end --NT_STATUS_DIGEST
    WHEN NOT MATCHED BY TARGET THEN
        INSERT (shareId, notificationOption, enableAlertNotification, isDigestEnabledForAlert)
            VALUES(SOURCE.entityId1, 0, case when (SOURCE.flags&1)>0 then 1 else 0 end,
				case when (SOURCE.flags&2)>0 then 1 else 0 end);
	SET @o_xmlString =
		(
			SELECT
				(SELECT
					SI.shareId as '@shareId',
					SI.notificationOption as '@notificationOption',
					(CASE
						WHEN SI.enableAlertNotification & 1 > 0 THEN 1
						ELSE 0
					END) as '@enableAlertNotification',
					SI.isDigestEnabledForAlert '@isDigestEnabledForAlert'
					FROM #shareInfo SI
					FOR XML PATH('shares'), TYPE
				),
				(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
					FOR XML PATH ('error'), TYPE
				)
			FOR XML PATH(''), ROOT('Api_GetShareNotificationSubscriptionResp')
		)
	ERROR_EXIT:
		IF @o_xmlString IS NULL
			SET @o_xmlString =
				(
					SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
					FOR XML PATH ('error'), ROOT('Api_GetShareNotificationSubscriptionResp')
				)
	SELECT @o_xmlString AS o_xmlString
	IF OBJECT_ID('tempdb.dbo.#shareInfo') IS NOT NULL
		DROP TABLE #shareInfo
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetNotificatonAndAlertSubscriptionForShares')
	delete from GxQscripts where name = 'AppSharingGetNotificatonAndAlertSubscriptionForShares'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetNotificatonAndAlertSubscriptionForShares')
	delete from GXDBVersions where aliasname = 'AppSharingGetNotificatonAndAlertSubscriptionForShares'
GO

insert into GXDBVersions values(2, 'AppSharingGetNotificatonAndAlertSubscriptionForShares',  '00000000000000000000', 'AppSharingGetNotificatonAndAlertSubscriptionForShares', '00000000000000000000')
GO

