

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetNotificationSubscriptionsForShareOrUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  		AppSharingGetNotificationSubscriptionsForShareOrUser						|
--	|          Procedure for creating a new Shared Folder				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingGetNotificationSubscriptionsForShareOrUser <<<'

IF EXISTS (select * from sysobjects where name='AppSharingGetNotificationSubscriptionsForShareOrUser')
	drop procedure AppSharingGetNotificationSubscriptionsForShareOrUser
IF EXISTS (select * from GxQscripts where name='AppSharingGetNotificationSubscriptionsForShareOrUser')
	delete from GxQscripts where name = 'AppSharingGetNotificationSubscriptionsForShareOrUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetNotificationSubscriptionsForShareOrUser')
	delete from GXDBVersions where aliasname = 'AppSharingGetNotificationSubscriptionsForShareOrUser'
GO
print '... Creating Procedure: AppSharingGetNotificationSubscriptionsForShareOrUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetNotificationSubscriptionsForShareOrUser
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @o_xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	-- READ THE XML
	DECLARE @errorCode		INT = 0
	DECLARE @errorString	NVARCHAR(200) = ''
	DECLARE @shareId		INT = ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
												FROM @i_xmlString.nodes ('Api_GetShareSubscribersReq/shareInfo/shareFolder') R(ref)), 0)
	IF OBJECT_ID('tempdb.dbo.#shareInfo') IS NOT NULL
		DROP TABLE #shareInfo
	CREATE TABLE #shareInfo (shareId INT, shareName NVARCHAR(512), syncPath NVARCHAR(512), subClientId INT, sharedTo INT, isSharedDirectly INT, notificationOption INT)
	CREATE CLUSTERED INDEX sharedTo_idx ON #shareInfo(sharedTo)
	IF NOT EXISTS (SELECT 1 FROM App_SyncCloudFolder WHERE syncWebFolderId = @shareId)
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'Invalid share inforation provided in the request.'
			GOTO ERROR_EXIT
		END
	IF @shareId > 0 AND @i_userId <> 0
	BEGIN
		-- GET THE SUBSCRIBERS INFORMATION FOR A SHARE
		-- SHARED TO USER. GET ALL THE USERS WITH WHOM IT IS DIRECTLY SHARED
		INSERT INTO #shareInfo
		SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, US.id, 1/*isSharedDirectly*/, USM.flag/*notification option*/
				FROM App_SyncCloudConfig SC WITH(NOLOCK)
				JOIN App_SyncCloudFolder SH WITH(NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 AND SU.userType = 1  /*Get owner's entry as well*/
				JOIN UMUsers US WITH(NOLOCK) ON SU.sharedTo = CAST(US.id AS NVARCHAR(15))
                LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON US.id = USM.userId AND USM.shareId = SU.shareId
				WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
				GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, US.id, USM.flag
		UNION ALL
		-- SHARED TO GROUP. GET USER FOR WHICH THE SP IS CALLED.
		SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, 0/*isSharedDirectly*/, USM.flag/*notification option*/
				FROM App_SyncCloudConfig SC WITH(NOLOCK)
				JOIN App_SyncCloudFolder SH WITH(NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 AND (SU.userType = 3 OR SU.userType = 4) /*Get owner's entry as well*/
				JOIN UMUserGroup UG WITH (NOLOCK) ON SU.sharedTo = CAST(UG.groupId AS NVARCHAR(15)) AND UG.userId = @i_userId
                LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON UG.userId = USM.userId AND USM.shareId = SU.shareId
				WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
				GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, USM.flag
		-- SHARED TO GROUP'S EMAIL. GET USER FOR WHICH THE SP IS CALLED.
		UNION ALL
		SELECT SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, 0/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH (NOLOCK)
			JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 /*Get owner's entry as well*/ AND SU.userType = 2
			JOIN UMGroups U WITH(NOLOCK) ON U.email = SU.sharedTo AND SU.sharedTo <> ''
			JOIN UMUserGroup UG WITH (NOLOCK) ON U.id = UG.groupId AND UG.userId = @i_userId
            LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON UG.userId = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, USM.flag
		-- SHARED TO USER'S EMAIL
		UNION ALL
		SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, U.id, 1/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH (NOLOCK)
			JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 /*Get owner's entry as well*/ AND SU.userType = 2
			JOIN Umusers U WITH(NOLOCK) ON U.email = SU.sharedTo AND SU.sharedTo <> ''
            LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON U.id = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, U.id, USM.flag
	END
	ELSE IF @shareId > 0 AND @i_userId = 0
	BEGIN
		INSERT INTO #shareInfo
		SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, S.userId, 1/*isSharedDirectly*/, USM.flag/*notification option*/
				FROM App_SyncCloudConfig SC WITH(NOLOCK)
				JOIN App_SyncCloudFolder SH WITH(NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 AND SU.userType = 1 /*Get owner's entry as well*/
				JOIN UMQSDKSessions S WITH(NOLOCK) ON SU.sharedTo = CAST(S.userId AS NVARCHAR(15))
				JOIN App_NotificationSubscription NS WITH(NOLOCK) ON NS.sessionId = S.id
                LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON S.userId = USM.userId AND USM.shareId = SU.shareId
				WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
				GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, S.userId, USM.flag
		UNION ALL
		-- SHARED TO GROUP
		SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, 0/*isSharedDirectly*/, USM.flag/*notification option*/
				FROM App_SyncCloudConfig SC WITH(NOLOCK)
				JOIN App_SyncCloudFolder SH WITH(NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 AND (SU.userType = 3 OR SU.userType = 4) /*Get owner's entry as well*/
				JOIN UMUserGroup UG WITH (NOLOCK) ON SU.sharedTo = CAST(UG.groupId AS NVARCHAR(15)) --JOINING DIRECLTY AS IF SUBSCRIPTION IS PRESNET THAT MEANS THIS TABLE IS POPULATED WITH THE USER GROUP INFORMAITON
				JOIN UMQSDKSessions S WITH(NOLOCK) ON S.userId = UG.userId
				JOIN App_NotificationSubscription NS WITH(NOLOCK) ON NS.sessionId = S.id
                LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON S.userId = USM.userId AND USM.shareId = SU.shareId
				WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
				GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, USM.flag
		-- SHARED TO GROUP'S EMAIL
		UNION ALL
		SELECT SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, 0/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH (NOLOCK)
			JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 /*Get owner's entry as well*/ AND SU.userType = 2
			JOIN UMGroups U WITH(NOLOCK) ON U.email = SU.sharedTo AND SU.sharedTo <> ''
			JOIN UMUserGroup UG WITH (NOLOCK) ON U.id = UG.groupId
			JOIN UMQSDKSessions S WITH(NOLOCK) ON S.userId = UG.userId
			JOIN App_NotificationSubscription NS WITH(NOLOCK) ON NS.sessionId = S.id
            LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON S.userId = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, USM.flag
		-- SHARED TO USER'S EMAIL
		UNION ALL
		SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, U.id, 1/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH (NOLOCK)
			JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 /*Get owner's entry as well*/ AND SU.userType = 2
			JOIN Umusers U WITH(NOLOCK) ON U.email = SU.sharedTo AND SU.sharedTo <> ''
			JOIN UMQSDKSessions S WITH(NOLOCK) ON U.id = S.userId
			JOIN App_NotificationSubscription NS WITH(NOLOCK) ON NS.sessionId = S.id
            LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON S.userId = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, U.id, USM.flag
		/*-------------------------------------------------------------------------------------------------------------------------
			Adding user subscriptions exclusively for mobile user(s) who have no entry in App_NotificationSubscription table
		--------------------------------------------------------------------------------------------------------------------------*/
		UNION ALL
			SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, MIA.activeUserId, 1/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH(NOLOCK)
			JOIN App_SyncCloudFolder SH WITH(NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 AND SU.userType = 1 /*Get owner's entry as well*/
			JOIN MDM_InstalledApp MIA WITH(NOLOCK) ON SU.sharedTo = CAST(MIA.activeUserId AS NVARCHAR(15))
            LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON MIA.activeUserId = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, MIA.activeUserId, USM.flag
		UNION ALL
			-- SHARED TO GROUP
			SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, 0/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH(NOLOCK)
			JOIN App_SyncCloudFolder SH WITH(NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 AND (SU.userType = 3 OR SU.userType = 4) /*Get owner's entry as well*/
			JOIN UMUserGroup UG WITH (NOLOCK) ON SU.sharedTo = CAST(UG.groupId AS NVARCHAR(15)) --JOINING DIRECLTY AS IF SUBSCRIPTION IS PRESNET THAT MEANS THIS TABLE IS POPULATED WITH THE USER GROUP INFORMAITON
			JOIN MDM_InstalledApp MIA WITH(NOLOCK) ON MIA.activeUserId = UG.userId
			LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON MIA.activeUserId = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, USM.flag
		-- SHARED TO GROUP'S EMAIL
		UNION ALL
			SELECT SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, 0/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH (NOLOCK)
			JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
			JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 /*Get owner's entry as well*/ AND SU.userType = 2
			JOIN UMGroups U WITH(NOLOCK) ON U.email = SU.sharedTo AND SU.sharedTo <> ''
			JOIN UMUserGroup UG WITH (NOLOCK) ON U.id = UG.groupId
			JOIN MDM_InstalledApp MIA WITH(NOLOCK) ON MIA.activeUserId = UG.userId
            LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON MIA.activeUserId = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, UG.userId, USM.flag
		-- SHARED TO USER'S EMAIL
		UNION ALL
			SELECT	SU.shareId, SH.syncWebFolderName, SC.syncPath, SC.subclientId, U.id, 1/*isSharedDirectly*/, USM.flag/*notification option*/
			FROM App_SyncCloudConfig SC WITH (NOLOCK)
			JOIN App_SyncCloudFolder SH WITH (NOLOCK) ON SC.syncWebFolderId = SH.syncWebFolderId AND SH.syncWebFolderId = @shareId
			JOIN App_SharingUserInfo SU WITH (NOLOCK) ON SU.shareId = SH.syncWebFolderId AND deleted = 0 AND SU.excluded = 0 /*Get owner's entry as well*/ AND SU.userType = 2
			JOIN Umusers U WITH(NOLOCK) ON U.email = SU.sharedTo AND SU.sharedTo <> ''
			JOIN MDM_InstalledApp MIA WITH(NOLOCK) ON MIA.activeUserId = U.id
            LEFT OUTER JOIN App_ShareUserSubscriptionMap USM WITH(NOLOCK) ON MIA.activeUserId = USM.userId AND USM.shareId = SU.shareId
			WHERE (SH.flag & 0x100 = 0) AND SC.flag & 0x1 <> 0x1	-- SHARED FOLDER ARE MARKED PAUSED WHEN OWNER LOOSES RIGHTS TO CLIENT
			GROUP BY SU.shareId,  SH.syncWebFolderName, SC.syncPath, SC.subclientId, U.id, USM.flag
	END
	ELSE
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'Invalid user information provided in the request.'
		GOTO ERROR_EXIT
	END
	--CHECK AND REMOVE DUPLICATE SUBSCRIPTIONS
	IF @errorCode = 0 AND EXISTS (SELECT 1 FROM #shareInfo GROUP BY shareId, sharedTo HAVING COUNT(*) > 1)
	BEGIN
		DELETE a
			FROM (SELECT ROW_NUMBER() OVER (PARTITION BY shareId, shareName, syncPath, subClientId, sharedTo, notificationOption ORDER BY isSharedDirectly desc) row
					FROM #shareInfo) a
			WHERE a.row > 1
	END
	SET @o_xmlString =
		(
			SELECT
				(SELECT
					(SELECT S.shareId as '@syncWebFolderId'
						FOR XML PATH ('shareFolder'), TYPE
					),
					(SELECT
						SU.userType AS '@userType',
						(SELECT
							(CASE
WHEN SU.userType = 1 THEN SU.sharedTo --USER
WHEN SU.userType = 2 AND EXISTS (SELECT TOP 1 1 FROM UMUsers WITH(NOLOCK) WHERE email = SU.sharedTo and enabled =1) THEN --USER EMAIL
									(SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE email = SU.sharedTo and enabled =1)
								ELSE NULL
							END) AS '@userId'
						 FOR XML PATH('user'), TYPE),
						 (SELECT
							(CASE
WHEN SU.userType = 3 OR SU.userType = 4 THEN SU.sharedTo -- GROUP
WHEN SU.userType = 2 AND EXISTS (SELECT TOP 1 1 FROM UMGroups WITH(NOLOCK) WHERE email = SU.sharedTo and enabled =1) THEN --GROUP EMAIL
									(SELECT TOP 1 1 FROM UMGroups UG WITH(NOLOCK)
										JOIN UMUserGroup UUG WITH(NOLOCK) ON UG.id = UUg.groupId
										WHERE UG.email = SU.sharedTo)
								ELSE NULL
							END) AS '@userGroupId'
						 FOR XML PATH('group'), TYPE)
					FROM App_SharingUserInfo SU WITH(NOLOCK)
					WHERE SU.shareId = @shareId AND SU.deleted = 0
					FOR XML PATH('sharedTo'), TYPE
					)
				FROM App_SharingUserInfo S WITH(NOLOCK)
				WHERE S.shareId = @shareId AND S.isOwner = 1
				FOR XML PATH('shareInfo'), TYPE
				),
				(SELECT
					SI.shareId as '@entityId',
					1 /*SHARE_ENTITY*/ as '@entityType',
					SI.shareName as '@entityName',
					SI.syncPath as '@itemGuid',
					SI.subClientId as '@appId',
					6 /*EDGE_DRIVE*/ as '@subscriptionType',
					SI.isSharedDirectly as '@isSharedDirectly',
					CAST(SC.configOptions AS nvarchar(2048)) as '@shareBrowseInfo',
					SI.notificationOption as '@notificationOption',
					(SELECT
						U.id as '@userId',
						U.userGuid as '@userGUID',
						(CASE
							WHEN U.name <> '' THEN U.name
							ELSE U.login
						END) as '@userName'
						FOR XML PATH ('user'), TYPE
					),
					(SELECT groupId as '@val' FROM UMUserGroup WITH(NOLOCK) WHERE userId = U.id
						FOR XML PATH ('groupIds'), TYPE
					)
				FROM #shareInfo SI
				JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON SI.shareId = SC.syncWebFolderId
				JOIN UMUsers U WITH(NOLOCK) ON SI.sharedTo = U.id
				FOR XML PATH('subscriptions'), TYPE)
			FOR XML PATH(''), ROOT('Api_GetShareSubscribersResp')
		)
	ERROR_EXIT:
		IF @o_xmlString IS NULL
			SET @o_xmlString =
				(
					SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
					FOR XML PATH ('error'), ROOT('Api_GetShareSubscribersResp')
				)
	SELECT @o_xmlString AS o_xmlString
	IF OBJECT_ID('tempdb.dbo.#shareInfo') IS NOT NULL
		DROP TABLE #shareInfo
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetNotificationSubscriptionsForShareOrUser')
	delete from GxQscripts where name = 'AppSharingGetNotificationSubscriptionsForShareOrUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetNotificationSubscriptionsForShareOrUser')
	delete from GXDBVersions where aliasname = 'AppSharingGetNotificationSubscriptionsForShareOrUser'
GO

insert into GXDBVersions values(2, 'AppSharingGetNotificationSubscriptionsForShareOrUser',  '00000000000000000000', 'AppSharingGetNotificationSubscriptionsForShareOrUser', '00000000000000000000')
GO

