

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetMissingEmailInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingGetMissingEmailInfo.sp,v $ $Id: AppSharingGetMissingEmailInfo.sp,v 1.2.74.4 2018/12/21 19:22:56 saggarwal Exp $";
--	+===================================================================+
--	|  					  AppSharingGetMissingEmailInfo					|
--	|          Procedure for getting missing AD information				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSharingGetMissingEmailInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppSharingGetMissingEmailInfo <<<'
	drop procedure AppSharingGetMissingEmailInfo
END
IF EXISTS (select * from GxQscripts where name='AppSharingGetMissingEmailInfo')
	delete from GxQscripts where name = 'AppSharingGetMissingEmailInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetMissingEmailInfo')
	delete from GXDBVersions where aliasname = 'AppSharingGetMissingEmailInfo'
GO
print '... Creating Procedure: AppSharingGetMissingEmailInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetMissingEmailInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_ProviderId INT
  DECLARE @o_useSecureLdap INT
  DECLARE @o_userType INT
  DECLARE @o_permission INT
  DECLARE @o_port INT
  DECLARE @o_serviceType INT
  DECLARE @o_errorCode INT = 0
  DECLARE @o_serverName NVARCHAR(MAX)
  DECLARE @o_loginName NVARCHAR(MAX)
  DECLARE @o_loginPassword NVARCHAR(MAX)
  DECLARE @o_FQDN NVARCHAR(MAX)
  DECLARE @o_userName NVARCHAR(MAX)
  DECLARE @o_groupName NVARCHAR(MAX)
  DECLARE @o_errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
BEGIN
	DECLARE @userId				INT = 0
	DECLARE @groupName			NVARCHAR(MAX) = ''
	DECLARE @userGroupId		INT = 0
	DECLARE @userName			NVARCHAR(MAX) = ''
	DECLARE @providerName		NVARCHAR(MAX) = ''
	DECLARE @providerId			INT = 0
	DECLARE @ccId				INT = 2
	DECLARE @pos				INT = 0
    DECLARE @assocCount			INT = 0
	DECLARE @i					INT = 1
	DECLARE @assocXML			XML
	DECLARE	@userType			INT
	DECLARE @permission			INT = 1
	DECLARE	@o_sharedTo			NVARCHAR(MAX)
	DECLARE @infoTable			TABLE(providerId INT, serverName NVARCHAR(MAX), loginName NVARCHAR(MAX), loginPassword NVARCHAR(MAX), FQDN  NVARCHAR(MAX), useSecureLdap INT, userType INT, permission INT, port INT, userName NVARCHAR(MAX), groupName NVARCHAR(MAX), serviceType INT)
	SET @assocCount = @i_xmlString.value('count(//.[@userType])', 'INT')
	WHILE (@i <= @assocCount)
	BEGIN
		SET @assocXML = @i_xmlString.query('(//.[@userType])[sql:variable("@i")]')
		SET @userType = ISNULL (( SELECT ref.value('@userType', 'INT')
									FROM @assocXML.nodes ('sharedTo') R(ref)), 0)
		SET @permission = ISNULL (( SELECT ref.value('@permission', 'INT')
									FROM @assocXML.nodes ('sharedTo') R(ref)), 0)
IF @userType = 1	--USER
		BEGIN
			SET @o_sharedTo = ISNULL (( SELECT ref.value('@userId', 'NVARCHAR(MAX)')
									FROM @assocXML.nodes ('sharedTo/user') R(ref)), '')
			IF @o_sharedTo = '' OR @o_sharedTo = '0'
			BEGIN
				SET @o_sharedTo = ISNULL (( SELECT ref.value('@userName', 'NVARCHAR(MAX)')
										FROM @assocXML.nodes ('sharedTo/user') R(ref)), '')
				SET @userId = ISNULL ((SELECT id FROM UMUsers WHERE login = @o_sharedTo), 0)
				IF @userId = 0
				BEGIN
					SET @pos = CHARINDEX('\', @o_sharedTo)
					IF @pos <> 0
					BEGIN
						SET @providerName = LTRIM(RTRIM(LEFT(@o_sharedTo, @pos-1)))
						SET @userName = RIGHT(@o_sharedTo, LEN(@o_sharedTo)-@pos)
					END
					SET @userId = ISNULL ((SELECT id FROM UMUsers WHERE login = @o_sharedTo), 0)
					IF @userId = 0
					BEGIN
						SET @providerId = ISNULL((SELECT TOP 1 id FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @providerName), 0)
						IF (@providerId = 0)
						BEGIN
							SET @o_errorCode = 1
							SET @o_errorString = 'Error : Domain [' + @providerName + '] not found for User: ' + @o_sharedTo
							GOTO ERROR
						END
						INSERT INTO @infoTable (providerId, serverName, loginName, loginPassword, FQDN, useSecureLdap, userType, permission, port, userName, groupName, serviceType)
						SELECT id, domainName, login, password,
						CASE WHEN dnsRootStatus > 0 THEN dnsRoot
						ELSE hostName END FQND,
						useSecureLdap,
						@userType,
						@permission,
						port,
						@userName userName,
						'' groupName,
						serviceType
						FROM UMDSProviders
						WHERE domainName = @providerName
					END
				END
				SET @o_sharedTo = CAST(@userId AS NVARCHAR(MAX))
			END
		END
ELSE IF @userType = 4	--EXTERNAL GROUP
		BEGIN
			SET @o_sharedTo = ISNULL (( SELECT ref.value('@groupId', 'INT')
									FROM @assocXML.nodes ('sharedTo/externalGroup') R(ref)), '')
			IF @o_sharedTo = '' OR @o_sharedTo = '0'
			BEGIN
				SET @o_sharedTo = ISNULL (( SELECT ref.value('@externalGroupName', 'NVARCHAR(MAX)')
										FROM @assocXML.nodes ('sharedTo/externalGroup') R(ref)), '')
				SET @userGroupId = ISNULL ((SELECT id FROM UMDSgroups WHERE name = @o_sharedTo), 0)
				IF @userGroupId = 0
				BEGIN
					SET @providerId = ISNULL (( SELECT ref.value('@providerId', 'NVARCHAR(MAX)')
											FROM @assocXML.nodes ('sharedTo/externalGroup') R(ref)), '')
					IF @providerId = 0
					BEGIN
						SET @pos = CHARINDEX('\', @o_sharedTo)
						IF @pos <> 0
						BEGIN
							SET @providerName = LTRIM(RTRIM(LEFT(@o_sharedTo, @pos-1)))
							SET @groupName = RIGHT(@o_sharedTo, LEN(@o_sharedTo)-@pos)
						END
						SET @providerName = ISNULL (( SELECT ref.value('@providerDomainName', 'NVARCHAR(MAX)')
												FROM @assocXML.nodes ('sharedTo/externalGroup') R(ref)), @providerName)
						SET @providerId = ISNULL((SELECT TOP 1 id FROM UMDSProviders WHERE domainName = @providerName), 0)
						IF (@providerId = 0)
						BEGIN
							SET @o_errorCode = 1
							SET @o_errorString = 'Error : Domain [' + @providerName + '] not found for Group: ' + @groupName
							GOTO ERROR
						END
						INSERT INTO @infoTable (providerId, serverName, loginName, loginPassword, FQDN, useSecureLdap, userType, permission, port, userName, groupName,serviceType)
						SELECT id, domainName, login, password,
						CASE WHEN dnsRootStatus > 0 THEN dnsRoot
						ELSE hostName END FQND,
						useSecureLdap,
						@userType,
						@permission,
						port,
						'' userName,
						@groupName groupName,
						serviceType
						FROM UMDSProviders
						WHERE domainName = @providerName
					END
				END
				SET @o_sharedTo = CAST(@userGroupId AS NVARCHAR(MAX))
			END
		END
NEXT:
		SET @i  = @i +1
	END
ERROR:
	SELECT ProviderId AS 'o_ProviderId', useSecureLdap AS 'o_useSecureLdap', userType AS 'o_userType', permission AS 'o_permission', port AS 'o_port', serviceType AS 'o_serviceType', @o_errorCode AS 'o_errorCode',
	serverName AS 'o_serverName', loginName AS 'o_loginName', loginPassword AS 'o_loginPassword', FQDN AS 'o_FQDN', userName AS 'o_userName', groupName AS 'o_groupName', @o_errorString AS 'o_errorString'
	FROM @infoTable
	ORDER BY providerId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetMissingEmailInfo')
	delete from GxQscripts where name = 'AppSharingGetMissingEmailInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetMissingEmailInfo')
	delete from GXDBVersions where aliasname = 'AppSharingGetMissingEmailInfo'
GO

insert into GXDBVersions values(2, 'AppSharingGetMissingEmailInfo',  '00010002007400040000', 'AppSharingGetMissingEmailInfo', '00010002007400040000')
GO

