

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetIdsFromUserAndGroupNames.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingGetIdsFromUserAndGroupNames.sp,v $ $Id: AppSharingGetIdsFromUserAndGroupNames.sp,v 1.1.2.5 2018/03/27 08:15:23 jiechen Exp $";
--	+===================================================================+
--	|  			       AppSharingGetIdsFromUserAndGroupNames			|
--	|          Procedure for filling up the input xml with Ids      	|
--	|                           from user or group names				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingGetIdsFromUserAndGroupNames <<<'

IF EXISTS (select * from sysobjects where name='AppSharingGetIdsFromUserAndGroupNames')
	drop procedure AppSharingGetIdsFromUserAndGroupNames
IF EXISTS (select * from GxQscripts where name='AppSharingGetIdsFromUserAndGroupNames')
	delete from GxQscripts where name = 'AppSharingGetIdsFromUserAndGroupNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetIdsFromUserAndGroupNames')
	delete from GXDBVersions where aliasname = 'AppSharingGetIdsFromUserAndGroupNames'
GO
print '... Creating Procedure: AppSharingGetIdsFromUserAndGroupNames'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetIdsFromUserAndGroupNames
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT = NULL,
  @i_localeId INT = NULL
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @assocCount			INT = 0
	DECLARE @i					INT = 1
	DECLARE @assocXML			XML
	DECLARE	@userType			INT
	DECLARE	@sharedToName		NVARCHAR(MAX)
	DECLARE @userOrGroupId				INT = 0
	DECLARE @groupName			NVARCHAR(MAX) = ''
	DECLARE @userGroupId		INT = 0
	DECLARE @providerName		NVARCHAR(MAX) = ''
	DECLARE @email				NVARCHAR(255) = ''
	DECLARE @providerId			INT = 0
	DECLARE @pos				INT = 0
	DECLARE @isUserEmail		INT = 0
	DECLARE @newUserFlag		INT = 0x001
	DECLARE @ccId				INT = 2
	DECLARE @groupDescription	NVARCHAR(MAX) = 'Group created for sharing'
	DECLARE @userDescription	NVARCHAR(MAX) = 'User created for sharing'
	DECLARE @userGUID			NVARCHAR(MAX)
	DECLARE @shareToEmail		NVARCHAR(MAX) = ''
	DECLARE @userName			NVARCHAR(MAX) = ''
	-- ITERATE THE LIST OF PERMISSIONS
	SET @o_xmlString = @i_xmlString
	-- USER
	SET @assocCount = @i_xmlString.value('count(//.[user])', 'INT')
	WHILE (@i <= @assocCount)
	BEGIN
		SET @assocXML = @o_xmlString.query('(//.[user])[sql:variable("@i")]')
		SET @userType = ISNULL (( SELECT ref.value('@userType', 'INT')
								FROM @assocXML.nodes ('userInfo') R(ref)), 0)
		SET @shareToEmail = ISNULL (( SELECT ref.value('@email', 'NVARCHAR(MAX)')
							FROM @assocXML.nodes ('userInfo') R(ref)), '')
		-- USER
		IF @userType = 1
		BEGIN
			SET @userOrGroupId = ISNULL (( SELECT ref.value('@userId', 'INT')
									FROM @assocXML.nodes ('userInfo/user') R(ref)), 0)
			IF @userOrGroupId = 0
			BEGIN
				SET @sharedToName = ISNULL (( SELECT ref.value('@userName', 'NVARCHAR(MAX)')
											FROM @assocXML.nodes ('userInfo/user') R(ref)), '')
				SET @userOrGroupId = ISNULL ((SELECT id FROM UMUsers WITH(NOLOCK) WHERE login = @sharedToName), 0)
				------------
				IF @userOrGroupId = 0
				BEGIN
					--CREATE USER
					SET @pos = CHARINDEX('\', @sharedToName)
					IF @pos <> 0
					BEGIN
						SET @providerName = LTRIM(RTRIM(LEFT(@sharedToName, @pos-1)))
						SET @userName = RIGHT(@sharedToName, LEN(@sharedToName)-@pos)
					END
					--CREATE USER
					SET @providerId = ISNULL((SELECT id FROM UMDSProviders WHERE domainName = @providerName), 0)
					IF (@providerId <> 0)
					BEGIN
						INSERT INTO UMUsers (name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified, pVer, Pager, lastLogInTime, credSetTime, umDSproviderId, userGuid, origUserGuid, origCCId)
						VALUES (@userName, @userDescription, @sharedToName, '2AZdUUxUUyUUz', @shareToEmail, 0, 0, 0, 1, @newUserFlag, 0, 50, '', 0, 0, @providerId, @userGUID, '', @ccId)
						SELECT @userOrGroupId = @@IDENTITY
					END
				END
				------------
				--INSERT USERID IN THE XML
				IF @userOrGroupId <> 0
				BEGIN
					IF @assocXML.exist('//userInfo/user/@userId') = 1
						SET @o_xmlString.modify('replace value of (//userInfo/user)[sql:variable("@i")][1]/@userId with sql:variable("@userOrGroupId")')
					ELSE
						SET @o_xmlString.modify('insert (attribute userId {sql:variable("@userOrGroupId")}) into (//userInfo/user)[sql:variable("@i")][1]')
				END
			END
		END
		SET @i  = @i +1
	END
	--EMAIL
	SET @assocCount = @i_xmlString.value('count(//.[@email])', 'INT')
	SET @i = 1
	WHILE (@i <= @assocCount)
	BEGIN
	SET @isUserEmail = 0
		SET @assocXML = @o_xmlString.query('(//.[@email])[sql:variable("@i")]')
		SET @userType = ISNULL (( SELECT ref.value('@userType', 'INT')
								FROM @assocXML.nodes ('userInfo') R(ref)), 0)
		IF @userType = 2
		BEGIN
			SET @email = ISNULL (( SELECT ref.value('@email', 'NVARCHAR(255)')
								FROM @assocXML.nodes ('userInfo') R(ref)), 0)
			IF @email <> ''
			BEGIN
				SET @userOrGroupId = ISNULL ((SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE email = @email AND enabled = 1), 0)
				IF @userOrGroupId = 0
					SET @userOrGroupId = ISNULL ((SELECT TOP 1 id FROM UMGroups WITH(NOLOCK) WHERE email = @email), 0)
				ELSE
					SET @isUserEmail = 1
				--INSERT USERID IN THE XML
				IF @userOrGroupId <> 0
				BEGIN
					IF @isUserEmail = 1
					BEGIN
						SET @o_xmlString.modify('insert <user userId="{sql:variable("@userOrGroupId")}" /> into (//userInfo[@email=sql:variable("@email")])[1]')
						SET @o_xmlString.modify('replace value of (//userInfo[@email=sql:variable("@email")])[1]/@userType with 1')
					END
					ELSE
					BEGIN
						SET @o_xmlString.modify('insert <userGroup userGroupId="{sql:variable("@userOrGroupId")}" /> into (//userInfo[@email=sql:variable("@email")])[1]')
						SET @o_xmlString.modify('replace value of (//userInfo[@email=sql:variable("@email")])[1]/@userType with 3')
					END
				END
			END
		END
		SET @i  = @i +1
	END
	-- COMMCELL GROUP
	SET @assocCount = @i_xmlString.value('count(//.[userGroup])', 'INT')
	SET @i = 1
	WHILE (@i <= @assocCount)
	BEGIN
		SET @assocXML = @o_xmlString.query('(//.[userGroup])[sql:variable("@i")]')
		SET @userType = ISNULL (( SELECT ref.value('@userType', 'INT')
								FROM @assocXML.nodes ('userInfo') R(ref)), 0)
		SET @shareToEmail = ISNULL (( SELECT ref.value('@email', 'NVARCHAR(MAX)')
							FROM @assocXML.nodes ('userInfo') R(ref)), '')
		IF @userType = 3
		BEGIN
			SET @userOrGroupId = ISNULL (( SELECT ref.value('@userGroupId', 'INT')
								FROM @assocXML.nodes ('userInfo/userGroup') R(ref)), 0)
			IF @userOrGroupId = 0
			BEGIN
				SET @sharedToName = ISNULL (( SELECT ref.value('@userGroupName', 'NVARCHAR(MAX)')
									FROM @assocXML.nodes ('userInfo/userGroup') R(ref)), '')
				SET @userOrGroupId = ISNULL ((SELECT id FROM UMGroups WITH(NOLOCK) WHERE name = @sharedToName), 0)
				IF @userOrGroupId = 0
				BEGIN
					--CREATE GROUP
					INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID)
					VALUES (1, 0, 0, 1, @sharedToName, @groupDescription, @ccId, NEWID())
					SELECT @userOrGroupId = @@IDENTITY
				END
				--INSERT GROUPID IN THE XML
				IF @userOrGroupId <> 0
				BEGIN
					IF @assocXML.exist('//userInfo/userGroup/@userGroupId') = 1
						SET @o_xmlString.modify('replace value of (//userInfo/userGroup)[sql:variable("@i")][1]/@userGroupId with sql:variable("@userOrGroupId")')
					ELSE
						SET @o_xmlString.modify('insert (attribute userGroupId {sql:variable("@userOrGroupId")}) into (//userInfo/userGroup)[sql:variable("@i")][1]')
				END
			END
		END
		SET @i  = @i +1
	END
	--EXTERNAL GROUP
	SET @assocCount = @i_xmlString.value('count(//.[externalGroup])', 'INT')
	SET @i = 1
	WHILE (@i <= @assocCount)
	BEGIN
		SET @assocXML = @o_xmlString.query('(//.[externalGroup])[sql:variable("@i")]')
		SET @userType = ISNULL (( SELECT ref.value('@userType', 'INT')
								FROM @assocXML.nodes ('userInfo') R(ref)), 0)
		SET @shareToEmail = ISNULL (( SELECT ref.value('@email', 'NVARCHAR(MAX)')
							FROM @assocXML.nodes ('userInfo') R(ref)), '')
		IF @userType = 4
		BEGIN
			--support all these cases
			--group: commvault-nj\Dev-Server
			--group: Dev-Server providerId: 1
			--group: Dev-Server providerDomainName: commvault-nj
			SET @userOrGroupId = ISNULL (( SELECT ref.value('@groupId', 'INT')
									FROM @assocXML.nodes ('userInfo/externalGroup') R(ref)), 0)
			IF @userOrGroupId = 0
			BEGIN
				SET @sharedToName = ISNULL (( SELECT ref.value('@externalGroupName', 'NVARCHAR(MAX)')
									FROM @assocXML.nodes ('userInfo/externalGroup') R(ref)), '')
				SET @providerId = ISNULL (( SELECT ref.value('@providerId', 'NVARCHAR(MAX)')
										FROM @assocXML.nodes ('userInfo/externalGroup') R(ref)), 0)
				SET @groupName = @sharedToName
				IF @providerId = 0
				BEGIN
					SET @pos = CHARINDEX('\', @groupName)
					IF @pos <> 0
					BEGIN
						SET @providerName = LTRIM(RTRIM(LEFT(@groupName, @pos-1)))
						SET @groupName = RIGHT(@groupName, LEN(@groupName)-@pos)
					END
					SET @providerName = ISNULL (( SELECT ref.value('@providerDomainName', 'NVARCHAR(MAX)')
											FROM @assocXML.nodes ('sharedTo/externalGroup') R(ref)), @providerName)
					SET @providerId = ISNULL((SELECT id FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @providerName), 0)
				END
				IF @providerId <> 0
					SET @userOrGroupId = ISNULL ((SELECT id FROM UMGroups WITH(NOLOCK) WHERE name = @groupName AND @providerID = umdsProviderId), 0)
				IF @userOrGroupId = 0
				BEGIN
					--CREATE AD GROUP
					INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
					VALUES (1, 0, 0, 1, @groupName, @groupDescription, 2, NEWID(), @providerId, @shareToEmail, 0)
					SELECT @userOrGroupId = @@IDENTITY
					INSERT INTO UMDSgroups(id, umdsProviderId, enabled, name, description, email, lastCredSetTime, oldId)
					SELECT UMGroups.id, @providerId, 1, @groupName, @groupDescription, @shareToEmail, 0, 0
					FROM UMGroups
					WHERE UMGroups.name = @groupName AND UMGroups.umdsProviderId = @providerId
									END
				--INSERT USERID IN THE XML
				IF @userOrGroupId <> 0
				BEGIN
					IF @assocXML.exist('//userInfo/externalGroup/@groupId') = 1
						SET @o_xmlString.modify('replace value of (//userInfo/externalGroup)[sql:variable("@i")][1]/@groupId with sql:variable("@userOrGroupId")')
					ELSE
						SET @o_xmlString.modify('insert (attribute groupId {sql:variable("@userOrGroupId")}) into (//userInfo/externalGroup)[sql:variable("@i")][1]')
				END
			END
		END
		SET @i  = @i +1
	END
	SELECT @o_xmlString AS o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetIdsFromUserAndGroupNames')
	delete from GxQscripts where name = 'AppSharingGetIdsFromUserAndGroupNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetIdsFromUserAndGroupNames')
	delete from GXDBVersions where aliasname = 'AppSharingGetIdsFromUserAndGroupNames'
GO

insert into GXDBVersions values(2, 'AppSharingGetIdsFromUserAndGroupNames',  '00010001000200050000', 'AppSharingGetIdsFromUserAndGroupNames', '00010001000200050000')
GO

