

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingGetEdgeClientShareDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingGetEdgeClientShareDetails.sp,v $ $Id: AppSharingGetEdgeClientShareDetails.sp,v 1.1.2.2 2018/12/05 07:58:12 gpattabiraman Exp $";
--	+===========================================================================================+
--	|  			    AppSharingGetEdgeClientShareDetails											|
--	|		This procedure is used to get share details of Edge and objectstore clients.		|
--	|		It is called from EvTaskMgrManaged to query index to determine which file/folders 	|
--	|		are deleted, so that corresponding shares can to be deleted.						|
--	+===========================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSharingGetEdgeClientShareDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppSharingGetEdgeClientShareDetails <<<'
	drop procedure AppSharingGetEdgeClientShareDetails
END
IF EXISTS (select * from GxQscripts where name='AppSharingGetEdgeClientShareDetails')
	delete from GxQscripts where name = 'AppSharingGetEdgeClientShareDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetEdgeClientShareDetails')
	delete from GXDBVersions where aliasname = 'AppSharingGetEdgeClientShareDetails'
GO
print '... Creating Procedure: AppSharingGetEdgeClientShareDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingGetEdgeClientShareDetails
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_batchCount INT=1000,
  @i_minId INT=0
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @webserverId INT = 0, @maxSyncConfigId INT = 0
DECLARE @ShareBit		INT = CAST(0x4 AS INT) | CAST(0x8 AS INT) | CAST(0x80 AS INT)
	SELECT DISTINCT TOP(@i_batchCount) SC.syncPath, SC.clientId, SC.subclientId, SC.syncConfigId, U.login
	FROM App_SyncCloudFolder SF WITH(NOLOCK)
	JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON SF.syncWebFolderId = SC.syncWebFolderId AND SC.syncConfigId > @i_minId
JOIN APP_Client CL WITH(NOLOCK) ON CL.id = SC.clientId AND CL.status & CAST(0x10000000 AS INT) > 0
	JOIN UMUsers U WITH(NOLOCK) ON U.id = SF.ownerId
	LEFT OUTER JOIN APP_ClientProp CP WITH(NOLOCK) ON CL.id = CP.componentNameId AND CP.attrName = 'system drive type'
	WHERE SF.flag & @ShareBit > 0
		-- App.x structure EdgeSystemDriveTypes (DEFAULT_EDGE_DRIVE = 0, EDGE_CONTENT_STORE = 1, OUTLOOK_ADDIN_STORE = 2, NFS_OBJECT_STORE = 4, FILESTORE=7)
		AND ISNULL(TRY_CAST(CP.attrVal AS INT), 0) IN (0, 1, 2, 4, 7)
	GROUP BY SC.syncPath, SC.clientId, SC.subclientId, SC.syncConfigId, U.login
	ORDER BY SC.syncConfigId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingGetEdgeClientShareDetails')
	delete from GxQscripts where name = 'AppSharingGetEdgeClientShareDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingGetEdgeClientShareDetails')
	delete from GXDBVersions where aliasname = 'AppSharingGetEdgeClientShareDetails'
GO

insert into GXDBVersions values(2, 'AppSharingGetEdgeClientShareDetails',  '00010001000200020000', 'AppSharingGetEdgeClientShareDetails', '00010001000200020000')
GO

