

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingExcludeUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSharingExcludeUsers						|
--	|			Procedure for excluding users from a share folder		|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingExcludeUsers <<<'

IF EXISTS (select * from sysobjects where name='AppSharingExcludeUsers')
	drop procedure AppSharingExcludeUsers
IF EXISTS (select * from GxQscripts where name='AppSharingExcludeUsers')
	delete from GxQscripts where name = 'AppSharingExcludeUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingExcludeUsers')
	delete from GXDBVersions where aliasname = 'AppSharingExcludeUsers'
GO
print '... Creating Procedure: AppSharingExcludeUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingExcludeUsers
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @userExists			INT = 0
	DECLARE @ownerId			INT = 0
    DECLARE @assocCount			INT = 0
	DECLARE @sharedBy			INT = 0
	DECLARE @sharedTo			NVARCHAR(MAX) = ''
	DECLARE @i					INT = 1
	DECLARE @assocXML			XML
	DECLARE @permission			INT = 0
	DECLARE @opEvMsgId			INT = 0
	DECLARE @dataIsEvent		INT = 0
	DECLARE @opMsgId			INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
	DECLARE @userName			NVARCHAR(MAX) = ''
	DECLARE @reshareCount		INT = 0,
			@iterator			INT = 1,
			@reshareId			INT = 0,
			@reshareSharedBy	INT = 0
DECLARE @UTypeGroup			INT = 3
DECLARE @UTypeDSGroup		INT = 4
	DECLARE @userEmail			NVARCHAR(MAX) = ''
	DECLARE @deleteShareXML XML = '<App_DeleteSharedFolderReq><shareFolder syncWebFolderId="0"/></App_DeleteSharedFolderReq>';
	-- READ THE XML
	DECLARE @shareName			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_ExcludeUsersFromShareFolderReq/shareInfo/shareFolder') R(ref)), '')
	DECLARE @shareId			INT = ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
													FROM @i_xmlString.nodes ('App_ExcludeUsersFromShareFolderReq/shareInfo/shareFolder') R(ref)), 0)
	DECLARE @reshareOpType		INT = ISNULL ((SELECT ref.value('@reshareOperationType', 'INT')
													FROM @i_xmlString.nodes ('App_ExcludeUsersFromShareFolderReq/shareInfo') R(ref)), 0) -- 0=None,1=Keep/Overtake,2=Delete
	IF @shareId < 1
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid share Folder info in exclude request.'
		GOTO ERROR_EXIT
	END
	SET @ownerId = ISNULL( (SELECT ownerId FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @shareId), 0)
	If @ownerId = 0
	BEGIN
SET @errorCode = (2272 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	IF @shareName = ''
	BEGIN
		SET @shareName = ISNULL((SELECT syncWebFolderName
										FROM App_SyncCloudFolder WITH (NOLOCK)
										WHERE syncWebFolderId = @shareId), '')
	END
	SELECT @userName = login, @userEmail = email
	FROM UMUsers WITH(NOLOCK)
	WHERE id = @i_userId
	IF OBJECT_ID('tempdb.dbo.#reshares') IS NOT NULL
		DROP TABLE #reshares
	BEGIN TRAN
		MERGE App_SharingUserInfo UI
		USING (
				SELECT DISTINCT shareId, CAST(@i_userId AS NVARCHAR(MAX)) sharedTo, sharedBy, excluded FROM App_SharingUserInfo
                WHERE shareId = @shareId AND isOwner = 0 AND excluded = 0
			   ) AS TMP
		ON TMP.shareId = UI.shareId
		AND (UI.sharedTo = TMP.sharedTo OR UI.sharedTo = @userEmail)
		WHEN MATCHED AND UI.excluded = 0 THEN
			UPDATE SET excluded = 1, modified = @nowTime
		WHEN NOT MATCHED THEN
			INSERT (shareId, sharedTo, sharedBy, userType, enabled, deleted,  permission, created, modified, isOwner, excluded)
VALUES(@shareId, CAST(@i_userId AS NVARCHAR(MAX)), TMP.sharedBy, 1, 0, 0, @permission, @nowTime, 0, 0, 1);
		 --OUTPUT TMP.*, $action, inserted.*;
		 -- CHECK IF USER HAS PERMISSION THROUGH ANY GROUP
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
		--TAKE ACTION ON ALL THE RESHARES
		SELECT IDENTITY(int, 1, 1) AS RowID, SC.syncWebFolderId INTO #reshares FROM App_SyncCloudConfig SC WITH(NOLOCK)
			JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SC.syncWebFolderId = SU.shareId
			WHERE SC.parentShareId = @shareId
			AND SU.sharedBy = @i_userId
		SET @reshareCount = @@ROWCOUNT --GET THE TOTAL NO. OF RESHARES
		IF @reshareCount > 0
		BEGIN
			WHILE (@iterator <= @reshareCount)
			BEGIN
				SELECT @reshareId=syncWebFolderId FROM #reshares WHERE RowID = @iterator -- GET THE RESHARE ID FROM THE TABLE
				IF @reshareId <> 0 AND @reshareOpType = 2
				BEGIN
					SET @deleteShareXML.modify('replace value of (/App_DeleteSharedFolderReq/shareFolder/@syncWebFolderId)[1] with sql:variable("@reshareId")')
					SET @reshareSharedBy = ISNULL((SELECT DISTINCT sharedBy FROM App_SharingUserInfo WITH(NOLOCK) WHERE shareId = @reshareId), 0)
					EXEC AppSharingDeleteShareFolder @deleteShareXML, @reshareSharedBy, @i_localeId
				END
				SET @iterator = @iterator + 1
			END
		END
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
		-- SET GUI AUDIT OPERATION
SET @opMsgId = (397 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @userName, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @shareName, @dataIsEvent
SET @paramMsgId = (1096 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
ERROR:
	IF OBJECT_ID('tempdb.dbo.#reshares') IS NOT NULL
		DROP TABLE #reshares
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('App_GenericResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingExcludeUsers')
	delete from GxQscripts where name = 'AppSharingExcludeUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingExcludeUsers')
	delete from GXDBVersions where aliasname = 'AppSharingExcludeUsers'
GO

insert into GXDBVersions values(2, 'AppSharingExcludeUsers',  '00000000000000000000', 'AppSharingExcludeUsers', '00000000000000000000')
GO

