

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingDoesUserHaveSharedFolder.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSharingDoesUserHaveSharedFolder()
--  | Description:
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingDoesUserHaveSharedFolder.sp,v $ $Id: AppSharingDoesUserHaveSharedFolder.sp,v 1.4.80.4 2018/03/27 08:09:37 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingDoesUserHaveSharedFolder <<<'

IF EXISTS (select * from sysobjects where name='AppSharingDoesUserHaveSharedFolder')
	drop procedure AppSharingDoesUserHaveSharedFolder
IF EXISTS (select * from GxQscripts where name='AppSharingDoesUserHaveSharedFolder')
	delete from GxQscripts where name = 'AppSharingDoesUserHaveSharedFolder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingDoesUserHaveSharedFolder')
	delete from GXDBVersions where aliasname = 'AppSharingDoesUserHaveSharedFolder'
GO
print '... Creating Procedure: AppSharingDoesUserHaveSharedFolder'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingDoesUserHaveSharedFolder
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId INT,
  @hasShares INT OUTPUT
-----------------------------------------------------------
AS
BEGIN
	SET @hasShares = 0
	-- SHARED BY/TO THE USER
	IF EXISTS (
			SELECT 1
			FROM App_SharingUserInfo WITH (NOLOCK)
			WHERE userType = 1
				AND sharedTo = CAST(@i_userId AS NVARCHAR(10))	-- SATISIFES BOTH SHAREDBY AND SHAREDTO CONDITION
				AND enabled = 1
				AND deleted = 0
				AND excluded = 0
			)
	BEGIN
		SET @hasShares = 1
	END
	-- SHARED USING A GROUP EMAIL
	ELSE IF EXISTS (
			SELECT 1
			FROM UMGroups G(NOLOCK)
			JOIN UMUserGroup UG(NOLOCK) ON UG.groupId = G.id
				AND UG.userId = @i_userId
			JOIN App_SharingUserInfo A ON A.sharedTo = G.email
				AND A.userType = 2
				AND A.enabled = 1
				AND A.deleted = 0
				AND A.excluded = 0
			)
	BEGIN
		SET @hasShares = 1
	END
	-- SHARED USING AN USER EMAIL
	ELSE IF EXISTS (
			SELECT 1
			FROM UMUsers U(NOLOCK)
				,App_SharingUserInfo A WITH (NOLOCK)
			WHERE sharedTo = U.email
				AND U.id = @i_userId
				AND U.enabled = 1
				AND flags & 1 = 1
				AND A.userType = 2
				AND A.enabled = 1
				AND A.deleted = 0
				AND A.excluded = 0
			)
	BEGIN
		SET @hasShares = 1
	END
	-- SHARED TO A GROUP
	ELSE IF EXISTS (
			SELECT 1
			FROM UMUserGroup U WITH (NOLOCK)
				,App_SharingUserInfo A WITH (NOLOCK)
			WHERE sharedTo = CAST(groupId AS NVARCHAR(10))
				AND userId = @i_userId
				AND (userType = 3 OR userType = 4)
				AND A.enabled = 1
				AND A.deleted = 0
				AND A.excluded = 0
			)
	BEGIN
		SET @hasShares = 1
	END
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSharingDoesUserHaveSharedFolder')
	delete from GxQscripts where name = 'AppSharingDoesUserHaveSharedFolder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingDoesUserHaveSharedFolder')
	delete from GXDBVersions where aliasname = 'AppSharingDoesUserHaveSharedFolder'
GO

insert into GXDBVersions values(2, 'AppSharingDoesUserHaveSharedFolder',  '00010004008000040000', 'AppSharingDoesUserHaveSharedFolder', '00010004008000040000')
GO

