

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingDeleteShareFolder.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSharingDeleteShareFolder					|
--	|			Procedure for deleting a Shared Folder					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingDeleteShareFolder <<<'

IF EXISTS (select * from sysobjects where name='AppSharingDeleteShareFolder')
	drop procedure AppSharingDeleteShareFolder
IF EXISTS (select * from GxQscripts where name='AppSharingDeleteShareFolder')
	delete from GxQscripts where name = 'AppSharingDeleteShareFolder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingDeleteShareFolder')
	delete from GXDBVersions where aliasname = 'AppSharingDeleteShareFolder'
GO
print '... Creating Procedure: AppSharingDeleteShareFolder'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingDeleteShareFolder
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @ownerId			INT = 0
	DECLARE @opEvMsgId			INT = 0
	DECLARE @dataIsEvent		INT = 0
	DECLARE @opMsgId			INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
	-- READ THE XML
	DECLARE @shareName			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_DeleteSharedFolderReq/shareFolder') R(ref)), '')
	DECLARE @shareId			INT = ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
													FROM @i_xmlString.nodes ('App_DeleteSharedFolderReq/shareFolder') R(ref)), 0)
	IF @shareId = 0
	BEGIN
		SET @shareId = ISNULL((SELECT syncWebFolderId
										FROM App_SyncCloudFolder WITH (NOLOCK)
										WHERE syncWebFolderName = @shareName AND ownerId = @i_userId), 0)
	END
	IF @shareId < 1
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid share Folder info in delete request.'
		GOTO ERROR_EXIT
	END
	--SET @ownerId = ISNULL( (SELECT ownerId FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @shareId), 0)
	-- OWNER SHOULD BE THE USER WHO HAS SHARED AS IN RESHARE THE ORIGINAL OWNER IS DIFFERENT
	SET @ownerId = ISNULL( (SELECT DISTINCT su.sharedBy FROM App_SyncCloudFolder sc WITH(NOLOCK)
							INNER JOIN App_SharingUserInfo su WITH (NOLOCK)
							ON sc.syncWebFolderId = su.shareId
							WHERE sc.syncWebFolderId = @shareId), 0)
	If @ownerId = 0
	BEGIN
SET @errorCode = (2272 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	ELSE IF @ownerId <> @i_userId
	BEGIN
		SET @errorCode = 3
		SET @errorString = 'Error : Unable to delete as user is not the owner.'
		GOTO ERROR_EXIT
	END
	IF @shareName = ''
	BEGIN
		SET @shareName = ISNULL((SELECT syncWebFolderName
										FROM App_SyncCloudFolder WITH (NOLOCK)
										WHERE syncWebFolderId = @shareId), '')
	END
	-- Get all the child shared folder
	DECLARE @MyCursor CURSOR
	DECLARE @Id INT;
	WITH cteShares (syncWebFolderId, parentShareId)
		AS
		(
			SELECT syncWebFolderId, parentShareId FROM App_SyncCloudConfig WHERE syncWebFolderId = @shareId
			UNION ALL
			SELECT sc.syncWebFolderId, sc.parentShareId FROM App_SyncCloudConfig sc
				INNER JOIN cteShares cs ON sc.parentShareId = cs.syncWebFolderId
		)
	SELECT syncWebFolderId INTO #temp FROM cteShares
	BEGIN TRAN
		SET @MyCursor = CURSOR FOR
		select syncWebFolderId from #temp
		OPEN @MyCursor
		FETCH NEXT FROM @MyCursor INTO @Id
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DELETE App_SyncCloudFolder
			WHERE syncWebFolderId = @Id
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR
			FETCH NEXT FROM @MyCursor
			INTO @Id
		END;
		CLOSE @MyCursor ;
		DEALLOCATE @MyCursor;
		DELETE #temp
		-- SET GUI AUDIT OPERATION
SET @opMsgId = (397 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 1 , 2, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @shareName, @dataIsEvent
SET @paramMsgId = (1088 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('App_GenericResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingDeleteShareFolder')
	delete from GxQscripts where name = 'AppSharingDeleteShareFolder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingDeleteShareFolder')
	delete from GXDBVersions where aliasname = 'AppSharingDeleteShareFolder'
GO

insert into GXDBVersions values(2, 'AppSharingDeleteShareFolder',  '00000000000000000000', 'AppSharingDeleteShareFolder', '00000000000000000000')
GO

