

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingCreateConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingCreateConfig.sp,v $ $Id: AppSharingCreateConfig.sp,v 1.16.2.33 2019/03/04 16:37:06 nlakade Exp $";
--	+===================================================================+
--	|  					  AppSharingCreateConfig						|
--	|          Procedure for creating a new Shared Folder				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSharingCreateConfig')
BEGIN
	print '>>> Drop Stored Procedure: AppSharingCreateConfig <<<'
	drop procedure AppSharingCreateConfig
END
IF EXISTS (select * from GxQscripts where name='AppSharingCreateConfig')
	delete from GxQscripts where name = 'AppSharingCreateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingCreateConfig')
	delete from GXDBVersions where aliasname = 'AppSharingCreateConfig'
GO
print '... Creating Procedure: AppSharingCreateConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingCreateConfig
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @posIdx				INT = 0
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @shareId			INT = 0
    DECLARE @assocCount			INT = 0
	DECLARE @i					INT = 1
	DECLARE @assocXML			XML
	DECLARE @userType			INT = 1
	DECLARE @sharedBy			INT = 0
	DECLARE @sharedTo			NVARCHAR(MAX) = ''
	DECLARE @shareToName		NVARCHAR(MAX) = ''
	DECLARE @syncType			INT = 1	--CREATE AS A SOURCE
	DECLARE @scFilterFileID		INT = 0
	DECLARE @opEvMsgId			INT = 0
	DECLARE @dataIsEvent		INT = 0
	DECLARE @opMsgId			INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
DECLARE @shareCap			BIGINT = POWER(2.0, 40-1)
	DECLARE @sharedToUserStatus INT = 0
	DECLARE @shareToTable		TABLE (sharedTo NVARCHAR(MAX), userType INT, shareToName NVARCHAR(MAX), errorCode INT, errorString NVARCHAR(MAX))
	DECLARE @clientName			NVARCHAR(MAX) = ''
	DECLARE @permissionParam	INT
	DECLARE @permissionVal		NVARCHAR(MAX) = ''
	DECLARE @shortUrl			NVARCHAR(MAX) = ''
	DECLARE @webConsoleURL		NVARCHAR(MAX) = ''
	DECLARE @goToLink			NVARCHAR(MAX) = ISNULL((SELECT value FROM GXGlobalParam WHERE name='Short Url Template' AND modified=0), 'gtl.do?gid=')
	DECLARE @clientStatus		INT = 0
	DECLARE @isEdgeClient		INT = 0
	DECLARE @reqWithUrl			INT = 0
	DECLARE @contentStoreType	NVARCHAR(MAX) = ''
	DECLARE @systemDriveType	INT = 0
	DECLARE @reshareParam		INT
	DECLARE @reshareVal			NVARCHAR(MAX) = ''
	DECLARE @isAlreadyShared	INT = 0
DECLARE @UTypeUser		INT = 1
DECLARE @UTypeEmail		INT = 2
DECLARE @UTypeGroup		INT = 3
DECLARE @UTypeDSGroup	INT = 4
	DECLARE @clientType		INT = 0
	DECLARE @ExchangeClientType INT = 25 --APP_ClientType::EXCHAGE_ONEPASS defined in App.x
	DECLARE @ExchangeOnePassClientProp NVARCHAR(32)= 'Exchange OnePass Client'  --  Defined in ClientProperties.cpp as const string CV_PROP_EXCHANGE_ONEPASS_CLIENT = 'Exchange OnePass Client';
	DECLARE @ExchangeShareBrowseUrl NVARCHAR(32) = 'summary/index.do?page=email'
	-- READ THE XML
	DECLARE @permission			INT = ISNULL (( SELECT ref.value('@userPermission', 'INT')
														FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo') R(ref)), 2)
	DECLARE @shareName			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo/shareFolder') R(ref)), '')
	DECLARE @description		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@description', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo') R(ref)), '')
	DECLARE @ownerId			INT = ISNULL (( SELECT ref.value('@userId', 'INT')
													FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo/owner') R(ref)), @i_userId)
	DECLARE @parentShareOwnerId	INT = @ownerId
	DECLARE @parentShareUserId	INT = @i_userId
	DECLARE @subclientId		INT = ISNULL (( SELECT ref.value('@subclientId', 'INT')
													FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo/client') R(ref)), 0)
	DECLARE @clientId			INT = ISNULL (( SELECT ref.value('@clientId', 'INT')
													FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo/client') R(ref)), 0)
	DECLARE @status				INT = ISNULL (( SELECT ref.value('@status', 'INT')
													FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo') R(ref)), 0)
	DECLARE @browseXMLReq		XML =  @i_xmlString.query('/App_CreateShareFolderReq/shareInfo/browseInfo')
	DECLARE @path				NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@path', 'NVARCHAR(MAX)')
														FROM @browseXMLReq.nodes ('/browseInfo/paths') R(ref)), '')
	DECLARE @emailInfo			XML =  @i_xmlString.query('/App_CreateShareFolderReq/shareInfo/browseInfo/emailInfo')
	DECLARE @browseUrl			NVARCHAR(MAX) = ''--ISNULL (( SELECT ref.value('@browseUrl', 'NVARCHAR(MAX)')
														--FROM @i_xmlString.nodes ('/App_CreateShareFolderReq/shareInfo/browseInfo/emailInfo') R(ref)), '')
	DECLARE @isDirectory		INT = ISNULL (( SELECT ref.value('@directory', 'INT')
													FROM @browseXMLReq.nodes ('browseInfo/paths') R(ref)), 1)
	DECLARE @canReshare			INT = ISNULL (( SELECT ref.value('@canReshare', 'INT')
													FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo') R(ref)), 0)
	DECLARE @reshareFlag		INT = 0
	DECLARE @parentShareId		INT = ISNULL (( SELECT ref.value('@shareId', 'INT')
													FROM @i_xmlString.nodes ('App_CreateShareFolderReq/shareInfo/parentShare') R(ref)), 0)
	DECLARE @ownerExistingPermission	INT = 0
	DECLARE @expirationDate		NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@timeValue', 'NVARCHAR(MAX)')
														FROM @browseXMLReq.nodes ('/browseInfo/expirationTime') R(ref)), '')
	DECLARE @expirationTime		BIGINT = ISNULL (( SELECT ref.value('@time', 'BIGINT')
														FROM @browseXMLReq.nodes ('/browseInfo/expirationTime') R(ref)), 0)
	DECLARE @isSet				INT = ISNULL (( SELECT ref.value('@isSet', 'INT')
														FROM @browseXMLReq.nodes ('/browseInfo/password') R(ref)), 0)
	DECLARE @isGeneratePwd				INT = ISNULL (( SELECT ref.value('@generatePassword', 'INT')
														FROM @browseXMLReq.nodes ('/browseInfo/password') R(ref)), 0)
	DECLARE @enforcePwdForPublicLink INT = 0
	DECLARE @excluded		INT = ISNULL (( SELECT ref.value('@isHiddenShare', 'INT')
														FROM @browseXMLReq.nodes ('App_CreateShareFolderReq') R(ref)), 0)
	BEGIN TRY
	BEGIN TRAN
	-- CHECK EMPTY PATH
	IF @path = ''
	BEGIN
SET @errorCode = (3531 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	--
	SET @status = (
					SELECT CASE @status
WHEN 1 THEN 0x8
WHEN 4 THEN 0x80
ELSE 0x4
					END
				  )
	-- if public share
IF ( (@status = CAST(0x8 AS INT)) OR  (@status = CAST(0x80 AS INT)) )
	BEGIN
		-- check if additional setting EnforcePasswordForPublicLink is enabled for the user.
		DECLARE @consoleSettingXML xml = '<App_ConsoleSettingsFilter><keyNameList val="EnforcePasswordForPublicLink"/></App_ConsoleSettingsFilter>'
		exec AppGetConsoleSettingsList @i_userId,1,@consoleSettingXML output
		SET @enforcePwdForPublicLink = (SELECT TOP 1 1 FROM @consoleSettingXML.nodes ('/App_ConsoleSettingsListResp/consoleSettings') R(ref) WHERE ref.value('@atterValue', 'NVARCHAR(MAX)')='true')
		-- Enforce password for public share if not set and auto generate password.
		IF(@enforcePwdForPublicLink = 1 AND @isSet <> 1)
		BEGIN
			SET @isSet = 1
			SET @isGeneratePwd =1
			IF (@browseXMLReq.exist('/browseInfo/password')) = 1
							SET @browseXMLReq.modify('delete /browseInfo/password [1]')
			SET @browseXMLReq.modify('insert <password isSet="1" generatePassword="1"/> into (/browseInfo)[1]')
		END
	END
	-- CHECK PASSWORD COMPLEXITY
	IF @isSet = 1
	BEGIN
		DECLARE @isStrongPwd INT = 0
		DECLARE @newPassword NVARCHAR(MAX)
		DECLARE @decryptedPwd NVARCHAR(MAX)
		IF @isGeneratePwd =1
		BEGIN
			EXEC APPGeneratePassword @newPassword OUTPUT
			SET @decryptedPwd = dbo.base64Encode(@newPassword)
		END
		ELSE
		BEGIN
			-- Password is in base64encoded->V3encrypted->base64encoded format
			SET @newPassword = ISNULL (( SELECT ref.value('@password', 'NVARCHAR(MAX)')
															FROM @browseXMLReq.nodes ('/browseInfo/password') R(ref)), '')
			IF((CHARINDEX('|#',@newPassword, 1)) >0 )
			BEGIN
					SET @newPassword=(select dbo.DecodeInvalidXMLChar(@newPassword))
					SET @newPassword = SUBSTRING(@newPassword,2,LEN(@newPassword))
			END
			SET @newPassword = dbo.base64Decode(@newPassword)
			exec miscProc2 @newPassword, @decryptedPwd OUTPUT
		END
		SET @newPassword = @decryptedPwd -- We keep the password in base64 encoded format
		IF (@browseXMLReq.exist('/browseInfo/password/@password')) = 1
			SET @browseXMLReq.modify('replace value of (/browseInfo/password/@password)[1] with sql:variable("@newPassword")')
		ELSE
			SET @browseXMLReq.modify('insert (attribute password {sql:variable("@newPassword")}) into (/browseInfo/password)[1]')
		DECLARE @encryptedPwd NVARCHAR(MAX)
		SET @newPassword = dbo.base64Decode(@newPassword) -- Plain text password
		EXEC dbo.pswEncryptionManaged @newPassword , @encryptedPwd OUTPUT
		DECLARE @psErrorCode int = 0
        EXEC sec_isPasswordStrong @encryptedPwd, @isStrongPwd OUTPUT, @errorString OUTPUT, @i_localeId, @psErrorCode OUTPUT
        IF @isStrongPwd = 0
        BEGIN
            SET @errorCode=400
            GOTO ERROR_EXIT
        END
    END
	IF @clientId = 0 AND  @subclientId <> 0
	BEGIN
		SELECT @clientId = clientId FROM APP_Application (NOLOCK) WHERE id = @subclientId
	END
	ELSE IF @parentShareId <> 0 -- Retrieve details using parentshareId
	BEGIN
		IF NOT EXISTS(SELECT 1 FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId=@parentShareId)
		BEGIN
SET @errorCode = (2747 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
		SELECT @clientId = SC.clientId, @subclientId = SC.subclientId, @parentShareUserId = SF.ownerId
			FROM App_SyncCloudConfig SC (NOLOCK)
			JOIN App_SyncCloudFolder SF (NOLOCK)
			ON SC.syncWebFolderId = SF.syncWebFolderId
			WHERE SC.syncWebFolderId = @parentShareId
	END
	SELECT @clientName = name, @clientStatus = status FROM App_Client WITH (NOLOCK)
	WHERE id = @clientId
SET @reshareFlag = (SELECT CASE WHEN @canReshare = 1 THEN CAST(0x10 AS INT)
ELSE CAST(0x8 AS INT)
			END
			)
--
	IF object_id('tempdb.dbo.#AppSharing_userObjects') is not null
		DROP TABLE #AppSharing_userObjects
create table  #AppSharing_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @parentShareUserId, 2013 /*SUB_CLIENT_ITEM */, 0, '#AppSharing_userObjects'
	IF NOT EXISTS(SELECT 1 FROM #AppSharing_userObjects sec
					WHERE sec.capabilities&@shareCap=@shareCap
					AND
					(
						clientId = @clientId
						OR
						(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
						)
					)
				)
	BEGIN
SET @errorCode = (2504 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	-- CHECK FOR RESHARE CALL. IF THEN CHECK WHETHER THE FOLDER CAN BE RESHARED AND OTHER VALIDATION
	IF @parentShareId <> 0
	BEGIN
		-- VALIDATE PARENT SHARE EXPIRATION
IF (SELECT flag&CAST(0x40 AS INT) FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @parentShareId) = CAST(0x40 AS INT)
		BEGIN
SET @errorCode = (2748 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
		-- PARENT SHARE EXPIRATION TIME VALIDATION
		DECLARE @parentShareBrowseInfo XML = (SELECT configOptions FROM App_SyncCloudConfig WITH(NOLOCk) WHERE syncWebFolderId = @parentShareId)
		IF @parentShareBrowseInfo.exist('browseInfo/expirationTime/@time') = 1
		BEGIN
			DECLARE @parentShareExpirationTime	BIGINT = ISNULL ((SELECT ref.value('@time', 'BIGINT') FROM @parentShareBrowseInfo.nodes ('//expirationTime') R(ref)), 0)
			IF (@expirationTime > @parentShareExpirationTime AND @parentShareExpirationTime <> 0) OR @expirationTime <= 0 -- 0=NEVER EXPIRE
			BEGIN
				SET @expirationTime = @parentShareExpirationTime
				IF @browseXMLReq.exist('browseInfo/expirationTime') = 1
				BEGIN
					IF @browseXMLReq.exist('browseInfo/expirationTime/@time') = 1
						SET @browseXMLReq.modify('replace value of (/browseInfo/expirationTime/@time)[1] with sql:variable("@expirationTime")')
					ELSE
						SET @browseXMLReq.modify('insert (attribute time {sql:variable("@expirationTime")}) into (/browseInfo/expirationTime)[1]')
				END
				ELSE
				BEGIN
					SET @browseXMLReq.modify('insert <expirationTime/> into (/browseInfo)[1]')
					SET @browseXMLReq.modify('insert (attribute time {sql:variable("@expirationTime")}) into (/browseInfo/expirationTime)[1]')
				END
			END
		END
		-- ONLY PRIVATE SHARES CAN BE RESHARED
IF (SELECT flag&CAST(0x4 AS INT) FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @parentShareId) <> CAST(0x4 AS INT)
		BEGIN
SET @errorCode = (2749 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
		IF OBJECT_ID('tempdb.dbo.#InUserGroup') IS NOT NULL
		DROP TABLE #InUserGroup
		CREATE TABLE #InUserGroup (
			userId		INT,
			groupId		INT,
			dsType		INT,
			PRIMARY KEY (userId, dsType, groupId)
		)
		INSERT INTO #InUserGroup
			SELECT userId, groupId, 0
			FROM UMUserGroup WITH(NOLOCK)
			WHERE userId = @i_userId
			UNION ALL
			SELECT userId, groupId, 1
			FROM UMDSUserGroup ug WITH(NOLOCK)
			WHERE ug.userId = @i_userId
		SET @parentShareOwnerId = ISNULL ((SELECT ownerId FROM App_SyncCloudFolder WITH(NOLOCk) WHERE syncWebFolderId = @parentShareId), @ownerId)
		-- GET THE SHARED FOLDER INFO
		DECLARE @t_userShares       TABLE(shareId int, sharedTo NVARCHAR(255), userType int, permission int, isOwner	int, excluded int, shareType int)
		INSERT INTO @t_userShares
			EXEC AppSharingGetSharedFoldersForUser @ownerId, @parentShareId, 0/*Get all shares*/, 1/*Include excluded shares*/
		--IF USER IS DIRECTLY PRESENT THEN THAT TAKES THE PRECEDENCE TO CONSIDER PERMISSIONS. MR# 157534
		--IF EXISTS (SELECT 1 FROM @t_userShares where userType = @UTypeUser)
		--	DELETE FROM @t_userShares where userType <> @UTypeUser
		SET @ownerExistingPermission = ISNULL (
			(
				SELECT dbo.BitwiseOR(SU.permission) FROM App_SharingUserInfo SU WITH(NOLOCk)
					JOIN @t_userShares US ON SU.shareId = US.shareId
					AND SU.sharedTo = US.sharedTo AND SU.userType = US.userType
			),
			 1)
		SET @permission = @ownerExistingPermission--TAKE HIGHEST PERMISSIONS OF PARENT SHARE'S SHAREDTO ITEM--(select CASE
							--		WHEN @ownerExistingPermission&SHARE_CAN_EDIT <> 0  THEN SHARE_CAN_EDIT
							--		ELSE SHARE_CAN_VIEW
							--	END)
		-- PUBLIC UPLOAD SHARE CAN ONLY BE CREATED IF THE USER HAS EDIT PERMISSIONS
IF @status=CAST(0x80 AS INT) AND (@permission & 2) <> 2
		BEGIN
SET @errorCode = (2504 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
IF NOT EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @parentShareId AND flag & CAST(0x10 AS INT) = CAST(0x10 AS INT))
		BEGIN
SET @errorCode = (2746 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
		--ADD IMMEDIATE PARENT SHARE OWNER TO SHAREDTO LIST OF THE RE-SHARE FOR PRIVATE SHARE
		DECLARE @immediateParentOwnerId	INT = ISNULL((SELECT TOP 1 sharedBy FROM app_SharingUserInfo WITH(NOLOCK) WHERE shareId=@parentShareId), 0)
IF @status = 0x4 AND @immediateParentOwnerId <> @i_userId --DO NOT ADD OWNER IN SHAREDTO LIST
		BEGIN
			DECLARE @parentOwnerSharedToString XML = '<sharedTo permission="1" userType="1"><user userId=""/></sharedTo>'
			SET @parentOwnerSharedToString.modify('replace value of (sharedTo/user/@userId)[1] with sql:variable("@immediateParentOwnerId")')
			SET @i_xmlString.modify('insert sql:variable("@parentOwnerSharedToString") as last into (/App_CreateShareFolderReq/shareInfo)[1]')
		END
	END
	-- CREATE NEW FOR THE FIRST TIME.
	-- Check is item is already shared.
	SELECT TOP 1 @shareId = SF.syncWebFolderId FROM App_SyncCloudFolder SF WITH(NOLOCK)
		INNER JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON SF.syncWebFolderId = SC.syncWebFolderId
		INNER JOIN App_SharingUserInfo SU WITH(NOLOCK) ON SF.syncWebFolderId = SU.shareId
		INNER JOIN App_SyncCloudFolders SFV ON SF.syncWebFolderId = SFV.SyncWebFolderId
		WHERE SU.sharedBy = @i_userId AND SC.subclientId = @subclientId AND syncPath = @path
		AND SC.parentShareId = @parentShareId
		AND SFV.FLAG <> 0	--CHECK THAT FOLDER IS A SHARE
		AND SF.flag & @status = @status	--WE CAN NOW HAVE PRIVATE AND PUBLIC SHARE WITH SAME NAME
	IF @shareId > 0
SET @isAlreadyShared = (2346 | (CAST(POWER(2, 24) AS BIGINT) * 35))
IF @clientStatus & 0x10000000 = 0x10000000
	BEGIN
		SET @isEdgeClient = 1
IF @clientStatus & 0x40000000 = 0x40000000
		BEGIN
			SET @contentStoreType = (SELECT attrVal FROM APP_SubClientProp WITH(NOLOCK)
									 WHERE attrName = 'Edge Content Store Type' AND modified = 0 --CV_PROP_EDGE_CONTENT_STORE_TYPE
									 AND componentNameId = @subclientId)
			SET @systemDriveType = (SELECT CAST(attrVal AS INT) FROM APP_ClientProp  WITH(NOLOCK)
									WHERE attrName = 'System Drive Type' AND modified = 0 --CV_PROP_SYSTEM_DRIVE_TYPE
									AND componentNameId = @clientId )
SET @status = @status | 0x20
			-- For outlook addin private share, the share should be hidden
			IF @systemDriveType = 2 -- OUTLOOK_ADDIN_STORE
AND @status & 0x8 = 0
			   BEGIN
SET @status = @status | 0x100
			   END
			ELSE IF @systemDriveType = 7 -- FILESTORE
AND @status & 0x8 = 0
			   BEGIN
SET @status = @status | 0x400
			   END
		END
	END
	--Check Exchange mailbox share
	IF EXISTS(SELECT id FROM APP_ClientProp WITH(nolock) WHERE componentNameId = @clientId AND attrName = @ExchangeOnePassClientProp AND AttrVal = '1' AND modified = 0)
	AND @isEdgeClient = 0
	BEGIN
		SET @clientType = @ExchangeClientType -- APP_ClientType::EXCHAGE_ONEPASS
		SET @excluded = 1	--Dont show in Shared With Me and Shared By Me bucket
	END
	IF @clientType != 0
	BEGIN
		IF (@browseXMLReq.exist('/browseInfo/@clientType')) = 1
			SET @browseXMLReq.modify('replace value of (/browseInfo/@clientType)[1] with sql:variable("@clientType")')
		ELSE
			SET @browseXMLReq.modify('insert (attribute clientType {sql:variable("@clientType")}) into (/browseInfo)[1]')
	END
	--FOR RESHARING THE ROOT, GUI WILL SEND THE PATH WITH JUST A SLASH
	If (@path = '\' OR @path = '/') AND @parentShareId <> 0
	BEGIN
		IF dbo.scgGetClientOSType(@clientId) = 2 --UNIX
            SET @path = '/'
		ELSE
			SET @path = '\'
    END
	IF (@browseXMLReq.exist('/browseInfo/paths/@path')) = 1
		SET @browseXMLReq.modify('replace value of (/browseInfo/paths/@path)[1] with sql:variable("@path")')
	-- VALIDATION SUCCESS, CREATE THE SHARING FOLDER
	IF @isAlreadyShared = 0
	BEGIN
		GENERATE_RETRY:
			SET @shareId = ABS(CHECKSUM(NEWID())) % 1000000 + 1;
			IF EXISTS (SELECT 1 FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @shareId)
				GOTO GENERATE_RETRY
		INSERT INTO App_SyncCloudFolder (syncWebFolderName, description, created, modified, flag, ownerId, syncWebFolderId)
					VALUES(@shareName, @description, @nowTime, 0, @status, @parentShareOwnerId, @shareId)
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR_EXIT
	END
	--BUILD BROWSE URL TO RETURN TO GUI
	SET @webConsoleURL = '/webconsole/' --NO NEED TO STORE THE FULL URL
	IF @browseUrl = ''
	BEGIN
		IF @isEdgeClient = 1
			SET @browseUrl = 'MyDrive.do?'
		ELSE
			SET @browseUrl = 'fsBrowse.do?'
		--DECLARE @urlDisplayName NVARCHAR(MAX) = REPLACE(@shareName,' ','+')
		--SET @browseUrl = '/webconsole/browse/' + @browseUrl + 'displayName=' + @urlDisplayName
		SET @browseUrl = 'browse/' + @browseUrl
		--IF @isDirectory = 1
		--	SET @browseUrl = @browseUrl + '&isDirectoryShareBrowse=true'
		-- Need path for edge drive
		IF @isEdgeClient = 1
			SET @browseUrl = @browseUrl + 'path=' + @path
		-- Make mail homepage as url for Exchange client
		IF @clientType = @ExchangeClientType
			SET @browseUrl = @ExchangeShareBrowseUrl
	END
	ELSE
		SET @reqWithUrl = 1
	IF @browseUrl <> ''
	BEGIN
		IF @reqWithUrl = 0
			SET @browseUrl = @webConsoleURL + @browseUrl
		IF @isEdgeClient = 1 OR @reqWithUrl = 1
			SET @browseUrl = @browseUrl + '&'
		IF @clientType != @ExchangeClientType -- Ignore for Exchange mailbox shares
			SET @browseUrl = @browseUrl + 'shareFolderId=' + CAST(@shareId AS NVARCHAR(10))
IF ((@status & CAST(0x8 AS INT) = CAST(0x8 AS INT)) OR
(@status & CAST(0x80 AS INT) = CAST(0x80 AS INT)))
		BEGIN
			SET @browseUrl = @browseUrl + '&iP=PUBLIC'
		END
		IF (@browseXMLReq.exist('/browseInfo/emailInfo')) <> 1
			SET @browseXMLReq.modify('insert <emailInfo /> into (/browseInfo)[1]')
		IF (@browseXMLReq.exist('/browseInfo/emailInfo/@browseUrl')) = 1
			SET @browseXMLReq.modify('replace value of (/browseInfo/emailInfo/@browseUrl)[1] with sql:variable("@browseUrl")')
		ELSE
			SET @browseXMLReq.modify('insert (attribute browseUrl {sql:variable("@browseUrl")}) into (/browseInfo/emailInfo)[1]')
		--CREATE SHORT URL FOR EMAIL
		EXEC AppShortUrlConvertion @i_userId, @browseUrl OUTPUT, @shortUrl OUTPUT, @errorCode OUTPUT
		IF @errorCode <> 0 GOTO ERROR_EXIT
		SET @shortUrl = @webConsoleURL + @goToLink + @shortUrl
	END
	IF @isEdgeClient = 1
	BEGIN
		IF (@browseXMLReq.exist('/browseInfo/@edgeClient')) = 1
			SET @browseXMLReq.modify('replace value of (/browseInfo/@edgeClient)[1] with sql:variable("@isEdgeClient")')
		ELSE
			SET @browseXMLReq.modify('insert (attribute edgeClient {sql:variable("@isEdgeClient")}) into (/browseInfo)[1]')
	END
	IF @contentStoreType <> ''
	BEGIN
		IF (@browseXMLReq.exist('/browseInfo/@contentStoreType')) = 1
			SET @browseXMLReq.modify('replace value of (/browseInfo/@contentStoreType)[1] with sql:variable("@contentStoreType")')
		ELSE
			SET @browseXMLReq.modify('insert (attribute contentStoreType {sql:variable("@contentStoreType")}) into (/browseInfo)[1]')
	END
	--ADD SHORT URL TO BROWSEURL RESPONSE
	IF (@browseXMLReq.exist('/browseInfo/emailInfo/@browseUrl')) = 1
		SET @browseXMLReq.modify('replace value of (/browseInfo/emailInfo/@browseUrl)[1] with sql:variable("@shortUrl")')
	--IF SHARE EXIST
IF @isAlreadyShared = (2271 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	BEGIN
SET @errorCode = (2271 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
ELSE IF @isAlreadyShared = (2346 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	BEGIN
SET @errorCode = (2346 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	INSERT INTO App_SyncCloudConfig(syncWebFolderId, syncPath, clientId, subclientId, syncType, scFilterFileId,  created, flag, configOptions, parentShareId)
	VALUES(@shareId, @path, @clientId, @subclientId, @syncType, @scFilterFileID, @nowTime, @reshareFlag, @browseXMLReq , @parentShareId)
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR_EXIT
	--ADD SHARE FOLDER CREATOR
	INSERT INTO App_SharingUserInfo(shareId, sharedTo, sharedBy, userType, enabled, deleted,  permission, created, modified, isOwner, excluded)
							VALUES(@shareId, @ownerId, @ownerId, @userType, 1, 0, @permission, @nowTime, 0, 1, @excluded)
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR_EXIT
	-- SET GUI AUDIT OPERATION
SET @opMsgId = (398 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 1, 2, @opEvMsgId OUTPUT, @opId OUTPUT
	-- SET GUI AUDIT PARAMETER
	EXEC EvGuiAuditSetParamData @opId, @shareName, @dataIsEvent
SET @paramMsgId = (1082 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	-- SET GUI AUDIT PARAMETER
	EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
SET @paramMsgId = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	IF @expirationDate != ''
	BEGIN
SET @paramMsgId = (1059 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @expirationDate, @dataIsEvent
	END
	IF @isSet = 1
	BEGIN
SET @paramMsgId = (1200 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	END
	-- ADD THE USERS FOR THIS FOLDER
	SET @assocCount = @i_xmlString.value('count(//.[@userType])', 'INT')
	WHILE (@i <= @assocCount)
	BEGIN
		SET @assocXML = @i_xmlString.query('(//.[@userType])[sql:variable("@i")]')
		SET @permission = ISNULL (( SELECT ref.value('@permission', 'INT')
									FROM @assocXML.nodes ('sharedTo') R(ref)), 0)
		SET @sharedToUserStatus = ISNULL((SELECT ref.value('@userStatus', 'INT')
									FROM @assocXML.nodes ('sharedTo') R(ref)), 0)
		SET @sharedBy = ISNULL (( SELECT ref.value('@userId', 'INT')
									FROM @assocXML.nodes ('sharedTo/sharedBy') R(ref)), @i_userId)
		-- IN CASE OF RESHARE CHECK IF SHAREDTO PERMISSION IS NOT HIGHER THAN THE OWNER'S EXISTING PERMISSION
		IF @parentShareId <> 0 AND @ownerExistingPermission > 0 AND @ownerExistingPermission < @permission
		BEGIN
SET @errorCode = (2493 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
		DELETE @shareToTable
		INSERT INTO @shareToTable
		EXEC AppSharingSetUserConfig @assocXML, @i_userId, @i_localeId
		SELECT TOP 1 @sharedTo = sharedTo, @userType = userType, @shareToName = shareToName, @errorCode = errorCode, @errorString = errorString
		FROM @shareToTable
		IF @errorCode <> 0 GOTO ERROR_EXIT
		IF NOT EXISTS (SELECT 1 FROM App_SharingUserInfo WITH(NOLOCK) WHERE shareId=@shareId AND sharedTo=@sharedTo AND userType=@userType)
			INSERT INTO App_SharingUserInfo(shareId, sharedTo, sharedBy, userType, enabled, deleted,  permission, created, modified, isOwner, excluded)
				VALUES(@shareId, @sharedTo, @sharedBy, @userType, 1, 0, @permission, @nowTime, 0, 0, CASE @sharedToUserStatus WHEN 2 THEN 1 ELSE 0 END)
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR_EXIT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @shareToName, @dataIsEvent
		SET @permissionParam =
(SELECT CASE WHEN @permission = 1 THEN (1086 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @permission = 2 THEN (1085 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			END)
		SET @permissionVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @permissionParam, 0, 2)
		EXEC EvGuiAuditSetParamData @opId, @permissionVal, @dataIsEvent
		SET @reshareParam =
(SELECT CASE WHEN @canReshare = 1 THEN (1208 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @canReshare = 0 THEN (1209 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			END)
		SET @reshareVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @reshareParam, 0, 2)
		EXEC EvGuiAuditSetParamData @opId, @reshareVal, @dataIsEvent
		SET @paramMsgId =
(SELECT CASE WHEN @userType = 1 THEN (1211 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 2 THEN (1212 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 3 THEN (1213 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @userType = 4 THEN (1213 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			END)
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
NEXT:
		SET @i  = @i +1
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#InUserGroup') IS NOT NULL
		DROP TABLE #InUserGroup
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0
			ROLLBACK TRAN
	END
	ELSE
		COMMIT TRAN
	--remove password in response
	IF(@browseXMLReq.exist('//password/@password') = 1)
	BEGIN
		SET @browseXMLReq.modify('replace value of (//password/@password)[1] with ""')
	END
    SET @o_xmlString =
    (
		SELECT
			(SELECT
				(SELECT
				@shareId AS '@syncWebFolderId',
				@shareName AS '@syncWebFolderName'
				FOR XML PATH('shareFolder'), TYPE
				),
				@browseXMLReq
				FOR XML PATH ('shareInfo'), TYPE
			),
			(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
			FOR XML PATH ('resp'), TYPE
			)
		FOR XML PATH(''), ROOT('App_SharedFoldersResp')
    )
	SELECT @o_xmlString AS o_xmlString
	IF object_id('tempdb.dbo.#AppSharing_userObjects') is not null
		DROP TABLE #AppSharing_userObjects
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingCreateConfig')
	delete from GxQscripts where name = 'AppSharingCreateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingCreateConfig')
	delete from GXDBVersions where aliasname = 'AppSharingCreateConfig'
GO

insert into GXDBVersions values(2, 'AppSharingCreateConfig',  '00010016000200330000', 'AppSharingCreateConfig', '00010016000200330000')
GO

