

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingCreateBrowseRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSharingCreateBrowseRequest.sp,v $ $Id: AppSharingCreateBrowseRequest.sp,v 1.5.2.6 2018/03/27 08:08:09 jiechen Exp $";
--	+===========================================================================+
--	|  					  AppSharingCreateBrowseRequest							|
--	|          Procedure for creating browse XML request for Shared Folder		|
--	+===========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingCreateBrowseRequest <<<'

IF EXISTS (select * from sysobjects where name='AppSharingCreateBrowseRequest')
	drop procedure AppSharingCreateBrowseRequest
IF EXISTS (select * from GxQscripts where name='AppSharingCreateBrowseRequest')
	delete from GxQscripts where name = 'AppSharingCreateBrowseRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingCreateBrowseRequest')
	delete from GXDBVersions where aliasname = 'AppSharingCreateBrowseRequest'
GO
print '... Creating Procedure: AppSharingCreateBrowseRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingCreateBrowseRequest
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId INT,
  @xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @clientId			INT = 0
	DECLARE @appTypeId			INT = 0
	DECLARE @instanceId			INT = 0
	DECLARE @backupSetId		INT = 0
	DECLARE @subclientId		INT = 0
	DECLARE @path				NVARCHAR(MAX) = ''
	DECLARE @inLen				INT = 0
	--DECLARE @pathLen			INT = 0
	DECLARE @configOptions		XML
	DECLARE @isNAS				INT = 0
	-- READ THE XML
	DECLARE @shareId			INT = ISNULL (( SELECT ref.value('@sharedFolderId', 'INT')
													FROM @xmlString.nodes ('databrowse_BrowseRequest/advOptions/advConfig/sharedFolderInfo') R(ref)), 0)
	DECLARE @inPath				NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@path', 'NVARCHAR(MAX)')
													FROM @xmlString.nodes ('databrowse_BrowseRequest/paths') R(ref)), '')
	SELECT @appTypeId = APP.appTypeId, @clientId = APP.clientId, @subclientId = APP.id, @backupSetId = APP.backupSet,
	@instanceId = APP.instance, @configOptions = CC.configOptions
	FROM App_SyncCloudFolder CF WITH (NOLOCK)
	JOIN App_SyncCloudConfig CC WITH (NOLOCK) ON CC.syncWebFolderId = CF.syncWebFolderId
	JOIN APP_Application APP WITH (NOLOCK) ON APP.id = CC.subclientId
	WHERE CF.syncWebFolderId = @shareId
SET @isNAS = ISNULL((SELECT status&0x0080 FROM APP_Client (NOLOCK) WHERE id = @clientId), 0)
	SET @inLen = LEN(@inPath);
	--SET @pathLen = LEN(@path)
	--CREATE FULL PATH BY USING PARENT-CHILD HIERARCHY
	WITH cteShares (syncWebFolderId, parentShareId, syncPath)
		AS
		(
			SELECT syncWebFolderId, parentShareId, syncPath FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @shareId
			UNION ALL
			SELECT sc.syncWebFolderId, sc.parentShareId, sc.syncPath FROM App_SyncCloudConfig sc WITH(NOLOCK)
				INNER JOIN cteShares cs ON sc.syncWebFolderId = cs.parentShareId
		)
	SELECT * INTO #temp
	FROM (
			SELECT sc.syncPath, sc.syncWebFolderId, sc.created FROM App_SyncCloudConfig sc WITH(NOLOCK)
				INNER JOIN cteShares cs ON sc.syncWebFolderId = cs.syncWebFolderId
		 ) AS PC ORDER BY created --order by created time as the shareId is random
	select @path = STUFF((
							SELECT CAST(syncPath AS NVARCHAR(MAX))
							FROM #temp
							FOR XML PATH(''), TYPE).value('.[1]', 'nvarchar(max)'), 1, 0, '')
	DROP TABLE #temp
	--FOR DIRECTORY SHARE APPEND CURRENT SUB FOLDER TO PATH
	--IF @inPath != '' AND @inLen > @pathLen AND SUBSTRING(@inPath, 0, @pathLen+1) = @path
	IF (SELECT ref.value('@directory', 'INT') FROM @configOptions.nodes ('/browseInfo/paths') R(ref)) = 1
	BEGIN
		IF LEFT(@inPath, 1) = '|'	--HANDLE PATH WITH UNICODE CHARACTERS
			SET @path =  '|' + @path + SUBSTRING(@inPath, 2, @inLen)
		ELSE
			SET @path = @path + @inPath
	END
	IF (@xmlString.exist('/databrowse_BrowseRequest/entity')) <> 1
		SET @xmlString.modify('insert <entity />  into (/databrowse_BrowseRequest)[1]')
	--ADD CLIENT ID
	IF (@xmlString.exist('/databrowse_BrowseRequest/entity/@clientId')) = 1
		SET @xmlString.modify('replace value of (/databrowse_BrowseRequest/entity/@clientId)[1] with sql:variable("@clientId")')
	ELSE
		SET @xmlString.modify('insert (attribute clientId {sql:variable("@clientId")}) into (/databrowse_BrowseRequest/entity)[1]')
	--ADD APPTYPE ID
	IF (@xmlString.exist('/databrowse_BrowseRequest/entity/@applicationId')) = 1
		SET @xmlString.modify('replace value of (/databrowse_BrowseRequest/entity/@applicationId)[1] with sql:variable("@appTypeId")')
	ELSE
		SET @xmlString.modify('insert (attribute applicationId {sql:variable("@appTypeId")}) into (/databrowse_BrowseRequest/entity)[1]')
	--ADD INSTANCE ID
	IF (@xmlString.exist('/databrowse_BrowseRequest/entity/@instanceId')) = 1
		SET @xmlString.modify('replace value of (/databrowse_BrowseRequest/entity/@instanceId)[1] with sql:variable("@instanceId")')
	ELSE
		SET @xmlString.modify('insert (attribute instanceId {sql:variable("@instanceId")}) into (/databrowse_BrowseRequest/entity)[1]')
	--ADD BACKUPSET ID
	IF (@xmlString.exist('/databrowse_BrowseRequest/entity/@backupsetId')) = 1
		SET @xmlString.modify('replace value of (/databrowse_BrowseRequest/entity/@backupsetId)[1] with sql:variable("@backupSetId")')
	ELSE
		SET @xmlString.modify('insert (attribute backupsetId {sql:variable("@backupSetId")}) into (/databrowse_BrowseRequest/entity)[1]')
	--ADD SUBCLIENT ID
IF @isNAS != 0x0080
	BEGIN
		IF (@xmlString.exist('/databrowse_BrowseRequest/entity/@subclientId')) = 1
			SET @xmlString.modify('replace value of (/databrowse_BrowseRequest/entity/@subclientId)[1] with sql:variable("@subclientId")')
		ELSE
			SET @xmlString.modify('insert (attribute subclientId {sql:variable("@subclientId")}) into (/databrowse_BrowseRequest/entity)[1]')
	END
	--ADD BROWSE PATH
	IF (@xmlString.exist('/databrowse_BrowseRequest/paths')) <> 1
		SET @xmlString.modify('insert <paths />  into (/databrowse_BrowseRequest)[1]')
	IF (@xmlString.exist('/databrowse_BrowseRequest/paths/@path')) = 1
		SET @xmlString.modify('replace value of (/databrowse_BrowseRequest/paths/@path)[1] with sql:variable("@path")')
	ELSE
		SET @xmlString.modify('insert (attribute path {sql:variable("@path")}) into (/databrowse_BrowseRequest/paths)[1]')
	SELECT @xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingCreateBrowseRequest')
	delete from GxQscripts where name = 'AppSharingCreateBrowseRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingCreateBrowseRequest')
	delete from GXDBVersions where aliasname = 'AppSharingCreateBrowseRequest'
GO

insert into GXDBVersions values(2, 'AppSharingCreateBrowseRequest',  '00010005000200060000', 'AppSharingCreateBrowseRequest', '00010005000200060000')
GO

