

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSharingAddNotificatonAndAlertSubscriptionForShares.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  		AppSharingAddNotificatonAndAlertSubscriptionForShares	    |
--	|          Procedure for creating a new Shared Folder				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSharingAddNotificatonAndAlertSubscriptionForShares <<<'

IF EXISTS (select * from sysobjects where name='AppSharingAddNotificatonAndAlertSubscriptionForShares')
	drop procedure AppSharingAddNotificatonAndAlertSubscriptionForShares
IF EXISTS (select * from GxQscripts where name='AppSharingAddNotificatonAndAlertSubscriptionForShares')
	delete from GxQscripts where name = 'AppSharingAddNotificatonAndAlertSubscriptionForShares'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingAddNotificatonAndAlertSubscriptionForShares')
	delete from GXDBVersions where aliasname = 'AppSharingAddNotificatonAndAlertSubscriptionForShares'
GO
print '... Creating Procedure: AppSharingAddNotificatonAndAlertSubscriptionForShares'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSharingAddNotificatonAndAlertSubscriptionForShares
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @inLocaleId INT,
  @o_xmlString XML OUTPUT
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	-- READ THE XML
	DECLARE @errorCode		INT = 0
	DECLARE @errorString	NVARCHAR(200) = ''
DECLARE @ruleId         INT = ISNULL( (SELECT top 1 NR.id FROM NTnotificationRule NR WITH(NOLOCK) where NR.alertTypeId=72 and (NR.status&128)>0),0)
	IF OBJECT_ID('tempdb.dbo.#shareInfo') IS NOT NULL
		DROP TABLE #shareInfo
	CREATE TABLE #shareInfo (shareId INT, notificationOption INT, flagsForAlert INT, PRIMARY KEY (shareId))
    BEGIN TRY
    -- Read the XML
    INSERT INTO #shareInfo
    SELECT
            ISNULL((ref.value('@shareId', 'INT')), 0),
            ISNULL((ref.value('@notificationOption', 'INT')), 0),
            case when ISNULL((ref.value('@enableAlertNotification', 'INT')), 0)>0 then
				case when ISNULL((ref.value('@isDigestEnabledForAlert', 'INT')), 1)>0 then 3 --NT_STATUS_USER_SUBSCRIBED| NT_STATUS_DIGEST -- DIGEST BY DEFAULT
				else 1 --NT_STATUS_USER_SUBSCRIBED
				end
			else 0
			end
    FROM
    @i_xmlString.nodes('/Api_AddShareNotificationSubscriptionReq/shares') doc(ref)
	--INSERT THE RECORDS
    BEGIN TRAN
    --Add Push Notification
    MERGE App_ShareUserSubscriptionMap AS TARGET
    USING (SELECT shareId, notificationOption FROM #shareInfo) AS
                            SOURCE (shareId, notificationOption)
        ON (TARGET.shareId = SOURCE.shareId AND TARGET.userId = @i_userId)
    WHEN MATCHED THEN
        UPDATE SET flag = SOURCE.notificationOption
    WHEN NOT MATCHED BY TARGET THEN
        INSERT (shareId,userId,flag) VALUES(SOURCE.shareId, @i_userId, SOURCE.notificationOption);
    --Add Alert Notification
    MERGE NTAlertSubScriptions AS TARGET
    USING (SELECT shareId, flagsForAlert FROM #shareInfo) AS
                            SOURCE (shareId, flagsForAlert)
ON (TARGET.ntRuleId = @ruleId AND TARGET.entityType1 = 7987/*SHARE_FOLDER_ENTITY*/ AND TARGET.entityId1 = SOURCE.shareId AND TARGET.userId = @i_userId)
    WHEN MATCHED THEN
        UPDATE SET flags = SOURCE.flagsForAlert
    WHEN NOT MATCHED BY TARGET THEN
        INSERT (ntRuleId, userId, escalationLevel, flags, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5)
VALUES(@ruleId, @i_userId, 1, SOURCE.flagsForAlert, 7987/*SHARE_FOLDER_ENTITY*/, SOURCE.shareId, 0,0,0,0,0,0,0,0);
    END TRY
    BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
    END CATCH
    ERROR:
        IF @errorCode <> 0
        BEGIN
            IF XACT_STATE() <> 0
            BEGIN
                ROLLBACK TRAN
            END
            IF @errorString = ''
            BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
                SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
            END
        END
        ELSE
            COMMIT TRAN
	ERROR_EXIT:
		IF @outXml  IS NULL
			SET @o_xmlString  =
				(
					(SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
					FOR XML PATH ('Api_GenericResp'), Type)
				)
	SELECT @o_xmlString
	IF OBJECT_ID('tempdb.dbo.#shareInfo') IS NOT NULL
		DROP TABLE #shareInfo
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSharingAddNotificatonAndAlertSubscriptionForShares')
	delete from GxQscripts where name = 'AppSharingAddNotificatonAndAlertSubscriptionForShares'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSharingAddNotificatonAndAlertSubscriptionForShares')
	delete from GXDBVersions where aliasname = 'AppSharingAddNotificatonAndAlertSubscriptionForShares'
GO

insert into GXDBVersions values(2, 'AppSharingAddNotificatonAndAlertSubscriptionForShares',  '00000000000000000000', 'AppSharingAddNotificatonAndAlertSubscriptionForShares', '00000000000000000000')
GO

