

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetWebconsoleDynamicAppSupport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetWebconsoleDynamicAppSupport.sp,v $ $Id: AppSetWebconsoleDynamicAppSupport.sp,v 1.1.2.3 2020/09/30 12:16:44 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppSetWebconsoleDynamicAppSupport()
--  |
--  | Description:  SP for setting webconsoles and dynamic app support property
--  |
--  |       Input:  SetWebconsoleDynamicAppSupportList xml
--  |
--  |      Output:  GenericResponse xml
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	SP for getting all webconsoles and dynamic app support property
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetWebconsoleDynamicAppSupport')
BEGIN
	print '>>> Drop Stored Procedure: AppSetWebconsoleDynamicAppSupport <<<'
	drop procedure AppSetWebconsoleDynamicAppSupport
END
IF EXISTS (select * from GxQscripts where name='AppSetWebconsoleDynamicAppSupport')
	delete from GxQscripts where name = 'AppSetWebconsoleDynamicAppSupport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetWebconsoleDynamicAppSupport')
	delete from GXDBVersions where aliasname = 'AppSetWebconsoleDynamicAppSupport'
GO
print '... Creating Procedure: AppSetWebconsoleDynamicAppSupport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetWebconsoleDynamicAppSupport
  @i_xml XML	
AS
SET NOCOUNT ON
DECLARE @errorCode int = 0
DECLARE @errorMsg NVARCHAR(510)
DECLARE @curUtcDateTime BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @localeId INT   = 0
BEGIN TRY
	 --for holding input request
	IF OBJECT_ID('tempdb.dbo.#inputTbl') is not null
		DROP TABLE #inputTbl
	CREATE TABLE #inputTbl (clientId int, dynamicAppEnabled INT DEFAULT(0))
	DECLARE @rcnt INT = 0
	INSERT INTO #inputTbl
	SELECT  ref.value('(webconsoleClient/@clientId)[1]', 'int'),
	ref.value('@isSupported', 'int')
	FROM    @i_xml.nodes('Api_SetWebconsoleDynamicAppSupportList/webconsoles') R ( ref )
	SET @rcnt = @@ROWCOUNT
	IF @rcnt = 0
	BEGIN
		RAISERROR ('No input provided.', 16, 1 )
	END
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int')
                            FROM @i_xml.nodes('Api_SetWebconsoleDynamicAppSupportList/processinginstructioninfo/locale') R ( ref )),0)
	DECLARE @webconsolePackageWindows varchar(50)
	DECLARE @webconsolePackageUnix varchar(50)
	DECLARE @webserverClientIdParam varchar(50)
	-- webconsoles
	IF OBJECT_ID('tempdb.dbo.#webConsoleTbl') is not null
		DROP TABLE #webConsoleTbl
	CREATE TABLE #webConsoleTbl (clientId int, dynamicAppEnabled INT DEFAULT(0))
	-- webconsole package and webserverclientId attribute
    	IF OBJECT_ID('tempdb.dbo.#clientPropTbl') is not null
     	   DROP TABLE #clientPropTbl
    	CREATE TABLE #clientPropTbl (id int,componentNameId int, attrName nvarchar(2048), attrVal nvarchar(2048))
	    -- available webservers
    	IF OBJECT_ID('tempdb.dbo.#webserverTbl') is not null
    	    DROP TABLE #webserverTbl
   	 CREATE TABLE #webserverTbl (clientId int PRIMARY KEY)
	 SET @webconsolePackageWindows = 'PackageStateForId 726'
	 SET @webconsolePackageUnix = 'PackageStateForId 1135'
     SET @webserverClientIdParam = 'WebServerClientId'
	-- Get webservers
    INSERT INTO #webserverTbl(clientId)
    SELECT cl.id
    FROM APP_Client AS CL WITH(NOLOCK)
        INNER JOIN SimInstalledpackages SIM WITH(NOLOCK) ON SIM.ClientId = CL.id AND sim.simPackageID IN (252,1174)
    --Get client props
    INSERT INTO #clientPropTbl(id ,componentNameId , attrName , attrVal )
    SELECT
    (CASE
        WHEN attrName=@webserverClientIdParam THEN 1
        WHEN attrName=@webconsolePackageWindows OR attrName = @webconsolePackageUnix THEN 2
    END) as id,
    componentNameId, attrName, attrval
    FROM APP_ClientProp WITH(NOLOCK) WHERE attrName in (@webserverClientIdParam, @webconsolePackageWindows,@webconsolePackageUnix)
	AND modified = 0
	-- #1 webconsole should have attrName 'WebServerClientId' with attrVal as WebserverID
    -- #2 webconsole should have attrName 'PackageStateForId 726' with attrVal=1
    INSERT INTO #webConsoleTbl(clientId)
    SELECT distinct cpTbl2.componentNameId
        FROM #clientPropTbl cpTbl1
        INNER JOIN #webserverTbl wsTbl ON cpTbl1.attrVal = CAST(wsTbl.clientId AS NVARCHAR(12))
        INNER JOIN #clientPropTbl cpTbl2 ON cpTbl2.componentNameId = cpTbl1.componentNameId
        WHERE cpTbl1.id = 1 --@webserverClientId
        AND cpTbl2.id = 2 /**@webServerAttribute**/ AND cpTbl2.attrVal = N'1'
		UPDATE WC SET dynamicAppEnabled = 1
		FROM #webConsoleTbl WC
		INNER JOIN APP_ClientProp CP
		ON WC.clientId = CP.componentNameId AND
		CP.attrName = N'Side by Side Loading of Multiple SP Instance Enabled' AND CP.attrVal = N'1'  AND CP.modified = 0
		WHERE WC.clientId iS NOT NULL
	-- get default webconsole
	DECLARE @webConsoleURL NVARCHAR(MAX) = ''
	DECLARE @defaultWebconsoleHostname nvarchar(510);
	DECLARE @defaultWebconsoleClientId INT
	SELECT @webConsoleURL = value FROM GXGlobalParam(nolock) WHERE name = N'WebConsoleURL' AND modified = 0
	IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''
	BEGIN
		SET @defaultWebconsoleHostname = DBO.GetHostnameFromUrl(@webConsoleURL)
		SELECT @defaultWebconsoleClientId = id
		FROM
		APP_Client CL (NOLOCK)
		INNER JOIN #webConsoleTbl WC ON CL.ID = WC.clientId
		WHERE (CL.net_hostname = @defaultWebconsoleHostname OR CL.name = @defaultWebconsoleHostname)
	END
	--
--
	IF EXISTS (SELECT 1 FROM #inputTbl I LEFT OUTER JOIN #webConsoleTbl WC ON I.ClientId = WC.ClientId WHERE WC.ClientId IS NULL)
	BEGIN
		RAISERROR ('Invalid webconsoles provided.', 16, 1 )
	END
	--Cannot disable the primary webconsole.
	IF EXISTS(SELECT 1 FROM #inputTbl WHERE clientId = @defaultWebconsoleClientId AND dynamicAppEnabled = 0)
	BEGIN
		SET @errorCode = 1001
SET @errorMsg = (SELECT message FROM EvLocaleMsgs(NOLOCK) WHERE messageId=(4655 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
	        SET @errorMsg = REPLACE(@errorMsg, '^1%s',  @defaultWebconsoleHostname)
		IF @errorMsg='' --fallback
		BEGIN
			SET @errorMsg = @defaultWebconsoleHostname + ' is a primary webconsole on the MasterCommcell and cannot be disabled.'
		END
	END
	ELSE
	BEGIN
		-- update the prop in client prop
		MERGE App_ClientProp t USING #inputTbl s
		ON (t.componentNameId = s.clientId AND t.attrName = N'Side by Side Loading of Multiple SP Instance Enabled'  AND t.modified=0 )
		WHEN MATCHED AND attrVal <>  CAST(s.dynamicAppEnabled AS NVARCHAR(10)) THEN
			UPDATE SET attrVal =  CAST(s.dynamicAppEnabled AS NVARCHAR(10))
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
			Values( s.clientId, N'Side by Side Loading of Multiple SP Instance Enabled', 1,  CAST(s.dynamicAppEnabled AS NVARCHAR(10)), @curUtcDateTime, 0, 0);
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
 SELECT  @errorCode as '@errorCode',
         @errorMsg as  '@errorMessage'
    FOR  XML PATH('Api_GenericResp'),TYPE
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetWebconsoleDynamicAppSupport')
	delete from GxQscripts where name = 'AppSetWebconsoleDynamicAppSupport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetWebconsoleDynamicAppSupport')
	delete from GXDBVersions where aliasname = 'AppSetWebconsoleDynamicAppSupport'
GO

insert into GXDBVersions values(2, 'AppSetWebconsoleDynamicAppSupport',  '00010001000200030000', 'AppSetWebconsoleDynamicAppSupport', '00010001000200030000')
GO

