

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetVmCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetVmCount.sp,v $ $Id: AppSetVmCount.sp
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetVmCount')
BEGIN
	print '>>> Drop Stored Procedure: AppSetVmCount <<<'
	drop procedure AppSetVmCount
END
IF EXISTS (select * from GxQscripts where name='AppSetVmCount')
	delete from GxQscripts where name = 'AppSetVmCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetVmCount')
	delete from GXDBVersions where aliasname = 'AppSetVmCount'
GO
print '... Creating Procedure: AppSetVmCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetVmCount
-- Input arguments
  @i_clientId INT,
  @i_competitiveProtectedVMCount BIGINT
AS
  DECLARE @o_errorCode INT
SET NOCOUNT ON
DECLARE @vmContentStr VARCHAR(MAX)
DECLARE @vmContent XML
DECLARE @nowUtcTime DATETIME = GETUTCDATE()
DECLARE @nowTime   int = dbo.GetUnixTime (@nowUtcTime)
SET @vmContentStr = (SELECT TOP 1 attrVal FROM APP_ExtendedProperties WITH(NOLOCK) WHERE attrName = 'Virtual Server Content' AND clientId = @i_clientId)
SET @vmContent = @vmContentStr
DECLARE @vmCount BIGINT = (SELECT COUNT(*) FROM
(
SELECT ref.value('@guid', 'nvarchar(max)') AS vmGUID, ref.value('@name', 'nvarchar(max)') AS vmName
FROM   @vmContent.nodes('EVGui_ManualDiscoverResp/guestHosts2') R ( ref )
UNION
SELECT C.attrVal AS vmGUID, CL.displayName AS vmName
	FROM APP_VMProp Vp WITH (NOLOCK)
INNER JOIN APP_Application APP WITH (NOLOCK)
	ON  APP.clientId = @i_clientId
inner join JMBkpStats JM WITH (NOLOCK)
	on JM.appId = APP.id AND JM.status in (1,3,14,16) AND VP.jobId=JM.jobId
INNER JOIN APP_ClientProp C WITH (NOLOCK)
	ON Vp.VMclientId = C.componentNameId AND C.attrName = 'Virtual Machine Instance UUID'  AND C.modified =0
INNER JOIN APP_Client CL WITH (NOLOCK)
	ON CL.id = C.componentNameId
where Vp.attrName = 'vmstatus' and Vp.attrVal in ('0', '3')
	group by C.attrVal, CL.displayName
) T
)
IF EXISTS (SELECT componentNameId FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'vmTotalCount')
	UPDATE APP_ClientProp SET attrVal = @vmCount WHERE componentNameId = @i_clientId AND attrName = 'vmTotalCount'
ELSE
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES(@i_clientId, 'vmTotalCount', 7, @vmCount, @nowTime, 0, 0)
--We need to maintain PIT history of 10 records for this property for every 7 days
DECLARE @lastModifiedTime int = 0
DECLARE @lastModifiedUtcTime DATETIME
DECLARE @diffDays int = 0
select top 1 @lastModifiedTime=created from APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'competitiveProtectedVMCount' order by created desc
IF @lastModifiedTime > 0
BEGIN
	SET  @lastModifiedUtcTime = dateadd(S, @lastModifiedTime, '1970-01-01')
	SET @diffDays= datediff(d,@nowUtcTime,@lastModifiedUtcTime)
	IF @diffDays > 7
	BEGIN
		--Age the current property
		UPDATE APP_ClientProp SET modified=@nowTime WHERE componentNameId = @i_clientId AND attrName = 'CompetitiveProtectedVMCount' and modified=0
		--insert new entry
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		VALUES(@i_clientId, 'CompetitiveProtectedVMCount', 7, @i_competitiveProtectedVMCount, @nowTime, 0, 0);
		--Retain only top 10 records, delete the remaining records
		with ACP as
		(
			select ROW_NUMBER() over(order by created desc) as rank, * from app_clientprop where attrname ='competitiveProtectedVMCount'
		)
		delete from ACP where ACP.rank > 10;
	END
END
ELSE
BEGIN
		--insert property for the first time
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		VALUES(@i_clientId, 'competitiveProtectedVMCount', 7, @i_competitiveProtectedVMCount, @nowTime, 0, 0)
END
SET @o_errorCode = @@ERROR
SELECT @o_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetVmCount')
	delete from GxQscripts where name = 'AppSetVmCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetVmCount')
	delete from GXDBVersions where aliasname = 'AppSetVmCount'
GO

insert into GXDBVersions values(2, 'AppSetVmCount',  '00000000000000000000', 'AppSetVmCount', '00000000000000000000')
GO

