

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetVSASubclientForClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +====================================================================================================================================+
--  |   Procedure: AppSetVSASubclientForClients
--  |
--  |	Description: Configures VSA Discover Subclient Id as given subclient ID for all clients in the input XML. Will remove the property
--  |				 for other clients with same subclient ID.
--  |
--	|	Authors: jswaminathan
--	|
--  +====================================================================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetVSASubclientForClients')
BEGIN
	print '>>> Drop Stored Procedure: AppSetVSASubclientForClients <<<'
	drop procedure AppSetVSASubclientForClients
END
IF EXISTS (select * from GxQscripts where name='AppSetVSASubclientForClients')
	delete from GxQscripts where name = 'AppSetVSASubclientForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetVSASubclientForClients')
	delete from GXDBVersions where aliasname = 'AppSetVSASubclientForClients'
GO
print '... Creating Procedure: AppSetVSASubclientForClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetVSASubclientForClients
  @inputXML XML OUTPUT
AS
SET NOCOUNT ON
--Stored procedure to configure discovered virtual machine client properties with given VSA subclient Id
--Sample XML
/*SET @inputXML = '<App_SetVSASubclientForClients>
	<subclient _type_="7" subclientId="21" subclientName="VSATest" backupsetId="45" backupsetName="VSABackupset" instanceId="12" instanceName="VSADiscovery" applicationId="106" appName="Virtual Server" clientId="3" clientName="VSADiscover"/>
	<clients _type_="3" clientId="4" clientName="Test1"/>
	<clients _type_="3" clientId="5" clientName="Test2"/>
	<clients _type_="3" clientId="6" clientName="Test3"/>
	<clients _type_="3" clientId="7" clientName="Test4"/>
</App_SetVSASubclientForClients>'*/
DECLARE @clientId INT
DECLARE @appTypeId INT
DECLARE @instanceId INT
DECLARE @backupsetId INT
DECLARE @subclientID INT
DECLARE @replaceAllClients INT =
ISNULL((SELECT  ref.value('@replaceAllClients', 'INT')
                              FROM     @inputXML.nodes('App_SetVSASubclientForClients') R ( ref )),1)
SELECT
	@clientId = ISNULL(ref.value('@clientId', 'INT'), 0),
	@appTypeID = ISNULL(ref.value('@applicationId', 'INT'), 0),
	@instanceID = ISNULL(ref.value('@instanceId', 'INT'), 0),
	@backupsetID = ISNULL(ref.value('@backupsetId', 'INT'), 0),
	@subclientId = ISNULL(ref.value('@subclientId', 'INT'), 0)
FROM @inputXML.nodes('App_SetVSASubclientForClients/subclient') R (ref)
IF @clientID = 0					--Client code sends only subclientId, Get remaining from it.
BEGIN
	SELECT
		@clientID = clientID,
		@appTypeID = appTypeId,
		@instanceId = instance,
		@backupsetId = backupSet,
		@subclientID = id
	FROM APP_Application (NOLOCK)
	WHERE id = @subclientID
END
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N''
BEGIN TRY
	--we should Overwrite the existing client list with the new list based on the below flag,
	DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
	if ( @replaceAllClients =1)
	BEGIN
		DECLARE @indexingV2Client int =0
		select @indexingV2Client = 1 from app_clientprop where componentNameId = @clientID and attrname ='IndexingV2_VSA' and attrval ='1' and modified =0
		--DeConfigure associated VM backupsets for VMs which are stopped getting backedup
		if ( @indexingV2Client =1)
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#ConfigureOrDeConfigureVMBackupsets_vmClientIdList') IS NOT NULL
				DROP TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
			CREATE TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList (
				 vmClientId INT,
				 vmBackupSetId INT,
				 PRIMARY KEY (vmClientId, vmBackupSetId)
			)
			INSERT INTO #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
				SELECT componentNameId,0 from APP_ClientProp
				WHERE attrName = N'VSA Discover Subclient ID'/*VSA_DISCOVER_CLIENT_PROP_SQL*/ AND attrVal = CAST(@subclientId AS NVARCHAR(10)) AND modified = 0	and componentNameId not in
				(SELECT ref.value('@clientId', 'int') FROM @inputXML.nodes('App_SetVSASubclientForClients/clients') R (ref))
			--Remove from the list if actively getting backedup from another subclient of same backupset
			delete from #ConfigureOrDeConfigureVMBackupsets_vmClientIdList where vmClientId in(select clProp.componentNameId from APP_ClientProp clProp
			WHERE clProp.attrName = N'VSA Discover Subclient ID'/*VSA_DISCOVER_CLIENT_PROP_SQL*/ AND clProp.modified = 0 AND clProp.attrVal <> CAST(@subclientId AS NVARCHAR(10))
			AND (select Appl.backupset from APP_Application Appl where CAST(Appl.id as nvarchar(12)) = clProp.attrVal) = @backupsetId )
			Update vmList set vmBackupSetId = vmb.ChildBackupSetId from  #ConfigureOrDeConfigureVMBackupsets_vmClientIdList vmList
				INNER JOIN APP_VMBackupSet vmb ON vmb.VMClientId = vmList.vmClientId AND vmb.ParentBackupSetId = @backupsetId
			--If VM backupset is manually deleted
			delete from #ConfigureOrDeConfigureVMBackupsets_vmClientIdList where vmBackupSetId=0
			IF EXISTS (SELECT 1 from #ConfigureOrDeConfigureVMBackupsets_vmClientIdList)
			BEGIN
				EXEC ConfigureOrDeConfigureVMBackupsets -1
			END
		END
		DELETE FROM APP_ClientProp
		WHERE
			attrName = N'VSA Discover Subclient ID'	-- VSA_DISCOVER_CLIENT_PROP_SQL
			AND attrVal = CAST(@subclientId AS NVARCHAR(10))
			AND modified = 0			--use macro
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT
			ref.value('@clientId', 'int') AS componentNameId,
			N'VSA Discover Subclient ID',		-- VSA_DISCOVER_CLIENT_PROP_SQL
7,
			CAST(@subclientId AS NVARCHAR(10)),
			@currentTime,
			0		--use macro
		FROM @inputXML.nodes('App_SetVSASubclientForClients/clients') R (ref)
	END
	ELSE
	BEGIN
		MERGE APP_ClientProp AS T1
		USING (SELECT ref.value('@clientId', 'int') clientId FROM @inputXML.nodes('App_SetVSASubclientForClients/clients') R (ref)) T2
		ON T1.componentNameId =T2.clientId AND T1.attrName = N'VSA Discover Subclient ID'/*VSA_DISCOVER_CLIENT_PROP_SQL*/ AND T1.attrVal = CAST(@subclientId AS NVARCHAR(10)) AND T1.modified = 0
		WHEN NOT MATCHED THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES(T2.clientId,N'VSA Discover Subclient ID',7,CAST(@subclientId AS NVARCHAR(10)), @currentTime,0);
	END
	--Update all smart client groups that has rule set Clients discovered using VSA Subclient and value as this subclient or its parent
	IF OBJECT_ID ('tempdb.dbo.#smartClientGroupsRefresh') IS NOT NULL
		DROP TABLE #smartClientGroupsRefresh
	CREATE TABLE #smartClientGroupsRefresh (
		clientGroupId		INT,
		--ruleXML				XML,
		--valXML				XML,
		clientId			INT,
		appTypeId			INT,
		instanceId			INT,
		backupsetId			INT,
		subclientId			INT,
		refreshIt			TINYINT DEFAULT 0
	)
	CREATE CLUSTERED INDEX smartClientGroupsRefresh_idx ON #smartClientGroupsRefresh(refreshIt, clientGroupId)
	INSERT INTO #smartClientGroupsRefresh (
		clientGroupId,
		--ruleXML,
		--valXML,
		clientId,
		appTypeId,
		instanceId,
		backupsetId,
		subclientId
	)
		SELECT
			q.scgId,
			--q.ruleXML,
			--q.valXML,
			ISNULL(app.value('@clientId', 'INT'), 0) AS clientId,
			ISNULL(app.value('@applicationId', 'INT'), 0) AS appTypeId,
			ISNULL(app.value('@instanceId', 'INT'), 0) AS instanceId,
			ISNULL(app.value('@backupsetId', 'INT'), 0) AS backupsetId,
			ISNULL(app.value('@subclientId', 'INT'), 0) AS subclientId
		FROM (
				SELECT
					sr.scgId,
					--sr.ruleXML,
					CAST(r.value('@value', 'VARCHAR(MAX)') AS XML) AS valXML
				FROM APP_ScgRule sr (NOLOCK)
					CROSS APPLY ruleXML.nodes('(//.[@propID])') x(r)
				WHERE
					sr.ruleQuery LIKE '%scgV2VSADiscoveredClients%'
					AND r.value('@propID', 'INT') = 40		-- SCG_PKID_VSA_DISCOVER_CLIENT
			) q
			CROSS APPLY q.valXML.nodes('App_Associations/entity') a(app)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt > 0)
	BEGIN
		UPDATE t
			SET refreshIt = 1
		FROM #smartClientGroupsRefresh t
		WHERE
			t.clientId = @clientID
			AND (
				t.appTypeID = 0
				OR t.appTypeID = @appTypeId
			)
			AND (
				t.instanceId = 0
				OR t.instanceId = @instanceId
			)
			AND (
				t.backupsetID = 0
				OR t.backupsetId = @backupsetID
			)
			AND (
				t.subclientID = 0
				OR t.subclientID = @subclientID
			)
		SET @rcnt = @@ROWCOUNT
		IF (@rcnt > 0)
		BEGIN
			INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
				SELECT DISTINCT
					2 clientId,			-- CSId
					-1 remoteClient,
					58 workToken,		-- WORK_TOKEN_SCG_REFRESH_GROUP
					t.clientGroupId workTokenParams,
					@currentTime createTime,
					0 lastUpdateTime,
					0 retryCount,
					0 flag
				FROM #smartClientGroupsRefresh t
				WHERE
					t.refreshIt = 1
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
END CATCH
SET @inputXML = (
SELECT @errorCode AS '@errorCode',
	   @errorString AS '@errorMessage'
FOR XML PATH ('App_GenericResp'))
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetVSASubclientForClients')
	delete from GxQscripts where name = 'AppSetVSASubclientForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetVSASubclientForClients')
	delete from GXDBVersions where aliasname = 'AppSetVSASubclientForClients'
GO

insert into GXDBVersions values(2, 'AppSetVSASubclientForClients',  '00000000000000000000', 'AppSetVSASubclientForClients', '00000000000000000000')
GO

