

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetVMDeletionStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetVMDeletionStatus')
BEGIN
	print '>>> Drop Stored Procedure: AppSetVMDeletionStatus <<<'
	drop procedure AppSetVMDeletionStatus
END
IF EXISTS (select * from GxQscripts where name='AppSetVMDeletionStatus')
	delete from GxQscripts where name = 'AppSetVMDeletionStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetVMDeletionStatus')
	delete from GXDBVersions where aliasname = 'AppSetVMDeletionStatus'
GO
print '... Creating Procedure: AppSetVMDeletionStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetVMDeletionStatus
  @instanceId int,
  @input xml
AS
  DECLARE @retVal INT
SET NOCOUNT ON
BEGIN
SET @retVal = 0
DECLARE @unixTime int
SET @unixTime = dbo.GetUnixTime(GetUTCDate())
IF object_id('tempdb.dbo.#tmpVMList') IS NOT null DROP TABLE #tmpVMList
CREATE TABLE #tmpVMList(
				id						int IDENTITY(1,1) NOT NULL,
				instanceUUID			nvarchar(255),
                componentNameId			int
)
INSERT INTO #tmpVMList (instanceUUID, componentNameId)
SELECT distinct case when left(T.vm.value('@guid', 'nvarchar(255)'),1) ='\'
            then STUFF(T.vm.value('@guid', 'nvarchar(255)'),1,1,'')
	    else T.vm.value('@guid', 'nvarchar(255)')
       end ,0
FROM @input.nodes('/EVGui_ManualDiscoverResp/guestHosts2') T(vm)
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
DECLARE @count int
SELECT @count = count(*) FROM #tmpVMList
IF @count =0 GOTO ERR_RETURN
IF EXISTS (SELECT attrVal FROM APP_InstanceProp WHERE attrName='Use VM Instance GUID' and componentNameId = @instanceId and attrVal ='1' AND modified=0)
BEGIN
UPDATE #tmpVMList
set componentNameId = cp.componentNameId
FROM APP_ClientProp cp
JOIN #tmpVMList on
cp.attrVal = #tmpVMList.instanceUUID
and cp.attrName = 'Virtual Machine Instance UUID' AND cp.modified =0
END
ELSE
BEGIN
UPDATE #tmpVMList
set componentNameId = cp.componentNameId
FROM APP_ClientProp cp
JOIN #tmpVMList on
cp.attrVal = #tmpVMList.instanceUUID
and cp.attrName = 'Virtual Machine GUID'
END
delete from #tmpVMList where componentNameId =0
-- Reset deletion time for all VMs that are discovered again
UPDATE APP_ClientProp
SET attrVal =0
FROM #tmpVMList
JOIN APP_ClientProp cp
on cp.attrName = 'Virtual Machine Deletion Time'
and cp.componentNameId = #tmpVMList.componentNameId
and cp.attrVal <>0
-- upsert heartbeat time
MERGE  App_ClientProp as Dest
USING (select * from #tmpVMList ) as Src
on  Dest.componentNameId = Src.componentNameId
	AND Dest.attrName = 'Virtual Machine Heartbeat Time'
	AND Dest.modified = 0
WHEN MATCHED
   THEN UPDATE SET attrVal = @unixTime
WHEN NOT MATCHED THEN
INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
Values( Src.componentNameId, 'Virtual Machine Heartbeat Time', 2, @unixTime, @unixTime, 0, 0);
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
MERGE  App_ClientProp as Dest
USING (select * from #tmpVMList ) as Src
on  Dest.componentNameId = Src.componentNameId
	AND Dest.attrName = 'Virtual Machine Instance ID'
	AND Dest.modified = 0
WHEN MATCHED
   THEN UPDATE SET attrVal = @instanceId
WHEN NOT MATCHED THEN
INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
Values( Src.componentNameId, 'Virtual Machine Instance ID', 2, @instanceId, @unixTime, 0, 0);
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
IF object_id('tempdb.dbo.#deletedVMList') IS NOT null DROP TABLE #deletedVMList
CREATE TABLE #deletedVMList(
    componentNameId			int,
)
INSERT INTO #deletedVMList
select componentNameId
FROM APP_ClientProp cp
where CP.attrName ='Virtual Machine Instance ID'
and cp.attrVal = @instanceId
AND cp.modified = 0
EXCEPT
select componentNameId from #tmpVMList
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
-- update deletion time to current time if vm is not found
-- with the given instance id
-- if deletion time doesn't exist then insert it if vm is not found
-- with the given instance id
MERGE  App_ClientProp as Dest
USING (select * from #deletedVMList ) as Src
on  Dest.componentNameId = Src.componentNameId
	AND Dest.attrName = 'Virtual Machine Deletion Time'
	AND Dest.modified = 0
WHEN MATCHED AND Dest.attrVal = '0'
   THEN UPDATE SET attrVal = @unixTime
WHEN NOT MATCHED THEN
INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
Values( Src.componentNameId, 'Virtual Machine Deletion Time', 2, @unixTime, @unixTime, 0, 0);
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
ERR_RETURN:
IF object_id('tempdb.dbo.#tmpVMList') IS NOT null DROP TABLE #tmpVMList
IF object_id('tempdb.dbo.#deletedVMList') IS NOT null DROP TABLE #deletedVMList
SELECT	@retVal
END
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'AppSetVMDeletionStatus')
	delete from GxQscripts where name = 'AppSetVMDeletionStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetVMDeletionStatus')
	delete from GXDBVersions where aliasname = 'AppSetVMDeletionStatus'
GO

insert into GXDBVersions values(2, 'AppSetVMDeletionStatus',  '00000000000000000000', 'AppSetVMDeletionStatus', '00000000000000000000')
GO

