

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetUserCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: Ashish Gupta
--  Date:   16/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetUserCredentials.sp,v $ $Id: AppSetUserCredentials.sp,v 1.2.72.3 2020/07/30 15:29:14 abhinawkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetUserCredentials')
BEGIN
	print '>>> Drop Stored Procedure: AppSetUserCredentials <<<'
	drop procedure AppSetUserCredentials
END
IF EXISTS (select * from GxQscripts where name='AppSetUserCredentials')
	delete from GxQscripts where name = 'AppSetUserCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetUserCredentials')
	delete from GXDBVersions where aliasname = 'AppSetUserCredentials'
GO
print '... Creating Procedure: AppSetUserCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetUserCredentials
  @i_userId INT,
  @i_clientId INT,
  @i_userName NVARCHAR(1024),
  @i_currentPassword NVARCHAR(1024),
  @i_newPassword NVARCHAR(1024),
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @o_ErrorCode        integer = 0
DECLARE @o_ErrorString      NVARCHAR(MAX) = N'Success'
DECLARE @appType        integer = 0
DECLARE @instance       integer = 0
DECLARE @retVal			integer = 0
DECLARE @oldPassword    NVARCHAR(1024)
IF @i_userId = 0 OR NOT EXISTS (SELECT id FROM UMUsers WITH(NOLOCK) WHERE id = @i_userId)
BEGIN
    SET @o_ErrorCode = 101
    SET @o_ErrorString = N'Invalid userId passed.'
    GOTO EXIT_ERROR
END
IF @i_clientId = 0 OR NOT EXISTS (SELECT id FROM APP_Client WITH(NOLOCK) WHERE id = @i_clientId)
BEGIN
    SET @o_ErrorCode = 102
    SET @o_ErrorString = N'Invalid clientId passed.'
    GOTO EXIT_ERROR
END
IF LEN(@i_userName) = 0
BEGIN
    SET @o_ErrorCode = 103
    SET @o_ErrorString = N'Invalid user name passed.'
    GOTO EXIT_ERROR
END
IF(1 <>(SELECT COUNT(DISTINCT appTypeId) FROM APP_Application WITH(NOLOCK) WHERE clientId = @i_clientId)) OR
  (1 <>(SELECT COUNT(DISTINCT instance) FROM APP_Application WITH(NOLOCK) WHERE clientId = @i_clientId))
BEGIN
    SET @o_ErrorCode = 104
    SET @o_ErrorString = N'AppType or Instance is not unique for the specified client.'
    GOTO EXIT_ERROR
END
SET @appType =  (SELECT TOP 1 appTypeId FROM APP_Application WITH(NOLOCK) WHERE clientId = @i_clientId)
SET @instance = (SELECT TOP 1 instance FROM APP_Application WITH(NOLOCK) WHERE clientId = @i_clientId)
-- Virtual Server
IF @appType = 106
BEGIN
	-- Validate user permissions
	IF object_id('tempdb.dbo.#tSecurityObjects') is not null DROP TABLE #tSecurityObjects
create table  #tSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#tSecurityObjects'
	IF NOT EXISTS( SELECT capabilities FROM #tSecurityObjects sec
WHERE sec.capabilities & 2 = 2 AND
((sec.clientId = @i_clientId AND sec.appTypeId IN (0, 106) AND sec.instanceId = 0 AND sec.backupsetId = 0 AND sec.subClientId = 0) OR
						  sec.clientGroupId IN (SELECT ass.clientGroupId FROM APP_ClientGroupAssoc ass WITH(NOLOCK) where ass.clientId = @i_clientId) OR
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	BEGIN
		SET @o_ErrorCode = 105
		SET @o_ErrorString = N'User does not have required rights for this operation.'
		GOTO EXIT_ERROR
	END
	-- validate old password
	SET @oldPassword = (SELECT dbo.pswConvertV5ToV3(attrVal) FROM APP_InstanceProp WHERE attrName = 'Virtual Server Password' AND componentNameId = @instance)
    EXEC isValidUserManaged @oldPassword, @i_currentPassword, @retVal OUTPUT, @o_ErrorString OUTPUT
    IF(@retVal = 0)
    BEGIN
		SET @o_ErrorCode = 106
		SET @o_ErrorString += N'. Invalid current password specified.'
		GOTO EXIT_ERROR
    END
	--update password
	UPDATE App_InstanceProp
		SET attrVal = @i_newPassword
		WHERE attrName = 'Virtual Server Password' AND componentNameId = @instance
	-- update name
	UPDATE App_InstanceProp
		SET attrVal = @i_userName
		WHERE attrName = 'Virtual Server User' AND componentNameId = @instance
END
ELSE
BEGIN
    SET @o_ErrorCode = 107
    SET @o_ErrorString = N'Unsupported AppType for the specified client.'
    GOTO EXIT_ERROR
END
EXIT_ERROR:
SET @o_xmlText = (  SELECT  1                   as TAG,
							0                       as Parent,
							@o_errorCode            as [CVGui_GenericResp!1!errorCode],
							@o_errorString          as [CVGui_GenericResp!1!errorMessage]
					FOR XML EXPLICIT)
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetUserCredentials')
	delete from GxQscripts where name = 'AppSetUserCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetUserCredentials')
	delete from GXDBVersions where aliasname = 'AppSetUserCredentials'
GO

insert into GXDBVersions values(2, 'AppSetUserCredentials',  '00010002007200030000', 'AppSetUserCredentials', '00010002007200030000')
GO

