

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetTranslations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetTranslations.sp,v $ $Id: AppSetTranslations.sp,v 1.3.2.9 2020/06/06 02:57:29 csunderland Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetTranslations')
BEGIN
	print '>>> Drop Stored Procedure: AppSetTranslations <<<'
	drop procedure AppSetTranslations
END
IF EXISTS (select * from GxQscripts where name='AppSetTranslations')
	delete from GxQscripts where name = 'AppSetTranslations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTranslations')
	delete from GXDBVersions where aliasname = 'AppSetTranslations'
GO
print '... Creating Procedure: AppSetTranslations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetTranslations
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_entityType INT,
  @i_entityId INT,
  @i_flag INT,
  @o_ErrorCode INT OUTPUT,
  @o_ErrorString NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	SET @o_ErrorCode = 0
	SET @o_ErrorString = ''
	-- Changes to attempt to fix deadlock with itself by simplifying previous operations from (DELETE, INSERT, and DELETE) to (INSERT and DELETE)
	-- If this does not work may have to put a lock in place.
	DECLARE @deleteDefaultIds TABLE (
		id		INT PRIMARY KEY
	)
	INSERT INTO @deleteDefaultIds (id)
		SELECT
			id
		FROM APP_Translations WITH(NOLOCK)
		WHERE
			entityType = @i_entityType
			AND entityId = @i_entityId
			AND flags = @i_flag
			AND locale = N'default'
	IF OBJECT_ID('TempDb..#translations') IS NOT NULL
		DROP TABLE #translations
	CREATE TABLE #translations (
		entityType INT,
		entityId INT,
		locale nvarchar(100),
		localeKey nvarchar(256),
		localeValue nvarchar(MAX),
		flags integer
	)
	INSERT INTO #translations(entityId, entityType, flags, locale, localeKey, localeValue)
		SELECT 	@i_entityId,
				@i_entityType,
				@i_flag,
				ref.value('(locale/text())[1]', 'NVARCHAR(100)'),
				ref.value('(localeKey/text())[1]', 'NVARCHAR(MAX)') ,
				ref.value('(localeValue/text())[1]', 'NVARCHAR(MAX)')
		FROM  @i_xmlText.nodes ('list/Translations') R(ref)
	-- AEB: Are these comments appliable any longer?
	-- Only insert translations that do not exist already in APP_Translations.
	-- We do not want to update or remove any. Reason: The existing rows most likely come from the language pack
	-- and it will have newer translations than what the report XML has embedded into it.
	-- The proper way to update translations is by applying the language pack.
	INSERT INTO APP_Translations(entityId, entityType, flags, locale, localeKey, localeValue)
		SELECT
			TT.entityId,
			TT.entityType,
			TT.flags,
			TT.locale,
			TT.localeKey,
			TT.localeValue
		FROM #translations TT
			LEFT OUTER JOIN APP_Translations AT WITH(NOLOCK) ON
				AT.entityId = TT.entityId
				AND TT.entityType = AT.entityType
				AND AT.flags = @i_flag
				AND AT.locale = TT.locale
				AND AT.localeKey COLLATE SQL_Latin1_General_CP1_CS_AS = TT.localeKey COLLATE SQL_Latin1_General_CP1_CS_AS
				AND AT.id NOT IN (SELECT id FROM @deleteDefaultIds)
		WHERE
			AT.id IS NULL
	--Deletes all rows with localekeys that are not present for locale 'default'
	DECLARE @deleteLocaleKeyIds TABLE (
		id		INT PRIMARY KEY
	)
	INSERT INTO @deleteLocaleKeyIds (id)
		SELECT
			T.id
		FROM APP_Translations T WITH(NOLOCK)
		WHERE T.localekey COLLATE SQL_Latin1_General_CP1_CS_AS NOT IN (
				SELECT
					T2.localeKey COLLATE SQL_Latin1_General_CP1_CS_AS
				FROM APP_Translations T2 WITH(NOLOCK)
					LEFT OUTER JOIN @deleteDefaultIds d ON
						d.id = t2.id
				WHERE
					t2.locale = N'default'
					AND t2.entityType = @i_entityType
					AND t2.entityId = @i_entityId
					AND t2.flags = @i_flag
					AND d.id IS NULL
			)
			AND T.entityType = @i_entityType
			AND T.entityId = @i_entityId
			AND T.flags = @i_flag
			--AND T.id NOT IN (SELECT id FROM @deleteDefaultIds)	-- so what I add the already deleted rows again
	-- Now delete all rows that have been identified to be deleted
	DELETE T
	FROM APP_Translations T
	WHERE
		T.id IN (
			SELECT id FROM @deleteDefaultIds
			UNION ALL
			SELECT id FROM @deleteLocaleKeyIds
		)
	SELECT @o_ErrorCode AS o_ErrorCode, @o_ErrorString AS o_ErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetTranslations')
	delete from GxQscripts where name = 'AppSetTranslations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTranslations')
	delete from GXDBVersions where aliasname = 'AppSetTranslations'
GO

insert into GXDBVersions values(2, 'AppSetTranslations',  '00010003000200090000', 'AppSetTranslations', '00010003000200090000')
GO

