

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetThirdPartyAppInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetThirdPartyAppInfo.sp,v $ $Id: AppSetThirdPartyAppInfo.sp,v 1.7.2.44 2020/12/29 19:16:23 njudge Exp $";
-- ===========================================================
-- Author:		Rohit Iyer
-- Create date: 05/01/2014
-- Description:	Set the properties for 3rd party application
-- ===========================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetThirdPartyAppInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppSetThirdPartyAppInfo <<<'
	drop procedure AppSetThirdPartyAppInfo
END
IF EXISTS (select * from GxQscripts where name='AppSetThirdPartyAppInfo')
	delete from GxQscripts where name = 'AppSetThirdPartyAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetThirdPartyAppInfo')
	delete from GXDBVersions where aliasname = 'AppSetThirdPartyAppInfo'
GO
print '... Creating Procedure: AppSetThirdPartyAppInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetThirdPartyAppInfo
  @in_xml XML,
  @skipSecCheck int = 0
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @cnt1				INT
DECLARE @cnt2				INT
DECLARE @creatorId      	INT
DECLARE @localeId			INT
DECLARE @isAdminUser 		INT
DECLARE @operationType      INT
DECLARE @i_appType      	INT
DECLARE @i_appKey  	    	nvarchar(100)
DECLARE @i_appName     		nvarchar(100)
DECLARE @i_appDescription 	nvarchar(255)
DECLARE @tempToken			nvarchar(255)
DECLARE @tempSecret			nvarchar(255)
DECLARE @i_isEnabled		BIT
DECLARE @i_appDisplayName	nvarchar(255)
DECLARE @i_isDefault		INT
DECLARE @i_isCloud			BIT
DECLARE @i_flags			INT
DECLARE @nowTime			INT
DECLARE @warningCode		INT
DECLARE @warningMessage		VARCHAR(MAX)
DECLARE @errorCode 			INT
DECLARE @errorMessage 		VARCHAR(MAX)
DECLARE @xmlText XML
DECLARE @thirdPartyAppId				INT
DECLARE @assocWebconsoleList XML --This is to be used for storing associates webconsole list(currently for OpenID Connect applications)
DECLARE @autoRedirectionEntities TABLE (appKey nvarchar(255),appName nvarchar(255),domainId int,domainName nvarchar(255),emailDomains nvarchar(255))
DECLARE @ownerCompany INT
DECLARE @isTenantAdmin INT
DECLARE @respTbl table(resp XML)
DECLARE @redirectRulesPresent INT = 0
DECLARE @i_isCloudServiceSubscription INT = 0
DECLARE @existingDomain nvarchar(max) = NULL
--declare the table to store the application for which the information has to be set
DECLARE @tempThirdPartyTable TABLE
(
appKey 			nvarchar(MAX),
appType			integer,
appName 		NVARCHAR(MAX),
appToken 		NVARCHAR(MAX),
appSecret 		NVARCHAR(MAX),
appDescription	NVARCHAR(MAX),
ownerId 		integer,
isEnabled 		BIT,
appDisplayName NVARCHAR(MAX),
isCloud        BIT,
flags			integer,
companyId		integer,
redirectRulesPresent integer,
attributeMappingPresent integer
)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @xmlText       	=    @in_xml
SET @operationType  =	 @xmlText.value('(/App_SetClientThirdPartyAppPropReq/@opType)[1]', 'INT')
INSERT INTO @tempThirdPartyTable(ownerId,appType , appKey , appName , appToken , appSecret, appDescription , isEnabled ,appDisplayName,isCloud,flags,companyId,redirectRulesPresent,attributeMappingPresent)
SELECT  ISNULL(ref.value('@ownerId', 'INT'),0) 										AS agent1,
		ISNULL(ref.value('@appType', 'INT'),0) 										AS agent2,
		ISNULL(ref.value('@appKey', 'nvarchar(256)'),'') 							AS agent3,
		ISNULL(ref.value('@appName', 'nvarchar(255)'),'') 							AS agent4,
		ISNULL(ref.value('@appToken', 'nvarchar(255)'),'')							AS agent5,
		ISNULL(ref.value('@appSecret', 'nvarchar(255)'),'')							AS agent6,
		ISNULL(ref.value('@appDescription', 'nvarchar(255)'),'')					AS agent7,
		ISNULL(CASE ref.value('@isEnabled', 'int') WHEN '1' THEN 1 ELSE 0 END , 0)	AS agent8,
		ISNULL(ref.value('@appDisplayName', 'nvarchar(255)'), '')					AS agent9,
		ISNULL(CASE ref.value('@isCloudApp', 'int') WHEN '1' THEN 1 ELSE 0 END , 0)	AS agent10,
		ISNULL(ref.value('@flags', 'INT'),0) 										AS agent11,
		ISNULL(ref.value('@createAsCompanyId', 'INT'),0) 							AS agent12,
		ISNULL(ref.exist('associations'),0)											AS agent13,
		ISNULL(ref.exist('attributeMappings'),0)									AS agent14
FROM    @xmlText.nodes('App_SetClientThirdPartyAppPropReq/clientThirdPartyApps') R ( ref )
--specific error when exporting a duplicate commcell app
if (@operationType = 1 and exists (select 1 from App_ThirdPartyApp tp join @tempThirdPartyTable tmp on tmp.appName = tp.appName where tmp.appType = 3 or tmp.apptype= 4))
begin
	if((select Guid from app_client where id = 2) = (select appname from @tempThirdPartyTable where apptype = 4 or apptype = 3)) -- only one entry will be sent from gui for commcell apps
	begin
		SET @errorCode	= 1
		SET @errorMessage = 'Failed to add. Attempted to import certificates of local Commcell'
		GOTO SEND_RESPONSE
	end
	else
	begin
SET @errorCode	= 2
		SET @errorMessage = 'Failed to add. This provider commcell is already configured'
		GOTO SEND_RESPONSE
	end
end
SET @creatorId = ISNULL((SELECT  ref.value('@userId', 'int') AS col1
                         FROM    @xmlText.nodes('App_SetClientThirdPartyAppPropReq/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS col1
                         FROM    @xmlText.nodes('App_SetClientThirdPartyAppPropReq/processinginstructioninfo/locale') R ( ref )),0)
SET @errorCode = 0
SET @errorMessage = ''
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @creatorId))
BEGIN
	SET @errorCode	= 1
SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WITH(nolock) WHERE messageId = (475 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId )
    SET @errorMessage = REPLACE(@errorMessage, '^1%s', @creatorId)
    GOTO SEND_RESPONSE
END
IF @skipSecCheck=1
	SET @isAdminUser=1
ELSE IF EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where ((UG.groupFlags & 0x10000 <> 0) or (UG.groupFlags & 0x40000 <> 0)) and UU.userId=@creatorId
			   UNION
SELECT 1 FROM UMUserGroup UU INNER JOIN UMDSGroupMaps UMDS ON UMDS.umDSgroupId = UU.groupId INNER JOIN UMGroups UG ON UMDS.umgroupId=UG.id where ((UG.groupFlags & 0x10000 <> 0) or (UG.groupFlags & 0x40000 <> 0)) and UU.userId=@creatorId)
	BEGIN
		SET @isTenantAdmin = 1
		Select @ownerCompany=U.id from UMDSProviders U inner join UMUsers Users on U.id=Users.umDSproviderId where Users.id = @creatorId
IF  EXISTS (Select 1 from UMDSProviders U where U.serviceType <> 5 and U.id=@ownerCompany)
		BEGIN
			Select @ownerCompany=U.ownerCompany from UMDSProviders U where U.id=@ownerCompany
		END
		-- If the user is tenantAdmin createAsCompany would be the company user belongs to so updating the companyId column in @tempThirdPartyTable
		Update @tempThirdPartyTable set companyId=@ownerCompany
	END
ELSE
BEGIN
	--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @creatorId, 1, @isAdminUser OUT,1,2
	IF(@isAdminUser = 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#hedvigEntity') IS NOT NULL
			DROP TABLE #hedvigEntity
		CREATE TABLE #hedvigEntity
		(
			hedvigEntityId int primary key
		)
exec sec_getNonIdaObjectsForThisUser @creatorId,195,260,'#hedvigEntity'
		IF NOT EXISTS (select 1 from #hedvigEntity)
			BEGIN
				SET @errorCode	= 1
SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WITH(nolock) WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId )
				GOTO SEND_RESPONSE
			END
	END
END
--@CNT1 will denote the number of rows in temp table after insertion of appKeys
--@CNT2 will denote the number of rows in temp table after deletion of invalid appkey
--(@CNT1 - @CNT2) will give us the number of invalid appkeys that were sent from gui/cmd and we can send back a warning message accordingly
SET @cnt1  = 	(SELECT COUNT(*) FROM @tempThirdPartyTable)
IF(@cnt1 = 0)
BEGIN
	SET @warningCode    = 1
	SET @warningMessage = 'No Application info provided'
	GOTO SEND_RESPONSE
END
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
--Declare a temp table and store all info from [name,value] pairs, if present in the request
DECLARE @NameValueMapTable TABLE
(
appKey		   nvarchar(255),
appType		   integer,
appName		   nvarchar(255),
name           nvarchar(255),
val    		   nvarchar(MAX)
)
--This table is to store the associated Webconsoles that support OpenId Connect.
--For openId Connect, you need to specify a redirect URL at the OIDC Server. This URL must belong to our webconsoles and this assocList will store URLs for
--all such registered web consoles.
DECLARE @tempAssocWCListTbl TABLE
(
appKey 				nvarchar(MAX),
appName 			NVARCHAR(MAX),
webconsoleURL		nvarchar(MAX)
);
DECLARE @attributeMappings TABLE
(
appKey		   nvarchar(255),
appName		   nvarchar(255),
name    	   nvarchar(MAX),
value    	   nvarchar(MAX)
);
--For Add/Update operation , insert the list of [name,value] pairs into this table
INSERT INTO @NameValueMapTable
SELECT  ISNULL(ref.value('../../@appKey' , 'nvarchar(255)'),''),
		ISNULL(ref.value('../../@appType' ,'int'),0),
		ISNULL(ref.value('../../@appName' ,'nvarchar(255)'),''),
		ISNULL(ref.value('@name' , 'nvarchar(255)'),''),
        ISNULL(ref.value('@value' , 'nvarchar(MAX)') , '')
        FROM   @xmlText.nodes('App_SetClientThirdPartyAppPropReq/clientThirdPartyApps/props/nameValues') R ( ref )
INSERT INTO @tempAssocWCListTbl
SELECT  ISNULL(ref.value('../../../@appKey' , 'nvarchar(255)'),''),
		ISNULL(ref.value('../../../@appName' ,'nvarchar(255)'),''),
		ISNULL(ref.value('@val' , 'nvarchar(255)'),'')
        FROM   @xmlText.nodes('App_SetClientThirdPartyAppPropReq/clientThirdPartyApps/props/nameValues/values') R ( ref )
INSERT into @autoRedirectionEntities(appKey,appName,domainId,domainName,emailDomains)
SELECT ref.value('../../@appKey' , 'nvarchar(255)'),
ref.value('../../@appName' , 'nvarchar(255)'),
		ISNULL(ref.value('../domain[1]/@id','int'),-1) ,
		ref.value('../domain[1]/@domainName','nvarchar(255)') ,
		ref.value('@val','nvarchar(255)')
		FROM    @xmlText.nodes('App_SetClientThirdPartyAppPropReq/clientThirdPartyApps/associations/emailDomains') R ( ref )
INSERT INTO @attributeMappings
SELECT  ISNULL(ref.value('../@appKey' , 'nvarchar(255)'),''),
		ISNULL(ref.value('../@appName' ,'nvarchar(255)'),''),
		ISNULL(ref.value('@name' , 'nvarchar(MAX)'),''),
		ISNULL(ref.value('@value' , 'nvarchar(MAX)'),'')
		FROM   @in_xml.nodes('App_SetClientThirdPartyAppPropReq/clientThirdPartyApps/attributeMappings') R ( ref )
--Deleting empty values if any.
DELETE from @attributeMappings where name = '' or value = ''
--1. ADD
--2. DELETE
--3. UPDATE
--4. RENEW
IF(@operationType = 3 OR @operationType = 4)
BEGIN
--delete all entries from temp table which do not have a matching row in the actual table
	DELETE AAT
		FROM @tempThirdPartyTable AAT LEFT JOIN App_ThirdPartyApp ATPA ON AAT.appKey = ATPA.appKey
		WHERE ATPA.appName IS NULL
	SET @cnt2 = (SELECT COUNT(*) FROM @tempThirdPartyTable)
	IF(@cnt1 > @cnt2)
	BEGIN
		SET @warningCode    = 1
		SET @warningMessage = 'Some Applications for the update/renew operation do not exist.'
	END
	DECLARE @AppTableCur CURSOR
	--if cursor is already open , close it
	IF ( CURSOR_STATUS('variable', '@AppTableCur') > 0) /* cursor is open */
		CLOSE @AppTableCur
	SET @AppTableCur = CURSOR
		FOR SELECT DISTINCT appKey,appType,appName,appDescription,isEnabled,appDisplayName,isCloud,flags,companyId,redirectRulesPresent
		 FROM @tempThirdPartyTable
			OPEN @AppTableCur
				FETCH NEXT FROM @AppTableCur INTO @i_appKey,@i_appType,@i_appName,@i_appDescription,@i_isEnabled,@i_appDisplayName,@i_isCloud,@i_flags,@ownerCompany,@redirectRulesPresent
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF(@operationType = 3) --update
					BEGIN
						--check if the application with the same name already exists.
						--If so , send back an error indicating the reason.
						IF EXISTS(SELECT 1 FROM App_ThirdPartyApp WHERE appName = @i_appName and appkey <> @i_appKey)
						BEGIN
							SET @errorCode	= 1
							SET @errorMessage = 'Failed to update. Application with name ['+@i_appName+'] already exists'
							DEALLOCATE @AppTableCur
							GOTO SEND_RESPONSE
						END
						SELECT @thirdPartyAppId = id from App_ThirdPartyApp	where appKey = @i_appKey
						--Update all columns except XML column props
						UPDATE App_ThirdPartyApp
						SET appName = @i_appName , appDescription = @i_appDescription , isEnabled = @i_isEnabled, appType = @i_appType ,flags=@i_flags
						WHERE appKey = @i_appKey
						--Now, update props column from the temp table entries
						IF EXISTS(select 1 from @NameValueMapTable WHERE appKey = @i_appKey ) --check for only row for this particular appKey
						BEGIN
							UPDATE App_ThirdPartyApp
							SET  props = (SELECT name as '@name',
												 val  as '@value'
										  FROM @NameValueMapTable
										  WHERE appKey = @i_appKey
										  for xml path('nameValues'), root('props'), TYPE)
							WHERE  appKey = @i_appKey
							if @i_appType = 3	--SAML Applications specific updation
							UPDATE App_ThirdPartyApp set props.modify('insert <nameValues name = "App Display Name" value = "{sql:variable("@i_appDisplayName")}"/> as last into (/props)[1]')
									WHERE  appKey = @i_appKey
							if @i_appType = 5	--For OpenID Connect applications, we need to insert the associated webconsole list.
							BEGIN
								SET @assocWebconsoleList = (select 'webConsoleUrls' as '@name',
															 (SELECT webconsoleURL as '@val'
																FROM @tempAssocWCListTbl
																WHERE appKey = @i_appKey
																for xml path('values'), TYPE)
																for xml path('nameValues'),TYPE);
								UPDATE App_ThirdPartyApp set props.modify('insert sql:variable("@assocWebconsoleList") into (/props)[1]')
								where appKey = @i_appKey
							END
						END
						--Update attribute mappings
						IF EXISTS (select 1 from @tempThirdPartyTable where appKey=@i_appKey and attributeMappingPresent = 1)
						BEGIN
							IF NOT EXISTS (Select 1 from @attributeMappings where appKey=@i_appKey)
							BEGIN
								Delete from App_ThirdPartyAppProp where componentNameId in (Select id from App_ThirdPartyApp where appKey = @i_appKey)
							END
ELSE IF NOT EXISTS (Select 1 from App_ThirdPartyAppProp where componentNameId = @thirdPartyAppId and attrName='Attribute Mapping')
							BEGIN
								Insert into App_ThirdPartyAppProp(componentNameId,attrName,attrType,attrVal,created,modified)
Values(@thirdPartyAppId,'Attribute Mapping',1,
									CAST(( SELECT name as '@name', value as'@value' FROM @attributeMappings  WHERE appKey = @i_appKey for xml path('attributeMappings'), TYPE) as nvarchar(max)),0,0)
							END
							ELSE
							BEGIN
								UPDATE App_ThirdPartyAppProp
									SET attrval =CAST(( SELECT name as '@name', value as'@value' FROM @attributeMappings  WHERE appKey = @i_appKey for xml path('attributeMappings'), TYPE) as nvarchar(max))
where componentNameId=@thirdPartyAppId and attrName='Attribute Mapping'
							END
						END
						--update display name in case of multicommcell apps
						IF @i_appType = 3
						UPDATE App_ThirdPartyApp set props.modify('replace value of (/props/nameValues[@name="App Display Name"]/@value)[1] with (sql:variable("@i_appDisplayName"))')
						where appKey = @i_appKey
DELETE FROM App_ComponentProp where componentType=1034 and componentId=@thirdPartyAppId and propertyTypeId = 3
						IF @i_isCloud = 1
							INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1034, @thirdPartyAppId, 3, 1, 1, 0, @nowTime, 0)
						IF @i_appType = 2 and (@isTenantAdmin = 1 or @isAdminUser = 1) and (@redirectRulesPresent = 1) --SAML application specific
						BEGIN
							--setting auto-redirection associations only if IDP wrapper is present
						IF Exists (select 1 from UMDSProviders U inner join UMDSProviderProp UP on U.id = UP.componentNameId where CAST(UP.attrVal as int)=@thirdPartyAppId and UP.attrName='SAML IDP' and @i_appType =2 )
							BEGIN
								--checking if any SAML application has configured these domains
								DECLARE @domainName nvarchar(255) = NULL
								Select @domainName=UM.domainName from @autoRedirectionEntities ARE inner join App_ThirdPartyApp ATPA on ARE.appName=ATPA.appName inner join UMDSProviders UM on ARE.domainId=UM.id and ATPA.id=@thirdPartyAppId where domainId in (Select componentId from APP_ComponentProp where  componentType=112 and longVal <> @thirdPartyAppId and longVal <> 0 and componentId <> 0 )
								IF (@domainName IS NOT NULL)
								BEGIN
									SET @errorCode	= 1
									IF(@isTenantAdmin = 1)
									BEGIN
										SET @errorMessage = 'Unable to set auto-redirection rules.'
									END
									ELSE
									BEGIN
										SET @errorMessage = 'Unable to set auto-redirection rules.Domain ['+@domainName+'] Configured by another SAML Application.'
									END
									GOTO SEND_RESPONSE
								END
								Delete from APP_ComponentProp where componentId in (Select domainId from @autoRedirectionEntities ARE inner join App_ThirdPartyApp ATPA on ARE.appName=ATPA.appName and ATPA.id=@thirdPartyAppId ) and componentType = 112 and longVal = 0 and componentId <> 0
								---checking if the rules are configured for another saml application or another domain has configured same emailDomains.
								DECLARE @samlAppName nvarchar(255) = NULL
								Select @samlAppName=ATPA.appName from APP_ComponentProp as ACP with(NOLOCK) inner join App_ThirdPartyApp ATPA on ATPA.id=ACP.longVal  ,@autoRedirectionEntities as ARE  where  componentType=112 and (componentId <> ARE.domainId or   ACP.longVal<>@thirdPartyAppId)
								and (ACP.stringVal like ARE.emailDomains or ACP.stringVal like ARE.emailDomains+';%'  or ACP.stringVal like '%;'+ARE.emailDomains+';%'  or  ACP.stringVal like '%;'+ARE.emailDomains)
								IF (@samlAppName IS NOT NULL)
								BEGIN
									SET @errorCode	= 1
									IF (@isTenantAdmin = 1)
									BEGIN
										SET @errorMessage = 'Unable to set auto-redirection rules'
									END
									ELSE
									BEGIN
										SET @errorMessage = 'Unable to set auto-redirection rules.Redirection Rule already configured by SAML App ['+@samlAppName+'].'
									END
									GOTO SEND_RESPONSE
								END
								IF EXISTS (SELECT 1 from @autoRedirectionEntities where domainId = -1 and (domainName IS NULL OR domainName = ''))
								BEGIN
									SET @errorCode	= 1
									SET @errorMessage = 'Unable to set auto-redirection rules.Empty/NULL domainName for domain creation.'
									GOTO SEND_RESPONSE
								END
								---Marking the dummy domains as deconfigured
Update UMDSProviders set flags=(flags&~8) where serviceType = 12 and id in (Select componentId from APP_ComponentProp where componentType=112 and longVal=@thirdPartyAppId )
								---Deleting the existing auto-redirection rules
								DELETE FROM App_ComponentProp where componentType=112 and longVal=@thirdPartyAppId
								IF ((@isTenantAdmin = 1) OR (@ownerCompany > 0))
								BEGIN
SELECT @existingDomain = ARE.domainName from @autoRedirectionEntities ARE inner join UMDSProviders UMDS on UMDS.domainName=ARE.domainName where (( UMDS.serviceType <> 5 AND UMDS.ownerCompany <> @ownerCompany) OR (UMDS.serviceType = 5 AND UMDS.id <> @ownerCompany))
									IF @existingDomain IS NOT NULL AND @existingDomain <> ''
									BEGIN
										SET @errorCode	= 1
										SET @errorMessage = 'Unable to associate domain '+@existingDomain
										GOTO SEND_RESPONSE
									END
								END
								ELSE
								BEGIN
SELECT @existingDomain = ARE.domainName from @autoRedirectionEntities ARE inner join UMDSProviders UMDS on UMDS.domainName=ARE.domainName where (UMDS.ownerCompany > 0 OR UMDS.serviceType = 5)
									IF @existingDomain IS NOT NULL AND @existingDomain <> ''
									BEGIN
										SET @errorCode	= 1
										SET @errorMessage = 'Unable to associate domain '+@existingDomain
										GOTO SEND_RESPONSE
									END
								END
								If EXISTS (Select 1 from @autoRedirectionEntities where domainId = -1)
								BEGIN
									--Creating new Nameservers if domainId = -1 is provided
									DECLARE ARECur CURSOR FOR SELECT distinct domainName FROM @autoRedirectionEntities where domainId = -1
									 OPEN ARECur
									 Fetch Next from ARECur INTO @domainName
									 While @@FETCH_STATUS = 0
									BEGIN
										DECLARE @xmlInput xml = ''
										SET @xmlInput= (Select @domainName as '@domainName',@creatorId as '@ownerID',@ownerCompany as '@ownerCompany' for xml path ('App_CustomDomainUserCreationRequest') , type)
										INSERT INTO @respTbl EXEC AppCreateCustomDomainUsers @xmlInput
										FETCH NEXT FROM ARECur INTO @domainName
									 END
									 CLOSE ARECur
									 DEALLOCATE ARECur
									--Updating the domainId of new Nameserver in @autoredirection table
									UPDATE ARE SET domainId=UP.id from @autoRedirectionEntities ARE inner join UMDSProviders UP on UP.domainName=ARE.domainName where ARE.domainId = -1
								END
								---Inserting the new auto-redirection rules
								INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,stringVal,created,modified)
								(Select 112,a.domainId,16,10,@thirdPartyAppId,0,(STUFF((select ';'+b.emailDomains from @autoRedirectionEntities b where b.domainId=a.domainId for xml path('')),1,1,'')),@nowTime,0   from @autoRedirectionEntities a where appKey=@i_appKey group by (domainId))
								--Marking dummy domains as configured
Update UMDSProviders set flags=flags|8 where serviceType = 12 and id in (Select domainId from @autoRedirectionEntities)
							END
							IF @i_appType = 2 and (@isTenantAdmin = 1 or @isAdminUser = 1)
							BEGIN
							--Updating the IDP wrapper in case of Name change.
								update UP set domainName = @i_appName+'_'+CAST(newId() as nvarchar(36)) from UMDSProviders UP inner join UMDSProviderProp UPP on Upp.componentNameId = Up.id where attrName='SAML IDP' AND CAST(Upp.attrVal as int) = @thirdPartyAppId
							END
						END
					END
					IF(@operationType = 4 AND @i_appType = 1) --renew operation only applicable to third party apps
					BEGIN
						--create a new unique application token
						SET @tempToken = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						WHILE EXISTS(SELECT 1 FROM App_ThirdPartyApp WHERE appToken = @tempToken AND appType = 1)
						BEGIN
							SET @tempToken = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						END
						--create a new unique application secret
						SET @tempSecret = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						WHILE EXISTS(SELECT 1 FROM App_ThirdPartyApp WHERE appSecret = @tempSecret AND appType = 1)
						BEGIN
							SET @tempSecret = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						END
						UPDATE App_ThirdPartyApp
						SET appToken =  @tempToken , appSecret = @tempSecret
						WHERE appKey = @i_appKey
					END
				FETCH NEXT FROM @AppTableCur INTO @i_appKey,@i_appType,@i_appName,@i_appDescription,@i_isEnabled,@i_appDisplayName,@i_isCloud,@i_flags,@ownerCompany,@redirectRulesPresent
				END
			DEALLOCATE @AppTableCur
END
ELSE IF (@operationType = 1)    --ADD
BEGIN
	DELETE AAT
	FROM @tempThirdPartyTable AAT INNER JOIN App_ThirdPartyApp ATPA ON AAT.appName = ATPA.appName
	SET @cnt2 = (SELECT COUNT(*) FROM @tempThirdPartyTable)
	IF(@cnt1 > @cnt2)
	BEGIN
		SET @errorCode	= 1
		SET @errorMessage = 'Failed to add. Application with given name already exists'
		GOTO SEND_RESPONSE
	END
	DECLARE @AppTableCur2 CURSOR
	--if cursor is already open , close it
	IF ( CURSOR_STATUS('variable', '@AppTableCur2') > 0) /* cursor is open */
		CLOSE @AppTableCur2
	SET @AppTableCur2 = CURSOR
		FOR SELECT DISTINCT appName,appType,appDescription,isEnabled,appDisplayName,isCloud,flags,companyId
		 FROM @tempThirdPartyTable
			OPEN @AppTableCur2
	 			FETCH NEXT FROM @AppTableCur2 INTO @i_appName,@i_appType,@i_appDescription,@i_isEnabled,@i_appDisplayName,@i_isCloud,@i_flags,@ownerCompany
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF EXISTS(SELECT 1 FROM App_ThirdPartyApp WHERE appName = @i_appName)
					BEGIN
						SET @errorCode	= 1
						SET @errorMessage = 'Failed to add. Application with name ['+@i_appName+'] already exists'
						DEALLOCATE @AppTableCur2
						GOTO SEND_RESPONSE
					END
					IF(@i_appType = 1)
					BEGIN
						--create a new unique application token
						SET @tempToken = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						WHILE EXISTS(SELECT 1 FROM App_ThirdPartyApp WHERE appToken = @tempToken AND appType = 1)
						BEGIN
							SET @tempToken = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						END
						--create a new unique application secret
						SET @tempSecret = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						WHILE EXISTS(SELECT 1 FROM App_ThirdPartyApp WHERE appSecret = @tempSecret AND appType = 1)
						BEGIN
							SET @tempSecret = LOWER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16))
						END
					END
					ELSE
					BEGIN
						SET @tempToken = 'NA'
						SET @tempSecret = 'NA'
					END
					--Getting the userGroupId for populating props xml
					IF NOT EXISTS (Select 1 from @NameValueMapTable where appName = @i_appName and name = 'userGroupId')
					BEGIN
						DECLARE @userGroupId INT = 0 -- Getting the tenant user userGroupId for the company the App is being created , which would be zero for commcell applications.
Select @userGroupId=id from UMGroups where name='Tenant Users' and umdsProviderId = @ownerCompany and @ownerCompany <> 0
						IF(@userGroupId <> 0) -- UserGroupID would be zero for commcell level applications so not inserting in props.
						BEGIN
							INSERT INTO @NameValueMapTable (appType,appName,name,val) Values (2,@i_appName,'userGroupId',CAST(@userGroupId as nvarchar(10)))
						END
					END
					if(@i_flags = 0 and @i_appType = 2)
					BEGIN
						-- If flags are 0 for SAML applications created for company , auto-create flag should be true
						SET @i_flags = 2
					END
					BEGIN TRAN
						INSERT INTO App_ThirdPartyApp
						(
						appType,
						appKey,
						appName,
						appToken,
						appSecret,
						appDescription,
						ownerId,
						created,
						modified,
						isEnabled,
						props,
						flags
						)
						VALUES
						(
						@i_appType,
						UPPER( SUBSTRING( REPLACE( CAST(NEWID() AS nvarchar(100)),'-','') , 0 ,16)),
						@i_appName ,
						@tempToken,
						@tempSecret,
						@i_appDescription,
						@creatorId,
						@nowTime,
						0,
						@i_isEnabled ,
						'<props />',
						@i_flags
						)
						SET @thirdPartyAppId=(Select  id from App_ThirdPartyApp where appName=@i_appName)
						UPDATE App_ThirdPartyApp
						SET  props = (SELECT name as '@name',
											 val  as '@value'
									  FROM @NameValueMapTable
									  WHERE appName = @i_appName AND appType = @i_appType
									  for xml path('nameValues'), root('props'), TYPE)
						WHERE  id = @thirdPartyAppId
						--Insert Attribute Mappings
						IF EXISTS(select 1 from @tempThirdPartyTable where appName=@i_appName and attributeMappingPresent = 1)
						BEGIN
							IF EXISTS (Select 1 from @attributeMappings where appName=@i_appName)
							BEGIN
								Insert into App_ThirdPartyAppProp(componentNameId,attrName,attrType,attrVal,created,modified)
Values(@thirdPartyAppId,'Attribute Mapping',1,
									CAST(( SELECT name as '@name', value as'@value' FROM @attributeMappings  WHERE appName = @i_appName for xml path('attributeMappings'), TYPE) as nvarchar(max)),0,0)
							END
						END
				if @i_appType = 3	--SAML application specific
						UPDATE App_ThirdPartyApp set props.modify('insert <nameValues name = "App Display Name" value = "{sql:variable("@i_appDisplayName")}"/> as last into (/props)[1]')
						where appName = @i_appName
				if @i_appType = 5	--For OpenID Connect applications, we need to insert the associated webconsole list.
				BEGIN
					SET @assocWebconsoleList = (select 'webConsoleUrls' as '@name',
												 (SELECT webconsoleURL as '@val'
													FROM @tempAssocWCListTbl
													WHERE appName = @i_appName
													for xml path('values'), TYPE)
													for xml path('nameValues'),TYPE);
					UPDATE App_ThirdPartyApp set props.modify('insert sql:variable("@assocWebconsoleList") into (/props)[1]')
					where appName = @i_appName
				END
				if @i_appType = 3 or @i_appType = 4
				INSERT INTO APP_ComponentProp VALUES(1034,@@IDENTITY,1,0,1,0,'Global Idp sync user creation pending ownwards id',DBO.GetUnixTime(GETUTCDATE()),0)
				IF @i_isCloud = 1
						INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1034,@thirdPartyAppId, 3, 1, 1, 0, @nowTime, 0)
				IF @i_appType = 2 and (@isAdminUser = 1 or @isTenantAdmin = 1)  --SAML application specific
				BEGIN
					--checking if these domains are already configured.
					Select @domainName=UM.domainName from @autoRedirectionEntities ARE inner join App_ThirdPartyApp ATPA on ARE.appName=ATPA.appName inner join UMDSProviders UM on ARE.domainId=UM.id and ATPA.id=@thirdPartyAppId where domainId in (Select componentId from APP_ComponentProp where  componentType=112 and longVal <> @thirdPartyAppId and longVal <> 0 and componentId <> 0)
					IF (@domainName IS NOT NULL)
					BEGIN
						SET @errorCode	= 1
						IF(@isTenantAdmin = 1)
						BEGIN
							SET @errorMessage = 'Unable to set auto-redirection rules.'
						END
						ELSE
						BEGIN
							SET @errorMessage = 'Unable to set auto-redirection rules.Domain ['+@domainName+'] Configured by another SAML Application.'
						END
						ROLLBACK
						GOTO SEND_RESPONSE
					END
					IF EXISTS(Select 1 from APP_ComponentProp where componentId in (Select domainId from @autoRedirectionEntities ARE inner join App_ThirdPartyApp ATPA on ARE.appName=ATPA.appName and ATPA.id=@thirdPartyAppId ) and componentType=112 and longVal = 0 )
					BEGIN
						Delete from APP_ComponentProp where componentId in (Select domainId from @autoRedirectionEntities ARE inner join App_ThirdPartyApp ATPA on ARE.appName=ATPA.appName and ATPA.id=@thirdPartyAppId ) and componentType = 112
					END
					---checking if the rules are configured for another saml application or another domain has configured same emailDomains.
					Select @samlAppName=ATPA.appName from APP_ComponentProp as ACP with(NOLOCK) inner join App_ThirdPartyApp ATPA on ATPA.id=ACP.longVal  ,@autoRedirectionEntities as ARE  where  componentType=112 and (componentId <> ARE.domainId or   ACP.longVal<>@thirdPartyAppId)
								and (ACP.stringVal like ARE.emailDomains or ACP.stringVal like ARE.emailDomains+';%'  or ACP.stringVal like '%;'+ARE.emailDomains+';%'  or  ACP.stringVal like '%;'+ARE.emailDomains)
					IF (@samlAppName IS NOT NULL)
					BEGIN
						SET @errorCode	= 1
						IF (@isTenantAdmin = 1)
						BEGIN
							SET @errorMessage = 'Unable to set auto-redirection rules'
						END
						ELSE
						BEGIN
							SET @errorMessage = 'Unable to set auto-redirection rules.Redirection Rule already configured by SAML App ['+@samlAppName+'].'
						END
						ROLLBACK
						GOTO SEND_RESPONSE
					END
						--Checking for Empty domainNames
					IF EXISTS (SELECT 1 from @autoRedirectionEntities where domainId = -1 and (domainName IS NULL OR domainName = ''))
					BEGIN
						SET @errorCode	= 1
						SET @errorMessage = 'Unable to set auto-redirection rules.Empty/NULL domainName for domain creation.'
						ROLLBACK
						GOTO SEND_RESPONSE
					END
					IF ((@isTenantAdmin = 1) OR (@ownerCompany > 0))
					BEGIN
SELECT @existingDomain = ARE.domainName from @autoRedirectionEntities ARE inner join UMDSProviders UMDS on UMDS.domainName=ARE.domainName where (( UMDS.serviceType <> 5 AND UMDS.ownerCompany <> @ownerCompany) OR (UMDS.serviceType = 5 AND UMDS.id <> @ownerCompany))
						IF @existingDomain IS NOT NULL AND @existingDomain <> ''
						BEGIN
							SET @errorCode	= 1
							SET @errorMessage = 'Unable to associate domain '+@existingDomain
							GOTO SEND_RESPONSE
						END
					END
					ELSE
					BEGIN
SELECT @existingDomain = ARE.domainName from @autoRedirectionEntities ARE inner join UMDSProviders UMDS on UMDS.domainName=ARE.domainName where (UMDS.ownerCompany > 0 OR UMDS.serviceType = 5)
						IF @existingDomain IS NOT NULL AND @existingDomain <> ''
						BEGIN
							SET @errorCode	= 1
							SET @errorMessage = 'Unable to associate domain '+@existingDomain
							GOTO SEND_RESPONSE
						END
					END
						--Creating Dummy domains using AppCreateCustomDomainUsers.
						DECLARE ARECur CURSOR FOR SELECT distinct domainName FROM @autoRedirectionEntities where domainId = -1
						OPEN ARECur
						Fetch Next from ARECur INTO @domainName
						While @@FETCH_STATUS = 0
						BEGIN
							SET @xmlInput= (Select @domainName as '@domainName',@creatorId as '@ownerID',@ownerCompany as '@ownerCompany' for xml path ('App_CustomDomainUserCreationRequest') , type)
							INSERT INTO @respTbl EXEC AppCreateCustomDomainUsers @xmlInput
							FETCH NEXT FROM ARECur INTO @domainName
						END
						CLOSE ARECur
						DEALLOCATE ARECur
						--Updating the domainId of new Nameserver in @autoredirection table
						UPDATE ARE SET domainId=UP.id from @autoRedirectionEntities ARE inner join UMDSProviders UP on UP.domainName=ARE.domainName where ARE.domainId = -1
					---Inserting the new auto-redirection rules
					INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,stringVal,created,modified)
							(SELECT 112,a.domainId,16,10,@thirdPartyAppId,0,(STUFF((select ';'+b.emailDomains from @autoRedirectionEntities b where b.domainId=a.domainId for xml path('')),1,1,'')),@nowTime,0   from @autoRedirectionEntities a  group by (domainId))
							--Marking dummy domains as configured
Update UMDSProviders set flags=flags|(8) where serviceType = 12 and id in (Select domainId from @autoRedirectionEntities)
							--Creating new UMDSprovider type (UMDS_PROVIDER_IDP_WRAPPER) for newly added domains
							IF NOT EXISTS (SELECT 1 from UMDSProviders U inner Join UMDSProviderProp UP on U.id=UP.componentNameId
												inner join App_ThirdPartyApp ATP on ATP.id=CAST(UP.attrVal as int)
												 where attrName='SAML IDP' and ATP.id=@thirdPartyAppId )
							BEGIN
								--Please update size 36 for appname_guid with caution.
								INSERT INTO UMDSProviders (domainName,flags,enabled,serviceType,modified,dnsRootStatus,useSecureLdap,origCCId,port,resourceId,checkTime,ownerId,ownerCompany
								,login,hostName,description,password,trustedHostUser,trustedHostPW )
Values (@i_appName+'_'+CAST(newId() as nvarchar(36)),0,1,11,0,0,0,2,0,0,86400,1,@ownerCompany,
															'','','','','','')
								-- Assign user management role to the created app
								DECLARE @umdsProviderId INT = 0
SET @umdsProviderId = ISNULL((SELECT id from UMDSProviders WITH (NOLOCK) where @i_appName = SUBSTRING(UMDSProviders.domainName,1,(LEN(UMDSProviders.domainName)-36-1)) and serviceType = 11), 0)
								DECLARE @errorString	nvarchar(1024)
DECLARE @TenantAdminGroupId int = ISNULL((SELECT id FROM umgroups WITH (NOLOCK) WHERE umdsProviderId = @ownerCompany AND groupFlags &  0x10000 = 0x10000),0)
DECLARE @userManagementRoleId int = ISNULL((SELECT id FROM UMRoles WITH (NOLOCK) WHERE (name = 'UserManagement_Owner') AND (flags & 128 <> 0)), 1)
DECLARE @adminuserId INT = (SELECT TOP 1 id FROM UMUsers WITH (NOLOCK) WHERE flags & 0x040 <> 0)
EXEC sec_setCreatorForEntity @adminuserId, @userManagementRoleId, '', @errorCode OUTPUT, @errorString OUTPUT, 61, @umdsProviderId, 0, 0, 0, 0, 0, 0, 0, 0, @TenantAdminGroupId
								--Adding new logic to match idpwrapper with appName by finding the substring from domainName of UMDSProviders entry. Since this depends on size 36 change this with caution.
								INSERT INTO UMDSProviderProp (componentNameId,attrName,attrType,attrVal,created,modified)
									SELECT id,'SAML IDP',10,@thirdPartyAppId,@nowTime,0 from UMDSProviders where @i_appName = SUBSTRING(UMDSProviders.domainName,1,(LEN(UMDSProviders.domainName)-36-1)) and serviceType=11
							END
				END
				COMMIT TRAN
				FETCH NEXT FROM @AppTableCur2 INTO @i_appName,@i_appType,@i_appDescription,@i_isEnabled,@i_appDisplayName,@i_isCloud,@i_flags,@ownerCompany
				END
			DEALLOCATE @AppTableCur2
END
ELSE IF(@operationType = 2)  --Delete operation
BEGIN
	-- Update appKey from appName for multicommcell apps in cloud service before unsubscription
    UPDATE AAT SET AAT.appKey = ATPA.appKey FROM @tempThirdPartyTable AAT INNER JOIN App_ThirdPartyApp ATPA
    ON AAT.appName = ATPA.appName and ATPA.appType = 3
	DELETE AAT
	FROM @tempThirdPartyTable AAT LEFT JOIN App_ThirdPartyApp ATPA ON AAT.appKey = ATPA.appKey
	WHERE ATPA.appName IS NULL
	SET @cnt2 = (SELECT COUNT(*) FROM @tempThirdPartyTable)
	IF(@cnt1 > @cnt2)
	BEGIN
		SET @warningCode    = 1
		SET @warningMessage = 'Some Applications for the update/renew operation do not exist.'
	END
	BEGIN TRAN
		DELETE FROM APP_ComponentProp WHERE  componentType = 1034 AND componentId IN (SELECT ATPA.ID
																						FROM App_ThirdPartyApp ATPA INNER JOIN @tempThirdPartyTable AAT
																						ON AAT.appKey = ATPA.appKey )
		If Exists (Select 1 from @tempThirdPartyTable ATP inner join App_ThirdPartyApp ATPA on ATP.appKey=ATPA.appKey and ATPA.appType = 2 and (@isTenantAdmin = 1 or @isAdminUser = 1))
		BEGIN
			--Deconfiguring Dummy domains associated with this SAML App
Update UMDSProviders set flags=(flags&~8) where serviceType = 12 and id in
									(Select ACP.componentId from @tempThirdPartyTable TTP
															 Inner Join
															 App_ThirdPartyApp ATPA on TTP.appKey=ATPA.appKey
															 Inner Join
															 APP_ComponentProp ACP on ACP.longVal=ATPA.id where ATPA.appType = 2 and ACP.componentType = 112)
			DELETE FROM APP_ComponentProp WHERE  componentType = 112 AND longVal IN (SELECT ATPA.ID
																						FROM App_ThirdPartyApp ATPA INNER JOIN @tempThirdPartyTable AAT
																						ON AAT.appKey = ATPA.appKey )
			DECLARE @providersToDelete TABLE (providerId int)
			INSERT INTO @providersToDelete Select componentNameId from UMDSProviderProp where attrName = 'SAML IDP' and  CAST(attrVal as int) IN (SELECT ATPA.ID
																	FROM App_ThirdPartyApp ATPA INNER JOIN @tempThirdPartyTable AAT
																	ON AAT.appKey = ATPA.appKey )
			DELETE FROM UMDSProviderProp where attrName='SAML IDP' and  CAST(attrVal as int) IN (SELECT ATPA.ID
																	FROM App_ThirdPartyApp ATPA INNER JOIN @tempThirdPartyTable AAT
																	ON AAT.appKey = ATPA.appKey )
			DELETE FROM UMDSProviders where id in (Select providerId from @providersToDelete)
		END
		DELETE FROM App_ThirdPartyUserMappings WHERE IssuerId IN (SELECT ATPA.ID
																	FROM App_ThirdPartyApp ATPA INNER JOIN @tempThirdPartyTable AAT
																	ON AAT.appKey = ATPA.appKey )
		DELETE FROM App_ThirdPartyAppProp
			Where componentNameID in (SELECT ATPA.ID
									  FROM App_ThirdPartyApp ATPA INNER JOIN @tempThirdPartyTable AAT
									  ON AAT.appKey = ATPA.appKey )
		DELETE ATPA
			FROM App_ThirdPartyApp ATPA INNER JOIN @tempThirdPartyTable AAT ON AAT.appKey = ATPA.appKey
	COMMIT TRAN
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF ( CURSOR_STATUS('variable', '@AppTableCur') > 0) /* cursor is open */
		CLOSE  @AppTableCur
    IF ( CURSOR_STATUS('variable', '@AppTableCur') = -1) /* cursor is closed */
    DEALLOCATE @AppTableCur
    IF ( CURSOR_STATUS('variable', '@AppTableCur2') > 0) /* cursor is open */
		CLOSE  @AppTableCur2
    IF ( CURSOR_STATUS('variable', '@AppTableCur2') = -1) /* cursor is closed */
    DEALLOCATE @AppTableCur2
END CATCH
SEND_RESPONSE:
SET @xmlText = ( SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString', @warningCode AS '@warningCode' , @warningMessage AS '@warningMessage'
                 FOR xml path('error'),ROOT('App_SetClientThirdPartyAppPropResp')
               )
SET NOCOUNT OFF
select @xmlText as 'out_xml'
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetThirdPartyAppInfo')
	delete from GxQscripts where name = 'AppSetThirdPartyAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetThirdPartyAppInfo')
	delete from GXDBVersions where aliasname = 'AppSetThirdPartyAppInfo'
GO

insert into GXDBVersions values(2, 'AppSetThirdPartyAppInfo',  '00010007000200440000', 'AppSetThirdPartyAppInfo', '00010007000200440000')
GO

