

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetTenantAdminPermissionforClientGroup.sp] ---------- 

--  +================================================================================================================================================================+
--  |		 		 Name:  AppSetTenantAdminPermissionforClientGroup()
--  | Description:  This procedure will be used to give Tenant Admin Permission to Tenant Admin of the provided company on provided Client Group
--  +================================================================================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetTenantAdminPermissionforClientGroup.sp,v $ $Id: AppSetTenantAdminPermissionforClientGroup.sp,v 1.1.2.1 2020/04/02 18:55:14 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetTenantAdminPermissionforClientGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppSetTenantAdminPermissionforClientGroup <<<'
	drop procedure AppSetTenantAdminPermissionforClientGroup
END
IF EXISTS (select * from GxQscripts where name='AppSetTenantAdminPermissionforClientGroup')
	delete from GxQscripts where name = 'AppSetTenantAdminPermissionforClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTenantAdminPermissionforClientGroup')
	delete from GXDBVersions where aliasname = 'AppSetTenantAdminPermissionforClientGroup'
GO
print '... Creating Procedure: AppSetTenantAdminPermissionforClientGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetTenantAdminPermissionforClientGroup
  @i_companyId INTEGER,
  @i_clientGroupId INTEGER,
  @i_localeId INTEGER,
  @i_isCalledFromCPP INTEGER,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(1024)= ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
DECLARE @TenantAdminGroupId int = ISNULL((SELECT id FROM umgroups WHERE umdsProviderId=@i_companyId AND groupFlags &  0x10000 = 0x10000),0)
DECLARE @tenantAdminRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (flags & 256 <> 0)), 1)
	DECLARE @entityRequest NVARCHAR(MAX) = N''
	SET @entityRequest = N'<App_SecurityAssociationForEntityList associationsOperationType="2">
								<associations>
								<properties>
								<role roleId="' + cast (@tenantAdminRoleId as nvarchar) +'">
									</role>
								</properties>
							<userOrGroup userGroupId="' + cast (@TenantAdminGroupId as nvarchar) +'">
							</userOrGroup>
								</associations>
							</App_SecurityAssociationForEntityList>'
	EXEC[dbo].[sec_setSecurityAssociationsFromEntity]
		@xmlIn = @entityRequest,
		@userId = @adminUserId,
		@isCmdLine = 1,
		@skipSecurityCheck = 1,
		@entityType1 = 28,--CLIENT_GROUP_ENTITY
		@entityId1 = @i_clientGroupId,
		@entityType2 = 0,
		@entityId2 = 0,
		@entityType3 = 0,
		@entityId3 = 0,
		@entityType4 = 0,
		@entityId4 = 0,
		@entityType5 = 0,
		@entityId5 = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
EXIT_ERROR:
SET @o_errCode		= @errCode
SET @o_errString	= @errString
IF (@i_isCalledFromCPP = 1)
BEGIN
	SELECT @errCode, @errString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetTenantAdminPermissionforClientGroup')
	delete from GxQscripts where name = 'AppSetTenantAdminPermissionforClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTenantAdminPermissionforClientGroup')
	delete from GXDBVersions where aliasname = 'AppSetTenantAdminPermissionforClientGroup'
GO

insert into GXDBVersions values(2, 'AppSetTenantAdminPermissionforClientGroup',  '00010001000200010000', 'AppSetTenantAdminPermissionforClientGroup', '00010001000200010000')
GO

