

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetTelstraImpersonationCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetTelstraImpersonationCredentials.sp,v $ $Id: AppSetTelstraImpersonationCredentials.sp,v 1.1.2.1 2018/06/26 04:16:25 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppSetTelstraImpersonationCredentials()
--  |
--  | Description:  SP for setting Telstra Impersonation credentials
--  |
--  |       Input:  login, password
--  |
--  |      Output:  errorCode, errorString to determine status of the operation
--  |      Return:  errorCode
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	Created from inline query to Stored Procedure
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetTelstraImpersonationCredentials <<<'

IF EXISTS (select * from sysobjects where name='AppSetTelstraImpersonationCredentials')
	drop procedure AppSetTelstraImpersonationCredentials
IF EXISTS (select * from GxQscripts where name='AppSetTelstraImpersonationCredentials')
	delete from GxQscripts where name = 'AppSetTelstraImpersonationCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTelstraImpersonationCredentials')
	delete from GXDBVersions where aliasname = 'AppSetTelstraImpersonationCredentials'
GO
print '... Creating Procedure: AppSetTelstraImpersonationCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetTelstraImpersonationCredentials
  @i_login NVARCHAR(510),
  @i_password NVARCHAR(800),
  @o_errorCode INTEGER = 0 OUTPUT ,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
DECLARE @curUtcDateTime BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @loginParam NVARCHAR(128) = N'TelestraLogin'
DECLARE @passwordParam NVARCHAR(128) = N'TelestraPassword'
DECLARE @rowCount int
BEGIN TRY
BEGIN TRANSACTION
	--set login
    UPDATE GXGlobalParam SET value = @i_login, modified = @curUtcDateTime WHERE name = @loginParam
    SET @rowCount = @@ROWCOUNT
    IF(@rowCount = 0)
    BEGIN
		INSERT INTO GXGlobalParam (name, value, created, modified) VALUES (@loginParam, @i_login, @curUtcDateTime, 0)
    END
	--set password
    UPDATE GXGlobalParam SET value = @i_password, modified = @curUtcDateTime WHERE name = @passwordParam
    SET @rowCount = @@ROWCOUNT
    IF(@rowCount = 0)
    BEGIN
		INSERT INTO GXGlobalParam (name, value, created, modified) VALUES (@passwordParam, @i_password, @curUtcDateTime, 0)
    END
	IF @o_errorCode=0
        COMMIT TRANSACTION
    ELSE
        ROLLBACK TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT	@o_errorCode	= ERROR_NUMBER(),
			@o_errorString	= 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	ROLLBACK TRANSACTION
END  CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetTelstraImpersonationCredentials')
	delete from GxQscripts where name = 'AppSetTelstraImpersonationCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTelstraImpersonationCredentials')
	delete from GXDBVersions where aliasname = 'AppSetTelstraImpersonationCredentials'
GO

insert into GXDBVersions values(2, 'AppSetTelstraImpersonationCredentials',  '00010001000200010000', 'AppSetTelstraImpersonationCredentials', '00010001000200010000')
GO

