

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetTFAForUserGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- Set the property on a user group or company / commcell
-- when set for a commcell/company, enable the property on all usre groups
--
-- ----------------------------------------------------------------------
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetTFAForUserGroups')
BEGIN
	print '>>> Drop Stored Procedure: AppSetTFAForUserGroups <<<'
	drop procedure AppSetTFAForUserGroups
END
IF EXISTS (select * from GxQscripts where name='AppSetTFAForUserGroups')
	delete from GxQscripts where name = 'AppSetTFAForUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTFAForUserGroups')
	delete from GXDBVersions where aliasname = 'AppSetTFAForUserGroups'
GO
print '... Creating Procedure: AppSetTFAForUserGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetTFAForUserGroups
  @i_entityType INT,
  @i_entityId INT,
  @i_userId INT,
  @i_localeId INT,
  @i_tfaValue INT
AS
  DECLARE @o_errorCode INT = 0 
  DECLARE @o_errorString nvarchar(1024) = ''
BEGIN TRY
	DECLARE @nowTime int = datediff(second, '01/01/1970', getUTCDate())
IF @i_entityType = 1
	BEGIN
		SET @i_entityId = 0
	IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
		DROP TABLE #TFASupportedADServiceTypesTempTable
	CREATE TABLE #TFASupportedADServiceTypesTempTable (serviceType INT)
	-- TFA support: AD, openldap, oracle ldap, apple ldap, jump cloud and Generic LDAP
	INSERT INTO #TFASupportedADServiceTypesTempTable
VALUES (2), (6), (8),
(9), (10), (14)
		--If its enabled at global level then inherit the value at Companies
		--Else ignore, cause it would already have been disabled at gxglobalparam before this SP is called.
IF(@i_tfaValue = 1)
		BEGIN
			IF object_id('tempdb.dbo.#UserGroupsToUpdateTempTable') IS NOT NULL
				DROP TABLE #UserGroupsToUpdateTempTable
			CREATE TABLE #UserGroupsToUpdateTempTable
			(userGroupId INT PRIMARY KEY)
			INSERT INTO #UserGroupsToUpdateTempTable
			(userGroupId)
			( 	-- COMMCELL LOCAL USER GROUPS
				SELECT UMG.id FROM UMGroups UMG WITH(NOLOCK) WHERE UMG.umdsProviderId = @i_entityId
			)
			UNION
			( 	-- COMMCELL AD USER GROUPS
				SELECT UMG.id FROM UMGroups UMG WITH(NOLOCK)
				JOIN UMDSProviders UMP WITH(NOLOCK) ON UMG.umdsProviderId <> @i_entityId
						AND UMP.serviceType in (SELECT serviceType FROM #TFASupportedADServiceTypesTempTable)
						AND UMP.ownerCompany = @i_entityId AND UMG.umdsProviderId = UMP.id
			)
			UNION
			(	-- USER GROUPS OF COMPANY'S THAT EITHER HAVE PROPERTY CV_PROP_COMPANY_TWO_FACTOR_AUTHENTICATION SET TO 0 OR DO NOT HAVE THAT PROPERTY
				SELECT UMG.id
				FROM UMGroups UMG WITH(NOLOCK)
				JOIN UMDSProviders UMP WITH(NOLOCK) ON UMG.umdsProviderId <> @i_entityId
AND UMP.serviceType = 5 AND UMG.umdsProviderId = UMP.id
LEFT JOIN APP_companyprop CP WITH(NOLOCK) ON CP.attrName = 'EnableTwoFactorAuthentication' AND CP.cs_attrName = CHECKSUM('EnableTwoFactorAuthentication')
						AND CP.modified = 0 AND CP.componentNameId = UMP.id
				WHERE CP.componentNameId IS NULL OR CP.attrVal = '0'
			)
			UNION
			(	-- AD USER GROUPS OF COMPANY'S THAT EITHER HAVE PROPERTY CV_PROP_COMPANY_TWO_FACTOR_AUTHENTICATION SET TO 0 OR DO NOT HAVE THAT PROPERTY
				SELECT UMG.id
				FROM UMGroups UMG WITH(NOLOCK)
				JOIN UMDSProviders UMP WITH(NOLOCK) ON UMG.umdsProviderId <> @i_entityId
						AND UMP.serviceType in (SELECT serviceType FROM #TFASupportedADServiceTypesTempTable)
						AND UMG.umdsProviderId = UMP.id
LEFT JOIN APP_companyprop CP WITH(NOLOCK) ON CP.attrName = 'EnableTwoFactorAuthentication' AND CP.cs_attrName = CHECKSUM('EnableTwoFactorAuthentication')
						AND CP.modified = 0 AND CP.componentNameId = UMP.ownerCompany
				WHERE CP.componentNameId IS NULL OR CP.attrVal = '0'
			)
			-- Enable tfa in all user groups created by commcell user(umdsproviderId = 0) as well as all groups that are either AD or company.
			-- The property at usergroup level is DisableTwoFactor, so set it 0
			MERGE   UMGroupsProp AS TGT
			USING   (SELECT userGroupId FROM #UserGroupsToUpdateTempTable) AS SRC
ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'DisableTwoFactorAuthentication' AND TGT.attrType = 7
			WHEN    MATCHED AND TGT.attrVal <> '0' THEN         UPDATE SET TGT.attrVal = '0'
			WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.userGroupId, 'DisableTwoFactorAuthentication', 7, 0, @nowTime ,0);
			-- If CC has TFA enabled, enable it for all companies, else the default is disabled.
			MERGE App_CompanyProp as CC
USING (SELECT id FROM UMDSProviders WITH(NOLOCK) WHERE serviceType=5) AS SRC
ON      CC.componentNameId = SRC.id and CC.attrName = 'EnableTwoFactorAuthentication' and CC.cs_attrName = CHECKSUM('EnableTwoFactorAuthentication')
			WHEN    MATCHED AND CC.attrVal = '0' THEN        UPDATE SET CC.attrVal = '1'
			WHEN NOT MATCHED THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES( SRC.id, 'EnableTwoFactorAuthentication',7,1,@nowTime,0);
		END
	END
	-- if disabled we dont need to do anything as login will not read at group level.
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errorCode = ERROR_NUMBER()
    set @o_errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
IF object_id('tempdb.dbo.#UserGroupsToUpdateTempTable') IS NOT NULL
	DROP TABLE #UserGroupsToUpdateTempTable
IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
	DROP TABLE #TFASupportedADServiceTypesTempTable
SELECT @o_errorCode, @o_errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetTFAForUserGroups')
	delete from GxQscripts where name = 'AppSetTFAForUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetTFAForUserGroups')
	delete from GXDBVersions where aliasname = 'AppSetTFAForUserGroups'
GO

insert into GXDBVersions values(2, 'AppSetTFAForUserGroups',  '00000000000000000000', 'AppSetTFAForUserGroups', '00000000000000000000')
GO

