

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetStatusForOrphanVMs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  DAGetDeconfiguredClientsWithNoData.sp                      */
/*                                                                            */
/*  Description :  Stored procedure that returns deconfigured clients		  */
/*				   with no valid data for pruning 							  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetStatusForOrphanVMs.sp,v $ $Id: AppSetStatusForOrphanVMs.sp,v 1.4.34.11 2020/08/20 23:57:06 scheppuri Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetStatusForOrphanVMs')
BEGIN
	print '>>> Drop Stored Procedure: AppSetStatusForOrphanVMs <<<'
	drop procedure AppSetStatusForOrphanVMs
END
IF EXISTS (select * from GxQscripts where name='AppSetStatusForOrphanVMs')
	delete from GxQscripts where name = 'AppSetStatusForOrphanVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetStatusForOrphanVMs')
	delete from GXDBVersions where aliasname = 'AppSetStatusForOrphanVMs'
GO
print '... Creating Procedure: AppSetStatusForOrphanVMs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetStatusForOrphanVMs
AS
  DECLARE @retVal INT
SET NOCOUNT ON
BEGIN
SET @retVal = 0
DECLARE @unixTime int
SET @unixTime = dbo.GetUnixTime(GetUTCDate())
IF object_id('tempdb.dbo.#tmpVMList') IS NOT null DROP TABLE #tmpVMList
CREATE TABLE #tmpVMList(
                componentNameId			int primary key
)
INSERT INTO #tmpVMList ( componentNameId)
SELECT componentNameId
from app_clientprop cp1
where cp1.attrName = 'Virtual Server Discovered Clients'
AND cp1.modified = 0
and cp1.attrVal ='1'
delete #tmpVMList
from #tmpVMList vmList
JOIN app_clientprop cp
on vmList.componentNameId = cp.componentNameId
and cp.attrName = 'Virtual Machine Heartbeat Time'
AND cp.modified = 0
and cp.attrVal is not null
-- 9.0 instance clients, which doesn't have instance id won't be compared
delete #tmpVMList
from #tmpVMList vmList
left join app_clientprop cp
on vmList.componentNameId = cp.componentNameId
and cp.attrName = 'Virtual Machine Instance UUID'
AND cp.modified = 0
and cp.attrVal is not null
where cp.attrName is NULL
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
INSERT into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
select componentNameId,
       'Virtual Machine Heartbeat Time',
	   2,
	   @unixTime,
	   @unixTime,
	   0,
	   0
FROM #tmpVMList
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
DECLARE @fromTime int
select @fromTime = dbo.GetUnixTime(DATEADD(DAY, -30,  GETUTCDATE()))
TRUNCATE TABLE #tmpVMList
insert into #tmpVMList
SELECT cp.componentNameId
FROM app_clientprop cp
where cp.attrName = 'Virtual Machine Heartbeat Time'
AND cp.modified = 0
and cp.attrVal is not null and cast(cp.attrVal as int) < @fromTime
-- if there is recent back in last 30 days, we should exclude such VMs
Delete T
from #tmpVMList T
inner join app_clientprop cp
on cp.componentNameId = T.componentNameId
and cp.attrName ='Last Backup JobID'
and cp.modified =0
inner join jmbkpstats J
on J.jobid = cp.attrval
and J.servEndDate > @fromTime
-- in case VM heart beat is not updated in last 30 days and VM deletion time is not set as instance is not known
-- set deletion time stamp , so that SLA will ignore such client.
MERGE  App_ClientProp as Dest
USING (select * from #tmpVMList ) as Src
on  Dest.componentNameId = Src.componentNameId
	AND Dest.attrName = 'Virtual Machine Deletion Time'
	AND Dest.modified = 0
WHEN MATCHED AND ISNULL(Dest.attrVal,0) =0
   THEN UPDATE SET attrVal = @unixTime
WHEN NOT MATCHED THEN
INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
Values( Src.componentNameId, 'Virtual Machine Deletion Time', 2, @unixTime, @unixTime, 0, 0);
--- in some cases, user is deleting the client from commcell and readding it later
--- the client id entry in app_vmprop and jmqinetixstatus is not valid and jobs couldn't be browsed from the new client
--- Update deleted VM client job records with proper client id
IF object_id('tempdb.dbo.#vmList') IS NOT null DROP TABLE #vmList
CREATE TABLE #vmList(
	vmClientId int,
	jobId int,
	vmGUID nvarchar(256),
	newClientId int
)
insert into #vmList
select vmClientId, max(jobid), attrval,0
FROM app_vmprop
left join app_client
on id = vmClientId
where id is null and  attrname ='vmGUID'
group by vmClientId, attrval
update v
set newClientId = cp.componentNameId
from #vmList v
inner join app_clientprop cp
on cp.attrName ='Virtual Machine Instance UUID'
and cp.modified =0
and cp.attrval = v.vmGUID
--two clients can point to same new VM client
DELETE FROM vmList
FROM #vmlist AS vmList
       INNER JOIN (
                     SELECT
                           newClientId,
                           MAX(vmClientId) AS MaxVMclientId
                     FROM #vmlist vmList2
                     GROUP BY
                           newClientId
                     HAVING
                           COUNT(*) > 1
       ) t ON
              vmList.newClientId=t.newClientId
WHERE
       vmList.vmClientId <> t.MaxVMclientId
-- in case of synthetic full jobs, the old client id is carried forward and in some cases, new client id is also part of the same job
-- in this case, we need to first remove the old client id assocation from the same job, where new client id association exists
delete vmprop1
from app_vmprop vmprop1
inner join #vmList v
on vmprop1.vmclientId = v.vmClientId
inner join app_vmprop vmprop2
on vmprop2.vmclientId = v.newClientId
and vmprop1.jobid = vmprop2.jobid
delete jmq
from JMQinetixUpdateStatus jmq
inner join #vmList v
on jmq.clientId = v.vmClientId
inner join JMQinetixUpdateStatus jmq2
on jmq2.clientId = v.newClientId
and jmq.jobid = jmq2.jobid
update vmprop
set vmClientId = newClientId
from app_vmprop vmprop
inner join #vmList v
on vmprop.vmClientId = v.vmClientID
and v.newClientId !=0
update jmq
set clientId = newClientId
from JMQinetixUpdateStatus jmq
inner join #vmList v
on jmq.clientId = v.vmClientID
and v.newClientId !=0
--reset last sync job id if the job doesn't exists for the VM
update map
set LastSyncJobId =0
from SMVMReplicationMap map
left join smvolume vm
on map.ClientId =  vm.OriginClientId
and vm.copyid = vm.copyid
and vm.JobId = map.LastSyncJobId
where vm.OriginClientId is null
-- Logic to deconfigure the deleted V2 VM clients
-- only consider only indexing v2 clients
DECLARE @numberOfDaysToKeepDeletedVMs INTEGER
SET     @numberOfDaysToKeepDeletedVMs = 30
--Get parameter to consider number of days to keep VMs after being marked deleted in VCenter
SELECT @numberOfDaysToKeepDeletedVMs = isnull(value, 30)
FROM Gxglobalparam WITH (NOLOCK)
WHERE name = 'NumberOfDaysToKeepUnProtectedVMs'
DECLARE @VMdeletionTime INTEGER
SET @VMdeletionTime = dbo.GetUnixTime(GETUTCDATE()) - @numberOfDaysToKeepDeletedVMs * 24 * 3600
IF OBJECT_ID('tempdb.dbo.#AppDeconfigureVMClient_deletedVMList') IS NULL
BEGIN
	CREATE TABLE #AppDeconfigureVMClient_deletedVMList  ( componentNameId INT PRIMARY KEY)
END
insert into #AppDeconfigureVMClient_deletedVMList
SELECT cp1.componentNameId
from app_clientprop cp1
inner join app_clientprop cp2
on cp1.attrName = 'Virtual Machine Deletion Time'
AND cp1.modified = 0
and isnull(cp1.attrVal,0) !=0 and cast(cp1.attrval as int) < @VMdeletionTime
and cp2.attrName = 'IndexingV2_VSA'
and cp2.attrval ='1'
and cp2.modified =0
and cp2.componentNameId = cp1.componentNameId
-- In case V2 VM is also a virtualization client that is geting backed up as VM, we should not consider it.
DELETE VM
from #AppDeconfigureVMClient_deletedVMList VM
inner join app_application A
on VM.componentnameId = A.clientid
and A.apptypeid = 106
inner join app_instanceProp prop
on A.instance = prop.componentNameId
and prop.attrName ='Virtual Server Instance Type'
and prop.modified =0
-- in case there is a licensed package installed, don't consider it.
DELETE VM
from #AppDeconfigureVMClient_deletedVMList VM
INNER JOIN siminstalledpackages SIM
on VM.componentnameId = SIM.ClientID
exec AppDeconfigureVMClient 0
ERR_RETURN:
IF object_id('tempdb.dbo.#tmpVMList') IS NOT null DROP TABLE #tmpVMList
IF object_id('tempdb.dbo.#AppDeconfigureVMClient_deletedVMList') IS NOT null DROP TABLE #AppDeconfigureVMClient_deletedVMList
SELECT	@retVal
SET NOCOUNT OFF
END
GO


IF EXISTS (select * from GxQscripts where name = 'AppSetStatusForOrphanVMs')
	delete from GxQscripts where name = 'AppSetStatusForOrphanVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetStatusForOrphanVMs')
	delete from GXDBVersions where aliasname = 'AppSetStatusForOrphanVMs'
GO

insert into GXDBVersions values(2, 'AppSetStatusForOrphanVMs',  '00010004003400110000', 'AppSetStatusForOrphanVMs', '00010004003400110000')
GO

