

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetSpecialClientStatesSCGAsync.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetSpecialClientStatesSCGAsync.sp,v $ $Id: AppSetSpecialClientStatesSCGAsync.sp,v 1.1.2.9 2019/06/25 00:31:05 vthakur Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSetSpecialClientStatesSCGAsync"	|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetSpecialClientStatesSCGAsync')
BEGIN
	print '>>> Drop Stored Procedure: AppSetSpecialClientStatesSCGAsync <<<'
	drop procedure AppSetSpecialClientStatesSCGAsync
END
IF EXISTS (select * from GxQscripts where name='AppSetSpecialClientStatesSCGAsync')
	delete from GxQscripts where name = 'AppSetSpecialClientStatesSCGAsync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetSpecialClientStatesSCGAsync')
	delete from GXDBVersions where aliasname = 'AppSetSpecialClientStatesSCGAsync'
GO
print '... Creating Procedure: AppSetSpecialClientStatesSCGAsync'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetSpecialClientStatesSCGAsync
  @i_clientId integer=0
AS
--:DECLARE  o_specialStatusFlags	integer
SET NOCOUNT ON
BEGIN
	-- create the client list temporary table
	IF object_id('tempdb.dbo.#ClientList') IS NOT null DROP TABLE #ClientList
	CREATE TABLE #ClientList	([clientId]	INT NOT NULL PRIMARY KEY)
	IF @i_clientId <> 0
	BEGIN
		INSERT INTO #ClientList
		SELECT id FROM App_client WITH(NOLOCK) WHERE id = @i_clientId
	END
	ELSE
	BEGIN
		INSERT INTO #ClientList
		SELECT id FROM App_client WITH(NOLOCK) WHERE id > 1
	END
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- AppIdaUpgrade_UninstalledClients via AppUpgrade_SetSpecialClientStates.spb
BEGIN
		DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(CURRENT_TIMESTAMP) )
		-- Reset default special status flag row to 0
		UPDATE App_Client
		SET specialClientFlags = 0
		WHERE id IN (SELECT clientId FROM #ClientList)
			AND specialClientFlags <> 0			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
			--AND releaseId >= SIM_ID_GX_REL90 -- We reset the flag for any types of client, this is as per SIM team as for older clients this has to be set
											   -- to 0, also this was initially disabled as per Waqas but nobody remembers why. So for timebeing after having
											   -- discussion with Parag, Hemant and Xuemei removing only this check.
		-- create the client list temporary table
		IF object_id('tempdb.dbo.#ResetClientListStatusTbl') IS NOT null DROP TABLE #ResetClientListStatusTbl
		CREATE TABLE #ResetClientListStatusTbl	([r_id]	INT PRIMARY KEY)
		-- Check for each status flag
		-- 1. 0x1   HIDE_IN_GUI_CLIENT_LIST  outlook add-in
		-- Set the HIDE_IN_GUI_CLIENT_LIST property
		UPDATE APP_Client
		SET specialClientFlags = specialClientFlags | 0x1
		FROM APP_Client C
		WHERE 	C.id IN (SELECT clientId FROM #ClientList)
				AND specialClientFlags <> (specialClientFlags | 0x1)			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND C.releaseId >= 14
				AND
				(
					(
						1 = (
								SELECT COUNT(*)
								FROM simInstalledPackages S WITH(NOLOCK)
								WHERE S.ClientId = C.id
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
								)
								AND EXISTS (
											SELECT id
											FROM simInstalledPackages S WITH(NOLOCK)
											WHERE S.ClientId = C.id
AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In' and 'Lotus Notes Add-in'
							)
					)
					 OR	  	(
								EXISTS (
									SELECT ACP.componentNameId
									FROM APP_ClientProp ACP WITH(NOLOCK)
									WHERE ACP.componentNameId = C.id
										AND ( ACP.attrName = 'Virtual Server Discovered Clients'
											  OR ACP.attrName = 'Mini SRM Agent'
											) AND attrVal='1'
									)
								AND NOT EXISTS(
											SELECT ClientId
											FROM simInstalledPackages S WITH(NOLOCK)
											WHERE S.ClientId = C.id
									)
								AND
								(
									0 = (
											SELECT COUNT(*)
											FROM APP_Application WITH(NOLOCK)
WHERE  clientId = C.id AND appTypeId < 600 AND (subclientStatus & 0x200000) = 0
										)
								)
							)
				--	OR
				--		( --Set HIDE_IN_GUI_CLIENT_LIST flag for NAS Deconfigured Clients
				--			EXISTS (
				--				SELECT * FROM APP_ClientProp WITH(NOLOCK)
				--				WHERE componentNameId = C.Id
				--				AND attrName = 'PlatformDeleted 4'
				--				AND attrVal = '1'
				--				AND C.simOperatingSystemId in (SELECT ID FROM simOperatingSystem WITH(NOLOCK) WHERE SubType = 'NAS'))
				--		)
					OR
						(	--Set HIDE_IN_GUI_CLIENT_LIST flag for EDC Discovered Clients
							EXISTS (	SELECT  CGA.clientId
																		  FROM app_clientgroup CG WITH(NOLOCK) INNER JOIN app_clientGroupAssoc CGA WITH(NOLOCK)
																				ON CG.id = CGA.clientGroupId and CGA.clientId = C.Id
																		  WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
									)
						)
				)
		-- Insert outlook addin package flag (THIS FLAG IS THE SAME FOR LOTUS NOTES ADD-IN TOO - CONFIRMED WITH ANAND)
		DELETE APP_ClientProp
		FROM APP_ClientProp C
		WHERE attrName = 'Outlook Addin Client' and modified = 0
			and componentNameId IN (SELECT clientId FROM #ClientList)
			AND
				1= (
					SELECT COUNT(*)
					FROM simInstalledPackages S WITH(NOLOCK)
					WHERE S.ClientId = C.componentNameId
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
					)
				AND EXISTS (
							SELECT id
							FROM simInstalledPackages S WITH(NOLOCK)
							WHERE S.ClientId = C.componentNameId
							AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In'
						   )
		INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		SELECT id,'Outlook Addin Client', 10, 1, @currentTime, 0 , 0
		FROM APP_Client C WITH(NOLOCK)
		WHERE 	C.id IN (SELECT clientId FROM #ClientList)
AND C.releaseId >= 14
				AND
				1= (
					SELECT COUNT(*)
					FROM simInstalledPackages S WITH(NOLOCK)
					WHERE S.ClientId = C.id
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
					)
				AND EXISTS (
							SELECT id
							FROM simInstalledPackages S WITH(NOLOCK)
							WHERE S.ClientId = C.id
							AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In'
						   )
		-- 2. 0X2   SAME_COMMCELL_GALAXY_PACKAGES_ABSENT  look for package table
		INSERT INTO #ResetClientListStatusTbl (r_id)
		SELECT id
		FROM APP_Client C WITH(NOLOCK)
		WHERE C.id IN (SELECT clientId FROM #ClientList)
AND C.releaseId >= 14
			  AND
			  EXISTS (
						SELECT ClientId
						FROM simInstalledPackages WITH(NOLOCK)
						WHERE ClientId = C.id
					 )
		-- Set the SAME_COMMCELL_GALAXY_PACKAGES_ABSENT property
		UPDATE APP_Client
		SET specialClientFlags = specialClientFlags | 0x2
		WHERE id IN (SELECT clientId FROM #ClientList)
			  AND specialClientFlags <> (specialClientFlags | 0x2)			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND releaseId >= 14
			  AND
			  id NOT IN (
							SELECT r_id
							FROM #ResetClientListStatusTbl
						)
		-- 3. 0X8   NO_COUNT_IN_SCALE_LIMITS  Virtual server, add-in,  miniSRM  ( - All package + add-in )
		-- Set the NO_COUNT_IN_SCALE_LIMITS property
		UPDATE APP_Client
		SET specialClientFlags = specialClientFlags | 0x8
		FROM APP_Client C
		WHERE
			C.id IN (SELECT clientId FROM #ClientList)
			AND specialClientFlags <> (specialClientFlags | 0x8)			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND C.releaseId >= 14
			AND
			(
				(
					1 =   (
							SELECT COUNT(*)
							FROM simInstalledPackages S WITH(NOLOCK)
							WHERE S.ClientId = C.id
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
							)
							AND EXISTS (
										SELECT id
										FROM simInstalledPackages S WITH(NOLOCK)
										WHERE S.ClientId = C.id
										AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In' and 'Lotus Notes Add-in'
						   )
				)
				 OR	  (
						(
							EXISTS (
									SELECT ACP.componentNameId
									FROM APP_ClientProp ACP WITH(NOLOCK)
									WHERE ACP.componentNameId = C.id
										AND ( ACP.attrName = 'Virtual Server Discovered Clients'
											  OR ACP.attrName = 'Mini SRM Agent'
											) AND attrVal='1'
									)
							OR
							EXISTS(
									SELECT componentNameId FROM APP_IDAProp WITH(NOLOCK)
WHERE componentNameId in(SELECT id from APP_IDAName WITH(NOLOCK) where clientId= C.id AND apptypeId=106)
									AND attrName = 'Pseudo Apptype' AND attrVal='1'
								)
						)
						AND NOT EXISTS(
										SELECT ClientId
										FROM simInstalledPackages S WITH(NOLOCK)
										WHERE S.ClientId = C.id
								)
					  )
			)
		-- Handle client states for Commnet clients
		UPDATE App_Client
		SET specialClientFlags = 0xB
		WHERE id IN (SELECT clientId FROM #ClientList)
		AND specialClientFlags <> 0xB			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND releaseId >= 14
		AND name like '%CommNetAgent_%'
		-- For commserv none of the flags make sense so hardcode it to 0, this is after discussion with Amey and Parag
		UPDATE App_Client
		SET specialClientFlags = 0
		WHERE  id = 2
			AND specialClientFlags <> 0			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
		DROP TABLE #ResetClientListStatusTbl
END
	-- Set the client version
	EXEC	AppSetClientVersion	@i_clientId
	-- Create dummy client groups for clients like addin etc
BEGIN
	-- Handle Addin Clients
	-- THIS IS BOTH LOTUS NOTES AND OUTLOOK ADDIN EVEN THOUGH THE PROPERTY NAME IS MISLEADING
	DECLARE @outlookAddinClntsCount INT = (SELECT COUNT(*)
										FROM APP_ClientProp WITH(NOLOCK)
										WHERE componentNameId IN (select clientId FROM  #ClientList) AND
											attrName = 'Outlook Addin Client' AND modified = 0 AND attrVal = 1
										)
	IF (@outlookAddinClntsCount = 0 AND @i_clientId = 0)
	BEGIN
		DELETE APP_ClientGroupAssoc
WHERE clientGroupId IN ( SELECT id FROM APP_ClientGroup WITH(NOLOCK) WHERE flag & 0x0400 = 0x0400 )
		DELETE APP_ClientGroup
WHERE flag & 0x0400 = 0x0400
	END
ELSE IF NOT EXISTS( SELECT * FROM APP_ClientGroup WITH(NOLOCK) where flag & 0x0400 = 0x0400) AND @outlookAddinClntsCount > 0
	BEGIN
		INSERT INTO APP_ClientGroup(name
				   ,description
				   ,flag
				   ,status
				   ,userId
				   ,refTime
				   ,modified
				   ,origCCId
				   ,fwPorts)
				   VALUES
				   ('AddIn Clients'
				   ,'All AddIn Clients'
,0x0400
				   ,0
				   ,1
				   ,dbo.GetUnixTime(GetDate())
				   ,0
				   ,2
				   ,' ')
	END
DECLARE @addinGroupId INT = ISNULL(( SELECT id FROM APP_ClientGroup WITH(NOLOCK) WHERE flag & 0x0400 = 0x0400 ),0)
	IF (@addinGroupId <> 0)
	BEGIN
		DELETE APP_ClientGroupAssoc
		WHERE clientId IN (select clientId FROM  #ClientList) AND
			clientGroupId = @addinGroupId
		INSERT INTO APP_ClientGroupAssoc (clientGroupId,clientId)
		SELECT @addinGroupId,componentNameId
		FROM APP_ClientProp WITH(NOLOCK)
		WHERE (@i_clientId=0 OR componentNameId IN (select clientId FROM  #ClientList)) AND
			attrName = 'Outlook Addin Client' and modified = 0 AND attrVal = 1
	END
	--SELECT id
	--FROM APP_ClientGroup
	--WHERE flag & CV_FLAG_ADDIN_CLIENT_GROUP = CV_FLAG_ADDIN_CLIENT_GROUP
END
	-- SELECT 	@o_specialStatusFlags    -- CALLER SHOULD CHECK FOR DB_NODATA AS THE CORRECT RESPONSE  -SKatz
	-- Check for Update of smart client groups for this client via an async operation for Admin User
	EXEC AppWorkQueueSubmitRequest 29 /*WORK_TOKEN_SCG_UPDATE_CLIENT*/, 0, 0, @i_clientId, 0, N''
	---set the property IsInfrastructure
	Exec AppSetIsInfrastructurePropertyForNewClient @i_clientId
	DROP TABLE #ClientList
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSetSpecialClientStatesSCGAsync')
	delete from GxQscripts where name = 'AppSetSpecialClientStatesSCGAsync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetSpecialClientStatesSCGAsync')
	delete from GXDBVersions where aliasname = 'AppSetSpecialClientStatesSCGAsync'
GO

insert into GXDBVersions values(2, 'AppSetSpecialClientStatesSCGAsync',  '00010001000200090000', 'AppSetSpecialClientStatesSCGAsync', '00010001000200090000')
GO

