

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetSnapDRReplicationInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppSetSnapDRReplicationInfo						|
--	|		 Procedure to set snap replication DR information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetSnapDRReplicationInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppSetSnapDRReplicationInfo <<<'
	drop procedure AppSetSnapDRReplicationInfo
END
IF EXISTS (select * from GxQscripts where name='AppSetSnapDRReplicationInfo')
	delete from GxQscripts where name = 'AppSetSnapDRReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetSnapDRReplicationInfo')
	delete from GXDBVersions where aliasname = 'AppSetSnapDRReplicationInfo'
GO
print '... Creating Procedure: AppSetSnapDRReplicationInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetSnapDRReplicationInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = datediff(second, '01/01/1970', GETDATE())
    DECLARE @replicationId      INT = 0
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
	CREATE TABLE #livesync_InfoTable (replicationId INT, vappId int, failoverStatus INT, dstName nvarchar(256), dstGUID nvarchar(256), relationshipStatus int, testfailoverstatus int)
	CREATE CLUSTERED INDEX livesync_InfoTable_replicationId_Index1 ON #livesync_InfoTable ([replicationId])
	IF object_id('tempdb.dbo.#dsInfoTable') is not null
		DROP TABLE #dsInfoTable
	declare @vappId int
	select @vappId = isnull(@i_xmlString.value('(Api_SetSnapDRReplicationReq/vApp/@vAppId)[1]', 'int'),0)
	CREATE table #dsInfoTable
	(
		clientId int,
		mapId int,
		destDSName nvarchar(256),
		destDSGUID nvarchar(256),
		destVClientId int,
		relationshipStatus int
	)
	INSERT into #dsInfoTable
	select
		ref.value('../@clientId', 'int'),
		ref.value('@id','int'),
		ref.value('destination[1]/@strDatastoreUUID','nvarchar(256)'),
		ref.value('destination[1]/@strDatastorename','nvarchar(256)'),
		isnull(ref.value('../destination[1]/@clientId', 'int'),-1),
		ref.value('@relationshipStatus', 'int')
	FROM @i_xmlString.nodes ('Api_SetSnapDRReplicationReq/siteInfo/datastore') R(ref)
	update DS
	set DSGuid = DI.destDSGUID,
	    DSName = DI.destDSName,
		VirtualClientId = case when DI.destVClientId =-1 then VirtualClientId else DI.destVClientId end
	from SMVMDatastore DS
	inner join SMVMReplicationMap DMAP
	on DS.id = DMAP.DestinationDatastoreId
	inner join #dsInfoTable DI
	on DMAP.ClientId = DI.clientId
    and DI.mapid  = DMAP.Id
	where DI.destDSGUID is not null
	update DMAP
	set relationshipstatus = case when DI.relationshipStatus is null then DMAP.RelationshipStatus else DI.relationshipStatus end
	from SMVMReplicationMap DMAP
	inner join #dsInfoTable DI
	on DMAP.ClientId = DI.clientId
    and DI.mapid  = DMAP.Id
	-- READ THE XML
	INSERT #livesync_InfoTable (replicationId, vappId, failoverstatus,dstName, dstGUID, testfailoverstatus )
	SELECT	ISNULL((ref.value('@replicationId', 'INT')), 0),
	        @vappId,
			ISNULL((ref.value('@failoverStatus', 'INT')), -1),
			ISNULL((ref.value('@destinationName', 'nvarchar(256)')), ''),
			ISNULL((ref.value('@destinationGuid', 'nvarchar(256)')), ''),
			ISNULL((ref.value('@testFailoverStatus', 'INT')), -1)
			FROM @i_xmlString.nodes ('Api_SetSnapDRReplicationReq/siteInfo') R(ref)
		UPDATE VR SET
			FailoverStatus = case when RT.failoverStatus =-1 then VR.FailoverStatus else RT.failoverStatus end,
			TestFailoverStatus = case when RT.testfailoverStatus =-1 then VR.TestFailoverStatus else RT.testfailoverStatus end,
			DestinationVMName = case when RT.dstName is null then VR.DestinationVMName else RT.dstName end,
			DestinationVMGuid = case when RT.dstGUID is null then VR.DestinationVMGuid else RT.dstGUID end
		FROM App_VirtualAppReplication VR
			JOIN #livesync_InfoTable RT ON
			RT.replicationId = VR.replicationId
		SELECT @errorCode = @@ERROR, @replicationId = SCOPE_IDENTITY()
    END
ERROR_EXIT:
    SET @o_xmlString =
    (
		SELECT
			(SELECT
				@replicationId AS '@replicationId'
				--taskId AS '@taskId'
				--FROM #outTable
				FOR XML PATH('siteInfo'), TYPE
			),
			(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
			FOR XML PATH ('resp'), TYPE
			)
		FOR XML PATH(''), ROOT('Api_SetSnapDRReplicationResp')
    )
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
	IF object_id('tempdb.dbo.#outTable') is not null
		DROP TABLE #outTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetSnapDRReplicationInfo')
	delete from GxQscripts where name = 'AppSetSnapDRReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetSnapDRReplicationInfo')
	delete from GXDBVersions where aliasname = 'AppSetSnapDRReplicationInfo'
GO

insert into GXDBVersions values(2, 'AppSetSnapDRReplicationInfo',  '00000000000000000000', 'AppSetSnapDRReplicationInfo', '00000000000000000000')
GO

