

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetSECloudMapping.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetSECloudMapping.sp,v $ $Id: AppSetSECloudMapping.sp,v 1.6.12.8 2020/10/04 00:58:12 abilbrey Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppSetSECloudMapping   - Set cloudid to preview cloud id details
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetSECloudMapping')
BEGIN
	print '>>> Drop Stored Procedure: AppSetSECloudMapping <<<'
	drop procedure AppSetSECloudMapping
END
IF EXISTS (select * from GxQscripts where name='AppSetSECloudMapping')
	delete from GxQscripts where name = 'AppSetSECloudMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetSECloudMapping')
	delete from GXDBVersions where aliasname = 'AppSetSECloudMapping'
GO
print '... Creating Procedure: AppSetSECloudMapping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetSECloudMapping
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_srcCloudId integer,
  @i_destCloudId integer,
  @i_sharingType integer,
  @i_isEnabled integer,
  @i_userId integer
AS
DECLARE @o_errorCode INT =0
DECLARE @o_errorString varchar(1024) = ''
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @nowTime DATETIME = GETUTCDATE()
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
DECLARE @coreId         INT = 0
DECLARE @roleId         INT = 0
DECLARE @isAuditRequired         INT = 0
--if Preview engine option is disabled
IF @i_isEnabled = 0  --CV_CLOUD_FLAG_DISABLE
BEGIN
	IF EXISTS ( SELECT * FROM DM2SearchEngineCloudMapping WITH (NOLOCK)  WHERE SrcCloudId = @i_srcCloudId AND SharingType = @i_sharingType)
	BEGIN
		set @i_destCloudId =  ISNULL( (SELECT DestCloudId FROM DM2SearchEngineCloudMapping WITH (NOLOCK)  WHERE SrcCloudId = @i_srcCloudId AND SharingType = @i_sharingType),0)
		DELETE FROM DM2SearchEngineCloudMapping WHERE SrcCloudId = @i_srcCloudId AND SharingType = @i_sharingType
		set @isAuditRequired = 1
	END
END
ELSE
BEGIN
	--do not audit everytime
IF NOT EXISTS ( SELECT * FROM DM2SearchEngineCloudMapping WITH (NOLOCK)  WHERE SrcCloudId = @i_srcCloudId AND destCloudId = @i_destCloudId AND SharingType = @i_sharingType AND Flags = 1)
		BEGIN
				--new entry for preview cloud
				INSERT INTO DM2SearchEngineCloudMapping (SrcCloudId, SharingType, DestCloudId, Flags, CreationTime, ModifiedTime)
VALUES (@i_srcCloudId, @i_sharingType, @i_destCloudId, 1, @nowTime , 0)
				IF (@@ERROR <> 0)
				BEGIN
					SET @o_errorCode = @@ERROR
					SET @o_errorString = 'Failed to insert preview cloud information.'
					GOTO ERROR_EXIT
				END
		set @isAuditRequired = 1
	END
END
IF @isAuditRequired = 1
BEGIN
	--AUDIT
	DECLARE @srcCloudName NVARCHAR(512) =ISNULL((SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE id = @i_srcCloudId ),N'')
	DECLARE @destCloudName NVARCHAR(512) =ISNULL((SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE id = @i_destCloudId ),N'')
	-- SET GUI AUDIT OPERATION
IF @i_sharingType = 1  --EVGui::SharingType_PREVIEW
	BEGIN
SET @opMsgId = (445 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @paramMsgId = (1178 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	END
	EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- SET GUI AUDIT PARAMETER
	EXEC EvGuiAuditSetParamData @opId, @destCloudName, @dataIsEvent
	IF @i_isEnabled = 1
		EXEC EvGuiAuditSetParamData @opId, 'ADDED', @dataIsEvent
	ELSE IF @i_isEnabled = 0
		EXEC EvGuiAuditSetParamData @opId, 'REMOVED', @dataIsEvent
	EXEC EvGuiAuditSetParamData @opId, @srcCloudName, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
END
  --------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
ERROR_EXIT:
SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetSECloudMapping')
	delete from GxQscripts where name = 'AppSetSECloudMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetSECloudMapping')
	delete from GXDBVersions where aliasname = 'AppSetSECloudMapping'
GO

insert into GXDBVersions values(2, 'AppSetSECloudMapping',  '00010006001200080000', 'AppSetSECloudMapping', '00010006001200080000')
GO

