

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetReplicationGroupProp.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppSetReplicationGroupProp()
--  | Description: Sets replication group properties
--  |
--  |       Input: repGroupId, attrName, attrType, attrVal, isXml
--  |      Output: App_GenericResp xml
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetReplicationGroupProp')
BEGIN
	print '>>> Drop Stored Procedure: AppSetReplicationGroupProp <<<'
	drop procedure AppSetReplicationGroupProp
END
IF EXISTS (select * from GxQscripts where name='AppSetReplicationGroupProp')
	delete from GxQscripts where name = 'AppSetReplicationGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetReplicationGroupProp')
	delete from GXDBVersions where aliasname = 'AppSetReplicationGroupProp'
GO
print '... Creating Procedure: AppSetReplicationGroupProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetReplicationGroupProp
  @repGroupId INT,
  @attrName NVARCHAR(255),
  @attrType INT,
  @attrVal NVARCHAR(MAX),
  @isXml INT
AS
DECLARE @errorCode    INT = 0
DECLARE @errorString  NVARCHAR(1024) = ''
DECLARE @o_xml		  XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	DECLARE @attrXML XML = ''
	-- Preprocessing for certain xml since the root tag is generalized when called using encode in c# layer
	IF (@isXml = 1)
	BEGIN
		SET @attrXML = CONVERT(XML,@attrVal)
	END
IF(@isXml = 1 AND @attrName  = 'BLR recovery options')
	BEGIN
		SET @attrXML = @attrXML.query('element blrRecoveryOpts {BlockReplication_BLRRecoveryOptions/@*, /BlockReplication_BLRRecoveryOptions/*}');
	END
	IF(@isXml = 1)
	BEGIN
		UPDATE App_ReplicationGroupProp SET attrXml = @attrXML WHERE componentNameId = @repGroupId AND attrName = @attrName
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
					 VALUES (@repGroupId, @attrName, @attrType, '', @attrXML, @currentTime, 0 )
		END
	END
	ELSE
	BEGIN
		UPDATE App_ReplicationGroupProp SET attrVal = @attrVal WHERE componentNameId = @repGroupId AND attrName = @attrName
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
					 VALUES (@repGroupId, @attrName, @attrType, @attrVal, '', @currentTime, 0 )
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
	IF @errorCode = 1205  --DEADLOCK error
	BEGIN
	    ;THROW;   -- rethrow the DEADLOCK so XE captures.
	END
END CATCH
PROC_EXIT:
	SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
    SELECT @o_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetReplicationGroupProp')
	delete from GxQscripts where name = 'AppSetReplicationGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetReplicationGroupProp')
	delete from GXDBVersions where aliasname = 'AppSetReplicationGroupProp'
GO

insert into GXDBVersions values(2, 'AppSetReplicationGroupProp',  '00000000000000000000', 'AppSetReplicationGroupProp', '00000000000000000000')
GO

