

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetRecoveryModeForDBOnCS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetRecoveryModeForDBOnCS.sp,v $ $Id: AppSetRecoveryModeForDBOnCS.sp,v 1.1.2.5 2019/08/15 21:01:21 mnatarajan Exp $";
-- =============================================
-- Author:		Madhusudhananan N
-- Create date: 07/10/2009
-- Description:
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetRecoveryModeForDBOnCS')
BEGIN
	print '>>> Drop Stored Procedure: AppSetRecoveryModeForDBOnCS <<<'
	drop procedure AppSetRecoveryModeForDBOnCS
END
IF EXISTS (select * from GxQscripts where name='AppSetRecoveryModeForDBOnCS')
	delete from GxQscripts where name = 'AppSetRecoveryModeForDBOnCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetRecoveryModeForDBOnCS')
	delete from GXDBVersions where aliasname = 'AppSetRecoveryModeForDBOnCS'
GO
print '... Creating Procedure: AppSetRecoveryModeForDBOnCS'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetRecoveryModeForDBOnCS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @databaseList NVARCHAR(MAX),
  @recoveryMode NVARCHAR(MAX),
  @ntAuthoritySystemLogin NVARCHAR(MAX)
AS
  DECLARE @errCode INTEGER
  DECLARE @errStr NVARCHAR(1024)
BEGIN
	IF (@recoveryMode <> 'Simple' AND @recoveryMode <> 'FULL' AND @recoveryMode <> 'Bulk-logged')
	BEGIN
		SELECT 1, 'Invalid recovery mode passed as input.'
		RETURN
	END
	EXEC  master..sp_addsrvrolemember @loginame = @ntAuthoritySystemLogin, @rolename = N'sysadmin'
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
BEGIN TRY
	DECLARE @csSecondInstanceClientID INT = 0
	SELECT @csSecondInstanceClientID = CONVERT(INT, attrval) FROM App_clientprop (NOLOCK)
	WHERE componentnameID=2 AND attrname='Failover Instance ClientID' AND modified=0
	IF (@csSecondInstanceClientID>0)
	BEGIN
		-- Fill DB path for CS into CS second instance
		DECLARE @csDBFilePathXML XML
		SET @csDBFilePathXML = (
									SELECT name '@logicalFileName', physical_name '@fileName', size '@fileMaxSize',0 '@id',database_id 'sqlDBInfo/@databaseId',DB_NAME(database_id) 'sqlDBInfo/@databaseName'
                                    FROM sys.master_files
									WHERE DB_NAME(database_id) IN
									(
										SELECT DBs._ID
										FROM dbo.SplitIDString(@databaseList) DBs
									)
                                    FOR XML PATH('sqlDbdeviceItem'),ROOT('Api_GetDBFilePathInfoResp')
								)
		IF @csDBFilePathXML IS NOT NULL
		BEGIN
			UPDATE GxglobalParam
			SET Value = CAST(@csDBFilePathXML AS NVARCHAR(MAX)),
			created = dbo.getunixtime(getutcdate())
WHERE Name = 'DBFilePathInfo_'+CAST(@csSecondInstanceClientID AS  NVARCHAR(20))
			IF @@ROWCOUNT=0
			BEGIN
				INSERT INTO GxglobalParam
SELECT 'DBFilePathInfo_'+CAST(@csSecondInstanceClientID AS  NVARCHAR(20)), CAST(@csDBFilePathXML AS NVARCHAR(MAX)), dbo.getunixtime(getutcdate()),0
			END
		END
	END
	-- First get the database list for which we need to set the recovery mode.
	IF ( CURSOR_STATUS('global', 'SetRecoveryModeCursor') >= 0   OR CURSOR_STATUS('local', 'SetRecoveryModeCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE SetRecoveryModeCursor
	IF ( CURSOR_STATUS('global','SetRecoveryModeCursor') = -1     OR CURSOR_STATUS('local','SetRecoveryModeCursor') = -1 )
		DEALLOCATE SetRecoveryModeCursor
	DECLARE @dbName NVARCHAR(100)
	DECLARE @sqlStatement NVARCHAR(1024)
	DECLARE SetRecoveryModeCursor CURSOR FOR
		SELECT DBs._ID
		   FROM dbo.SplitIDString(@databaseList) DBs
		   INNER JOIN sys.databases SysDB ON SysDB.name = DBs._ID
		   AND SysDB.recovery_model_desc <> @recoveryMode
		OPEN SetRecoveryModeCursor
		FETCH NEXT FROM SetRecoveryModeCursor INTO @dbName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @sqlStatement = 'ALTER DATABASE ' + @dbName + ' SET RECOVERY '+@recoveryMode
			--SET @sqlStatement = @sqlStatement + ' WITH ROLLBACK IMMEDIATE'
			EXEC sp_executesql @sqlStatement
			FETCH NEXT FROM SetRecoveryModeCursor INTO @dbName
		END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	IF ( CURSOR_STATUS('global', 'SetRecoveryModeCursor') >= 0   OR CURSOR_STATUS('local', 'SetRecoveryModeCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE SetRecoveryModeCursor
	IF ( CURSOR_STATUS('global','SetRecoveryModeCursor') = -1     OR CURSOR_STATUS('local','SetRecoveryModeCursor') = -1 )
		DEALLOCATE SetRecoveryModeCursor
	SELECT @errorCode, @errorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetRecoveryModeForDBOnCS')
	delete from GxQscripts where name = 'AppSetRecoveryModeForDBOnCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetRecoveryModeForDBOnCS')
	delete from GXDBVersions where aliasname = 'AppSetRecoveryModeForDBOnCS'
GO

insert into GXDBVersions values(2, 'AppSetRecoveryModeForDBOnCS',  '00010001000200050000', 'AppSetRecoveryModeForDBOnCS', '00010001000200050000')
GO

