

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetRServerHostInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: AppSetRServerHostInfo
--  |
--  | Description:
--  |  To validate and set R Server Host info
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		To validate and set R Server Host Info
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetRServerHostInfo <<<'

IF EXISTS (select * from sysobjects where name='AppSetRServerHostInfo')
	drop procedure AppSetRServerHostInfo
IF EXISTS (select * from GxQscripts where name='AppSetRServerHostInfo')
	delete from GxQscripts where name = 'AppSetRServerHostInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetRServerHostInfo')
	delete from GXDBVersions where aliasname = 'AppSetRServerHostInfo'
GO
print '... Creating Procedure: AppSetRServerHostInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetRServerHostInfo
  @xmlText XML,
  @operatioNType INT
AS
  DECLARE @errorCode INT = 0
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @nowTime        INT = dbo.GetUnixTime (GetUTCdate())
    DECLARE @hostName NVARCHAR(256)
	DECLARE @id NVARCHAR(16)
	SET @hostName = ISNULL((SELECT  ref.value('@hostname', 'NVARCHAR(256)')
                                      FROM    @xmlText.nodes('/App_RServerHostInfo') R ( ref )),'')
	SET @id = ISNULL((SELECT  ref.value('@id', 'NVARCHAR(16)')
                                      FROM    @xmlText.nodes('/App_RServerHostInfo') R ( ref )),'')
  	IF @operationType = 2 -- DELETE Operation
    BEGIN
		DELETE FROM APP_ExtendedProperties WHERE attrType = 131 AND clientId = 1 AND modified = 0 AND MD5 = @id
	END
	IF @operationType = 1 --ADD Operation
    BEGIN
		IF EXISTS (SELECT 1 FROM APP_ExtendedProperties WITH (NOLOCK) WHERE attrType = 131 AND modified = 0 AND clientId = 1 AND attrName = @hostName)
		BEGIN
SET @errorCode = (3314 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		DECLARE @maxId INT = ISNULL((SELECT MAX(CAST(MD5 AS INT)) FROM APP_ExtendedProperties WITH (NOLOCK) WHERE attrType = 131 AND modified = 0 AND clientId = 1), 0) + 1
		SET @id = CAST(@maxId AS NVARCHAR(16))
		IF @xmlText.exist('(/App_RServerHostInfo/@id)[1]') = 1
			SET @xmlText.modify('replace value of (/App_RServerHostInfo/@id)[1] with sql:variable("@id")')
		ELSE
			SET @xmlText.modify('insert attribute id {sql:variable("@id")} into (/App_RServerHostInfo)[1]')
		INSERT INTO APP_ExtendedProperties(clientId, appTypeId, instance, backupSet, subclientId, attrType,attrName, attrVal, MD5, created, modified, ccpId)
		VALUES(1, 0, 0, 0, 0, 131, @hostName, CAST(@xmlText AS NVARCHAR(MAX)), @id, @nowTime,0,0)
    END
	IF @operationType = 3 -- MODIFY Operation
    BEGIN
		IF EXISTS (SELECT 1 FROM APP_ExtendedProperties WITH (NOLOCK) WHERE attrType = 131 AND modified = 0 AND clientId = 1 AND attrName = @hostName AND MD5 <> @id)
		BEGIN
SET @errorCode = (3314 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		UPDATE APP_ExtendedProperties SET attrName = @hostName, attrVal = CAST(@xmlText AS NVARCHAR(MAX)), created = @nowTime WHERE attrType = 131 AND clientId = 1 AND modified = 0 AND MD5 = @id
    END
    ERROR_EXIT:
   SELECT @errorCode AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetRServerHostInfo')
	delete from GxQscripts where name = 'AppSetRServerHostInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetRServerHostInfo')
	delete from GXDBVersions where aliasname = 'AppSetRServerHostInfo'
GO

insert into GXDBVersions values(2, 'AppSetRServerHostInfo',  '00000000000000000000', 'AppSetRServerHostInfo', '00000000000000000000')
GO

