

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetPushNotificationConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetPushNotificationConfig.sp,v $ $Id: AppSetPushNotificationConfig.sp,v 1.1.2.3 2018/09/16 03:35:10 vdevassy Exp $";
-- =============================================================
-- Author:		Rohit Iyer
-- Create date: 03/14/2018
-- Description:	Set configuration details for Push notification
-- =============================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetPushNotificationConfig <<<'

IF EXISTS (select * from sysobjects where name='AppSetPushNotificationConfig')
	drop procedure AppSetPushNotificationConfig
IF EXISTS (select * from GxQscripts where name='AppSetPushNotificationConfig')
	delete from GxQscripts where name = 'AppSetPushNotificationConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPushNotificationConfig')
	delete from GXDBVersions where aliasname = 'AppSetPushNotificationConfig'
GO
print '... Creating Procedure: AppSetPushNotificationConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetPushNotificationConfig
  @in_xml XML
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @userId						      		INT
DECLARE @localeId           					INT
DECLARE @isAdminUser        					INT
DECLARE @bDisableMobileNotification      		INT
DECLARE @mobileNotificationServerId			    INT
DECLARE @mobileActiveMQServerId				    INT
DECLARE @bMobileNotificatonFreq		      		INT
DECLARE @nowTime							INT
DECLARE @errorCode 							INT
DECLARE @errorMessage 						VARCHAR(MAX)
declare @outXml								xml
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
select  @userId 						= isnull(userRef.value('@userId', 'int'),0),
		@localeId 						= isnull(locRef.value('@localeId', 'int'),0),
		@bDisableMobileNotification 	= isnull(pushServerRef.value('../@disableMobilePushNotification', 'int'),0),
		@mobileNotificationServerId 	= isnull(pushServerRef.value('@clientId', 'int'),0),
		@mobileActiveMQServerId 		= isnull(activeMqRef.value('@clientId', 'int'),0),
		@bMobileNotificatonFreq 		= isnull(pushServerRef.value('../@consumerSleepDurationInMins', 'int'),2)
FROM    @in_xml.nodes('App_SetPushNotificationConfigReq') A ( ref )
		outer apply ref.nodes('./pushConfig/mobilePushServer') B ( pushServerRef )
		outer apply ref.nodes('./pushConfig/mobileActiveMQServer') C ( activeMqRef )
        outer apply ref.nodes('./processinginstructioninfo/user') D ( userRef )
		outer apply ref.nodes('./processinginstructioninfo/locale') E ( locRef )
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId))
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	SET @errorMessage = REPLACE(@errorMessage, '^1%s', @userId)
	GOTO SEND_RESPONSE
END
--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO SEND_RESPONSE
END
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRAN
	--1. Update property for disabling mobile notifications
	if(exists(select 1 from GxGlobalParam with(nolock) where name = 'bDisableMobilePushNotification'))
	begin
		update GxGlobalParam set value = CAST(@bDisableMobileNotification as nvarchar(10)) where name = 'bDisableMobilePushNotification'
	end
	else
	begin
		insert into GxGlobalParam(name, value, created, modified)
		values('bDisableMobilePushNotification', @bDisableMobileNotification, @nowTime, 0)
	end
	--2. Update property to set Mobile notification server
	if(exists(select 1 from GxGlobalParam with(nolock) where name = 'mobilePushServerId'))
	begin
		update GxGlobalParam set value = CAST(@mobileNotificationServerId as nvarchar(10)) where name = 'mobilePushServerId'
	end
	else
	begin
		insert into GxGlobalParam(name, value, created, modified)
		values('mobilePushServerId', @mobileNotificationServerId, @nowTime, 0)
	end
	--3. Update property to set Mobile ActiveMQ server
	if(exists(select 1 from GxGlobalParam with(nolock) where name = 'mobileActiveMQServerId'))
	begin
		update GxGlobalParam set value = CAST(@mobileActiveMQServerId as nvarchar(10)) where name = 'mobileActiveMQServerId'
	end
	else
	begin
		insert into GxGlobalParam(name, value, created, modified)
		values('mobileActiveMQServerId', @mobileActiveMQServerId, @nowTime, 0)
	end
	--4. Update property to set mobile notification frequency
	if(exists(select 1 from GxGlobalParam with(nolock) where name = 'bMobilePushConsumerSleepInMins'))
	begin
		update GxGlobalParam set value = CAST(@bMobileNotificatonFreq as nvarchar(10)) where name = 'bMobilePushConsumerSleepInMins'
	end
	else
	begin
		insert into GxGlobalParam(name, value, created, modified)
		values('bMobilePushConsumerSleepInMins', @bMobileNotificatonFreq, @nowTime, 0)
	end
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SET @outXml = ( SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString'
                 FOR xml path('error'),ROOT('App_SetPushNotificationConfigResp')
               )
select @outXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetPushNotificationConfig')
	delete from GxQscripts where name = 'AppSetPushNotificationConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPushNotificationConfig')
	delete from GXDBVersions where aliasname = 'AppSetPushNotificationConfig'
GO

insert into GXDBVersions values(2, 'AppSetPushNotificationConfig',  '00010001000200030000', 'AppSetPushNotificationConfig', '00010001000200030000')
GO

