

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetPre80GlobalFilterSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetPre80GlobalFilterSettings.sp,v $ $Id: AppSetPre80GlobalFilterSettings.sp,v 1.6.60.2 2018/03/22 01:32:07 jiechen Exp $";
-------------------------------------------
-- Name:			AppSetPre80GlobalFilterSettings
-- Date:			09-Sep-2009
-- Author:			SKatz
-- Description:		Sets 'default' global filter properties for pre-8.0
--                  subClients
-- TR(original):	090818-000210
-- Customer:		Rackspace Ltd.
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetPre80GlobalFilterSettings <<<'

IF EXISTS (select * from sysobjects where name='AppSetPre80GlobalFilterSettings')
	drop procedure AppSetPre80GlobalFilterSettings
IF EXISTS (select * from GxQscripts where name='AppSetPre80GlobalFilterSettings')
	delete from GxQscripts where name = 'AppSetPre80GlobalFilterSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPre80GlobalFilterSettings')
	delete from GXDBVersions where aliasname = 'AppSetPre80GlobalFilterSettings'
GO
print '... Creating Procedure: AppSetPre80GlobalFilterSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetPre80GlobalFilterSettings
AS
--SET ANSI_PADDING ON
--GO
--SET ARITHABORT ON
--GO
--SET QUOTED_IDENTIFIER ON
--GO
--Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName					varchar(40)
SET		@scriptName					= 'Pre80GlobalFilterSettings'
DECLARE	@CV_USE_GLOBAL_FILTERS		varchar(40)
SET		@CV_USE_GLOBAL_FILTERS 		= 'use global filters'
DECLARE	@CV_USE_CS_SETTING_FOR_GF	varchar(40)
SET		@CV_USE_CS_SETTING_FOR_GF 	= 'use cs setting for global filters'
DECLARE @CV_ASSOC_SUBCLIENT_POLICY	varchar(40)
SET		@CV_ASSOC_SUBCLIENT_POLICY  = 'Associated subclient Policy'
DECLARE	@CV_IGNORE_STATUS			integer
SET		@CV_IGNORE_STATUS			= 4+16		--DELETED, DUMMY
DECLARE	@RELEASE_ID_80				integer
SET		@RELEASE_ID_80				= 13
DECLARE @AFFECTED_COUNT				integer
SET		@AFFECTED_COUNT				= 0
--#define CV_USE_CS_SETTING_FOR_GF	""
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError				= 0		-- Be optimistic
DECLARE @nowTime        integer
SET     @nowTime        = dbo.GetUnixTime (GetUTCdate())
BEGIN TRAN
------------------------------------------------
-- DO THE WORK!								----
------------------------------------------------
DECLARE	@releaseId				integer
DECLARE @clientId				integer
DECLARE @appTypeId				integer
DECLARE @backupsetId			integer
DECLARE @subClientId 			integer
DECLARE @useGlobalfiltersProp	integer			-- Current value for ..
DECLARE @useCellLevelProp		integer			-- Current value for ..
DECLARE	@newPropValue			integer			-- Will be used to "fix" props stored
DECLARE @UsingSubClientPolicy	integer
DECLARE @oldClientId			integer
SET		@oldClientId			= 0				-- Will save some 'releaseId' fetches!
BEGIN TRY
	DECLARE appCursor CURSOR STATIC FOR
		SELECT id, clientId, appTypeId, backupset from app_application
			WHERE  appTypeId <> 1000
			  AND  (subclientStatus & @CV_IGNORE_STATUS) = 0
				order by clientId, id
	OPEN appCursor
	FETCH NEXT FROM appCursor INTO @subClientId, @clientId, @appTypeId, @backupsetid
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @clientId <> @oldClientId
		BEGIN
			SET @releaseId				= ISNULL((Select releaseId from app_client where id = @clientId), 0)
			SET @oldClientId = @clientId
		END
		SET @useGlobalfiltersProp	= ISNULL((Select top 1 attrVal from app_subClientProp
                                               			where componentNameId = @subClientId and attrName = @CV_USE_GLOBAL_FILTERS and modified = 0 order by created desc), -1)
		SET @useCellLevelProp		= ISNULL((Select top 1 attrVal from app_subClientProp
                                               			where componentNameId = @subClientId and attrName = @CV_USE_CS_SETTING_FOR_GF and modified = 0 order by created desc), -1)
		SET @UsingSubClientPolicy	= ISNULL((Select top 1 attrVal from app_backupsetProp
												where componentNameId = @backupsetId and attrName = @CV_ASSOC_SUBCLIENT_POLICY and modified = 0), 0)
		SET @newPropValue			= 0		-- MOST LIKELY VALUE TO BE SET
		--Select step='debug1', subClientId=@subclientId, clientId=@clientId, useGlobalfiltersProp=@useGlobalfiltersProp, useCellLevelProp=@useCellLevelProp
		----------------------------------------------------------------------
		-- NEED TO CHECK ALL THE PERMUTATIONS OF @useGlobalfiltersProp and	--
		-- @useCellLevelProp, THEN TEMPER ACTION BASED ON @releaseId		--
		----------------------------------------------------------------------
		If @appTypeId = 1030
 			AND	  			-- DEFECT 63532: Cell level Policy being turned off for SubClient Policy on CS upgrade
				NOT EXISTS (Select id from app_subClientProp WHERE componentNameId = @subclientId
				  AND attrName        = @CV_USE_CS_SETTING_FOR_GF
				  AND modified		  = 0)											-- In 8.0, "Cell Policy" is not exposed in GUI, so regardless of client
			GOTO ADD_CELL_LEVEL_PROP									-- release level, must always set this property to 'false'!
		IF @UsingSubClientPolicy  <> 0									-- IF subClient is already part of a subClient policy, don't add any
			GOTO NEXT_SUBCLIENT											-- 'new' properties to it.
		If @useGlobalfiltersProp = 1 AND @useCellLevelProp = 1			-- HAVE SEEN THIS ON CUST DB!
		BEGIN
			UPDATE APP_SUBCLIENTPROP
				SET attrVal = '0'									-- Since appMgr would have used cell policy precedence
					WHERE componentNameId = @subclientId			-- .. set "use global filters" off for consistency
					  AND attrName = @CV_USE_GLOBAL_FILTERS
					  AND modified = 0
			SET @AFFECTED_COUNT = @AFFECTED_COUNT +1
--			PRINT 'Fixed prop ['+ @CV_USE_GLOBAL_FILTERS + '] for subClient[' + convert(varchar(8), @subClientId) + '].'
			GOTO NEXT_SUBCLIENT
		END
		If @useCellLevelProp = -1										-- THIS IS THE MAJOR ISSUE, WHERE NO CELL LEVEL PROP IS SET!
		BEGIN
			IF @useGlobalfiltersProp <> -1								-- 'Use Global Filter' Explicity set, so set 'use cell level policy = 0
				GOTO ADD_CELL_LEVEL_PROP
			IF @releaseId < @RELEASE_ID_80								-- PRE 8.0, there was no 'Use Cell Level Prop', so set
				GOTO ADD_CELL_LEVEL_PROP								--		'use cell level policy' to 0 here too
			SET @newPropValue = 1										-- must be 8.0 or greater, so default in this case is to use cell level policy!
			GOTO ADD_CELL_LEVEL_PROP
		END
/*		DON'T NEED TO DO ANYTHING FOR THESE, BUT LEAVE HERE FOR 'DOCUMENTATION' PURPOSES
		If	(@useGlobalfiltersProp = 0 AND @useCellLevelProp = 0) OR
			(@useGlobalfiltersProp = 1 AND @useCellLevelProp = 0) OR
			(@useGlobalfiltersProp = 0 AND @useCellLevelProp = 1)
*/
		GOTO NEXT_SUBCLIENT						-- NO OTHER 'CASES' NEED TO BE CONSIDERED
ADD_CELL_LEVEL_PROP:
		IF @newPropValue = @useCellLevelProp				-- IF NEW PROP IS SAME AS OLD, NO NEED TO WRITE TO DB
			GOTO NEXT_SUBCLIENT
		IF @useCellLevelProp <> -1							-- Property Already existed, and value has changed so
			UPDATE APP_SubClientProp						-- we need to "age" the old value off first
				SET modified = @nowtime
				WHERE componentNameId = @subclientId
				  AND attrName        = @CV_USE_CS_SETTING_FOR_GF
				  AND modified		  = 0
															-- Property is new or old has aged off, so insert "new" values
		INSERT APP_SubClientProp(componentNAmeId, attrNAme, attrType, attrVal, created, modified)
			VALUES (@subClientId, @CV_USE_CS_SETTING_FOR_GF, 2, convert(nvarchar(10), @newPropValue), @nowTime, 0)
		SET @AFFECTED_COUNT = @AFFECTED_COUNT +1
--		PRINT 'Added prop ['+ @CV_USE_CS_SETTING_FOR_GF + ']=[' +convert(varchar(10), @newPropValue)
--			+'] for client[' +convert(varchar(10), @clientId) + '], subClient[' + convert(varchar(8), @subClientId) + '].'
		GOTO NEXT_SUBCLIENT
NEXT_SUBCLIENT:
		FETCH NEXT FROM appCursor INTO @subClientId, @clientId, @appTypeId, @backupsetId
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END CATCH
CLOSE       appCursor
DEALLOCATE  appCursor
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
IF (@lastError  = 0)
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
--ARGS_ERROR:
IF @lastError <> 0
BEGIN
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + '. Exit Code(' +convert(varchar(8), @lastError) + ').'
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetPre80GlobalFilterSettings')
	delete from GxQscripts where name = 'AppSetPre80GlobalFilterSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPre80GlobalFilterSettings')
	delete from GXDBVersions where aliasname = 'AppSetPre80GlobalFilterSettings'
GO

insert into GXDBVersions values(2, 'AppSetPre80GlobalFilterSettings',  '00010006006000020000', 'AppSetPre80GlobalFilterSettings', '00010006006000020000')
GO

