

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetPendingEndUserEraseStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetPendingEndUserEraseStatus.sp,v $ $Id: AppSetPendingEndUserEraseStatus.sp,v 1.2.80.1 2018/03/22 01:45:04 jiechen Exp $";
-- =============================================
-- Author:		Paul Mazur
-- Create date: 12/01/2013
-- Description:	checking is endUserErase pending for the given AppId
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetPendingEndUserEraseStatus <<<'

IF EXISTS (select * from sysobjects where name='AppSetPendingEndUserEraseStatus')
	drop procedure AppSetPendingEndUserEraseStatus
IF EXISTS (select * from GxQscripts where name='AppSetPendingEndUserEraseStatus')
	delete from GxQscripts where name = 'AppSetPendingEndUserEraseStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPendingEndUserEraseStatus')
	delete from GXDBVersions where aliasname = 'AppSetPendingEndUserEraseStatus'
GO
print '... Creating Procedure: AppSetPendingEndUserEraseStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetPendingEndUserEraseStatus
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_appId integer,
  @i_status integer
AS
SET NOCOUNT ON
BEGIN
--no more erases present
IF (@i_status = 0)
BEGIN
DELETE FROM APP_SubClientProp where AttrName='EndUser Erase Enabled' and componentNameId=@i_appId
END
IF (@i_status = 1)
BEGIN
IF (not exists (SELECT attrVal FROM APP_SubClientProp where AttrName='EndUser Erase Enabled' and componentNameId=@i_appId))
  insert into APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified) values ( @i_appId, 'EndUser Erase Enabled', 7, 1, dbo.getunixtime(GETUTCDATE()), 0)
else
  UPDATE APP_SubClientProp set attrVal='1', modified=dbo.getunixtime(GETUTCDATE())  where AttrName='EndUser Erase Enabled' and componentNameId=@i_appId
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetPendingEndUserEraseStatus')
	delete from GxQscripts where name = 'AppSetPendingEndUserEraseStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPendingEndUserEraseStatus')
	delete from GXDBVersions where aliasname = 'AppSetPendingEndUserEraseStatus'
GO

insert into GXDBVersions values(2, 'AppSetPendingEndUserEraseStatus',  '00010002008000010000', 'AppSetPendingEndUserEraseStatus', '00010002008000010000')
GO

