

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetPasskeyOnEntity.sp] ---------- 

--  +=============================================================================================+
--  |						Name: AppSetPasskeyOnEntity()
--  | Description: Sets passkey on provided entity
--  |
--  |       Input: XML
--  |      Output: errorCode, errorString
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetPasskeyOnEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppSetPasskeyOnEntity <<<'
	drop procedure AppSetPasskeyOnEntity
END
IF EXISTS (select * from GxQscripts where name='AppSetPasskeyOnEntity')
	delete from GxQscripts where name = 'AppSetPasskeyOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPasskeyOnEntity')
	delete from GXDBVersions where aliasname = 'AppSetPasskeyOnEntity'
GO
print '... Creating Procedure: AppSetPasskeyOnEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetPasskeyOnEntity
  @i_xmlText XML
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(max)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @userId INT = 0
	DECLARE @localeId INT = 0
	DECLARE @entityId INT = 0
	DECLARE @entityType INT = 0
	DECLARE @passkeyOpType INT = 0
	DECLARE @newPasskey NVARCHAR(MAX) = ''
	DECLARE @currentPasskey NVARCHAR(MAX) = ''
	DECLARE @time INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @passkeyInDB NVARCHAR(MAX) = ''
	DECLARE @isStrongPwd INT = 0
	DECLARE @psErrorCode int = 0
	DECLARE @psErrorString NVARCHAR(MAX) = ''
	SET @errorCode = 0
	SET @errorString = N''
	SET @localeId = ISNULL(@i_xmlText.value('(//App_SetPasskeyRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
							FROM @i_xmlText.nodes ('App_SetPasskeyRequest/processinginstructioninfo/user') R(ref)), 0)
	SET @entityType = ISNULL(@i_xmlText.value('(//App_SetPasskeyRequest/entity/@_type_)[1]', 'int') , 0)
IF(@entityType = 3)
	BEGIN
		SET @entityId = ISNULL(@i_xmlText.value('(//App_SetPasskeyRequest/entity/@clientId)[1]', 'int') , 0)
	END
	ELSE
	BEGIN
		SET @entityId = ISNULL(@i_xmlText.value('(//App_SetPasskeyRequest/company/@providerId)[1]', 'int') , -1)
		IF @entityId = -1
		BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
		ELSE
		BEGIN
-- SET @entityType = (CASE WHEN @entityId = 0 THEN 1 ELSE 61 END)
SET @entityType = 61
		END
	END
	SET @passkeyOpType = ISNULL(@i_xmlText.value('(//App_SetPasskeyRequest/@passkeyOpType)[1]', 'int') , 0)
	DECLARE @companyId INT
	DECLARE @allowSettingPasskeyCommCell INT = -1
	DECLARE @allowSettingPasskeyCompany INT = -1
	DECLARE @isUserMSPAdmin INT = 0, @isTenantAdmin INT = 0
	-- GET COMPANY ID
IF (@entityType = 3)
	BEGIN
		-- get companyId given clientId
SET @companyId = ISNULL((SELECT CONVERT(INTEGER,attrval) FROM APP_ClientProp WHERE attrname='Installation Company ID' AND componentNameId=@entityId AND modified=0) , -1)
		-- Some clients could have 0 as their "Installation company ID" for reasons like MSP admin creds were used during installation, so we need to check smart client group info to get true company Id
		IF @companyId = -1 OR @companyId = 0
		BEGIN
			SET @companyId = ISNULL((SELECT TOP 1 ACP.componentNameId FROM APP_Client AC
									INNER JOIN APP_ClientGroupAssoc ACGA ON AC.id = ACGA.clientId
									INNER JOIN App_CompanyProp ACP ON ACP.attrVal = CAST(ACGA.clientGroupId AS NVARCHAR(12))
AND ACP.attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') AND ACP.modified = 0
									WHERE AC.id = @entityId), 0)
		END
	END
ELSE IF (@entityType = 61)
	BEGIN
		SET @companyId = @entityId
	END
	-- CHECK IF USER IS TENANT ADMIN
IF EXISTS(SELECT 1 FROM UMUserGroup UU WITH(NOLOCK) INNER JOIN UMGroups UG WITH(NOLOCK) ON UU.groupId=UG.id WHERE UG.groupFlags & 0x10000 <> 0 and UU.userId=@userId)
	BEGIN
		DECLARE @cmpId INT = -1
		Select @cmpId=U.id from UMDSProviders U WITH(NOLOCK) inner join UMUsers Users WITH(NOLOCK) on U.id=Users.umDSproviderId where Users.id = @userId
		IF(@cmpId IS NOT NULL AND @companyId = @cmpId)
		BEGIN
			SET @isTenantAdmin = 1
		END
	END
	-- check if user is MSP admin
IF EXISTS(SELECT 1 FROM UMUserGroup UU WITH(NOLOCK) INNER JOIN UMGroups UG WITH(NOLOCK) ON UU.groupId=UG.id WHERE UG.groupFlags & 0x0008 <> 0 and UU.userId=@userId)
	BEGIN
		SET @isUserMSPAdmin = 1
		SET @isTenantAdmin = 1
	END
	IF @passkeyOpType = 1 -- Check if passkey feature is enabled when CREATING passkey
	BEGIN
		-- CHECK IF PASSKEY FEATURE IS ENABLED AT COMMCELL LEVEL
SET @allowSettingPasskeyCommCell = ISNULL((SELECT CAST(value AS INTEGER) FROM GXGlobalParam WHERE name = 'AllowSettingPasskey' AND modified = 0),0)
		IF @companyId <> 0	-- MEANING GIVEN CLIENT BELONGS TO A COMPANY
		BEGIN
			-- CHECK IF PASSKEY FEATURE IS ENABLED AT COMPANY LEVEL
			SET @allowSettingPasskeyCompany = ISNULL((SELECT attrVal FROM App_CompanyProp WHERE componentNameId = @companyId
AND attrName = 'AllowSettingPasskey'
																						AND modified = 0
AND cs_attrName = CHECKSUM('AllowSettingPasskey')),
ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'AllowSettingPasskey' AND modified = 0), 0))
		END
IF (@entityType = 3)
		BEGIN
			-- WHEN SET PASSKEY AT CLIENT LEVEL, IF PASSKEY FEATURE IS NOT ENABLED AT COMMCELL LEVEL, THEN DONT ALLOW
			IF @allowSettingPasskeyCommCell = 0
			BEGIN
SET @errorCode = (4509 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
			ELSE
			BEGIN
				-- WHEN SET PASSKEY AT CLIENT LEVLE, WHICH BELONGS TO A COMPANY, IF ALTHOUGH PASSKEY FEATURE IS ENABLED AT COMMCELL LEVEL, BUT IS NOT ENABLED AT COMPANY LEVEL, THEN DONT ALLOW
				IF @allowSettingPasskeyCompany = 0
				BEGIN
SET @errorCode = (4509 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					GOTO PROC_EXIT
				END
			END
		END
ELSE IF (@entityType = 61)
		BEGIN
			IF @entityId = 0
			BEGIN
				-- WHEN SET PASKSEY AT COMMCELL LEVEL, IF THE USER IS NOT A MSP ADMIN, THEN DONT ALLOW
				IF @isUserMSPAdmin = 0
				BEGIN
SET @errorCode = (4509 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					GOTO PROC_EXIT
				END
			END
			ELSE
			BEGIN
				-- WHEN SET PASSKEY AT COMPANY LEVEL, IF PASSKEY FEATURE IS NOT ENABLED AT COMMCELL LEVEL OR USER IS NOT A TENANT ADMIN, THEN DONT ALLOW
				IF @allowSettingPasskeyCommCell = 0 OR @isTenantAdmin = 0
				BEGIN
SET @errorCode = (4509 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					GOTO PROC_EXIT
				END
			END
		END
	END
	ELSE IF @passkeyOpType = 2 OR @passkeyOpType = 3	-- Check if passkey has been enabled when UPDATING/DISABLING passkey
	BEGIN
		DECLARE @authType NVARCHAR
IF (@entityType = 3)
		BEGIN
SET @authType = ISNULL((SELECT attrVal FROM App_ClientProp WHERE componentNameId = @entityId AND attrName = 'AuthorizationType' AND modified = 0), '1')
		END
ELSE IF (@entityType = 61)
		BEGIN
SET @authType = ISNULL((SELECT attrVal FROM App_CompanyProp WHERE componentNameId = @entityId AND attrName = 'AuthorizationType' AND modified = 0 AND cs_attrName = CHECKSUM('AuthorizationType')), '1')
		END
		IF @authType <> '2'
		BEGIN
SET @errorCode = (4510 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
	END
	ELSE
	BEGIN	-- Incorrect passkey operation type
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	SET @currentPasskey = ISNULL(@i_xmlText.value('(//App_SetPasskeyRequest/@currentPasskey)[1]', 'nvarchar(max)') , '')
	IF (@passkeyOpType = 2) -- EDIT PASSKEY
	BEGIN
		SET @newPasskey = ISNULL(@i_xmlText.value('(//App_SetPasskeyRequest/@newPasskey)[1]', 'nvarchar(max)') , '')
	END
	-- passkey extraction and validation
	-- Passkey is in base64encoded->V3encrypted format
	IF((CHARINDEX('|#',@currentPasskey, 1)) >0 )
	BEGIN
		SET @currentPasskey=(select dbo.DecodeInvalidXMLChar(@currentPasskey))
		SET @currentPasskey = SUBSTRING(@currentPasskey,2,LEN(@currentPasskey))
	END
	SET @currentPasskey = dbo.base64Decode(@currentPasskey)
	IF @passkeyOpType = 1 -- EDIT OR DISABLE PASSKEY(SKIP CHECK ON PASSKEY COMPLEXITY - USER ALREADY SET IT)
	BEGIN
		-- Passkey complexity validation
		EXEC sec_isPasswordStrong @currentPasskey, @isStrongPwd OUTPUT, @psErrorString  OUTPUT, @localeId, @psErrorCode OUTPUT
		IF @isStrongPwd = 0
		BEGIN
IF @psErrorCode = (3507 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			BEGIN
SET @errorCode = (4393 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			END
ELSE IF @psErrorCode = (3508 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			BEGIN
SET @errorCode = (4394 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			END
			ELSE
			BEGIN
				SET @errorCode = @psErrorCode
				SET @errorString = @psErrorString
			END
			GOTO PROC_EXIT
		END
	END
	IF(@passkeyOpType = 2) -- EDIT PASSKEY
	BEGIN
		SET @isStrongPwd = 0
		IF((CHARINDEX('|#',@newPasskey, 1)) >0 )
		BEGIN
			SET @newPasskey=(select dbo.DecodeInvalidXMLChar(@newPasskey))
			SET @newPasskey = SUBSTRING(@newPasskey,2,LEN(@newPasskey))
		END
		SET @newPasskey = dbo.base64Decode(@newPasskey)
		-- Passkey complexity validation
		EXEC sec_isPasswordStrong @newPasskey, @isStrongPwd OUTPUT, @psErrorString  OUTPUT, @localeId, @psErrorCode OUTPUT
		IF @isStrongPwd = 0
		BEGIN
IF @psErrorCode = (3507 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			BEGIN
SET @errorCode = (4393 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			END
ELSE IF @psErrorCode = (3508 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			BEGIN
SET @errorCode = (4394 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			END
			ELSE
			BEGIN
				SET @errorCode = @psErrorCode
				SET @errorString = @psErrorString
			END
			GOTO PROC_EXIT
		END
	END
IF (@entityType = 3) -- passkey is set at client entity level
	BEGIN
		-- First, check if user is client owner
		DECLARE @isClientOwner int = 0;
		SELECT @isClientOwner = dbo.IsClientOwner(@entityId,@userId)
		IF (@isClientOwner = 0)
		BEGIN
SET @errorCode = (2845 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (2845 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s',(SELECT login FROM UMUsers WITH (NOLOCK) WHERE id = @userId))
			SET @errorString = REPLACE(@errorString, '^2%s',(SELECT ISNULL((SELECT name FROM App_Client WITH(NOLOCK) WHERE id = @entityId),'InvalidClientName')))
			GOTO PROC_EXIT
		END
		IF(@passkeyOpType = 1) -- CREATE PASSKEY. STORE IN DB
		BEGIN
			-- Update passkey in DB
IF EXISTS(SELECT 1 FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0' AND modified = 0)
UPDATE App_ClientProp SET attrVal = @currentPasskey WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0' AND modified = 0 AND attrVal <> @currentPasskey
			ELSE
INSERT INTO App_ClientProp(ComponentNameId, attrName, attrVal, attrType, created, modified, ccpId) values(@entityId, 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0', @currentPasskey, 1, @time, 0, 0)
			-- Update authorization type in DB to 2 (USE_PASSKEY)
IF EXISTS(SELECT 1 FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'AuthorizationType' AND modified = 0)
UPDATE App_ClientProp SET attrVal = '2' WHERE componentNameId = @entityId AND attrName = 'AuthorizationType' AND modified = 0 AND attrVal <> '2'
			ELSE
INSERT INTO App_ClientProp(ComponentNameId, attrName, attrVal, attrType, created, modified, ccpId) values(@entityId, 'AuthorizationType', '2', 7, @time, 0, 0)
			GOTO PROC_EXIT
		END
		ELSE IF(@passkeyOpType = 3) -- DISABLE PASSKEY. DONT REMOVE FROM DB (expensive). UPDATE AUTHTYPE
		BEGIN
			-- Verify if user supplied correct passkey
SELECT @passkeyInDB = attrVal FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0' AND modified = 0
			IF (@passkeyInDB <> @currentPasskey)
			BEGIN
SET @errorCode = (3968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
			-- Set authorization type to USE_LOGIN (1)
UPDATE App_ClientProp SET attrVal = '1' WHERE componentNameId = @entityId AND attrName = 'AuthorizationType' AND modified = 0 AND attrVal <> '1'
			-- Remove the list of auth users
UPDATE App_ClientProp SET attrVal = '' WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore' AND modified = 0 AND attrVal <> ''
			GOTO PROC_EXIT
		END
		ELSE IF (@passkeyOpType = 2) -- FOR EDIT PASSKEY CHECK NEWPASSKEY AS WELL AS CURRENTPASSKEY(done above)
		BEGIN
			-- Verify if user supplied correct passkey
SELECT @passkeyInDB = attrVal FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0' AND modified = 0
			IF (@passkeyInDB <> @currentPasskey)
			BEGIN
SET @errorCode = (3968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
			-- Update passkey in DB
IF EXISTS(SELECT 1 FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0' AND modified = 0)
UPDATE App_ClientProp SET attrVal = @newPasskey WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0' AND modified = 0 AND attrVal <> @newPasskey
			ELSE
INSERT INTO App_ClientProp(ComponentNameId, attrName, attrVal, attrType, created, modified, ccpId) values(@entityId, 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0', @newPasskey, 1, @time, 0, 0)
			GOTO PROC_EXIT
		END
	END
ELSE IF (@entityType = 61) -- passkey is set at company entity level
	BEGIN
		IF @entityId = 0 -- commcell
		BEGIN
			DECLARE @canManageProvider INT=0
EXEC sec_checkPermissionOnEntity @userId, 1, @canManageProvider OUTPUT, 61, @entityId
			IF @canManageProvider <> 1
			BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
		END
		ELSE
		BEGIN
			If(@isTenantAdmin = 0)
			BEGIN
SET @errorCode = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
		END
		IF(@passkeyOpType = 1) -- CREATE PASSKEY. STORE IN DB
		BEGIN
			-- Update passkey in DB
UPDATE App_CompanyProp SET attrVal = @currentPasskey WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0'
AND modified=0 AND cs_attrName=checksum('b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0')
			IF(@@ROWCOUNT = 0)
			BEGIN
				INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@entityId, 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0', 1, @currentPasskey, @time, 0)
			END
			-- Update authorization type in DB to 2 (USE_PASSKEY)
UPDATE App_CompanyProp SET attrVal = '2' WHERE componentNameId = @entityId AND attrName = 'AuthorizationType'
AND modified=0 AND cs_attrName=checksum('AuthorizationType')
			IF(@@ROWCOUNT = 0)
			BEGIN
				INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@entityId, 'AuthorizationType', 7, '2', @time, 0)
			END
			GOTO PROC_EXIT
		END
		ELSE IF(@passkeyOpType = 3) -- DISABLE PASSKEY. DONT REMOVE FROM DB (expensive). UPDATE AUTHTYPE
		BEGIN
			-- Verify if user supplied correct passkey
SELECT @passkeyInDB = attrVal FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0'
AND modified=0 AND cs_attrName=checksum('b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0')
			IF (@passkeyInDB <> @currentPasskey)
			BEGIN
SET @errorCode = (3968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
			-- Set authorization type to USE_LOGIN (1)
UPDATE App_CompanyProp SET attrVal = '1' WHERE componentNameId = @entityId AND attrName = 'AuthorizationType'
AND modified=0 AND cs_attrName=checksum('AuthorizationType') AND attrVal <> '1'
			-- Remove the list of auth users
UPDATE App_CompanyProp SET attrVal = '' WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore'
AND modified=0 AND cs_attrName=checksum('AuthorizedUsersForRestore') AND attrVal <> ''
			GOTO PROC_EXIT
		END
		ELSE IF (@passkeyOpType = 2) -- FOR EDIT PASSKEY CHECK NEWPASSKEY AS WELL AS CURRENTPASSKEY(done above)
		BEGIN
			-- Verify if user supplied correct passkey
SELECT @passkeyInDB = attrVal FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0'
AND modified=0 AND cs_attrName=checksum('b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0')
			IF (@passkeyInDB <> @currentPasskey)
			BEGIN
SET @errorCode = (3968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
			-- Update passkey in DB
UPDATE App_CompanyProp SET attrVal = @newPasskey WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0'
AND modified=0 AND cs_attrName=checksum('b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0')
			IF(@@ROWCOUNT = 0)
			BEGIN
				INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@entityId, 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0', 1, @newPasskey, @time, 0)
			END
			GOTO PROC_EXIT
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END CATCH
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode AND localeId = @localeId)
	END
	SELECT @errorCode,@errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetPasskeyOnEntity')
	delete from GxQscripts where name = 'AppSetPasskeyOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetPasskeyOnEntity')
	delete from GXDBVersions where aliasname = 'AppSetPasskeyOnEntity'
GO

insert into GXDBVersions values(2, 'AppSetPasskeyOnEntity',  '00000000000000000000', 'AppSetPasskeyOnEntity', '00000000000000000000')
GO

