

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetOffice365IdxMailboxStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetOffice365IdxMailboxStats.sp,v $ $Id: AppSetOffice365IdxMailboxStats.sp,v 1.1.2.3 2020/09/21 21:28:18 srajani Exp $";
--	+===================================================================+
--	|  				AppSetOffice365IdxMailboxStats				    	|
--	| Procedure for Set mailbox level stats for Office 365 agents	    |
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetOffice365IdxMailboxStats')
BEGIN
	print '>>> Drop Stored Procedure: AppSetOffice365IdxMailboxStats <<<'
	drop procedure AppSetOffice365IdxMailboxStats
END
IF EXISTS (select * from GxQscripts where name='AppSetOffice365IdxMailboxStats')
	delete from GxQscripts where name = 'AppSetOffice365IdxMailboxStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetOffice365IdxMailboxStats')
	delete from GXDBVersions where aliasname = 'AppSetOffice365IdxMailboxStats'
GO
print '... Creating Procedure: AppSetOffice365IdxMailboxStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetOffice365IdxMailboxStats
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inXml XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @subclientId		INT = ISNULL( (SELECT ref.value('@subclientId', 'int') FROM @inXml.nodes('Indexing_SetOffice365MailboxIdxStats') R(ref)), 0)
	DECLARE @appType			INT = ISNULL( (SELECT TOP 1 App.appTypeId from App_Application App WITH(NOLOCK) WHERE App.id = @subclientId), 0)
	Declare @idxAppType			INT = -1
	IF OBJECT_ID('tempdb.dbo.#mailboxAssociation') IS NOT NULL
       DROP TABLE #mailboxAssociation
CREATE TABLE #mailboxAssociation (mbxGuid varchar(40), subclientId INT, mailboxSize BIGINT, itemsIndexed BIGINT, itemsCIed BIGINT, collectionTime INT)
	CREATE CLUSTERED INDEX #mailboxAssociation_userGuid_subclientId_Index ON #mailboxAssociation ([mbxGuid],[subclientId])
	INSERT INTO #mailboxAssociation(mbxGuid, subclientId, mailboxSize, itemsIndexed, itemsCIed, collectionTime)
	SELECT MB.value('@mbxGUID', 'NVARCHAR(MAX)'),
			MB.value('(../@subclientId)','INT'),
			MB.value('@size', 'BIGINT'),
			MB.value('@itemsIndexed', 'BIGINT'),
			MB.value('@itemsContentIndexed', 'INT'),
			MB.value('(../@collectionTime)','INT')
	FROM @inXml.nodes('Indexing_SetOffice365MailboxIdxStats/stats') M(MB)
	--Check if received input has valid values
	IF EXISTS(SELECT TOP 1 1 FROM #mailboxAssociation WHERE subclientId <=0 OR mbxGuid IS NULL)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input received. Check input request. Exiting'
		GOTO ERROR_EXIT
	END
	BEGIN TRANSACTION
IF(@appType IN (134, 78))
		BEGIN
			EXEC AppGetIndexingAppType @appType, @subclientId, @idxAppType OUT, @errorCode OUT
IF(@idxAppType IN ( 200118, 200128, 200127, 78)) -- For OneDrive,SharePoint mailbox info is stored in APP_CloudAppUserDetails
			BEGIN
				UPDATE APP_CloudAppUserDetails
				SET userAccountSize =  MB.mailboxSize, numberOfItems = MB.itemsIndexed, IdxCollectionTime = MB.collectionTime
				FROM #mailboxAssociation MB
				WHERE APP_CloudAppUserDetails.userGuid = MB.mbxGuid AND APP_CloudAppUserDetails.subClientId = MB.subclientId
				AND APP_CloudAppUserDetails.modified=0
				SET @errorCode = @@ERROR
			END
			ELSE
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Unsupported idx app type [' + STR(@idxAppType) +'] for the subclient. Exiting'
				GOTO ERROR_EXIT
			END
		END
		ELSE
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Unsupported app type [' + STR(@appType) +'] for the subclient. Exiting'
			GOTO ERROR_EXIT
		END
	ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
	ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH ('App_GenericResp'), TYPE )
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetOffice365IdxMailboxStats')
	delete from GxQscripts where name = 'AppSetOffice365IdxMailboxStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetOffice365IdxMailboxStats')
	delete from GXDBVersions where aliasname = 'AppSetOffice365IdxMailboxStats'
GO

insert into GXDBVersions values(2, 'AppSetOffice365IdxMailboxStats',  '00010001000200030000', 'AppSetOffice365IdxMailboxStats', '00010001000200030000')
GO

