

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetNodeMetaProp.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSetNodeMetaProp
--  | Description:   set node properties like JVM memory
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetNodeMetaProp.sp,v $ $Id: AppSetNodeMetaProp.sp,v 1.1.4.4 2020/02/11 23:14:45 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetNodeMetaProp')
BEGIN
	print '>>> Drop Stored Procedure: AppSetNodeMetaProp <<<'
	drop procedure AppSetNodeMetaProp
END
IF EXISTS (select * from GxQscripts where name='AppSetNodeMetaProp')
	delete from GxQscripts where name = 'AppSetNodeMetaProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetNodeMetaProp')
	delete from GXDBVersions where aliasname = 'AppSetNodeMetaProp'
GO
print '... Creating Procedure: AppSetNodeMetaProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetNodeMetaProp
  @i_inputXml XML
AS
  DECLARE @o_xmlText XML;
	DECLARE @i_clientId INT
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
                            FROM @i_inputXml.nodes('App_NodeOperation/nodes/nodeClientEntity') R ( ref ) ), 0)
	IF @i_clientId <= 0
		GOTO PROC_EXIT
	--get node properties
	DECLARE @nodeProperties TABLE (t_name NVARCHAR(1024), t_value NVARCHAR(1024))
	INSERT INTO @nodeProperties
	SELECT ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')
	 FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
	 CROSS APPLY R.ref.nodes('nodeMetaInfos') as R1(ref1)
	--in case if no input is provided, nothing to do
	IF NOT EXISTS (SELECT TOP 1 1 FROM @nodeProperties)
		GOTO PROC_EXIT
	DECLARE @cloudType INT =0
	DECLARE @nodeProps TABLE (name NVARCHAR(256), value nvarchar(1024))
	DECLARE @nodePropXml XML
SELECT @nodePropXml = nodeProps , @cloudType = cloudType FROM DM2SearchServerCoreInfo (NOLOCK) WHERE clientId = @i_clientId AND cloudType IN (1, 9) AND ISNULL(nodeProps,'') <> ''
    IF(@nodePropXml IS NOT NULL)
    BEGIN
            INSERT INTO @nodeProps
            SELECT  ref.value('@name', 'NVARCHAR(1024)'),ref.value('@value', 'NVARCHAR(1024)')
            FROM @nodePropXml.nodes ('NodeMetaProp/nodeMetaInfos') R(ref)
			--populate UseDataDirAsCoreRoot, if it is not present at Node Properties
			INSERT INTO @nodeProps (name, value)
			SELECT t_name, t_value
			FROM @nodeProperties N
			LEFT JOIN @nodeProps C ON N.t_name = C.name
WHERE N.t_name = 'UseDataDirAsCoreRoot' AND C.name IS NULL AND @cloudType = 1
			UPDATE @nodeProps
			SET value = N.t_value
			FROM @nodeProperties N
			JOIN  @nodeProps C ON N.t_name = C.name
			WHERE C.name = 'JVMMAXMEMORY'	AND N.t_value >0 AND value != N.t_value
		SET @o_xmlText = (SELECT name as '@name', value AS '@value'
				FROM @nodeProps P
				FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp'))
		UPDATE DM2SearchServerCoreInfo
		SET nodeProps =  cast (@o_xmlText as nvarchar(1024))
WHERE clientId = @i_clientId AND cloudType IN (1, 9) AND ISNULL(nodeProps,'') <> ''
	END
PROC_EXIT:
	IF @o_xmlText IS NULL
		SET @o_xmlText = '<App_NodeOperation/>'
SELECT @o_xmlText AS [o_xmlText]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetNodeMetaProp')
	delete from GxQscripts where name = 'AppSetNodeMetaProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetNodeMetaProp')
	delete from GXDBVersions where aliasname = 'AppSetNodeMetaProp'
GO

insert into GXDBVersions values(2, 'AppSetNodeMetaProp',  '00010001000400040000', 'AppSetNodeMetaProp', '00010001000400040000')
GO

