

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetNavigationSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetNavigationSettings.sp,v $ $Id: AppSetNavigationSettings.sp,v 1.1.2.2 2020/07/05 02:39:06 nshah Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSetIsInfrastructurePropertyForNewClient"	|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetNavigationSettings')
BEGIN
	print '>>> Drop Stored Procedure: AppSetNavigationSettings <<<'
	drop procedure AppSetNavigationSettings
END
IF EXISTS (select * from GxQscripts where name='AppSetNavigationSettings')
	delete from GxQscripts where name = 'AppSetNavigationSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetNavigationSettings')
	delete from GXDBVersions where aliasname = 'AppSetNavigationSettings'
GO
print '... Creating Procedure: AppSetNavigationSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetNavigationSettings
AS
SET NOCOUNT ON
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
/*
1. Find a setup that are not completed
2. Find the clients for these not completed setup.
3. Find the denied navigation items for the not completed setup
4. Tenant:
	4a. If client is found mark that setup completed
	4b. Remove the navitems for this deniedNavItems for tanent admin and tenant user
	4c. Add this setup to the to the supported solutions
5. MSP:
	5a. If client is found mark that setup completed
	5b. Remove the navitems for this deniedNavItems
*/
DECLARE @nowTime   integer =   dbo.GetUnixTime (GetUTCdate())
--Api.x : enum SupportedSolutionsBitValue
DECLARE @SupportedSolutions table(setup nvarchar(50), setupVal int)
INSERT INTO @SupportedSolutions VALUES
('ENDPOINT',4),
('ADMIN_CONSOLE',1),
('OFFICE365',4096),
('VSA',2),
('DBS',8),
('KUBERNETES',18),
('BIG_DATA_APPS',13),
('ACTIVE_DIRECTORY',11),
('SHAREPOINT',9),
('GSUITE',15),
('ARCHIVING',5),
('SALESFORCE',16),
('EXCHANGE',4)
DECLARE @CompletedSetupsToState table(setup nvarchar(50), navItem nvarchar(50) PRIMARY KEY (setup, navItem))
INSERT INTO @CompletedSetupsToState VALUES
('ENDPOINT','devices'),
('ADMIN_CONSOLE','fsServersList'),
('OFFICE365','office365V2'),
('VSA', 'hypervisors'),
('VSA', 'vmGroups'),
('VSA', 'userVMs'),
('DBS', 'instances'),
('DBS', 'sqlserver'),
('DBS', 'dbDatabases'),
('DBS', 'dbCloudEntities'),
('DBS', 'dbInstancesClone'),
('KUBERNETES', 'clusters'),
('KUBERNETES', 'applicationGroups'),
('KUBERNETES', 'applications'),
('BIG_DATA_APPS', 'bigDataApps'),
('ACTIVE_DIRECTORY', 'activeDirectory'),
('SHAREPOINT', 'sharepoint'),
('GSUITE', 'gsuiteApps'),
('ARCHIVING', 'archiveFileServers'),
('SALESFORCE', 'cappsClients'),
('EXCHANGE', 'exchange')
--('EXCHANGE_DAG', 'exchange'),
--('EXCHANGE_MAILBOX', 'exchange')
--('CAPPS', 'cappsClients'), not needed
--('AMAZON_SQL', 'cappsClients'), not needed
--('EBS', 'ebsApps'), not needed
IF object_id('tempdb.dbo.#CompanyLevelCompletedSetups') IS NOT NULL
		DROP TABLE #CompanyLevelCompletedSetups
CREATE TABLE  #CompanyLevelCompletedSetups (companyId int,setup NVARCHAR(MAX), state varchar(10) default  'false')
IF object_id('tempdb.dbo.#CompanyCompletedSetupsTblToUpdate') IS NOT NULL
		DROP TABLE #CompanyCompletedSetupsTblToUpdate
CREATE TABLE  #CompanyCompletedSetupsTblToUpdate (companyId int,setup NVARCHAR(MAX))
IF object_id('tempdb.dbo.#clients') IS NOT NULL
		DROP TABLE #clients
CREATE TABLE  #clients  (companyId int, Setup varchar(25), hasClient varchar(5) default 'false')
--navItems
IF object_id('tempdb.dbo.#CompanyRestrictedNavItems') IS NOT NULL
		DROP TABLE #CompanyRestrictedNavItems
CREATE TABLE  #CompanyRestrictedNavItems (companyId int, level varchar(100), navItem nvarchar(50), includedNavItem int default 0 )
DECLARE @appType35Table TABLE (
    appTypeId       INT PRIMARY KEY
)
INSERT INTO @appType35Table
SELECT DISTINCT appTypeId
FROM GetAppTypesForAppGroup(35,0)
-----1. Find a setup that are not completed
INSERT INTO #CompanyLevelCompletedSetups
SELECT u.id, A._Name, A._Value
FROM UMDSProviders U
LEFT JOIN App_CompanyProp C ON C.componentNameId=U.id  AND C.attrName ='completedSetups' AND C.modified=0
OUTER APPLY (SELECT * FROM  dbo.SplitStringByDelimiter(REPLACE (REPLACE(REPLACE(attrVal, '{', ''), '}',''), '"', '') ,',') WHERE attrVal is not null ) S
OUTER APPLY (SELECT * FROM dbo.SplitStringByDelimiterToTable(s._ID, ':')  WHERE s._id is not null) A
WHERE serviceType=5
UNION
SELECT  0, A._Name, A._Value   FROM GXGlobalParam
CROSS APPLY (SELECT * FROM  dbo.SplitStringByDelimiter(REPLACE (REPLACE(REPLACE(value, '{', ''), '}',''), '"', '') ,',') WHERE value is not null ) S
CROSS APPLY (SELECT * FROM dbo.SplitStringByDelimiterToTable(s._ID, ':')  WHERE s._id is not null) A
WHERE name = 'completedSetups'
--select '#CompanyLevelCompletedSetups',* from #CompanyLevelCompletedSetups order by companyId
--ADMIN_CONSOLE
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'ADMIN_CONSOLE'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'ADMIN_CONSOLE' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM APP_IDAName i
	INNER JOIN  @appType35Table t on i.appTypeId=t.appTypeId
	INNER JOIN app_client cl on cl.id= i.clientId and cl.status & 4096 = 0
INNER JOIN APP_ClientProp cp on attrName = 'Installation Company ID' and cp.modified=0 and cp.attrVal = cast(c.companyId as varchar(10)) and cp.componentNameId=cl.id
LEFT JOIN APP_ClientProp cp1 on cp1.componentNameId = cp.componentNameId and cp1.attrName = 'IsInfrastructure' and cp1.modified=0 WHERE (cp1.attrVal = '0' or cp1.attrVal is null))
AND setup='ADMIN_CONSOLE'
--ENDPOINT
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'ENDPOINT'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'ENDPOINT' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM  app_client cl
INNER JOIN APP_ClientProp cp ON attrName = 'Installation Company ID' AND cp.modified=0 AND cp.attrVal = CAST(c.companyId as varchar(10)) AND cp.componentNameId=cl.id
WHERE cl.status & 4096<> 0)
AND setup='ENDPOINT'
--VSA
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'VSA'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'VSA' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM  APP_InstanceProp i
INNER JOIN APP_Application a ON a.instance = i.componentNameId
INNER JOIN APP_ClientProp cp ON cp.attrName = 'Installation Company ID' AND cp.modified=0 AND cp.attrVal = CAST(c.companyId AS varchar(10)) AND cp.componentNameId=a.clientId
WHERE i.attrName='Virtual Server Instance Type' AND i.modified='0' AND i.attrVal<>'1501'	)
AND setup='VSA'
--OFFICE365
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'OFFICE365'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'OFFICE365' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM APP_IDAName i
INNER JOIN APP_ClientProp cp ON cp.attrName = 'Installation Company ID' AND cp.modified=0 AND cp.attrVal = CAST(c.companyId AS varchar(10)) AND cp.componentNameId=i.clientId
INNER JOIN APP_ClientProp cp1 ON cp1.componentNameId=i.clientId AND cp1.attrName='Office 365 Pseudo Client' AND cp1.attrVal='1' and cp1.modified=0
WHERE appTypeId IN (137, 78, 134))
AND c.setup='OFFICE365'
--DBS
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'DBS'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'DBS' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1
       FROM  APP_IDAName A
       INNER JOIN APP_ClientProp cp on attrName = 'Installation Company ID' and cp.modified=0 and cp.attrVal = cast(c.companyId as varchar(10)) and cp.componentNameId=a.clientId
WHERE apptypeid IN (22, 135, 125, 80, 104,
62,37,103, 5, 81, 61, 3))
AND c.setup='DBS'
--KUBERNETES
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'KUBERNETES'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'KUBERNETES' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM  APP_InstanceProp i
INNER JOIN APP_Application a ON a.instance = i.componentNameId
INNER JOIN APP_ClientProp cp ON cp.attrName = 'Installation Company ID' AND cp.modified=0 AND cp.attrVal = CAST(c.companyId AS varchar(10)) AND cp.componentNameId=a.clientId
WHERE i.attrName='Virtual Server Instance Type' AND i.modified='0' AND i.attrVal='1501'	)
AND setup='KUBERNETES'
--BIG_DATA_APPS
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'BIG_DATA_APPS'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'BIG_DATA_APPS' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM  APP_InstanceProp i
INNER JOIN APP_Application a ON a.instance = i.componentNameId
INNER JOIN APP_ClientProp cp ON cp.attrName = 'Installation Company ID' AND cp.modified=0 AND cp.attrVal = CAST(c.companyId AS varchar(10)) AND cp.componentNameId=a.clientId
WHERE i.attrName='Distributed Cluster Type' AND i.modified='0' AND i.attrVal in ('2','8','9','16')	) -- DistributedClusterType: HADOOP,MONGODB ,CASSANDRA , SPLUNK
AND setup='BIG_DATA_APPS'
--ACTIVE_DIRECTORY
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'ACTIVE_DIRECTORY'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'ACTIVE_DIRECTORY' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1
       FROM  APP_IDAName A
       INNER JOIN APP_ClientProp cp on attrName = 'Installation Company ID' and cp.modified=0 and cp.attrVal = cast(c.companyId as varchar(10)) and cp.componentNameId=a.clientId
WHERE apptypeid IN (139, 41))
AND c.setup='ACTIVE_DIRECTORY'
--GSUITE
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'GSUITE'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'GSUITE' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM  APP_InstanceProp i
INNER JOIN APP_Application a ON a.instance = i.componentNameId
INNER JOIN APP_ClientProp cp ON cp.attrName = 'Installation Company ID' AND cp.modified=0 AND cp.attrVal = CAST(c.companyId AS varchar(10)) AND cp.componentNameId=a.clientId
WHERE i.attrName='Cloud Apps Instance Type' AND i.modified='0' AND i.attrVal in ('1','2'))
AND setup='GSUITE'
--SHAREPOINT
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'SHAREPOINT'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'SHAREPOINT' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1
       FROM  APP_IDAName A
INNER JOIN APP_ClientProp cp on attrName = 'Installation Company ID' and cp.modified=0 and cp.attrVal = cast(c.companyId as varchar(10)) and cp.componentNameId=a.clientId
WHERE apptypeid IN (78))
AND c.setup='SHAREPOINT'
--ARCHIVING
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'ARCHIVING'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'ARCHIVING' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT top 1 a.id
    FROM APP_Application A
INNER JOIN APP_ClientProp cp on attrName = 'Installation Company ID'  and cp.modified=0 and cp.attrVal = cast(c.companyId as varchar(10)) and cp.componentNameId=a.clientId
        LEFT JOIN APP_BackupsetProp BP
            ON BP.componentNameId = A.backupset
            AND BP.attrName = 'Is Archiving Enabled'
            AND BP.attrVal = '1'
            AND BP.modified = 0
            AND A.subclientStatus & 8 /*CV_STATUS_DEFAULT*/ <> 0
   LEFT JOIN  APP_SubclientProp SP
                on SP.attrName = N'Turbo Mode Enable Stubbing'
                AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
                AND SP.attrVal = '1'
                AND SP.modified = 0 and sp.componentNameId = a.id
				where sp.ccpId is not null or bp.componentNameId is not null)
AND c.setup='ARCHIVING'
--SALESFORCE
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'SALESFORCE'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'SALESFORCE' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (SELECT 1 FROM  APP_InstanceProp i
INNER JOIN APP_Application a ON a.instance = i.componentNameId
INNER JOIN APP_ClientProp cp ON cp.attrName = 'Installation Company ID' AND cp.modified=0 AND cp.attrVal = CAST(c.companyId AS varchar(10)) AND cp.componentNameId=a.clientId
WHERE i.attrName='Cloud Apps Instance Type' AND i.modified='0' AND i.attrVal = ('3')) --CV_CLOUDAPPS_INSTANCE_TYPE -- cloudAppsInstanceType_SALESFORCE
AND setup='SALESFORCE'
--EXCHANGE
INSERT INTO #clients(companyId, Setup)
SELECT companyId , 'EXCHANGE'
FROM #CompanyLevelCompletedSetups
GROUP BY companyId
HAVING SUM(CASE setup WHEN 'EXCHANGE' THEN 1 ELSE 0 END)=0
UPDATE c
SET c.hasClient='true'
FROM #clients c
WHERE EXISTS (select top 1 a.clientId FROM APP_IDAName a
INNER JOIN  APP_ClientProp cp on attrName = 'Installation Company ID' AND cp.modified=0 and cp.attrVal = cast(c.companyId as varchar(10)) AND cp.componentNameId=a.clientId
LEFT JOIN app_client c ON a.clientId = c.id
LEFT JOIN APP_ClientProp cp1 ON cp1.componentNameId=cp.componentNameId AND cp1.attrName = 'Office 365 Pseudo Client' AND cp1.attrVal='1' AND cp1.modified=0
WHERE a.appTypeId =53 OR (appTypeId = 137 and cp1.componentNameId IS NULL))
AND setup='EXCHANGE'
DELETE FROM #clients WHERE hasClient='false'
--select '#clients',* from #clients
---3. Find the denied navigation items for the not completed setup
INSERT INTO #CompanyRestrictedNavItems (companyId , level, navItem)
SELECT distinct componentNameId, attrName, S._ID
FROM App_CompanyProp c
INNER JOIN #clients cs ON cs.companyId=c.componentNameId
CROSS APPLY dbo.SplitStringByDelimiter(attrVal,',') S
WHERE attrName IN ('Restricted Nav Items For Tenant Admin','Restricted Nav Items For Tenant User') AND modified=0
UNION
SELECT 0, name, S._ID
FROM GXGlobalParam g
INNER JOIN #clients cs ON cs.companyId=0
CROSS APPLY dbo.SplitStringByDelimiter(value,',') S
WHERE name IN ('Restricted Nav Items For MSP User','Restricted Nav Items For Restricted Admin','Restricted Nav Items For MSP Admin') AND modified=0
--select * from @CompletedSetupsToState
UPDATE c SET c.includedNavItem=1
FROM #CompanyRestrictedNavItems c
INNER JOIN @CompletedSetupsToState setupstoState ON setupstoState.navItem=c.navItem
INNER JOIN #clients cl ON cl.Setup=setupstoState.setup
WHERE c.companyId=cl.companyId
--completed setups
INSERT INTO #CompanyCompletedSetupsTblToUpdate
SELECT companyId, STUFF((SELECT ',' +( '"' + setup +'":true' )
         FROM #clients   WHERE  companyId=t.companyId
         FOR XML PATH(''))
         ,1,1,'') FROM #clients t  WHERE t.hasClient='true'
        GROUP BY companyId
--select '#CompanyCompletedSetupsTblToUpdate', * from #CompanyCompletedSetupsTblToUpdate
-----4a. If client is found mark that setup completed
--select  'updateexsiting', c.componentNameId, REPLACE(attrval, '}',',' + setup + '}')
UPDATE c SET attrVal = REPLACE(attrval, '}',',' + setup + '}')
FROM App_CompanyProp c
INNER JOIN #CompanyCompletedSetupsTblToUpdate f ON c.componentNameId=f.companyId
WHERE c.attrName='completedSetups' AND modified=0  AND attrval <> ''
AND companyId>0
----Empty string
--SELECT 'empty string', '{' + setup + '}'
UPDATE c SET attrVal= '{' + setup + '}'
FROM  App_CompanyProp c
INNER JOIN #CompanyCompletedSetupsTblToUpdate f ON c.componentNameId=f.companyId
WHERE attrName='completedSetups' AND attrVal='' AND modified=0
AND companyId>0
--No setups completed(null)
INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
SELECT u.companyId,'completedSetups', 1,'{' + setup + '}',@nowTime,0
FROM #CompanyCompletedSetupsTblToUpdate u
LEFT JOIN  App_CompanyProp cp on cp.componentNameId=u.companyId  AND attrName='completedSetups' AND cp.modified=0
WHERE cp.id is null
AND companyId>0
----4b. Remove the navitems for this deniedNavItems for tanent admin and tenant user
UPDATE C set c.attrVal=A.newNav
--SELECT 'App_CompanyProp_new', c.componentNameId, c.attrName, A.newNav
FROM App_CompanyProp c
INNER JOIN
(SELECT companyId, level, isnull( STUFF(
(SELECT ',' + A.navItem
FROM #CompanyRestrictedNavItems A
WHERE A.companyId = B.companyId AND includedNavItem=0 AND a.level=b.level
FOR XML PATH('')),1,1,''),'') AS newNav
	FROM #CompanyRestrictedNavItems AS B
GROUP BY B.companyId, level) A ON A.companyId=c.componentnameid AND A.level=c.attrName AND A.companyId > 0
INNER JOIN  #CompanyRestrictedNavItems D ON D.companyId = c.componentNameId AND d.includedNavItem=1
WHERE c.modified=0
AND c.componentNameId>0
----4c. Add this setup to the to the supported solutions
MERGE APP_COMPANYPROP AS C
USING
(SELECT companyId, SUM(s.setupVal) as setupVal from #clients up inner join @SupportedSolutions s on s.setup = up.setup where up.companyid > 0 GROUP BY companyId) as ct
ON ct.companyId = c.componentnameid and c.attrName = 'supportedSolutions' and c.modified = 0 and ISNUMERIC(attrVal)=1
WHEN MATCHED THEN
UPDATE SET c.attrVal = CAST(c.attrVal as int) | ct.setupVal
WHEN  NOT MATCHED   THEN
INSERT (componentNameId,  attrName, attrType, attrVal, created, modified)
VALUES (ct.companyId, 'supportedSolutions', 1, ct.setupVal,  @nowTime, 0);--PROPERTY_STRING
---5a. If client is found mark that setup completed
--select  'updateexsiting gxgl', REPLACE(value, '}',',' + setup + '}')
UPDATE g set value = REPLACE(value, '}',',' + setup + '}')
FROM GXGlobalParam g
INNER JOIN #CompanyCompletedSetupsTblToUpdate f ON f.companyId=0
WHERE name='completedSetups' AND modified=0  AND value <> ''
and companyId=0
----5b. Remove the navitems for this deniedNavItems
UPDATE g set g.value=A.newNav
--select 'GXGlobalParam_new', 0, g.name, g.value, A.newNav
FROM GXGlobalParam g
INNER JOIN
(SELECT b.companyId, level, isnull(STUFF(
(SELECT ',' + A.navItem
FROM #CompanyRestrictedNavItems A
WHERE includedNavItem=0 AND a.level=b.level AND a.companyId=0
FOR XML PATH('')),1,1,''),'') AS newNav
	FROM #CompanyRestrictedNavItems AS B where b.companyId=0
GROUP BY B.companyId, level) A on A.level=g.name and a.companyId=0
INNER JOIN  #CompanyRestrictedNavItems D on D.companyId = 0 and d.includedNavItem=1 and d.level=a.level
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSetNavigationSettings')
	delete from GxQscripts where name = 'AppSetNavigationSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetNavigationSettings')
	delete from GXDBVersions where aliasname = 'AppSetNavigationSettings'
GO

insert into GXDBVersions values(2, 'AppSetNavigationSettings',  '00010001000200020000', 'AppSetNavigationSettings', '00010001000200020000')
GO

