

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetMongoConnectionString.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetMongoConnectionString.sp,v $ $Id: AppSetMongoConnectionString.sp,v 1.1.2.4 2020/12/08 15:57:10 snandhini Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetMongoConnectionString')
BEGIN
	print '>>> Drop Stored Procedure: AppSetMongoConnectionString <<<'
	drop procedure AppSetMongoConnectionString
END
IF EXISTS (select * from GxQscripts where name='AppSetMongoConnectionString')
	delete from GxQscripts where name = 'AppSetMongoConnectionString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMongoConnectionString')
	delete from GXDBVersions where aliasname = 'AppSetMongoConnectionString'
GO
print '... Creating Procedure: AppSetMongoConnectionString'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetMongoConnectionString
  @clientId INTEGER,
  @iPort INTEGER,
  @mongoInstance nVarChar(256),
  @pMongoAccess nvarchar(1024)
AS
  DECLARE @r_errorCode INTEGER
  DECLARE @r_errorMessage NVARCHAR(1024)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @r_errorCode = 0
	SET @r_errorMessage = ''
	declare @time int = dbo.GetUnixTime(GETUTCDATE())
	declare @MongoConnectionInfo table
	(
		errorCode integer,
		clientId integer
	)
	insert into @MongoConnectionInfo exec AppGetMongoDbClientId @clientId
	declare @mongoClientId int = 0
	select @mongoClientId = clientId from @MongoConnectionInfo
	-- if given id does not have mongo package
	-- check if the given entry is from cluster and if the physical machines have mongo installed
	IF(@mongoClientId <> @clientId)
	BEGIN
			IF EXISTS ( SELECT 1 FROM APP_VMToPMMap
						INNER JOIN SimInstalledPackages ON PMClientId = clientId
WHERE simPackageID IN (952, 1604)
						AND VMClientId = @clientId )
			BEGIN
				SELECT @mongoClientId = @clientId
			END
	END
	IF(@mongoClientId = @clientId)
	BEGIN
		-- Check if nMongoPort exists, if yes, update else insert
IF EXISTS(SELECT 1 from APP_CLIENTPROP where attrName = 'Mongo DB port' AND componentNameId = @mongoClientId)
		BEGIN
UPDATE APP_ClientProp SET attrVal = Convert(Nvarchar(5), @iPort) where attrName = 'Mongo DB port' AND componentNameId = @mongoClientId
		END
		ELSE
		BEGIN
INSERT INTO APP_CLIENTPROP(ComponentNameId, attrName, attrVal, attrType, created, modified, ccpId) values(@mongoClientId, 'Mongo DB port', CONVERT(nvarchar(1024),@iPort), 1, @time, 0, 0)
		END
        -- Check if sMongoInstance exists, if yes, update else insert
IF EXISTS(SELECT 1 from APP_CLIENTPROP where attrName = 'Mongo DB Instance' AND componentNameId = @mongoClientId)
		BEGIN
UPDATE APP_ClientProp SET attrVal = @mongoInstance where attrName = 'Mongo DB Instance' AND componentNameId = @mongoClientId
		END
		ELSE
		BEGIN
INSERT INTO APP_CLIENTPROP(ComponentNameId, attrName, attrVal, attrType, created, modified, ccpId) values(@mongoClientId, 'Mongo DB Instance', @mongoInstance, 1, @time, 0, 0)
		END
        -- Check if pMongoAccess exists, if yes, update else insert
IF EXISTS(SELECT 1 from APP_CLIENTPROP where attrName = 'Mongo DB Access' AND componentNameId = @mongoClientId)
		BEGIN
UPDATE APP_ClientProp SET attrVal = @pMongoAccess where attrName = 'Mongo DB Access' AND componentNameId = @mongoClientId
		END
		ELSE
		BEGIN
INSERT INTO APP_CLIENTPROP(ComponentNameId, attrName, attrVal, attrType, created, modified, ccpId) values(@mongoClientId, 'Mongo DB Access', @pMongoAccess, 1, @time, 0, 0)
		END
		SET @r_errorCode = @@ERROR
	END
	ELSE
	BEGIN
		SET @r_errorCode = 1
		SET @r_errorMessage = 'MongoDB is not installed'
	END
	SELECT @r_errorCode as r_errorCode, @r_errorMessage as r_errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetMongoConnectionString')
	delete from GxQscripts where name = 'AppSetMongoConnectionString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMongoConnectionString')
	delete from GXDBVersions where aliasname = 'AppSetMongoConnectionString'
GO

insert into GXDBVersions values(2, 'AppSetMongoConnectionString',  '00010001000200040000', 'AppSetMongoConnectionString', '00010001000200040000')
GO

