

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetMobileInstalledAppInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ===========================================================
-- Author:		Rohit Iyer
-- Create date: 11/16/2017
-- Description:	Set the properties of mobile device clients
-- ===========================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetMobileInstalledAppInfo <<<'

IF EXISTS (select * from sysobjects where name='AppSetMobileInstalledAppInfo')
	drop procedure AppSetMobileInstalledAppInfo
IF EXISTS (select * from GxQscripts where name='AppSetMobileInstalledAppInfo')
	delete from GxQscripts where name = 'AppSetMobileInstalledAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMobileInstalledAppInfo')
	delete from GXDBVersions where aliasname = 'AppSetMobileInstalledAppInfo'
GO
print '... Creating Procedure: AppSetMobileInstalledAppInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetMobileInstalledAppInfo
  @io_xml xml output,
  @skipSecCheck int = 0	
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @activeUserId      	INT
DECLARE @localeId			INT
DECLARE @isAdminUser 		INT
DECLARE @operationType      INT
declare @creatorId			INT
--Device properties
DECLARE @i_deviceGUID  		nvarchar(64)
DECLARE @i_deviceName	  	nvarchar(100)
DECLARE @i_clientType  		INT
DECLARE @i_ownerId  		INT
DECLARE @i_locale	  		varchar(10)
DECLARE @i_timeZone  		varchar(100)
DECLARE @i_hostName			varchar(100)
--Installed App Properties
DECLARE @i_appUUID  		varchar(64)
DECLARE @i_mobileAppType  	INT
DECLARE @i_regToken		  	nvarchar(256)
DECLARE @i_activeUserId		INT
DECLARE @i_subscriberType  	INT
DECLARE @i_subscriberId  	INT
DECLARE @i_subscriptionType INT
DECLARE @i_filter			XML
DECLARE @osType				INT
DECLARE @i_MDMDeviceId			INT
DECLARE @i_MDMInstalledAppId	INT
DECLARE @nowTime			INT
DECLARE @warningCode		INT
DECLARE @warningMessage		VARCHAR(MAX)
DECLARE @errorCode 			INT
DECLARE @errorMessage 		VARCHAR(MAX)
DECLARE @xmlText XML  = @io_xml
select  @operationType = isnull(ref.value('@opType', 'int'),0),
		@localeId = isnull(locRef.value('@localeId', 'int'),0),
		@creatorId = isnull(userRef.value('@userId', 'int'),0)
FROM    @xmlText.nodes('Api_SetMobileInstalledAppPropReq') A ( ref )
		outer apply ref.nodes('./locale') B ( locRef )
		outer apply ref.nodes('./user') C ( userRef )
SET @errorCode = 0
SET @errorMessage = ''
IF @skipSecCheck = 1
	SET @isAdminUser = 1
ELSE
BEGIN
	--check requesting user details
	IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @creatorId))
	BEGIN
		SET @errorCode	= 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', @creatorId)
		GOTO SEND_RESPONSE
	END
	--Users with Administrative capability at commcell level
	EXEC sec_checkPermissionOnEntity @creatorId, 1, @isAdminUser OUT,1,2
	IF(@isAdminUser = 0)
	BEGIN
		SET @errorCode	= 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO SEND_RESPONSE
	END
END
SELECT  @i_deviceGUID = ISNULL(ref.value('@deviceGUID', 'nvarchar(256)'),''),
		@i_deviceName = ISNULL(ref.value('@deviceName', 'nvarchar(256)'),''),
		@i_clientType = ISNULL(ref.value('@clientType', 'int'),0),
		@i_ownerId 	  = ISNULL(ref.value('@ownerId', 'int'),0),
		@i_hostName	  =	ISNULL(ref.value('@hostName', 'nvarchar(256)'),''),
		@i_locale 	  = ISNULL(ref.value('@locale', 'nvarchar(256)'),''),
		@i_timeZone	  = ISNULL(ref.value('@timeZone', 'nvarchar(256)'),'')
FROM    @xmlText.nodes('Api_SetMobileInstalledAppPropReq/parentDeviceProp') R ( ref )
SELECT  @i_appUUID 			= ISNULL(C.value('@appUUID', 'nvarchar(256)'),''),
		@i_mobileAppType 	= ISNULL(C.value('@mobileAppType', 'int'),0),
		@i_regToken 		= ISNULL(C.value('@fcmToken', 'nvarchar(512)'),''),
		@i_activeUserId 	= ISNULL(C.value('@activeUserId', 'int'),0)
FROM    @xmlText.nodes('Api_SetMobileInstalledAppPropReq/installedAppProp') T ( C )
SET @osType = (select case
							when @i_clientType = 3 then 215
							when @i_clientType = 10 then 216
							when @i_clientType = 11 then 217
							when @i_clientType = 23 then 215
							when @i_clientType = 24 then 216
						end
				  )
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
--1. OVERWRITE
--2. ADD
--3. DELETE
--If DELETE, delete the whole device/Application entries from all tables
IF(@operationType = 3)  --Overwrite/Delete operation
BEGIN
	if exists(select 1 from MDM_Device where deviceGUID = @i_deviceGUID)
	begin
		BEGIN TRAN
			set @i_MDMDeviceId = (select top 1 id from MDM_Device where deviceGUID = @i_deviceGUID)
			if(@i_appUUID <> '')
			begin
				--Delete users sessions on installed Application
				delete UMQ
				from UMQSDKSessions UMQ with(nolock) inner join MDM_InstalledApp B with(nolock) on UMQ.hostName = B.appUUID
				where B.deviceId = @i_MDMDeviceId and B.appUUID = @i_appUUID
				--Delete any installed app on the device
				delete from MDM_InstalledApp where appUUID = @i_appUUID
			end
			else
			begin		--Delete the whole device and all apps on it
				--Delete users sessions on installed Application
				delete UMQ
				from UMQSDKSessions UMQ with(nolock) inner join MDM_InstalledApp B with(nolock) on UMQ.hostName = B.appUUID
				where B.deviceId = @i_MDMDeviceId
				--Delete any installed app on the device
				delete from MDM_InstalledApp where deviceId = @i_MDMDeviceId
				--Delete the device too
				delete from MDM_Device where id = @i_MDMDeviceId
			end
		COMMIT TRAN
	end
END
IF (@operationType = 2)    --ADD
BEGIN
	--Add the installed application
	if exists(select 1 from MDM_InstalledApp where appUUID = @i_appUUID)
	begin
		SET @errorCode	= 1
		SET @errorMessage = 'Failed to add new mobile device. Application with with GUID ['+@i_appUUID+'] already exists. Aborting Add operation'
		GOTO SEND_RESPONSE
	end
	else
	begin	--Add app and device accordingly
		BEGIN TRAN
			if exists(select 1 from MDM_Device where deviceGUID = @i_deviceGUID)
			begin
				--Insert device first
				insert into MDM_Device(name, deviceGUID, osId, deviceType, ownerType, ownerId, flags, created, modified)
				values(@i_deviceName, @i_deviceGUID, @osType, 0, 13, @i_ownerId, 0, @nowTime, 0)
				SET @i_MDMDeviceId = SCOPE_IDENTITY()
			end
			else
			begin
				set @i_MDMDeviceId = (select top 1 id from MDM_Device where deviceGUID = @i_deviceGUID)
			end
			if exists(select 1 from MDM_DeviceProp where componentNameId = @i_MDMDeviceId and attrName = 'hostName')
			begin
				update MDM_DeviceProp set attrVal = @i_hostName where componentNameId = @i_MDMDeviceId and attrName = 'hostName'
			end
			else
			begin
				insert into MDM_DeviceProp(componentNameId, attrName, attrVal, attrType, created, modified, ccpid)
				values	(@i_MDMDeviceId, 'hostName', @i_hostName, 10, @nowTime, 0, 0)
			end
			insert into MDM_InstalledApp(appUUID, appType, deviceId, activeUserId, flags, created, modified)
			values(@i_appUUID, @i_mobileAppType, @i_MDMDeviceId, @i_activeUserId, 0, @nowTime, 0)
			SET @i_MDMInstalledAppId = SCOPE_IDENTITY()
			--1. FCM token insert
			insert into MDM_InstalledAppProp(componentNameId, attrName, attrVal, attrType, created, modified, ccpid)
			values	(@i_MDMInstalledAppId, 'fcmToken', @i_regToken, 10, @nowTime, 0, 0)
		COMMIT TRAN
	end
END
IF (@operationType = 1)    --OVERWRITE
BEGIN
	BEGIN TRAN
		--Update Device Properies
		if not exists(select 1 from MDM_Device where deviceGUID = @i_deviceGUID)
		begin
			--Insert device first
			insert into MDM_Device(name, deviceGUID, osId, deviceType, ownerType, ownerId, flags, created, modified)
			values(@i_deviceName, @i_deviceGUID, @osType, 0, 13, @i_ownerId, 0, @nowTime, 0)
			SET @i_MDMDeviceId = SCOPE_IDENTITY()
		end
		else
		begin
			set @i_MDMDeviceId = (select top 1 id from MDM_Device where deviceGUID = @i_deviceGUID)
			update MDM_Device set name = @i_deviceName, osId = @osType, ownerId = @i_ownerId
			where id = @i_MDMDeviceId
		end
		--1. Hostname
		if exists(select 1 from MDM_DeviceProp where componentNameId = @i_MDMDeviceId and attrName = 'hostName')
		begin
			update MDM_DeviceProp set attrVal = @i_hostName where componentNameId = @i_MDMDeviceId and attrName = 'hostName'
		end
		else
		begin
			insert into MDM_DeviceProp(componentNameId, attrName, attrVal, attrType, created, modified, ccpid)
			values	(@i_MDMDeviceId, 'hostName', @i_hostName, 10, @nowTime, 0, 0)
		end
		--Update Installed App properties
		if  not exists(select 1 from MDM_InstalledApp where appUUID = @i_appUUID and deviceId = @i_MDMDeviceId)
		begin
			insert into MDM_InstalledApp(appUUID, appType, deviceId, activeUserId, flags, created, modified)
			values(@i_appUUID, @i_mobileAppType, @i_MDMDeviceId, @i_activeUserId, 0, @nowTime, 0)
			SET @i_MDMInstalledAppId = SCOPE_IDENTITY()
		end
		else
		begin
			update MDM_InstalledApp set appType = @i_mobileAppType, activeUserId = @i_activeUserId
			where appUUID = @i_appUUID and deviceId = @i_MDMDeviceId
			SET @i_MDMInstalledAppId = (select top 1 id from MDM_InstalledApp where appUUID = @i_appUUID )
		end
		--1. FCM Token
		if exists(select 1 from MDM_InstalledAppProp where componentNameId = @i_MDMInstalledAppId and attrName = 'fcmToken')
		begin
			update MDM_InstalledAppProp set attrVal = @i_regToken
			where componentNameId = @i_MDMInstalledAppId and attrName = 'fcmToken'
		end
		else
		begin
			insert into MDM_InstalledAppProp(componentNameId, attrName, attrVal, attrType, created, modified, ccpid)
			values	(@i_MDMInstalledAppId, 'fcmToken', @i_regToken, 10, @nowTime, 0, 0)
		end
	COMMIT TRAN
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SET @io_xml = ( SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString', @warningCode AS '@warningCode' , @warningMessage AS '@warningMessage'
                 FOR xml path('error'),ROOT('Api_SetMobileInstalledAppPropResp')
               )
select @io_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetMobileInstalledAppInfo')
	delete from GxQscripts where name = 'AppSetMobileInstalledAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMobileInstalledAppInfo')
	delete from GXDBVersions where aliasname = 'AppSetMobileInstalledAppInfo'
GO

insert into GXDBVersions values(2, 'AppSetMobileInstalledAppInfo',  '00000000000000000000', 'AppSetMobileInstalledAppInfo', '00000000000000000000')
GO

